/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConnectionInfo;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPJCODestinationProvider;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.ext.Environment;

public class SAPDestinationManager {
    public static synchronized void registerDestinationProvider() {
        SAPJCODestinationProvider dest = SAPJCODestinationProvider.getInstance();
        if (!Environment.isDestinationDataProviderRegistered()) {
            Environment.registerDestinationDataProvider((DestinationDataProvider)dest);
        }
    }

    public static synchronized void unregisterDestinationProvider() {
        SAPJCODestinationProvider dest = SAPJCODestinationProvider.getInstance();
        if (Environment.isDestinationDataProviderRegistered()) {
            Environment.unregisterDestinationDataProvider((DestinationDataProvider)dest);
        }
    }

    public static boolean testDestination(SAPConnectionInfo connInfo) {
        boolean connected = false;
        SAPJCODestinationProvider dest = null;
        try {
            dest = SAPJCODestinationProvider.getInstance();
            String destname = dest.addDestinationProperties(connInfo);
            JCoDestination destination = dest.getDestination(destname);
            destination.ping();
            connected = true;
        }
        catch (JCoException e) {
            throw new ERPException(XQEMessageKeys.ERP_ConnectionError, e);
        }
        finally {
            dest.removeDestinationProperties(connInfo);
        }
        return connected;
    }
}

