/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConnectionInfo;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPUtil;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoDestinationManager;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SAPJCODestinationProvider
implements DestinationDataProvider {
    private static final SAPJCODestinationProvider _destinationProvider = new SAPJCODestinationProvider();
    private Map<String, Properties> destinations = new HashMap<String, Properties>();
    private ReentrantReadWriteLock destMapLock = new ReentrantReadWriteLock();

    private SAPJCODestinationProvider() {
    }

    public static SAPJCODestinationProvider getInstance() {
        return _destinationProvider;
    }

    public String addDestinationProperties(SAPConnectionInfo conninfo) {
        Properties properties = null;
        String destName = SAPUtil.getDestinationName(conninfo);
        properties = conninfo.isPoolingEnabled() ? this.getDestinationPropertiesWithPool(conninfo) : this.getDestinationProperties(conninfo);
        try {
            this.destMapLock.writeLock().lock();
            this.destinations.put(destName, properties);
        }
        catch (Exception e) {
            throw new ERPException(e);
        }
        finally {
            this.destMapLock.writeLock().unlock();
        }
        return destName;
    }

    public void removeDestinationProperties(SAPConnectionInfo conninfo) {
        String destName = SAPUtil.getDestinationName(conninfo);
        try {
            this.destMapLock.writeLock().lock();
            this.destinations.remove(destName);
        }
        finally {
            this.destMapLock.writeLock().unlock();
        }
    }

    private Properties getDestinationPropertiesWithPool(SAPConnectionInfo sapConnInfo) {
        Properties prop = this.getDestinationProperties(sapConnInfo);
        prop.put("jco.destination.pool_capacity", (Object)sapConnInfo.getConnPoolCapacity());
        prop.put("jco.destination.peak_limit", (Object)sapConnInfo.getConnPoolPeakLimit());
        prop.put("jco.destination.expiration_time", (Object)sapConnInfo.getConnExpirationTime());
        prop.put("jco.destination.expiration_check_period", (Object)sapConnInfo.getConnExpirationPeriod());
        return prop;
    }

    private Properties getDestinationProperties(SAPConnectionInfo sapConnInfo) {
        Properties prop = new Properties();
        prop.put("jco.client.client", sapConnInfo.getClient());
        prop.put("jco.client.user", sapConnInfo.getUser());
        prop.put("jco.client.passwd", sapConnInfo.getPassword());
        prop.put("jco.client.lang", sapConnInfo.getLanguage());
        prop.put("jco.client.saprouter", sapConnInfo.getRouterString());
        if (SAPUtil.isLoadBalancedEnvironment(sapConnInfo)) {
            prop.setProperty("jco.client.mshost", sapConnInfo.getMessageServer());
            prop.setProperty("jco.client.r3name", sapConnInfo.getSystemId());
            prop.setProperty("jco.client.group", sapConnInfo.getLogonGroup());
        } else {
            prop.put("jco.client.ashost", sapConnInfo.getServer());
            prop.put("jco.client.sysnr", sapConnInfo.getSystemNo());
        }
        return prop;
    }

    public Properties getDestinationProperties(String name) {
        Properties prop = null;
        try {
            this.destMapLock.readLock().lock();
            prop = this.destinations.get(name);
        }
        finally {
            this.destMapLock.readLock().unlock();
        }
        return prop;
    }

    public void setDestinationDataEventListener(DestinationDataEventListener arg0) {
    }

    public boolean supportsEvents() {
        return false;
    }

    public JCoDestination getDestination(String destName) {
        JCoDestination destination = null;
        try {
            destination = JCoDestinationManager.getDestination((String)destName);
        }
        catch (JCoException e) {
            throw new ERPException(XQEMessageKeys.ERP_ConnectionError, e);
        }
        return destination;
    }
}

