/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import java.util.ArrayList;
import java.util.List;

public class SAPOptionBuilder
implements SAPConstants {
    private final List<String> filterList = new ArrayList<String>();
    private final StringBuilder sb = new StringBuilder();

    public void buildOption(String str) {
        int strlen = str.length();
        int availableSpace = 72 - this.sb.length();
        if (availableSpace <= 0) {
            this.filterList.add(this.sb.toString());
            this.sb.setLength(0);
            availableSpace = 72;
        }
        if (strlen > availableSpace) {
            this.filterList.add(this.sb.toString());
            this.sb.setLength(0);
            this.sb.append(str);
        } else {
            this.sb.append(str);
        }
    }

    public List<String> getOptions() {
        this.flush();
        return this.filterList;
    }

    public String[] getOptionsArray() {
        this.flush();
        String[] options = this.filterList.toArray(new String[this.filterList.size()]);
        return options;
    }

    private void flush() {
        if (this.sb.length() > 0) {
            this.filterList.add(this.sb.toString());
            this.sb.setLength(0);
        }
    }

    public void buildInClauseValues(List<String> values) {
        this.buildOption("(");
        int len = values.size();
        for (int i = 0; i < len; ++i) {
            this.buildOption(values.get(i));
            if (i >= len - 1) continue;
            this.buildOption(",");
        }
        this.buildOption(")");
    }

    protected void buildWhereClause(String variable, String condition, String value) {
        this.buildOption(variable);
        this.buildOption(" ");
        this.buildOption(condition);
        this.buildOption(" ");
        this.buildOption(value);
    }

    protected void addANDOperator() {
        this.buildOption(" ");
        this.buildOption("AND");
        this.buildOption(" ");
    }
}

