/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.ERPLog;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPFieldMetadata;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPOptionBuilder;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTable;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPUtil;
import com.cognos.xqe.trace.LogLevel;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SAPRFCIntrpspectorBean
implements SAPConstants {
    private final SAPClient sapclient;

    public SAPRFCIntrpspectorBean(SAPClient sapclient) {
        this.sapclient = sapclient;
    }

    public List<String> getRFCDevClassNames(String devClassFilter) {
        ArrayList<String> devclassnames = new ArrayList<String>();
        if (devClassFilter == null) {
            return devclassnames;
        }
        String[] fields = new String[]{"DEVCLASS", "CTEXT"};
        SAPOptionBuilder optionBuilder = new SAPOptionBuilder();
        optionBuilder.buildWhereClause("SPRAS", "=", SAPUtil.getQuotedValue(this.sapclient.getIsoLanguage()));
        if (!SAPUtil.isValid(devClassFilter)) {
            devClassFilter = "%";
        }
        optionBuilder.addANDOperator();
        optionBuilder.buildWhereClause("DEVCLASS", "LIKE", SAPUtil.getQuotedValue(devClassFilter));
        String[] options = optionBuilder.getOptionsArray();
        Map<String, String> importparams = SAPUtil.getImporParams("TDEVCT", "0", "0");
        JCoParameterList parameterList = this.sapclient.getData(fields, options, importparams, false);
        SAPTable sapTable = new SAPTable(parameterList, this.sapclient);
        StringBuilder sbuildr = new StringBuilder();
        while (sapTable.next()) {
            sbuildr.append(sapTable.getFieldValue("DEVCLASS"));
            sbuildr.append(" ");
            sbuildr.append("-");
            sbuildr.append(" ");
            sbuildr.append(sapTable.getFieldValue("CTEXT"));
            devclassnames.add(sbuildr.toString());
            sbuildr.setLength(0);
        }
        return devclassnames;
    }

    public List<String> getRFCFunctionGroups(String devClassNameFilter) {
        ArrayList<String> funGrpNames = new ArrayList<String>();
        if (devClassNameFilter == null) {
            return funGrpNames;
        }
        devClassNameFilter = SAPUtil.removeDescription(devClassNameFilter);
        String[] fields = new String[]{"OBJ_NAME"};
        SAPOptionBuilder optionBuilder = new SAPOptionBuilder();
        optionBuilder.buildWhereClause("PGMID", "=", SAPUtil.getQuotedValue("R3TR"));
        optionBuilder.addANDOperator();
        optionBuilder.buildWhereClause("OBJECT", "=", SAPUtil.getQuotedValue("FUGR"));
        if (devClassNameFilter != null && !devClassNameFilter.equals("%")) {
            optionBuilder.addANDOperator();
            optionBuilder.buildWhereClause("DEVCLASS", "=", SAPUtil.getQuotedValue(devClassNameFilter));
        }
        String[] options = optionBuilder.getOptionsArray();
        Map<String, String> importparams = SAPUtil.getImporParams("TADIR", "0", "0");
        JCoParameterList parameterList = this.sapclient.getData(fields, options, importparams, false);
        SAPTable sapTable = new SAPTable(parameterList, this.sapclient);
        while (sapTable.next()) {
            funGrpNames.add(sapTable.getFieldValue("OBJ_NAME"));
        }
        return funGrpNames;
    }

    public List<String> getRFCTableNames(String funcGrpName, String tableNameFilter) {
        ArrayList<String> rfcTableNames = new ArrayList<String>();
        if (funcGrpName == null) {
            return rfcTableNames;
        }
        funcGrpName = SAPUtil.removeDescription(funcGrpName);
        HashMap<String, String> importparams = new HashMap<String, String>();
        if (tableNameFilter != null) {
            tableNameFilter = SAPUtil.removeDescription(tableNameFilter);
            importparams.put("FUNCNAME", tableNameFilter);
        }
        importparams.put("GROUPNAME", funcGrpName);
        importparams.put("LANGUAGE", this.sapclient.getIsoLanguage());
        try {
            JCoParameterList functionlist = this.sapclient.getData(null, null, importparams, true);
            JCoTable functionTable = functionlist.getTable("FUNCTIONS");
            if (!functionTable.isEmpty()) {
                functionTable.firstRow();
                StringBuilder sb = new StringBuilder();
                do {
                    String name = functionTable.getString(0);
                    String desc = functionTable.getString(4);
                    sb.setLength(0);
                    sb.append(name);
                    if (desc == null || desc.length() <= 0) continue;
                    sb.append(" ");
                    sb.append("-");
                    sb.append(" ");
                    sb.append(desc);
                    rfcTableNames.add(sb.toString());
                } while (functionTable.nextRow());
            }
        }
        catch (ERPException e) {
            ERPLog.getLogger(LogLevel.ERROR).log("Error in getting Table List of Pattern :- " + funcGrpName);
            ERPLog.getLogger(LogLevel.ERROR).log((Throwable)((Object)e));
        }
        return rfcTableNames;
    }

    public List<SAPFieldMetadata> getRFCTableFields(String funName) {
        ArrayList<SAPFieldMetadata> sapfields = new ArrayList<SAPFieldMetadata>();
        if (funName == null) {
            return sapfields;
        }
        funName = SAPUtil.removeDescription(funName);
        JCoFunctionTemplate funTemplate = this.sapclient.getFunctionTemplate(funName);
        JCoListMetaData importParameters = funTemplate.getImportParameterList();
        List<SAPFieldMetadata> importParams = this.getSAPFields((JCoMetaData)importParameters, "Import");
        sapfields.addAll(importParams);
        JCoListMetaData exportParameters = funTemplate.getExportParameterList();
        List<SAPFieldMetadata> exportParams = this.getSAPFields((JCoMetaData)exportParameters, "Export");
        sapfields.addAll(exportParams);
        JCoListMetaData tableParameters = funTemplate.getTableParameterList();
        if (tableParameters != null) {
            for (int i = 0; i < tableParameters.getFieldCount(); ++i) {
                JCoRecordMetaData table = tableParameters.getRecordMetaData(i);
                String tableName = tableParameters.getName(i);
                List<SAPFieldMetadata> tableFields = this.getSAPFields((JCoMetaData)table, tableName);
                sapfields.addAll(tableFields);
            }
        }
        return sapfields;
    }

    private List<SAPFieldMetadata> getSAPFields(JCoMetaData metadata, String prefix) {
        ArrayList<SAPFieldMetadata> fields = new ArrayList<SAPFieldMetadata>();
        if (metadata != null) {
            for (int i = 0; i < metadata.getFieldCount(); ++i) {
                String name = metadata.getName(i);
                if (metadata.isStructure(i)) {
                    JCoRecordMetaData structMetadata = metadata.getRecordMetaData(i);
                    for (int j = 0; j < structMetadata.getFieldCount(); ++j) {
                        String fieldName = prefix + " " + name + " " + structMetadata.getName(j);
                        int decimals = structMetadata.getDecimals(j);
                        int type = structMetadata.getType(j);
                        int length = structMetadata.getLength(j);
                        String desc = structMetadata.getDescription(j);
                        char datatype = SAPUtil.getSAPDataType(type);
                        SAPFieldMetadata sapField = SAPFieldMetadata.getSAPFieldMetadata(fieldName, desc, datatype, 0, length, decimals, true);
                        fields.add(sapField);
                    }
                    continue;
                }
                String fieldName = prefix + " " + metadata.getName(i);
                int decimals = metadata.getDecimals(i);
                short type = (short)metadata.getType(i);
                int length = metadata.getLength(i);
                String desc = metadata.getDescription(i);
                char datatype = SAPUtil.getSAPDataType(type);
                SAPFieldMetadata sapField = SAPFieldMetadata.getSAPFieldMetadata(fieldName, desc, datatype, 0, length, decimals, true);
                fields.add(sapField);
            }
        }
        return fields;
    }
}

