/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.sap.conn.jco.JCoFunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SAPRFCInvocation
implements SAPConstants {
    private final String rfc;
    private final Map<String, String> importParams;
    private final Map<String, List<RFCTableRowFilter>> tableParams;
    private JCoFunction data;

    protected static RFCTableRowFilter getRFCTableRowFilter() {
        return new RFCTableRowFilter();
    }

    public SAPRFCInvocation(String rfc) {
        this.rfc = rfc;
        this.importParams = new LinkedHashMap<String, String>();
        this.tableParams = new LinkedHashMap<String, List<RFCTableRowFilter>>();
    }

    public void addImportParam(String name, String value) {
        this.importParams.put(name, value);
    }

    public void addImportParams(Map<String, String> params) {
        this.importParams.putAll(params);
    }

    public void addRowFilter(String colname, String colvalue) {
        String tblName = this.getTableName(colname);
        List<RFCTableRowFilter> tblrows = this.tableParams.get(tblName);
        RFCTableRowFilter rowFilter = new RFCTableRowFilter();
        rowFilter.addColumnFilter(colname, colvalue);
        if (tblrows == null) {
            ArrayList<RFCTableRowFilter> tablerows = new ArrayList<RFCTableRowFilter>(1);
            tablerows.add(rowFilter);
            this.tableParams.put(tblName, tablerows);
        } else {
            tblrows.add(rowFilter);
        }
    }

    public void addTableRowFilters(Map<String, List<RFCTableRowFilter>> tableparameters) {
        for (Map.Entry<String, List<RFCTableRowFilter>> entry : tableparameters.entrySet()) {
            String tableName = entry.getKey();
            List<RFCTableRowFilter> rows = entry.getValue();
            List<RFCTableRowFilter> targetTableRows = this.tableParams.get(tableName);
            if (targetTableRows == null) {
                this.tableParams.put(tableName, rows);
                continue;
            }
            int rowIndex = 0;
            for (RFCTableRowFilter targetRow : targetTableRows) {
                if (rowIndex >= rows.size()) continue;
                RFCTableRowFilter trow = rows.get(rowIndex);
                targetRow.addColumnFilters(trow.getColumFilters());
                ++rowIndex;
            }
            while (rowIndex < rows.size()) {
                RFCTableRowFilter trow = rows.get(rowIndex);
                targetTableRows.add(trow);
                ++rowIndex;
            }
        }
    }

    private String getTableName(String str) {
        int i = str.indexOf(" ");
        return str.substring(0, i);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("importParams=");
        sb.append(this.importParams.toString());
        sb.append(" tableParams = {");
        int i = 1;
        for (Map.Entry<String, List<RFCTableRowFilter>> ent : this.tableParams.entrySet()) {
            String tableName = ent.getKey();
            List<RFCTableRowFilter> rows = ent.getValue();
            sb.append(" Table = ");
            sb.append(tableName);
            sb.append(" [");
            for (RFCTableRowFilter row : rows) {
                sb.append(" row");
                sb.append(i++);
                sb.append(" = ");
                sb.append(row.colFilters);
            }
            sb.append(" ]");
        }
        sb.append(" }");
        return sb.toString();
    }

    public Map<String, String> getImportParams() {
        return Collections.unmodifiableMap(this.importParams);
    }

    public Map<String, List<RFCTableRowFilter>> getTableParams() {
        return Collections.unmodifiableMap(this.tableParams);
    }

    public String getRfc() {
        return this.rfc;
    }

    protected void setData(JCoFunction data) {
        this.data = data;
    }

    protected JCoFunction getData() {
        return this.data;
    }

    protected String getImportParameterValue(String name) {
        return this.importParams.get(name);
    }

    public static final class RFCTableRowFilter {
        private final Map<String, String> colFilters = new HashMap<String, String>();

        protected RFCTableRowFilter() {
        }

        public void addColumnFilter(String colname, String value) {
            this.colFilters.put(colname, value);
        }

        public void addColumnFilters(Map<String, String> colfilters) {
            this.colFilters.putAll(colfilters);
        }

        public Map<String, String> getColumFilters() {
            return Collections.unmodifiableMap(this.colFilters);
        }
    }
}

