/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTableDescBatchTask;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;

public class SAPTableDesc {
    private final List<List<String>> batchTableList;
    private final SAPClient _client;
    private final BlockingQueue<Map> queue = new LinkedBlockingQueue<Map>();
    private int totalBatchCount;
    private int batchResult = 0;

    public SAPTableDesc(List<List<String>> batchTableList, SAPClient client) {
        this.batchTableList = batchTableList;
        this._client = client;
        this.totalBatchCount = batchTableList.size();
        this.processInvocations();
    }

    private void processInvocations() {
        ExecutorService executor = this._client.getExecutorService();
        for (List<String> batch : this.batchTableList) {
            SAPTableDescBatchTask task = new SAPTableDescBatchTask(batch, this._client, this.queue);
            executor.execute(task);
        }
    }

    public boolean hasNext() {
        return this.batchResult < this.totalBatchCount;
    }

    public Map<String, String> next() throws InterruptedException {
        ++this.batchResult;
        return this.queue.take();
    }
}

