/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPQueryTable;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPTable;
import com.sap.conn.jco.JCoParameterList;
import java.util.List;
import java.util.Map;

public class SAPTablesWrapper
implements SAPQueryTable {
    private final SAPTable[] sapTableArray;
    private final Map<String, Integer> fieldIndexMap;
    private final SAPTable queryTable;

    public SAPTablesWrapper(List<JCoParameterList> params, SAPClient sapclient, Map<String, Integer> fieldIndexMap) {
        this.fieldIndexMap = fieldIndexMap;
        this.sapTableArray = new SAPTable[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            this.sapTableArray[i] = new SAPTable(params.get(i), sapclient);
        }
        this.queryTable = this.sapTableArray.length > 0 ? this.sapTableArray[0] : null;
    }

    @Override
    public String getFieldValue(String name) {
        SAPTable table = this.sapTableArray[this.fieldIndexMap.get(name)];
        return table.getFieldValue(name);
    }

    @Override
    public boolean next() {
        for (SAPTable saptable : this.sapTableArray) {
            if (saptable == null) continue;
            return saptable.next();
        }
        return false;
    }

    public int getRowCount() {
        if (this.queryTable != null) {
            return this.queryTable.getRowCount();
        }
        return 0;
    }
}

