/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.client;

import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConnectionInfo;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPConstants;
import com.sap.conn.jco.JCoField;
import com.sap.conn.jco.JCoFieldIterator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SAPUtil
implements SAPConstants {
    public static String removeDescription(String nameWithDesc) {
        int idx = nameWithDesc.indexOf("-");
        String tname = nameWithDesc;
        if (idx > -1) {
            tname = nameWithDesc.substring(0, idx);
        }
        return tname.trim();
    }

    public static String getDescription(String nameWithDesc) {
        String desc = "";
        int index = nameWithDesc.indexOf("-");
        if (index > -1 && nameWithDesc.length() > index + 2) {
            desc = nameWithDesc.substring(index + 2);
        }
        return desc.trim();
    }

    protected static String concateNateUsingDelimiter(String s1, String s2) {
        StringBuffer sb = new StringBuffer();
        sb.append(s1);
        sb.append("-");
        sb.append(s2);
        return sb.toString();
    }

    public static List<String> getInClause(String variable, List<String> values) {
        ArrayList<String> options = new ArrayList<String>();
        int optLen = 0;
        int len = values.size();
        StringBuilder sb = new StringBuilder();
        sb.append(variable);
        sb.append(" ");
        sb.append("IN");
        sb.append(" ");
        sb.append("(");
        if (sb.length() >= 72) {
            options.add(sb.toString());
            sb.setLength(0);
        }
        for (int i = 0; i < len; ++i) {
            String tabname = values.get(i);
            optLen = tabname.length() + sb.length() + 3;
            if (optLen >= 72) {
                options.add(sb.toString());
                sb.setLength(0);
            }
            sb.append("'");
            sb.append(tabname);
            sb.append("'");
            if (i >= len - 1) continue;
            sb.append(",");
        }
        sb.append(")");
        options.add(sb.toString());
        return options;
    }

    public static Map<String, String> getImporParams(String queryObject, String rowCount, String rowSkips) {
        HashMap<String, String> importparams = new HashMap<String, String>();
        importparams.put("QUERY_TABLE", queryObject);
        importparams.put("ROWCOUNT", rowCount);
        importparams.put("ROWSKIPS", rowSkips);
        return importparams;
    }

    public static char getWorkPlace(String queryArea) {
        char workplace = ' ';
        if (queryArea.equalsIgnoreCase("Global Area")) {
            workplace = 'X';
        }
        return workplace;
    }

    public static String formatDate(String dateStr) {
        String formatedDate = null;
        if (dateStr != null && dateStr.length() == 8) {
            SimpleDateFormat sd1 = new SimpleDateFormat("yyyyMMdd");
            SimpleDateFormat sd2 = new SimpleDateFormat("yyyy-MM-dd");
            Date date = null;
            try {
                date = sd1.parse(dateStr);
                formatedDate = sd2.format(date);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return formatedDate;
    }

    public static String getRepoName(Object obj) {
        StringBuilder sb = new StringBuilder();
        sb.append("Repo");
        String key = Integer.toHexString(obj.hashCode());
        sb.append(key);
        return sb.toString();
    }

    public static String removeApostrophe(String str) {
        int idx2;
        int idx1;
        String temp = str;
        if (str != null && (idx1 = str.indexOf(39)) > -1 && (idx2 = str.indexOf(39, idx1 + 1)) > -1) {
            temp = str.substring(idx1 + 1, idx2);
        }
        return temp;
    }

    public static String getQuotedString(String str) {
        int len;
        if (str != null && (len = str.length()) > 0 && str.charAt(0) != '\'' && str.charAt(len - 1) != '\'') {
            StringBuilder sb = new StringBuilder();
            sb.append('\'');
            sb.append(str);
            sb.append('\'');
            str = sb.toString();
        }
        return str;
    }

    public static String extractFieldName(String str) {
        return str.substring(7);
    }

    public static String getQuotedValue(String tabtype) {
        StringBuilder sb = new StringBuilder();
        sb.append("'");
        sb.append(tabtype);
        sb.append("'");
        return sb.toString();
    }

    protected static List<String> getQuotedList(Collection<String> strlist) {
        ArrayList<String> quoteList = new ArrayList<String>(strlist.size());
        for (String str : strlist) {
            String val = SAPUtil.getQuotedValue(str);
            quoteList.add(val);
        }
        return quoteList;
    }

    public static char getSAPDataType(int type) {
        char dataType = 'C';
        switch (type) {
            case 0: {
                dataType = 'C';
                break;
            }
            case 6: {
                dataType = 'N';
                break;
            }
            case 4: {
                dataType = 'X';
                break;
            }
            case 29: {
                dataType = 'g';
                break;
            }
            case 8: {
                dataType = 'I';
                break;
            }
            case 2: {
                dataType = 'P';
                break;
            }
            case 7: {
                dataType = 'F';
                break;
            }
            case 1: {
                dataType = 'D';
                break;
            }
            case 3: {
                dataType = 'T';
            }
        }
        return dataType;
    }

    public static boolean isValid(String val) {
        return val != null && val.trim().length() > 0;
    }

    public static String escapeSpecialCharacters(String value, String specialChar) {
        StringBuilder sb = new StringBuilder();
        if (value.indexOf(specialChar) != -1) {
            sb.append(':');
            sb.append(specialChar);
            value = value.replaceAll(specialChar, sb.toString());
            sb.setLength(0);
            sb.append(value);
            sb.append("'ESCAPE':");
        } else {
            sb.append(value);
        }
        return sb.toString();
    }

    public static JCoField getField(JCoFieldIterator fieldIterator, String name) {
        while (fieldIterator.hasNextField()) {
            JCoField field = fieldIterator.nextField();
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public static String getDestinationName(SAPConnectionInfo connInfo) {
        StringBuffer sb = new StringBuffer();
        String client = connInfo.getClient();
        String user = connInfo.getUser();
        String password = connInfo.getPassword();
        String language = connInfo.getLanguage();
        String messageServer = connInfo.getMessageServer();
        String routerString = connInfo.getRouterString();
        String systemId = connInfo.getSystemId();
        String logonGroup = connInfo.getLogonGroup();
        String server = connInfo.getServer();
        String systemNo = connInfo.getSystemNo();
        int conn = connInfo.getConnPoolPeakLimit();
        sb.append(user);
        sb.append(password);
        sb.append(conn);
        sb.append(language);
        if (SAPUtil.isLoadBalancedEnvironment(connInfo)) {
            sb.append(messageServer);
            sb.append(systemId);
            sb.append(logonGroup);
        } else {
            sb.append(routerString);
            sb.append(server);
            sb.append(client);
            sb.append(systemNo);
        }
        sb.append(connInfo.isPoolingEnabled());
        String s = sb.toString();
        return Integer.toHexString(s.hashCode());
    }

    public static boolean isLoadBalancedEnvironment(SAPConnectionInfo sapConnInfo) {
        return SAPUtil.isValid(sapConnInfo.getMessageServer()) && SAPUtil.isValid(sapConnInfo.getSystemId()) && SAPUtil.isValid(sapConnInfo.getLogonGroup());
    }
}

