/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.relational.erp.sap.resultset;

import com.cognos.xqe.data.providers.relational.erp.ERPException;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPClient;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLogger;
import com.cognos.xqe.data.providers.relational.erp.sap.client.SAPLoggerFactory;
import com.cognos.xqe.exception.XQEMessageKeys;
import java.math.BigDecimal;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public class SAPMetadataHelper {
    private static final int TIME_LENGTH_HHMMSS_FORMAT_8 = 8;
    private static final int TIME_LENGTH_HHMMSS_FORMAT_6 = 6;
    private static final int TIME_LENGTH_HHMM_FORMAT = 4;
    private static final int TIME_LENGTH_HH_FORMAT = 2;
    private static final int ZERO = 48;
    private static final int NINE = 57;
    private SAPClient sapClient;
    private final SimpleDateFormat sapDefaultTimeFormat6 = new SimpleDateFormat("HHmmss");
    private final SimpleDateFormat sapDefaultTimeFormat4 = new SimpleDateFormat("HHmm");
    private final SimpleDateFormat sapDefaultTimeFormat2 = new SimpleDateFormat("HH");
    private final SimpleDateFormat sapDefaultTimeFormat8 = new SimpleDateFormat("HH:mm:ss");
    private final SimpleDateFormat sapDefaultDateFormat = new SimpleDateFormat("yyyyMMdd");
    private boolean isParseDecimalValues;
    private final SimpleDateFormat userDefualtDateFormat;
    private Map<String, String> dateTimeDefaultValuesMap;
    private static SAPLogger logger = SAPLoggerFactory.getLogger(SAPMetadataHelper.class);

    public SAPMetadataHelper(SAPClient client) {
        this.sapClient = client;
        this.sapDefaultDateFormat.setLenient(false);
        String dateformat = client.getDateFormat().toLowerCase();
        dateformat = dateformat.replace('m', 'M');
        this.userDefualtDateFormat = new SimpleDateFormat(dateformat);
        this.isParseDecimalValues = client.isParseDecimalValues();
        this.dateTimeDefaultValuesMap = this.sapClient.getDateTimeDefaultValuesMap();
        if (this.dateTimeDefaultValuesMap == null) {
            this.dateTimeDefaultValuesMap = Collections.EMPTY_MAP;
        }
        this.isParseDecimalValues = this.sapClient.isParseDecimalValues();
    }

    public Object convertValue(String sapValue, Class classType, boolean isABAP, int scale) {
        if (sapValue == null) {
            return null;
        }
        BigDecimal decVal = null;
        try {
            if (classType == String.class) {
                return sapValue;
            }
            if (classType == Integer.class) {
                decVal = this.getBigDecimal(sapValue, isABAP, 0);
                return decVal.intValue();
            }
            if (classType == Long.class) {
                decVal = this.getBigDecimal(sapValue, isABAP, 0);
                return decVal.longValue();
            }
            if (classType == Float.class) {
                decVal = this.getBigDecimal(sapValue, isABAP, 0);
                return Float.valueOf(decVal.floatValue());
            }
            if (classType == Double.class) {
                decVal = this.getBigDecimal(sapValue, isABAP, scale);
                return decVal.doubleValue();
            }
            if (classType.getName().equals(BigDecimal.class.getName())) {
                decVal = this.getBigDecimal(sapValue, isABAP, scale);
                return decVal;
            }
            if (classType == Date.class) {
                if (this.dateTimeDefaultValuesMap.containsKey(sapValue)) {
                    sapValue = this.dateTimeDefaultValuesMap.get(sapValue);
                }
                if (sapValue != null) {
                    if (isABAP) {
                        return this.userDefualtDateFormat.parse(sapValue);
                    }
                    return this.sapDefaultDateFormat.parse(sapValue);
                }
            } else if (classType == Time.class) {
                if (this.dateTimeDefaultValuesMap.containsKey(sapValue)) {
                    sapValue = this.dateTimeDefaultValuesMap.get(sapValue);
                }
                if (sapValue != null) {
                    int len = sapValue.length();
                    if (len == 8) {
                        return new Time(this.sapDefaultTimeFormat8.parse(sapValue).getTime());
                    }
                    if (len == 6) {
                        return new Time(this.sapDefaultTimeFormat6.parse(sapValue).getTime());
                    }
                    if (len >= 4) {
                        String str1 = sapValue.substring(0, 4);
                        return new Time(this.sapDefaultTimeFormat4.parse(str1).getTime());
                    }
                    if (len >= 2) {
                        String str2 = sapValue.substring(0, 2);
                        return new Time(this.sapDefaultTimeFormat2.parse(str2).getTime());
                    }
                }
            }
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            sb.append("DATA_PARSING_ERROR");
            sb.append(" - value ");
            sb.append(sapValue);
            sb.append(", type ");
            sb.append(classType);
            sb.append(", scale ");
            sb.append(scale);
            logger.error(sb.toString(), e);
            throw new ERPException(XQEMessageKeys.ERP_DataParsingError, e, sapValue, classType.toString());
        }
        return null;
    }

    private BigDecimal getBigDecimal(String value, boolean isABAP, int scale) {
        BigDecimal decimalvalue = null;
        if (isABAP) {
            value = this.getDecimalString(value, scale, true);
            decimalvalue = new BigDecimal(value);
        } else {
            value = this.getDecimalString(value, scale, this.isParseDecimalValues);
            decimalvalue = new BigDecimal(value);
        }
        return decimalvalue;
    }

    private String getDecimalString(String fieldval, int scale, boolean parseDecimal) {
        int fieldLen = fieldval.length();
        StringBuilder sb = new StringBuilder();
        int j = fieldLen - 1;
        boolean isNegative = false;
        if (j > 0 && fieldval.charAt(j) == '-') {
            sb.append('-');
            isNegative = true;
        }
        if (parseDecimal) {
            for (int i = 0; i < fieldLen; ++i) {
                char c = fieldval.charAt(i);
                if (c < '0' || c > '9') continue;
                sb.append(c);
            }
            if (scale > 0) {
                int index = sb.length() - scale;
                sb.insert(index, ".");
            }
        } else if (isNegative) {
            sb.append(fieldval.substring(0, fieldLen - 1));
        } else {
            sb.append(fieldval);
        }
        String decstr = sb.toString();
        return decstr;
    }
}

