/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.ProviderIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseDimensionCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMemberAncestorsHelper;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMemberCacheKey;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataCache;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataNames;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseResultSet;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.essbase.api.base.IEssIterator;
import com.essbase.api.base.IEssValueAny;
import com.essbase.api.dataquery.IEssMdAxis;
import com.essbase.api.dataquery.IEssMdMember;
import com.essbase.api.metadata.IEssMember;
import com.essbase.api.metadata.IEssMemberSelection;
import java.util.ArrayList;
import java.util.Map;

public class EssbaseAxisIterator
extends ProviderIteratorBase {
    private final IEssMdAxis essAxis;
    private int tupleCount = 0;
    private boolean mHasNext = false;
    private final ICube mCube;
    private Map<EssbaseMemberCacheKey, Member> resultMemberCache = null;
    private final EssbaseConnection connection;
    private final EssbaseWrappers essbaseAPI;
    private final String aliasTableName;
    private final XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"DataQuery", (LogLevel)LogLevel.TRACE);

    public EssbaseAxisIterator(EssbaseResultSet resultSet, XDataContext xDataContext, ICube cube, int theAxisNumber, Integer theNodeId) {
        super((ProviderResultSetBase)resultSet, xDataContext, theNodeId);
        super.setEdgeNumber(theAxisNumber);
        IEssMdAxis[] essmdAxes = resultSet.getAxis();
        this.essAxis = essmdAxes[theAxisNumber];
        this.mCube = cube;
        this.resultMemberCache = resultSet.getResultMemberCache();
        this.connection = resultSet.getConnection();
        this.essbaseAPI = this.connection.getEssAPI();
        this.aliasTableName = resultSet.getAliasTableName();
        int theTupleCount = this.essbaseAPI.getTupleCount(this.essAxis);
        if (theTupleCount > 0) {
            this.mHasNext = true;
            this.tupleCount = theTupleCount;
        }
    }

    public Object nextImpl() {
        Tuple result = null;
        IMember[] tuple = null;
        if (!this.mHasNext) {
            return null;
        }
        tuple = this.getNextTuple((int)this.currentIndex + 1);
        if (tuple.length == 0) {
            return null;
        }
        ++this.currentIndex;
        this.mHasNext = this.currentIndex + 1L < (long)this.tupleCount;
        result = new Tuple(tuple, false);
        return result;
    }

    private ILevel determineLevel(String dimensionUniqueName, int levelNumber) {
        IDimension aDimension = this.mCube.getDimension(dimensionUniqueName);
        if (aDimension == null) {
            return null;
        }
        IHierarchy aHierarchy = aDimension.getDefaultHierarchy();
        if (aHierarchy == null) {
            return null;
        }
        return aHierarchy.getLevel(levelNumber);
    }

    public IMember[] getNextTuple(int tupleIndex) {
        IMember[] tuple = new IMember[]{};
        if (tupleIndex >= this.tupleCount) {
            return tuple;
        }
        EssbaseMetadataCache metadataCache = this.connection.getMetadataCache();
        Map<String, IEssMember> essRootMembers = metadataCache.getEssRootMemberMap();
        String measureDimensionName = metadataCache.getMeasureDimensionName();
        IEssMdMember[] essMbrs = this.essbaseAPI.getAllTupleMembers(this.essAxis, tupleIndex);
        ArrayList<Member> membersFound = new ArrayList<Member>(essMbrs.length);
        for (IEssMdMember mbr : essMbrs) {
            String memberName = this.essbaseAPI.getMdMemberName(mbr);
            EssbaseMemberAncestorsHelper ancestorNames = new EssbaseMemberAncestorsHelper(this.connection, mbr);
            String parentName = ancestorNames.getParentName();
            Member currentMember = null;
            EssbaseMemberCacheKey memberKey = new EssbaseMemberCacheKey(parentName, memberName);
            currentMember = this.resultMemberCache.get(memberKey);
            if (currentMember == null) {
                currentMember = new Member(memberName);
                currentMember.setCaption(memberName);
                IEssMdMember essDim = this.essbaseAPI.getDimension(mbr);
                String dimensionName = this.essbaseAPI.getMdMemberName(essDim);
                boolean isMeasure = false;
                if (dimensionName.equals(measureDimensionName)) {
                    isMeasure = true;
                }
                String[] propertyNames = this.essbaseAPI.getPropertyNames(essDim);
                int propertyCount = propertyNames.length;
                int levelNumber = -1;
                int genNumber = -1;
                String caption = null;
                for (int ii = 0; ii < propertyCount; ++ii) {
                    StringValue v;
                    StringValue v2;
                    String propertyName = propertyNames[ii];
                    IEssValueAny propertyValue = this.essbaseAPI.getPropertyValueAny(mbr, ii);
                    if (propertyValue == null || this.essbaseAPI.getDataTypeIntValue(propertyValue) == 0) continue;
                    IEssValueAny.EEssDataType type = this.essbaseAPI.getPropertyDataType(mbr, ii);
                    if (propertyName.equalsIgnoreCase("LEVEL_NUMBER")) {
                        levelNumber = (int)this.essbaseAPI.getLong(propertyValue);
                        continue;
                    }
                    if (propertyName.equalsIgnoreCase("GEN_NUMBER")) {
                        genNumber = (int)this.essbaseAPI.getLong(propertyValue);
                        continue;
                    }
                    if (propertyName.equalsIgnoreCase("ANCESTOR_NAMES")) {
                        v2 = DataValueFactory.createStringValue();
                        v2.set(propertyValue.toString());
                        currentMember.setProperty(propertyName, (Object)v2);
                        if (!ancestorNames.isParentExist()) continue;
                        String pun = ancestorNames.getParentUniqueName();
                        v2 = DataValueFactory.createStringValue();
                        v2.set(pun);
                        currentMember.setProperty("PARENT_UNIQUE_NAME", (Object)v2);
                        currentMember.setParentUniqueName(pun);
                        continue;
                    }
                    if (propertyName.equalsIgnoreCase(this.aliasTableName)) {
                        caption = propertyValue.toString();
                        if (caption == null || caption.trim().length() <= 0) continue;
                        v2 = DataValueFactory.createStringValue();
                        v2.set(caption);
                        currentMember.setProperty(propertyName, (Object)v2);
                        currentMember.setCaption(caption);
                        continue;
                    }
                    if (propertyName.equalsIgnoreCase("COMMENTS")) {
                        String description = propertyValue.toString();
                        v = DataValueFactory.createStringValue();
                        v.set(description);
                        currentMember.setProperty("DESCRIPTION", (Object)v);
                        continue;
                    }
                    if (propertyName.equalsIgnoreCase("MEMBER_NAME")) {
                        currentMember.setProperty("MEMBER_NAME", (Object)memberName);
                        StringValue keyValue = DataValueFactory.createStringValue();
                        keyValue.set(memberName);
                        currentMember.setBusinessKey((Value)keyValue);
                        continue;
                    }
                    if (propertyName.equalsIgnoreCase("MEMBER_ALIAS")) {
                        v2 = DataValueFactory.createStringValue();
                        v2.set(memberName);
                        currentMember.setProperty("MEMBER_ALIAS", (Object)v2);
                        continue;
                    }
                    if ("MEMBER_TYPE".equals(propertyName)) {
                        currentMember.setType(EssbaseUtil.getMemberType(this.connection, mbr, isMeasure));
                        continue;
                    }
                    String propertyUNAme = UniqueNameGenerator.createUniqueName((String)dimensionName, (String)propertyName);
                    v = EssbaseUtil.getPropertyValue(this.connection, propertyName, type, propertyValue, this.aliasTableName);
                    currentMember.setProperty(propertyUNAme, (Object)v);
                }
                String externalMUN = null;
                externalMUN = ancestorNames.isParentExist() ? UniqueNameGenerator.appendUniqueName((String)ancestorNames.getParentUniqueName(), (String)memberName) : (dimensionName.equals(memberName) ? UniqueNameGenerator.createUniqueName((String)memberName) : UniqueNameGenerator.createUniqueName((String)dimensionName, (String)memberName));
                currentMember.setUniqueName(externalMUN);
                if (levelNumber == -1 || genNumber == -1) {
                    IEssMember essRootMember = essRootMembers.get(dimensionName);
                    levelNumber = this.essbaseAPI.getLevelNumber(essRootMember);
                    genNumber = 1;
                }
                IntegerValue vLevelNumber = DataValueFactory.createIntegerValue();
                vLevelNumber.set(levelNumber);
                vLevelNumber.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                currentMember.setProperty("LEVEL_NUMBER", (Object)vLevelNumber);
                int actualLevelIndex = genNumber - 1;
                if (isMeasure && actualLevelIndex > 0) {
                    --actualLevelIndex;
                }
                IntegerValue vGenNumber = DataValueFactory.createIntegerValue();
                vGenNumber.set(actualLevelIndex);
                vGenNumber.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                currentMember.setProperty("GEN_NUMBER", (Object)vGenNumber);
                if (ancestorNames.isParentExist()) {
                    currentMember.setParentLevelNumber(actualLevelIndex - 1);
                    currentMember.setNumberOfParents(1);
                } else {
                    currentMember.setParentLevelNumber(-1);
                    currentMember.setNumberOfParents(0);
                }
                ILevel refLevel = null;
                if (this.mCube != null) {
                    String cognosDUN = EssbaseMetadataNames.createDimensionUniqueName(dimensionName);
                    refLevel = this.determineLevel(cognosDUN, actualLevelIndex);
                    if (refLevel != null) {
                        StringValue vLevelUN = DataValueFactory.createStringValue();
                        vLevelUN.set(refLevel.getUniqueName());
                        currentMember.setProperty("LEVEL_UNIQUE_NAME", (Object)vLevelUN);
                        currentMember.setLevel(refLevel);
                    }
                } else {
                    throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_CUBE_OBJECT);
                }
                MetadataConnection iConnection = this.mCube.getConnection();
                if (iConnection != null) {
                    currentMember.setConnection(iConnection);
                }
                if (this.isRollupComputed(dimensionName, memberName, levelNumber)) {
                    currentMember.setRollupType(RollupTypeEnum.COMPUTED);
                } else {
                    currentMember.setRollupType(RollupTypeEnum.ROLLUP);
                }
                this.resultMemberCache.put(memberKey, currentMember);
            }
            membersFound.add(currentMember);
        }
        tuple = membersFound.toArray(new IMember[0]);
        return tuple;
    }

    private boolean isRollupComputed(String dimensionName, String memberName, int essbaseLevelNumber) {
        EssbaseMetadataCache metadataCache = this.connection.getMetadataCache();
        EssbaseDimensionCacheItem cachedDimension = metadataCache.getDimension(dimensionName);
        if (cachedDimension.getType() != DimensionTypeEnum.SCENARIO) {
            return false;
        }
        if (essbaseLevelNumber == 0) {
            return false;
        }
        boolean isMemberFormula = EssbaseUtil.isFormula(this.connection, memberName);
        if (isMemberFormula) {
            return true;
        }
        boolean foundNonSumRollup = false;
        IEssMemberSelection mbrSel = this.connection.openMbrSel();
        this.essbaseAPI.executeQuery(mbrSel, memberName, 1, dimensionName, "", "");
        IEssIterator essMembers = this.essbaseAPI.getMembers(mbrSel);
        int essMembersCount = this.essbaseAPI.getCount(essMembers);
        for (int i = 0; i < essMembersCount; ++i) {
            IEssMember essChild = (IEssMember)this.essbaseAPI.getAt(essMembers, i);
            int type = this.essbaseAPI.getConsolidationType(essChild);
            if (type == 0) continue;
            foundNonSumRollup = true;
            break;
        }
        this.connection.releaseMbrSel(mbrSel);
        return foundNonSumRollup;
    }

    public void releaseImpl() {
        if (null != this.logger && this.logger.isOn()) {
            this.logger.log("Release called on AxisIterator.");
        }
        this.mHasNext = false;
    }
}

