/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.ProviderScrollableCellIteratorBase;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseCell;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseFormatter;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseResultSet;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.essbase.api.dataquery.IEssMdDataSet;

public class EssbaseCellIterator
extends ProviderScrollableCellIteratorBase {
    private final IEssMdDataSet essmddata;
    private final EssbaseWrappers essbaseAPI;
    boolean mHasNext = false;
    private final XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"DataQuery", (LogLevel)LogLevel.TRACE);
    private final EssbaseFormatter formatHelper;
    private ICell currentCell = null;
    private long nextOrdinal = -1L;
    private boolean bHasNextCalled = false;
    private final int cellCount;

    EssbaseCellIterator(EssbaseResultSet resultSet, XDataContext xDataContext, IEssMdDataSet inmddata, EssbaseFormatter theFormatHelper, Integer theNodeId) {
        super((ProviderResultSetBase)resultSet, xDataContext, theNodeId);
        this.essmddata = inmddata;
        this.essbaseAPI = resultSet.getEssAPI();
        this.formatHelper = theFormatHelper;
        this.cellCount = this.essbaseAPI.getCellCount(this.essmddata);
    }

    public boolean hasNext() {
        if (!this.bHasNextCalled) {
            for (int i = (int)this.currentOrdinal + 1; i < this.cellCount; ++i) {
                if (!this.isCellValueNotNull(i)) continue;
                this.nextOrdinal = i;
                break;
            }
            this.mHasNext = this.nextOrdinal > this.currentOrdinal;
            this.bHasNextCalled = true;
        }
        return this.mHasNext;
    }

    public ICell nextImpl() {
        if (!this.bHasNextCalled) {
            this.hasNext();
        }
        if (this.mHasNext) {
            this.fetchCell(this.nextOrdinal);
        } else {
            this.currentCell = null;
            this.currentOrdinal = this.cellCount;
        }
        return this.currentCell;
    }

    public ICell current() {
        return this.currentCell;
    }

    public boolean absolute(long index) {
        if (index == this.currentOrdinal) {
            return true;
        }
        if (index < 0L || index >= (long)this.cellCount) {
            return false;
        }
        this.fetchCell(index);
        return true;
    }

    public boolean reset() {
        return this.absolute(0L);
    }

    private boolean isCellValueNotNull(int cellOrdinal) {
        return !this.essbaseAPI.isMissingCell(this.essmddata, cellOrdinal) && !this.essbaseAPI.isNoAccessCell(this.essmddata, cellOrdinal);
    }

    private ICell fetchCell(long ordinal) {
        int cellOrdinal = (int)ordinal;
        EssbaseCell cell = null;
        if (this.isCellValueNotNull(cellOrdinal)) {
            double dbl = this.essbaseAPI.getCellValue(this.essmddata, cellOrdinal);
            Double result = dbl;
            DoubleValue value = DataValueFactory.createDoubleValue();
            value.set(result.doubleValue());
            FormatId formatId = this.formatHelper.findMeasureFormatID(cellOrdinal);
            if (formatId != null) {
                ((Value)value).setFormatId(formatId);
            }
            cell = new EssbaseCell();
            cell.setValue((IValue)value);
            cell.setOrdinal(ordinal);
        }
        this.currentCell = cell;
        this.currentOrdinal = ordinal;
        this.bHasNextCalled = false;
        return this.currentCell;
    }

    public boolean hasPrevious() {
        for (int i = (int)this.currentOrdinal - 1; i > -1; --i) {
            if (!this.isCellValueNotNull(i)) continue;
            return true;
        }
        return false;
    }

    public ICell previous() {
        for (int i = (int)this.currentOrdinal - 1; i > -1; --i) {
            if (!this.isCellValueNotNull(i)) continue;
            this.fetchCell(i);
            return this.currentCell;
        }
        this.currentCell = null;
        this.currentOrdinal = -1L;
        this.bHasNextCalled = false;
        return null;
    }

    public ICell byOrdinal(long ordinal) {
        if (!this.absolute(ordinal)) {
            return null;
        }
        return this.currentCell;
    }

    public void releaseImpl() {
        if (null != this.logger && this.logger.isOn()) {
            this.logger.log("Release called on CellIterator.");
        }
        this.mHasNext = false;
        this.currentCell = null;
    }
}

