/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IUsernamePasswordSignon;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.connection.parameters.AttributeRepresentationType;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.NamespaceParameter;
import com.cognos.xqe.data.providers.connection.parameters.PasswordParameter;
import com.cognos.xqe.data.providers.connection.parameters.ServerParameter;
import com.cognos.xqe.data.providers.connection.parameters.UserIDParameter;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.IOLAPDataProvider;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseConfig;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseDataProvider;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseExceptionHandler;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMemberSelection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataCache;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.essbase.api.base.EssException;
import com.essbase.api.base.IEssIterator;
import com.essbase.api.dataquery.IEssCubeView;
import com.essbase.api.dataquery.IEssMdDataSet;
import com.essbase.api.dataquery.IEssOpMdxQuery;
import com.essbase.api.dataquery.IEssOperation;
import com.essbase.api.datasource.IEssCube;
import com.essbase.api.datasource.IEssOlapApplication;
import com.essbase.api.datasource.IEssOlapServer;
import com.essbase.api.domain.IEssDomain;
import com.essbase.api.metadata.IEssDimension;
import com.essbase.api.metadata.IEssMember;
import com.essbase.api.metadata.IEssMemberSelection;
import com.essbase.api.session.IEssbase;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class EssbaseConnection
extends DefaultConnection {
    private static final String STR_SERVER = "\"; server:\"";
    private static final String STR_CATALOG = "\"; catalog:\"";
    private static final String STR_CUBE = "\"; cube:\"";
    private static final String STR_ATTRIBUTE_AS = "\", attribute_as:\"";
    private static final String STR_QUOTE = "\"";
    private static final String STR_DOT = "\".";
    private static final String ERROR_RETURNED_FROM = "Error returned from ";
    private static final String ESSBASE_SERVER_VERSION_PREFIX = "ESSBASE SERVER ";
    private String essOlapSvrName;
    private boolean connected = false;
    private boolean isValid = true;
    private static final String STR_MDX_QUERY = "MDX Query";
    private static final String STR_ESSPROVIDER = "Embedded";
    private IEssbase essbaseJAPI = null;
    private final EssbaseDataProvider dataProvider;
    private IEssDomain domain = null;
    private IEssOlapServer essConnection = null;
    private EssbaseConnectionParameters essConnectParams = new EssbaseConnectionParameters();
    private IEssCubeView essCubeView = null;
    protected final XQELogger loggerConnect = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"Connection", (LogLevel)LogLevel.INFO);
    protected final XQELogger logger3rdp = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"3rdParty", (LogLevel)LogLevel.INFO);
    private final EssbaseExceptionHandler mEssbaseExceptionHandler = new EssbaseExceptionHandler(this);
    private final EssbaseWrappers essbaseAPI = new EssbaseWrappers(this.mEssbaseExceptionHandler);
    private final EssbaseMetadataCache metadataCache = new EssbaseMetadataCache(this);
    private String mPoolDisabled = null;
    private EssbaseMemberSelection memberSelectionHandlers = null;
    private static final int ESSBASE_SIGNON_FAILURE_CODE = 5;
    private static final int ESSBASE_LOGON_FAILURE_CODE = 4;
    private static final int ESSBASE_SERVER_NOT_EXISTS = 1042003;
    private static final int ESSBASE_ERROR = -1;
    private Date connectionUpdateDate = new Date();
    private String metadataUpdateMarkerName = null;
    private String metadataUpdateMarkerValue = null;

    public EssbaseConnection(IOLAPDataProvider provider, ConnectionParameters connectionParameters) {
        super(provider);
        this.setConnectionParameters(connectionParameters);
        this.connect(connectionParameters);
        this.dataProvider = (EssbaseDataProvider)provider;
        this.metadataUpdateMarkerName = EssbaseConfig.instance().getMetadataUpdateMarkerName();
        this.refreshSchemaUpdateMarkerValue();
    }

    public final EssbaseMetadataCache getMetadataCache() {
        return this.metadataCache;
    }

    private void connect(ConnectionParameters connectionParameters) {
        String essUserName = (String)connectionParameters.valueOf(UserIDParameter.class, String.class);
        String essPassword = (String)connectionParameters.valueOf(PasswordParameter.class, String.class);
        String essNamespace = (String)connectionParameters.valueOf(NamespaceParameter.class, String.class);
        this.essOlapSvrName = (String)connectionParameters.valueOf(ServerParameter.class, String.class);
        String connCatalog = (String)connectionParameters.valueOf(CatalogParameter.class, String.class);
        String connCube = (String)connectionParameters.valueOf(CubeParameter.class, String.class);
        String attributeRepresentation = (String)connectionParameters.valueOf(AttributeRepresentationType.class, String.class);
        IUsernamePasswordSignon overrideSignon = null;
        try {
            Class<?> clazz = Class.forName("com.cognos.xqe.test.data.provider.EssbaseUserSetup");
            Method meth = clazz.getMethod("getSignon", new Class[0]);
            overrideSignon = (IUsernamePasswordSignon)meth.invoke(null, new Object[0]);
        }
        catch (Throwable clazz) {
            // empty catch block
        }
        if (overrideSignon == null) {
            try {
                this.connect(essUserName, essPassword, connCatalog, connCube, attributeRepresentation, essNamespace);
            }
            catch (EssException e) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_CONNECT_FAILURE, e);
            }
        }
        try {
            this.connect(overrideSignon.getUserName(), (String)overrideSignon.getPassword().decrypt(), connCatalog, connCube, attributeRepresentation, essNamespace);
        }
        catch (EssException e1) {
            if (this.loggerConnect.isOn(LogLevel.WARN)) {
                this.loggerConnect.log(LogLevel.WARN, "Personal Essbase user ID is not set for user: " + overrideSignon.getUserName());
            }
            try {
                this.connect(essUserName, essPassword, connCatalog, connCube, attributeRepresentation, essNamespace);
            }
            catch (EssException e2) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_CONNECT_FAILURE, e2);
            }
        }
    }

    private void connect(String userID, String userPassw, String connectionCatalogName, String connectionCubeName, String attributeRepresentation, String namespace) throws EssException {
        this.essConnectParams.setParameters(userID, userPassw, connectionCatalogName, connectionCubeName, attributeRepresentation, namespace);
        if (this.loggerConnect.isOn()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Connection request for user:\"").append(userID);
            buf.append(STR_SERVER).append(this.essOlapSvrName);
            buf.append(STR_CATALOG).append(connectionCatalogName);
            buf.append(STR_CUBE).append(connectionCubeName);
            buf.append(STR_ATTRIBUTE_AS).append(attributeRepresentation).append(STR_DOT);
            this.loggerConnect.log(buf.toString());
        }
        try {
            this.essbaseJAPI = IEssbase.Home.create((String)"11.1.2.4");
            this.domain = this.essbaseJAPI.signOn(userID, userPassw, false, null, STR_ESSPROVIDER);
            this.essConnection = this.domain.getOlapServer(this.essOlapSvrName);
            this.essConnection.connect();
            String version = this.essbaseAPI.getOlapServerVersion(this.essConnection);
            char firstChar = version.charAt(0);
            if (firstChar != '9' && firstChar != '1') {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_UNSUPPORTED_VERSION, version);
            }
            this.loggerConnect.log("Essbase connection established.");
            IEssIterator essCatalogs = this.essbaseAPI.getCatalogs(this.essConnection);
            Map<String, IEssOlapApplication> catalogMap = this.metadataCache.getCatalogMap();
            int countEssCatalogs = this.essbaseAPI.getCount(essCatalogs);
            for (int c = 0; c < countEssCatalogs; ++c) {
                IEssOlapApplication app = (IEssOlapApplication)this.essbaseAPI.getAt(essCatalogs, c);
                String catalogName = this.essbaseAPI.getApplicationName(app).toUpperCase();
                catalogMap.put(catalogName, app);
                LinkedHashMap cubes = new LinkedHashMap();
                this.metadataCache.getCubeMap().put(catalogName, cubes);
            }
            IEssOlapApplication catalog = null;
            if (!EssbaseUtil.isEmpty(connectionCatalogName) && (catalog = catalogMap.get(connectionCatalogName.toUpperCase())) == null) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_CATALOG_NAME, connectionCatalogName);
            }
            this.metadataCacheInitialLoad(catalog, connectionCubeName);
            this.connected = true;
        }
        catch (EssException e) {
            if (this.loggerConnect.isOn(LogLevel.ERROR)) {
                StringBuilder buf = new StringBuilder();
                buf.append(userID).append(STR_SERVER).append(this.essOlapSvrName);
                buf.append(STR_CATALOG).append(connectionCatalogName);
                buf.append(STR_CUBE).append(connectionCubeName);
                buf.append(STR_ATTRIBUTE_AS).append(attributeRepresentation).append(STR_DOT);
                this.loggerConnect.log(LogLevel.ERROR, "Essbase connection request failed for user:\"" + buf.toString());
            }
            if (e.getNativeCode() == 1042003 || e.getNativeCode() == -1) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_CONNECT_FAILURE, e);
            }
            if (e.getCode() == 5 || e.getCode() == 4) {
                if (namespace == null) {
                    throw new LogonFailureException(LogonFailureException.SubCodeEnum.INVALID_CREDENTIALS);
                }
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_NAME_SPACE_CONNECT_FAILURE, namespace);
            }
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_CONNECT_FAILURE, e);
        }
    }

    private void metadataCacheInitialLoad(IEssOlapApplication catalog, String cubeName) throws EssException {
        if (!EssbaseUtil.isEmpty(cubeName)) {
            IEssCube essCube = this.essbaseAPI.getCube(catalog, cubeName);
            this.metadataCache.setEssConnectionCube(essCube);
            this.memberSelectionHandlers = new EssbaseMemberSelection(this.essbaseAPI, essCube);
            IEssIterator essDimensionList = null;
            try {
                essDimensionList = essCube.getDimensions();
            }
            catch (EssException e) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_CUBE_NAME, cubeName);
            }
            Map<String, IEssDimension> cachedEssDimensions = this.metadataCache.getEssDimensionMap();
            StringBuilder buf = new StringBuilder();
            int count = this.essbaseAPI.getCount(essDimensionList);
            for (int i = 0; i < count; ++i) {
                IEssDimension essDim = (IEssDimension)this.essbaseAPI.getAt(essDimensionList, i);
                String dimName = this.essbaseAPI.getDimensionName(essDim);
                cachedEssDimensions.put(dimName, essDim);
                int dimCategory = this.essbaseAPI.intValue(this.essbaseAPI.getTag(essDim));
                if (dimCategory == 1) {
                    this.metadataCache.setMeasureDimensionName(dimName);
                }
                if (i > 0) {
                    buf.append(",");
                }
                buf.append(STR_QUOTE).append(dimName).append(STR_QUOTE);
            }
            String[] aliasTableNames = this.essbaseAPI.getAliasTableNames(essCube);
            this.metadataCache.setEssAliasTableNames(aliasTableNames);
            Map<String, IEssMember> essRootMembers = this.metadataCache.getEssRootMemberMap();
            Map<String, Map<String, String>> rootMemberCaptions = this.metadataCache.getRootMemberAliasNames();
            IEssMemberSelection mbrSel = this.openMbrSel();
            mbrSel.executeQuery(" <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buf.toString());
            IEssIterator essMembers = this.essbaseAPI.getMembers(mbrSel);
            int essMembersCount = this.essbaseAPI.getCount(essMembers);
            for (int memberNo = 0; memberNo < essMembersCount; ++memberNo) {
                IEssMember essMember = (IEssMember)this.essbaseAPI.getAt(essMembers, memberNo);
                String memberName = this.essbaseAPI.getMemberName(essMember);
                essRootMembers.put(memberName, essMember);
                HashMap<String, String> captions = new HashMap<String, String>();
                for (String aliasTableName : aliasTableNames) {
                    String captionName = this.essbaseAPI.getAlias(essMember, aliasTableName);
                    if (captionName != null) {
                        captions.put(aliasTableName, captionName);
                        continue;
                    }
                    captions.put(aliasTableName, memberName);
                }
                rootMemberCaptions.put(memberName, captions);
            }
            this.releaseMbrSel(mbrSel);
        }
    }

    public MetadataUpdateMarkerEnum refreshSchemaUpdateMarkerValue() {
        IEssCube essCube = this.metadataCache.getEssConnectionCube();
        if (essCube == null) {
            return MetadataUpdateMarkerEnum.NOTDETECTED;
        }
        String[][] svList = this.essbaseAPI.getSubstitutionVariables(essCube);
        if (svList == null) {
            return MetadataUpdateMarkerEnum.NOTDETECTED;
        }
        for (int svNo = 0; svNo < svList.length; ++svNo) {
            String svName = svList[svNo][0];
            if (!this.metadataUpdateMarkerName.equalsIgnoreCase(svName)) continue;
            String svValue = svList[svNo][1];
            if (EssbaseUtil.isEmpty(svValue)) {
                return MetadataUpdateMarkerEnum.NOTDETECTED;
            }
            this.dataProvider.setMetadataUpdateMarkerValue(svValue);
            if (this.metadataUpdateMarkerValue == null) {
                this.metadataUpdateMarkerValue = svValue;
                return MetadataUpdateMarkerEnum.NOTCHANGED;
            }
            if (svValue.equals(this.metadataUpdateMarkerValue)) {
                return MetadataUpdateMarkerEnum.NOTCHANGED;
            }
            this.metadataUpdateMarkerValue = svValue;
            if (this.loggerConnect.isOn()) {
                this.loggerConnect.log("Detected a new value of metadataUpdateMarker: " + svValue);
            }
            return MetadataUpdateMarkerEnum.CHANGED;
        }
        return MetadataUpdateMarkerEnum.NOTDETECTED;
    }

    public String getMetadataUpdateMarkerValue() {
        return this.metadataUpdateMarkerValue;
    }

    public Date getConnectionUpdateDate() {
        return this.connectionUpdateDate;
    }

    public void reconnect() {
        this.loggerConnect.log("Re-connecting to Essbase server.");
        this.disconnect();
        try {
            this.connect(this.essConnectParams.userID, this.essConnectParams.userPassw, this.essConnectParams.catalogName, this.essConnectParams.cubeName, this.essConnectParams.attributeRepresentation, this.essConnectParams.namespace);
            this.connectionUpdateDate = new Date();
        }
        catch (EssException e) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_CONNECT_FAILURE, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IEssMdDataSet getMdDataSet(String catalogName, String cubeName, String mdx) {
        String methodname = "getMdDataSet";
        IEssMdDataSet mddata = null;
        while (true) {
            try {
                if (this.essCubeView == null) {
                    this.essCubeView = this.domain.openCubeView(STR_MDX_QUERY, this.essOlapSvrName, catalogName, cubeName);
                }
                IEssOpMdxQuery op = this.essCubeView.createIEssOpMdxQuery();
                op.setQuery(false, true, mdx, false, IEssOpMdxQuery.EEssMemberIdentifierType.NAME);
                this.essCubeView.performOperation((IEssOperation)op);
                mddata = this.essCubeView.getMdDataSet();
            }
            catch (EssException e) {
                this.mEssbaseExceptionHandler.exceptionHandler(EssbaseMessageKeys.ERR_API_CALL_ERROR, e, "getMdDataSet", mdx);
                continue;
            }
            finally {
                this.mEssbaseExceptionHandler.updateExceptionHandler();
                continue;
            }
            break;
        }
        if (mddata == null) {
            if (this.logger3rdp.isOn(LogLevel.ERROR)) {
                this.logger3rdp.log(LogLevel.ERROR, "Essbase perform operation error: no data returned.");
            }
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_EXECUTE_MDX_ERROR, mdx);
        }
        return mddata;
    }

    public void setPoolDisabled(String pooldisabled) {
        this.mPoolDisabled = pooldisabled;
    }

    public boolean getPoolDisabled() {
        if (this.mPoolDisabled != null) {
            return this.mPoolDisabled.equalsIgnoreCase("true");
        }
        return false;
    }

    public final EssbaseWrappers getEssAPI() {
        return this.essbaseAPI;
    }

    public IEssOlapServer getEssConnection() {
        return this.essConnection;
    }

    public String getMetadataUpdateMarkerName() {
        return this.metadataUpdateMarkerName;
    }

    public IEssMemberSelection openMbrSel() {
        return this.memberSelectionHandlers.getMbrSelection();
    }

    public void releaseMbrSel(IEssMemberSelection mbrSel) {
        this.memberSelectionHandlers.releaseMbrSelection(mbrSel);
    }

    public void setInvalid() {
        this.isValid = false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void disconnect() {
        if (this.connected) {
            if (this.memberSelectionHandlers != null) {
                this.memberSelectionHandlers.closeMbrSelection();
            }
            if (null != this.metadataCache) {
                this.metadataCache.release();
            }
            try {
                if (null != this.essCubeView) {
                    this.essCubeView.close();
                    this.essCubeView = null;
                }
                if (null != this.essConnection) {
                    if (this.essConnection.isConnected()) {
                        this.essConnection.disconnect();
                    }
                    this.essConnection = null;
                }
                if (null != this.essbaseJAPI) {
                    if (this.essbaseJAPI.isSignedOn()) {
                        this.essbaseJAPI.signOff();
                    }
                    this.essbaseJAPI = null;
                    this.domain = null;
                }
            }
            catch (EssException e) {
                if (null != this.loggerConnect && this.loggerConnect.isOn(LogLevel.ERROR)) {
                    this.loggerConnect.log(LogLevel.ERROR, "Essbase disconnection eror: ", (Throwable)e);
                }
            }
            finally {
                this.connected = false;
                if (null != this.loggerConnect && this.loggerConnect.isOn()) {
                    this.loggerConnect.log("Essbase connection ended.");
                }
            }
        }
    }

    public String getClientVersion() {
        if (null == this.essbaseJAPI) {
            return null;
        }
        String result = null;
        try {
            result = this.essbaseJAPI.getApiVersionDetail();
            result = result.toUpperCase();
        }
        catch (EssException ex) {
            int status = ex.getCode();
            StringBuilder buffer = new StringBuilder();
            buffer.append(ERROR_RETURNED_FROM).append("EssbaseConnection.getClientVersion(): ").append(status);
            if (this.loggerConnect.isOn(LogLevel.ERROR)) {
                this.loggerConnect.log(LogLevel.ERROR, buffer.toString());
            }
            throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, buffer.toString());
        }
        return result;
    }

    public String getServerVersion() {
        String result = null;
        if (this.essbaseAPI != null && this.essConnection != null) {
            result = ESSBASE_SERVER_VERSION_PREFIX + this.essbaseAPI.getOlapServerVersion(this.essConnection);
        }
        return result;
    }

    public List<XQEMessage> getConnectionDetails() {
        return this.checkAndGetDetails("Client property", this.getClientVersion(), "Server property", this.getServerVersion());
    }

    public List<XQEMessage> getConnectionBlackListDetails() {
        return this.checkAndGetBlackListDetails(this.getClientVersion(), this.getServerVersion());
    }

    private class EssbaseConnectionParameters {
        String userID = null;
        String userPassw = null;
        String catalogName = null;
        String cubeName = null;
        String attributeRepresentation = null;
        String namespace = null;

        private EssbaseConnectionParameters() {
        }

        private void setParameters(String theUserID, String theUserPassw, String theCatalogName, String theCubeName, String theAttrRepresentation, String theNamespace) {
            this.userID = theUserID;
            this.userPassw = theUserPassw;
            this.catalogName = theCatalogName;
            this.cubeName = theCubeName;
            this.attributeRepresentation = theAttrRepresentation;
            this.namespace = theNamespace;
        }
    }

    public static enum MetadataUpdateMarkerEnum {
        NOTDETECTED,
        NOTCHANGED,
        CHANGED;

    }
}

