/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseLocalizedString;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataCache;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataNames;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import com.essbase.api.datasource.IEssCube;
import com.essbase.api.metadata.IEssDimension;
import com.essbase.api.metadata.IEssMember;
import java.util.HashMap;
import java.util.Map;

public class EssbaseDimensionCacheItem {
    DimensionRecord cachedDimensionRecord = new DimensionRecord();
    private boolean isBalanced = false;
    Map<String, String> cachedAliasNames = new HashMap<String, String>();
    private boolean isAttributeDimension = false;
    private final EssbaseConnection connection;
    private final EssbaseWrappers essbaseAPI;

    public EssbaseDimensionCacheItem(EssbaseConnection theConnection) {
        this.connection = theConnection;
        this.essbaseAPI = this.connection.getEssAPI();
    }

    public String getName() {
        if (this.cachedDimensionRecord != null) {
            return this.cachedDimensionRecord.getName();
        }
        return null;
    }

    public String getUniqueName() {
        if (this.cachedDimensionRecord != null) {
            return this.cachedDimensionRecord.getUniqueName();
        }
        return null;
    }

    public String getDefaultHierarchyUniqueName() {
        if (this.cachedDimensionRecord != null) {
            return this.cachedDimensionRecord.getDefaultHierarchyUniqueName();
        }
        return null;
    }

    public String getDescription() {
        if (this.cachedDimensionRecord != null) {
            return this.cachedDimensionRecord.getDescription();
        }
        return null;
    }

    public String getCatalogName() {
        if (this.cachedDimensionRecord != null) {
            return this.cachedDimensionRecord.getCatalogName();
        }
        return null;
    }

    public String getCubeName() {
        if (this.cachedDimensionRecord != null) {
            return this.cachedDimensionRecord.getCubeName();
        }
        return null;
    }

    public DimensionTypeEnum getType() {
        if (this.cachedDimensionRecord != null) {
            return this.cachedDimensionRecord.getType();
        }
        return null;
    }

    public final int getCardinality() {
        if (this.cachedDimensionRecord != null) {
            return this.cachedDimensionRecord.getCardinality();
        }
        return 0;
    }

    public boolean isAttributeDimension() {
        return this.isAttributeDimension;
    }

    public boolean isBalanced() {
        return this.isBalanced;
    }

    public void setCacheDimension(IEssDimension essDimension) {
        String[] dimensionUDAs;
        String udaValue;
        EssbaseMetadataCache metadataCache = this.connection.getMetadataCache();
        IEssCube essCube = metadataCache.getEssConnectionCube();
        String dimensionName = this.essbaseAPI.getDimensionName(essDimension);
        this.cachedDimensionRecord.setName(dimensionName.intern());
        String dun = EssbaseMetadataNames.createDimensionUniqueName(dimensionName);
        this.cachedDimensionRecord.setUniqueName(dun);
        String hun = EssbaseMetadataNames.createHierarchyUniqueName(dimensionName);
        this.cachedDimensionRecord.setDefaultHierarchyUniqueName(hun);
        Map<String, IEssMember> rootMemberCache = metadataCache.getEssRootMemberMap();
        IEssMember rootMember = rootMemberCache.get(dimensionName);
        this.getAliasNames(dimensionName);
        String description = this.essbaseAPI.getMemberDescription(rootMember);
        if (description != null) {
            this.cachedDimensionRecord.setDescription(description);
        }
        this.isBalanced = (udaValue = EssbaseUtil.getUDAvalue(dimensionUDAs = this.essbaseAPI.getUDAs(rootMember), "COGNOS_HIERARCHY_BALANCED")) != null && Integer.parseInt(udaValue) > 0;
        this.cachedDimensionRecord.setCatalogName(this.essbaseAPI.getCatalogName(essCube));
        this.cachedDimensionRecord.setCubeName(this.essbaseAPI.getCubeName(essCube));
        this.cachedDimensionRecord.setRank(this.essbaseAPI.getDimensionOrdinal(essDimension));
        this.cachedDimensionRecord.setCardinality(this.essbaseAPI.getCardinality(essDimension));
        this.cachedDimensionRecord.setUniqueId(RecordType.DIMENSION, this.cachedDimensionRecord.getUniqueName());
        if (this.isUDAset(dimensionUDAs, "COGNOS_SCENARIO_DIMENSION")) {
            this.cachedDimensionRecord.setType(DimensionTypeEnum.SCENARIO);
        } else {
            int dimCategory = this.essbaseAPI.intValue(this.essbaseAPI.getTag(essDimension));
            switch (dimCategory) {
                case 3: {
                    this.cachedDimensionRecord.setType(DimensionTypeEnum.TIME);
                    break;
                }
                case 1: {
                    this.cachedDimensionRecord.setType(DimensionTypeEnum.MEASURE);
                    break;
                }
                default: {
                    this.cachedDimensionRecord.setType(DimensionTypeEnum.REGULAR);
                }
            }
            if (dimCategory == 6 || dimCategory == 7) {
                this.isAttributeDimension = true;
            }
        }
        if (this.cachedDimensionRecord.getType() == DimensionTypeEnum.ACCOUNT || this.cachedDimensionRecord.getType() == DimensionTypeEnum.SCENARIO) {
            this.cachedDimensionRecord.setMembersRollup(false);
        }
    }

    private void getAliasNames(String dimensionName) {
        EssbaseMetadataCache metadataCache = this.connection.getMetadataCache();
        Map<String, String> rootMemberCaptions = metadataCache.getRootMemberAliasNames(dimensionName);
        this.cachedAliasNames.putAll(rootMemberCaptions);
    }

    public DimensionRecord createDimensionRecord(Map<String, String> aliasTableNames, EssbaseLocalizedString localizedStringHelper) {
        DimensionRecord dimensionRec = new DimensionRecord();
        dimensionRec.setName(this.cachedDimensionRecord.getName());
        dimensionRec.setUniqueName(this.cachedDimensionRecord.getUniqueName());
        dimensionRec.setDefaultHierarchyUniqueName(this.cachedDimensionRecord.getDefaultHierarchyUniqueName());
        LocalizedString caption = this.getCaptions(null, aliasTableNames, localizedStringHelper);
        dimensionRec.setCaption((ILocalizedString)caption);
        dimensionRec.setDescription(this.cachedDimensionRecord.getDescription());
        dimensionRec.setCatalogName(this.cachedDimensionRecord.getCatalogName());
        dimensionRec.setCubeName(this.cachedDimensionRecord.getCubeName());
        dimensionRec.setRank(this.cachedDimensionRecord.getRank());
        dimensionRec.setCardinality(this.cachedDimensionRecord.getCardinality());
        dimensionRec.setUniqueId(this.cachedDimensionRecord.getName());
        dimensionRec.setType(this.cachedDimensionRecord.getType());
        dimensionRec.setIsAttributeDimension(Boolean.valueOf(this.isAttributeDimension));
        dimensionRec.setMembersRollup(this.cachedDimensionRecord.getMembersRollup());
        return dimensionRec;
    }

    public LocalizedString getCaptions(IEssMember essMember, Map<String, String> aliasTableNames, EssbaseLocalizedString localizedStringHelper) {
        String dimensionName = this.cachedDimensionRecord.getName();
        return localizedStringHelper.getLocalizedCaptions(this.connection, dimensionName, dimensionName, essMember, aliasTableNames, this.cachedAliasNames);
    }

    private boolean isUDAset(String[] dimensionUDAs, String udaName) {
        if (dimensionUDAs != null) {
            for (String uda : dimensionUDAs) {
                if (!uda.startsWith(udaName)) continue;
                return true;
            }
        }
        return false;
    }
}

