/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataProviderBase;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseDataProvider;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseDimensionCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseLocalizedString;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMacro;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMemberCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMemberSearch;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMembersAndProperties;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataCache;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataNames;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseNamedSet;
import com.cognos.xqe.data.providers.olap.essbase.EssbasePropertyCacheItem;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseUtil;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.data.providers.olap.securecache.SALContext;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.exception.IMessageKey;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyNamedSetRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.transformation.ma.provider.MASearchCriteria;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.essbase.api.base.EssException;
import com.essbase.api.base.IEssIterator;
import com.essbase.api.datasource.IEssCube;
import com.essbase.api.datasource.IEssOlapApplication;
import com.essbase.api.metadata.IEssDimension;
import com.essbase.api.metadata.IEssMember;
import com.essbase.api.metadata.IEssMemberSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

public class EssbaseMetadataProvider
extends MetadataProviderBase
implements IOLAPMetadataProvider {
    private static final String STR_GENMBRS = "@GENMBRS (\"";
    private static final String STR_MEMBER = "@MEMBER(\"";
    private static final String STR_CHILDREN = "@CHILDREN(\"";
    private static final String STR_SIBLINGS = "@SIBLINGS(\"";
    private static final String STR_DESCENDANTS = "@DESCENDANTS(\"";
    private static final String STR_SEL_MBR_INFO_DIM = " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName)";
    private static final String STR_CLOSE_BRKT = ")";
    private static final String STR_QUOTATION = "\"";
    private static final String STR_QUOTATION_BRKT = "\")";
    private static final String STR_QUOTATION_COMMA = "\", ";
    private static final String ASTER = "*";
    private static final String STR_EMPTY = "";
    private static final String STR_BLANK = " ";
    private final AtomicBoolean released = new AtomicBoolean(false);
    private final EssbaseDataProvider dataProvider;
    private final MetadataQueryArguments queryArguments;
    private final EssbaseLocalizedString localizedStringHelper;
    private final XQELogger logger = XQELog.getLogger((ServiceEnumeration)ServiceEnumeration.XQEODP, (String)"Essbase", (String)"Metadata", (LogLevel)LogLevel.INFO);
    private boolean isAttributeProperty = true;
    private DateTimeValue schemaUpdateTimeStamp = DataValueFactory.createTimestampValue();
    private final ConnectionParameters defaultConnectionParameters;

    public EssbaseMetadataProvider(EssbaseDataProvider provider, MetadataQueryArguments theQueryArguments, ConnectionParameters theConnectionParams) {
        super((OLAPDataProviderBase)provider);
        this.dataProvider = provider;
        this.queryArguments = theQueryArguments;
        this.defaultConnectionParameters = theConnectionParams;
        Map metadataProperties = theQueryArguments.getDataSource().getMetadataProperties();
        String attributeFlag = (String)metadataProperties.get("attribute");
        if (attributeFlag != null && "dimension".equals(attributeFlag)) {
            this.isAttributeProperty = false;
        }
        Locale runLocale = theQueryArguments.getDesignLocale();
        this.localizedStringHelper = new EssbaseLocalizedString(runLocale);
    }

    public CacheParameters getCacheParameters(IRestrictions restrictions) {
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        String cubeName = (String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class);
        ConnectionParameters connParams = this.defaultConnectionParameters.duplicate();
        connParams.remove(CatalogParameter.class);
        connParams.remove(CubeParameter.class);
        CacheParameters cacheParams = new CacheParameters();
        cacheParams.put(connParams);
        if (null != catalogName) {
            cacheParams.put("catalog", (Object)catalogName);
        }
        if (null != cubeName) {
            cacheParams.put("cube", (Object)cubeName);
        }
        String runLocale = LocaleConverter.toString((Locale)this.queryArguments.getDesignLocale());
        cacheParams.put("runLocale", (Object)runLocale);
        return cacheParams;
    }

    public SALContext getMetadataQueryContext(String userId, MetadataOperation opType, short securityContextMode, IRestrictions restrictions) {
        String securityContext = userId;
        String effectiveKeyDateRange = null;
        String additionalMetadataRetrievalContext = null;
        return new SALContext(securityContext, effectiveKeyDateRange, additionalMetadataRetrievalContext);
    }

    public boolean isReplacementVariableUsed(IRestrictions restrictions) {
        return false;
    }

    public List<ActionRecord> getActions(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AliasRecord> getAliases(IRestrictions restrictions) {
        this.checkRestrictions(ALIASES_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        try {
            EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
            String[] aliasTableNames = metadataCache.getEssAliasTableNames();
            ArrayList<AliasRecord> result = new ArrayList<AliasRecord>(aliasTableNames.length);
            for (String aliasTableName : aliasTableNames) {
                AliasRecord aliasRec = new AliasRecord();
                aliasRec.setCatalogName(catalogName);
                aliasRec.setCubeName(cubeName);
                aliasRec.setUniqueName(aliasTableName);
                aliasRec.setName(aliasTableName);
                aliasRec.setCaption(aliasTableName);
                result.add(aliasRec);
            }
            ArrayList<AliasRecord> arrayList = result;
            return arrayList;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<String> getDatasourceLocales(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CatalogRecord> getCatalogs(IRestrictions restrictions) {
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        IPooledConnection xqeConnection = this.getConnection(catalogName, null);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        try {
            ArrayList<IEssOlapApplication> catalogsFound = new ArrayList<IEssOlapApplication>();
            int countCatalogs = this.getEssCatalogs(essConnection, catalogName, catalogsFound);
            ArrayList<CatalogRecord> result = new ArrayList<CatalogRecord>(countCatalogs);
            for (int i = 0; i < countCatalogs; ++i) {
                result.add(this.createCatalogRecord(essConnection, (IEssOlapApplication)catalogsFound.get(i)));
            }
            ArrayList<CatalogRecord> arrayList = result;
            return arrayList;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<CubeRecord> getCubes(IRestrictions restrictions) {
        this.checkRestrictions(CUBES_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        EssbaseConnection.MetadataUpdateMarkerEnum updateEnum = essConnection.refreshSchemaUpdateMarkerValue();
        if (updateEnum == EssbaseConnection.MetadataUpdateMarkerEnum.NOTDETECTED) {
            this.schemaUpdateTimeStamp.set("2000-01-01 00:00:00");
        } else if (updateEnum == EssbaseConnection.MetadataUpdateMarkerEnum.NOTCHANGED) {
            this.schemaUpdateTimeStamp.set(essConnection.getConnectionUpdateDate());
        } else if (updateEnum == EssbaseConnection.MetadataUpdateMarkerEnum.CHANGED) {
            essConnection.reconnect();
            this.schemaUpdateTimeStamp.set(essConnection.getConnectionUpdateDate());
        }
        while (true) {
            try {
                ArrayList<IEssCube> cubesFound = new ArrayList<IEssCube>(1);
                int countCubesFound = this.getEssCubes(essConnection, catalogName, cubeName, cubesFound);
                ArrayList<CubeRecord> result = new ArrayList<CubeRecord>(countCubesFound);
                for (int i = 0; i < countCubesFound; ++i) {
                    result.add(this.createCubeRecord(essConnection, (IEssCube)cubesFound.get(i)));
                }
                ArrayList<CubeRecord> arrayList = result;
                return arrayList;
            }
            catch (EssbaseRuntimeException e) {
                if (EssbaseUtil.isLoggedOutError(e)) {
                    essConnection.reconnect();
                    continue;
                }
                throw e;
            }
            break;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCubeDefaultMeasure(IRestrictions restrictions) {
        this.checkRestrictions(CUBES_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        try {
            ArrayList<IEssCube> cubesFound = new ArrayList<IEssCube>(1);
            int countCubesFound = this.getEssCubes(essConnection, catalogName, cubeName, cubesFound);
            if (countCubesFound == 1) {
                String defaultMeasure;
                EssbaseWrappers essbaseAPI = essConnection.getEssAPI();
                EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
                String string = defaultMeasure = this.getDefaultMeasureMUN(essConnection, essbaseAPI, metadataCache);
                return string;
            }
            String string = STR_EMPTY;
            return string;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<DimensionRecord> getDimensions(IRestrictions restrictions) {
        this.checkRestrictions(DIMENSIONS_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dimensionName = this.getDimensionName(restrictions);
        Map aliasTableNames = (Map)restrictions.getValueOf(RestrictionType.ALIASES, null);
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        while (true) {
            try {
                List<DimensionRecord> dimensionsFound;
                List<DimensionRecord> list = dimensionsFound = this.getDimensionRecords(essConnection, dimensionName, aliasTableNames);
                return list;
            }
            catch (EssbaseRuntimeException e) {
                if (EssbaseUtil.isLoggedOutError(e)) {
                    essConnection.reconnect();
                    continue;
                }
                throw e;
            }
            break;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<HierarchyRecord> getHierarchies(IRestrictions restrictions) {
        this.checkRestrictions(HIERARCHIES_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dimensionName = this.getDimensionName(restrictions);
        String hierarchyName = this.getHierarchyName(restrictions);
        Map aliasTableNames = (Map)restrictions.getValueOf(RestrictionType.ALIASES, null);
        if (!EssbaseUtil.isEmpty(hierarchyName) && !hierarchyName.equals(dimensionName)) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_HIERARCHY_NAME, hierarchyName, dimensionName);
        }
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        while (true) {
            try {
                List<EssbaseDimensionCacheItem> dimensionsFound = this.getCachedDimensions(essConnection, dimensionName, aliasTableNames, DimensionType.REGULAR);
                ArrayList<HierarchyRecord> result = new ArrayList<HierarchyRecord>(dimensionsFound.size());
                EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
                for (EssbaseDimensionCacheItem dimension : dimensionsFound) {
                    String dimName = dimension.getName();
                    Set<HierarchyRecord> cache = metadataCache.getDimensionHierarchyCache(dimName);
                    for (HierarchyRecord hierRec : cache) {
                        hierRec.setCaption((ILocalizedString)dimension.getCaptions(null, aliasTableNames, this.localizedStringHelper));
                        result.add(hierRec);
                    }
                }
                ArrayList<HierarchyRecord> arrayList = result;
                return arrayList;
            }
            catch (EssbaseRuntimeException e) {
                if (EssbaseUtil.isLoggedOutError(e)) {
                    essConnection.reconnect();
                    continue;
                }
                throw e;
            }
            break;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<LevelRecord> getLevels(IRestrictions restrictions) {
        this.checkRestrictions(LEVELS_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dimensionName = this.getDimensionName(restrictions);
        String hierarchyName = this.getHierarchyName(restrictions);
        String levelName = this.getLevelName(restrictions);
        int levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
        if (!EssbaseUtil.isEmpty(hierarchyName) && !hierarchyName.equals(dimensionName)) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_HIERARCHY_NAME, hierarchyName, dimensionName);
        }
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        while (true) {
            try {
                ArrayList<LevelRecord> levelsFound = new ArrayList<LevelRecord>(10);
                this.getLevels(essConnection, dimensionName, levelName, levelNumber, null, levelsFound);
                ArrayList<LevelRecord> arrayList = levelsFound;
                return arrayList;
            }
            catch (EssbaseRuntimeException e) {
                if (EssbaseUtil.isLoggedOutError(e)) {
                    essConnection.reconnect();
                    continue;
                }
                throw e;
            }
            break;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<MeasureRecord> getMeasures(IRestrictions restrictions) {
        this.checkRestrictions(MEASURES_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dimensionName = this.getDimensionName(restrictions);
        String levelName = this.getLevelName(restrictions);
        int levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
        String measureName = this.getMeasureName(restrictions);
        Map aliasTableNames = (Map)restrictions.getValueOf(RestrictionType.ALIASES, null);
        int restrFrom = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int restrSize = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        EnumSet treeOpSet = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, EnumSet.noneOf(TreeOperatorEnum.class));
        QueryParameters parameters = new QueryParameters();
        parameters.dimName = dimensionName;
        parameters.memberName = measureName;
        parameters.memberUniqueName = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME, null);
        parameters.levelNumber = levelNumber;
        parameters.treeOpSet = treeOpSet;
        parameters.from = restrFrom;
        parameters.size = restrSize;
        parameters.aliasTableNames = aliasTableNames;
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        while (true) {
            try {
                ArrayList<MeasureRecord> measuresFound = new ArrayList<MeasureRecord>();
                this.getMeasureRecords(essConnection, levelName, parameters, measuresFound);
                ArrayList<MeasureRecord> arrayList = measuresFound;
                return arrayList;
            }
            catch (EssbaseRuntimeException e) {
                if (EssbaseUtil.isLoggedOutError(e)) {
                    essConnection.reconnect();
                    continue;
                }
                throw e;
            }
            break;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<MemberRecord> getMembers(IRestrictions restrictions) {
        this.checkRestrictions(MEMBERS_RESTRICTIONS, restrictions);
        if (restrictions.contains(RestrictionType.TREEOP) && !restrictions.contains(RestrictionType.MEMBER_UNIQUE_NAME)) {
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, RestrictionType.MEMBER_UNIQUE_NAME.toString());
        }
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dimensionName = this.getDimensionName(restrictions);
        String hierarchyName = this.getHierarchyName(restrictions);
        String levelName = this.getLevelName(restrictions);
        int levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
        String memberName = this.getMemberName(restrictions);
        EnumSet treeOpSet = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, EnumSet.noneOf(TreeOperatorEnum.class));
        int restrFrom = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int restrSize = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        Map aliasTableNames = (Map)restrictions.getValueOf(RestrictionType.ALIASES, null);
        Collection ppdsCodes = (Collection)restrictions.getValueOf(RestrictionType.PPDS_CODES);
        MASearchCriteria searchCriteria = (MASearchCriteria)restrictions.getValueOf(RestrictionType.MEMBERSEARCH, null);
        Boolean useMetadataCallOnly = (Boolean)restrictions.getValueOf(RestrictionType.USE_METADATA_CALL_ONLY, (Object)Boolean.TRUE);
        ICube icube = (ICube)restrictions.getValueOf(RestrictionType.CUBE_OBJECT, null);
        String memberProperty = (String)restrictions.getValueOf(RestrictionType.PROPERTY, null);
        if (!EssbaseUtil.isEmpty(hierarchyName) && !hierarchyName.equals(dimensionName)) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_HIERARCHY_NAME, hierarchyName, dimensionName);
        }
        QueryParameters parameters = new QueryParameters();
        parameters.dimName = dimensionName;
        parameters.memberName = memberName;
        parameters.memberUniqueName = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        parameters.levelNumber = levelNumber;
        parameters.treeOpSet = treeOpSet;
        parameters.from = restrFrom;
        parameters.size = restrSize;
        parameters.aliasTableNames = aliasTableNames;
        if (restrictions.contains(RestrictionType.DESCENDANTSOPT)) {
            parameters.descendantsopt = (Integer)restrictions.getValueOf(RestrictionType.DESCENDANTSOPT);
        }
        if (restrictions.contains(RestrictionType.DESCENDANTSLEVELDISTANCE)) {
            parameters.descendantsleveldistance = (Integer)restrictions.getValueOf(RestrictionType.DESCENDANTSLEVELDISTANCE);
        }
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        while (true) {
            try {
                ArrayList<MemberRecord> membersFound = new ArrayList<MemberRecord>();
                if (memberProperty != null) {
                    this.getMemberProperty(essConnection, memberProperty, parameters, membersFound);
                } else if (!useMetadataCallOnly.booleanValue() || icube != null) {
                    this.getMemberRecordsWithProperies(essConnection, levelName, parameters, membersFound);
                } else if (searchCriteria != null) {
                    this.getMemberRecordsSearch(essConnection, levelName, parameters, searchCriteria, membersFound);
                } else if (ppdsCodes != null && ppdsCodes.size() > 0) {
                    this.getMemberRecordsFromPPDSCodes(essConnection, ppdsCodes, levelName, parameters, membersFound);
                } else {
                    this.getMemberRecords(essConnection, levelName, parameters, membersFound);
                }
                ArrayList<MemberRecord> arrayList = membersFound;
                return arrayList;
            }
            catch (EssbaseRuntimeException e) {
                if (EssbaseUtil.isLoggedOutError(e)) {
                    essConnection.reconnect();
                    continue;
                }
                throw e;
            }
            break;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MacroRecord> getMacros(IRestrictions restrictions) {
        this.checkRestrictions(MACROS_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String macroName = (String)restrictions.getValueOf(RestrictionType.NAME);
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
        try {
            Map<String, EssbaseMacro> macroCache = metadataCache.getMacroCache();
            if (macroCache == null) {
                this.getNamedSetsAndMacros(essConnection);
                macroCache = metadataCache.getMacroCache();
            }
            if (EssbaseUtil.isEmpty(macroName)) {
                ArrayList<MacroRecord> listMacros = new ArrayList<MacroRecord>(macroCache.size());
                for (EssbaseMacro macro : macroCache.values()) {
                    listMacros.add(macro.getMacroRecord());
                }
                ArrayList<MacroRecord> arrayList = listMacros;
                return arrayList;
            }
            EssbaseMacro macro = macroCache.get(macroName);
            ArrayList<MacroRecord> listMacro = new ArrayList<MacroRecord>(1);
            if (macro == null) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_MACRO_NAME, macroName);
            }
            macro.refreshCachedValue(essConnection);
            listMacro.add(macro.getMacroRecord());
            ArrayList<MacroRecord> arrayList = listMacro;
            return arrayList;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NamedSetRecord> getNamedSets(IRestrictions restrictions) {
        this.checkRestrictions(NAMEDSETS_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
        try {
            ArrayList<NamedSetRecord> namedSets = new ArrayList<NamedSetRecord>();
            Map<String, EssbaseNamedSet> namedSetCache = metadataCache.getNamedSetCache();
            if (namedSetCache == null) {
                this.getNamedSetsAndMacros(essConnection);
                namedSetCache = metadataCache.getNamedSetCache();
            }
            for (EssbaseNamedSet namedSet : namedSetCache.values()) {
                namedSets.add(namedSet.getNamedSetRecord());
            }
            ArrayList<NamedSetRecord> arrayList = namedSets;
            return arrayList;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<HierarchyNamedSetRecord> getHierarchyNamedSets(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MemberRecord> getHierarchyRootMembers(IRestrictions restrictions) {
        this.checkRestrictions(HIERARCHY_ROOT_MEMBERS_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String hierarchyName = this.getHierarchyName(restrictions);
        Map aliasTableNames = (Map)restrictions.getValueOf(RestrictionType.ALIASES, null);
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        try {
            EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
            EssbaseWrappers essbaseAPI = essConnection.getEssAPI();
            String dimensionName = hierarchyName;
            IEssMember rootMember = metadataCache.getEssRootMemberMap().get(dimensionName);
            QueryParameters parameters = new QueryParameters();
            parameters.dimName = dimensionName;
            parameters.levelNumber = 0;
            parameters.aliasTableNames = aliasTableNames;
            parameters.memberName = essbaseAPI.getMemberName(rootMember);
            ArrayList<MemberRecord> rootMembersFound = new ArrayList<MemberRecord>(1);
            if (dimensionName.equals(metadataCache.getMeasureDimensionName())) {
                this.getDimensionMemberRecords(essConnection, null, parameters, rootMembersFound);
            } else {
                rootMembersFound.add(this.getSingleMemberRecord(essConnection, parameters, rootMember));
            }
            ArrayList<MemberRecord> arrayList = rootMembersFound;
            return arrayList;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<MemberRecord> getNamedSetMembers(IRestrictions restrictions) {
        this.checkRestrictions(NAMEDSETMEMBERS_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String namedSetName = this.getNamedSetName(restrictions);
        int restrFrom = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int restrSize = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        Map aliasTableNames = (Map)restrictions.getValueOf(RestrictionType.ALIASES, null);
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        while (true) {
            try {
                ArrayList<MemberRecord> namedSetMembers = new ArrayList<MemberRecord>();
                this.getNamedSetMembers(essConnection, namedSetName, restrFrom, restrSize, aliasTableNames, namedSetMembers);
                ArrayList<MemberRecord> arrayList = namedSetMembers;
                return arrayList;
            }
            catch (EssbaseRuntimeException e) {
                if (EssbaseUtil.isLoggedOutError(e)) {
                    essConnection.reconnect();
                    continue;
                }
                throw e;
            }
            break;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<String> getNamedSetLevelUniqueNames(IRestrictions restrictions) {
        this.checkRestrictions(NAMEDSETLEVELUNIQUENAMES_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String namedSetName = this.getNamedSetName(restrictions);
        Map aliasTableNames = (Map)restrictions.getValueOf(RestrictionType.ALIASES, null);
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        while (true) {
            try {
                ArrayList<String> namedSetMembers = new ArrayList<String>();
                this.getNamedSetLevelUniqueNames(essConnection, namedSetName, 0, Integer.MAX_VALUE, aliasTableNames, namedSetMembers);
                ArrayList<String> arrayList = namedSetMembers;
                return arrayList;
            }
            catch (EssbaseRuntimeException e) {
                if (EssbaseUtil.isLoggedOutError(e)) {
                    essConnection.reconnect();
                    continue;
                }
                throw e;
            }
            break;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    public List<PropertyRecord> getProperties(IRestrictions restrictions) {
        this.checkRestrictions(PROPERTIES_RESTRICTIONS, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String dimensionName = this.getDimensionName(restrictions);
        String hierarchyName = this.getHierarchyName(restrictions);
        String levelName = this.getLevelName(restrictions);
        int levelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
        String propertyName = this.getPropertyName(restrictions);
        Map aliasTableNames = (Map)restrictions.getValueOf(RestrictionType.ALIASES, null);
        if (!EssbaseUtil.isEmpty(hierarchyName) && !hierarchyName.equals(dimensionName)) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_HIERARCHY_NAME, hierarchyName, dimensionName);
        }
        IPooledConnection xqeConnection = this.getConnection(catalogName, cubeName);
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
        while (true) {
            try {
                ArrayList<PropertyRecord> result = new ArrayList<PropertyRecord>();
                if (this.isAttributeProperty) {
                    List<EssbaseDimensionCacheItem> cashedDimensions = this.getCachedDimensions(essConnection, dimensionName, aliasTableNames, DimensionType.REGULAR);
                    for (EssbaseDimensionCacheItem dimension : cashedDimensions) {
                        if (dimension.getType() == DimensionTypeEnum.MEASURE) continue;
                        String currentDimName = dimension.getName();
                        if (!metadataCache.isDimensionPropertiesCached(currentDimName)) {
                            this.cacheProperties(essConnection, dimension, aliasTableNames);
                        }
                        if (!metadataCache.isPropertiesExist(currentDimName)) continue;
                        if (propertyName == null) {
                            Set<HierarchyRecord> hierarchyCache = metadataCache.getDimensionHierarchyCache(currentDimName);
                            Iterator<HierarchyRecord> iter = hierarchyCache.iterator();
                            HierarchyRecord hierRec = iter.next();
                            if (hierRec.isParentChild()) {
                                this.getPropertyRecords(essConnection, currentDimName, null, aliasTableNames, result);
                                continue;
                            }
                            ArrayList<LevelRecord> levelsFound = new ArrayList<LevelRecord>(10);
                            this.getLevels(essConnection, currentDimName, levelName, levelNumber, aliasTableNames, levelsFound);
                            for (LevelRecord level : levelsFound) {
                                this.getPropertyRecords(essConnection, currentDimName, level.getName(), aliasTableNames, result);
                            }
                            continue;
                        }
                        this.getPropertyRecord(essConnection, currentDimName, propertyName, result);
                        ArrayList<PropertyRecord> arrayList = result;
                        return arrayList;
                    }
                }
                result.add(EssbasePropertyCacheItem.getPropertyPPDSCode(catalogName, cubeName));
                PropertyRecord propertyRec = EssbasePropertyCacheItem.getPropertyBusinessKey(catalogName, cubeName);
                if (!EssbaseUtil.isEmpty(dimensionName)) {
                    if (!EssbaseUtil.isEmpty(levelName) || levelNumber >= 0) {
                        ArrayList<LevelRecord> levelsFound = new ArrayList<LevelRecord>(10);
                        this.getLevels(essConnection, dimensionName, levelName, levelNumber, aliasTableNames, levelsFound);
                        LevelRecord levelRec = (LevelRecord)levelsFound.get(0);
                        String dashName = STR_BLANK + XQEMessages.getMessage((IMessageKey.Param0)EssbaseMessageKeys.STR_DASH_NAME, (Locale)this.localizedStringHelper.getRunLocale());
                        propertyRec.setCaption(levelRec.getCaption().toString() + dashName);
                    } else if (!EssbaseUtil.isEmpty(hierarchyName)) {
                        List<EssbaseDimensionCacheItem> cashedDimensions = this.getCachedDimensions(essConnection, dimensionName, aliasTableNames, DimensionType.ALL);
                        LocalizedString propertyCaption = this.generatePropertyCaption(cashedDimensions.get(0), aliasTableNames);
                        propertyRec.setCaption((ILocalizedString)propertyCaption);
                    }
                }
                result.add(propertyRec);
                result.add(EssbasePropertyCacheItem.getPropertyRollup(catalogName, cubeName));
                ArrayList<PropertyRecord> arrayList = result;
                return arrayList;
            }
            catch (EssbaseRuntimeException e) {
                if (EssbaseUtil.isLoggedOutError(e)) {
                    essConnection.reconnect();
                    continue;
                }
                throw e;
            }
            break;
        }
        finally {
            this.returnConnection(xqeConnection);
        }
    }

    private LocalizedString generatePropertyCaption(EssbaseDimensionCacheItem dimension, Map<String, String> aliasTableNames) {
        String[] locales;
        LocalizedString dimensionCaption = dimension.getCaptions(null, aliasTableNames, this.localizedStringHelper);
        String dashName = STR_BLANK + XQEMessages.getMessage((IMessageKey.Param0)EssbaseMessageKeys.STR_DASH_NAME, (Locale)this.localizedStringHelper.getRunLocale());
        String defaultCaption = dimensionCaption.toString() + dashName;
        LocalizedString propertyCaption = new LocalizedString(this.localizedStringHelper.getRunLocaleStr(), defaultCaption);
        for (String localeStr : locales = dimensionCaption.getSupportedLocales()) {
            Locale locale = LocaleConverter.strToLocale((String)localeStr);
            dashName = STR_BLANK + XQEMessages.getMessage((IMessageKey.Param0)EssbaseMessageKeys.STR_DASH_NAME, (Locale)locale);
            String caption = dimensionCaption.toString(localeStr) + dashName;
            propertyCaption.put(localeStr, caption);
        }
        return propertyCaption;
    }

    public List<VariableRecord> getVariables(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    private void checkRestrictions(EnumSet<RestrictionType> apiCallRestrictionType, IRestrictions restrictions) {
        EnumSet missingTypes = restrictions.contains(apiCallRestrictionType);
        if (missingTypes != null) {
            String missedRestrictions = missingTypes.toString();
            throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, missedRestrictions);
        }
    }

    private IPooledConnection getConnection(String catalogName, String cubeName) {
        try {
            ExecutionEnvironment executionEnvironment = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
            if (null == executionEnvironment) {
                throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
            }
            ConnectionParameters parameters = this.defaultConnectionParameters.duplicate();
            if (catalogName != null) {
                parameters.put((IConnectionParameter)new CatalogParameter(catalogName));
            }
            if (cubeName != null) {
                parameters.put((IConnectionParameter)new CubeParameter(cubeName));
            }
            IPooledConnection xqeConnection = this.dataProvider.borrowConnection(parameters, (IExecutionEnvironment)executionEnvironment);
            return xqeConnection;
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(this.queryArguments.getDataSource());
            }
            IDataSource dataSource = this.queryArguments.getDataSource();
            IDataSourceConnection connection = dataSource.getDataSourceConnection();
            connection.invalidateResolvedSignon();
            throw e;
        }
    }

    private void returnConnection(IPooledConnection xqeConnection) {
        EssbaseConnection essConnection = (EssbaseConnection)((Object)xqeConnection.getConnection());
        if (!essConnection.isValid()) {
            xqeConnection.setNotReusable();
        }
        xqeConnection.returnConnection();
    }

    private int getEssCatalogs(EssbaseConnection connection, String catalogName, List<IEssOlapApplication> catalogsFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        Map<String, IEssOlapApplication> catalogMap = metadataCache.getCatalogMap();
        if (EssbaseUtil.isEmpty(catalogName)) {
            for (IEssOlapApplication app : catalogMap.values()) {
                catalogsFound.add(app);
            }
        } else {
            IEssOlapApplication app = catalogMap.get(catalogName.toUpperCase());
            if (app == null) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_CATALOG_NAME, catalogName);
            }
            catalogsFound.add(app);
        }
        return catalogsFound.size();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getEssCubes(EssbaseConnection connection, String catalogName, String cubeName, List<IEssCube> cubesFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        Map<String, IEssCube> essCubes = metadataCache.getCubeMap(catalogName.toUpperCase());
        if (essCubes == null) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_CATALOG_NAME, catalogName);
        }
        if (essCubes.isEmpty()) {
            IEssOlapApplication essCatalog = metadataCache.getCatalogMap().get(catalogName.toUpperCase());
            if (essCatalog == null) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_CATALOG_NAME, catalogName);
            }
            IEssIterator list = essbaseAPI.getCubes(essCatalog);
            int countEssCubes = essbaseAPI.getCount(list);
            for (int i = 0; i < countEssCubes; ++i) {
                IEssCube cube = (IEssCube)essbaseAPI.getAt(list, i);
                essCubes.put(essbaseAPI.getCubeName(cube).toUpperCase(), cube);
            }
        }
        if (cubeName != null) {
            IEssCube cube = essCubes.get(cubeName.toUpperCase());
            if (cube == null) throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_CUBE_NAME, cubeName);
            cubesFound.add(cube);
            return cubesFound.size();
        } else {
            for (IEssCube cube : essCubes.values()) {
                cubesFound.add(cube);
            }
        }
        return cubesFound.size();
    }

    private List<DimensionRecord> getDimensionRecords(EssbaseConnection connection, String dimensionName, Map<String, String> aliasTableNames) {
        List<EssbaseDimensionCacheItem> cashedDimensions = this.getCachedDimensions(connection, dimensionName, aliasTableNames, DimensionType.REGULAR);
        ArrayList<DimensionRecord> dimensionsFound = new ArrayList<DimensionRecord>(cashedDimensions.size());
        for (EssbaseDimensionCacheItem dimension : cashedDimensions) {
            DimensionRecord dimensionRec = dimension.createDimensionRecord(aliasTableNames, this.localizedStringHelper);
            dimensionsFound.add(dimensionRec);
        }
        return dimensionsFound;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<EssbaseDimensionCacheItem> getCachedDimensions(EssbaseConnection connection, String dimensionName, Map<String, String> aliasTableNames, DimensionType dimensionType) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        if (dimensionName != null) {
            ArrayList<EssbaseDimensionCacheItem> cashedDimension = new ArrayList<EssbaseDimensionCacheItem>(1);
            EssbaseDimensionCacheItem dimension = metadataCache.findDimension(dimensionName);
            if (dimension == null) {
                IEssDimension essDim = metadataCache.getEssDimensionMap().get(dimensionName);
                if (essDim == null) throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_DIMENSION_NAME, dimensionName);
                if (!this.isDimensionRequired(connection, essDim, dimensionType)) return cashedDimension;
                dimension = metadataCache.loadDimension(essDim);
                cashedDimension.add(dimension);
                return cashedDimension;
            } else {
                if (!this.isDimensionRequired(dimension, dimensionType)) return cashedDimension;
                cashedDimension.add(dimension);
            }
            return cashedDimension;
        }
        Map<String, IEssDimension> cachedEssDimensionMap = metadataCache.getEssDimensionMap();
        ArrayList<EssbaseDimensionCacheItem> cashedDimensions = new ArrayList<EssbaseDimensionCacheItem>(cachedEssDimensionMap.size());
        for (IEssDimension essDim : cachedEssDimensionMap.values()) {
            String dimName = essbaseAPI.getDimensionName(essDim);
            EssbaseDimensionCacheItem dimension = metadataCache.findDimension(dimName);
            if (dimension == null) {
                if (!this.isDimensionRequired(connection, essDim, dimensionType)) continue;
                dimension = metadataCache.loadDimension(essDim);
                cashedDimensions.add(dimension);
                continue;
            }
            if (!this.isDimensionRequired(dimension, dimensionType)) continue;
            cashedDimensions.add(dimension);
        }
        return cashedDimensions;
    }

    private boolean isDimensionRequired(EssbaseDimensionCacheItem dimension, DimensionType dimensionType) {
        switch (dimensionType) {
            case ALL: {
                return true;
            }
            case REGULAR: {
                return !this.isAttributeProperty || !dimension.isAttributeDimension();
            }
            case MEASURE: {
                return dimension.getType() == DimensionTypeEnum.MEASURE;
            }
            case ATTRIBUTE: {
                return dimension.isAttributeDimension();
            }
        }
        return false;
    }

    private boolean isDimensionRequired(EssbaseConnection connection, IEssDimension essDimension, DimensionType dimensionType) {
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        int dimCategory = essbaseAPI.intValue(essbaseAPI.getTag(essDimension));
        switch (dimensionType) {
            case ALL: {
                return true;
            }
            case REGULAR: {
                return !this.isAttributeProperty || dimCategory != 6 && dimCategory != 7;
            }
            case MEASURE: {
                return dimCategory == 1;
            }
            case ATTRIBUTE: {
                return dimCategory == 6 || dimCategory == 7;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getDimensionName(IRestrictions restrictions) {
        String dimensionUniqueName = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        if (!EssbaseUtil.isEmpty(dimensionUniqueName)) return EssbaseUtil.extractDimensionName(dimensionUniqueName);
        String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        if (!EssbaseUtil.isEmpty(hierarchyUniqueName)) return EssbaseUtil.extractDimensionName(hierarchyUniqueName);
        String levelUniqueName = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null);
        if (!EssbaseUtil.isEmpty(levelUniqueName)) return EssbaseUtil.extractDimensionName(levelUniqueName);
        String memberUniqueName = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        if (!EssbaseUtil.isEmpty(memberUniqueName)) return EssbaseUtil.extractDimensionName(memberUniqueName);
        String measureUniqueName = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME, null);
        if (EssbaseUtil.isEmpty(measureUniqueName)) return null;
        return EssbaseUtil.extractDimensionName(measureUniqueName);
    }

    private String getHierarchyName(IRestrictions restrictions) {
        String hierarchyUniqueName = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        if (EssbaseUtil.isEmpty(hierarchyUniqueName)) {
            return this.getDimensionName(restrictions);
        }
        return EssbaseUtil.extractName(hierarchyUniqueName);
    }

    public void getLevels(EssbaseConnection connection, String dimensionName, String levelName, int levelNumber, Map<String, String> aliasTableNames, List<LevelRecord> levelsFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        List<EssbaseDimensionCacheItem> dimensionsFound = this.getCachedDimensions(connection, dimensionName, aliasTableNames, DimensionType.REGULAR);
        if (dimensionsFound.isEmpty()) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_DIMENSION_NAME, dimensionName);
        }
        EssbaseDimensionCacheItem dimension = dimensionsFound.get(0);
        if (dimension == null) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_DIMENSION_NAME, dimensionName);
        }
        boolean isNameSpecified = !EssbaseUtil.isEmpty(levelName);
        String dimName = dimension.getName();
        Set<LevelRecord> cache = metadataCache.getDimensionLevelCache(dimName);
        for (LevelRecord levelRec : cache) {
            if (isNameSpecified) {
                String name = levelRec.getName();
                if (!levelName.equals(name)) continue;
                levelsFound.add(levelRec);
                break;
            }
            if (levelNumber >= 0) {
                int levelNo = levelRec.getLevelNumber();
                if (levelNo != levelNumber) continue;
                levelsFound.add(levelRec);
                break;
            }
            levelsFound.add(levelRec);
        }
    }

    private void getMeasureRecords(EssbaseConnection connection, String levelName, QueryParameters parameters, List<MeasureRecord> measuresFound) {
        List<EssbaseDimensionCacheItem> dimensionsFound;
        if (EssbaseUtil.isEmpty(parameters.dimName) && !(dimensionsFound = this.getCachedDimensions(connection, null, parameters.aliasTableNames, DimensionType.MEASURE)).isEmpty()) {
            EssbaseDimensionCacheItem dimension = dimensionsFound.get(0);
            parameters.dimName = dimension.getName();
        }
        if (EssbaseUtil.isEmpty(parameters.dimName)) {
            return;
        }
        if (parameters.memberName != null) {
            if (parameters.treeOpSet.isEmpty()) {
                measuresFound.add(this.getSingleMeasureRecord(connection, parameters));
            } else {
                if (parameters.treeOpSet.contains(TreeOperatorEnum.SELF)) {
                    measuresFound.add(this.getSingleMeasureRecord(connection, parameters));
                }
                block8: for (TreeOperatorEnum treeOp : parameters.treeOpSet) {
                    switch (treeOp) {
                        case SELF: {
                            continue block8;
                        }
                        case PARENT: {
                            MeasureRecord record = this.getParentMeasureRecord(connection, parameters);
                            if (record == null) continue block8;
                            measuresFound.add(record);
                            continue block8;
                        }
                        case CHILDREN: {
                            this.getChildrenMeasureRecords(connection, parameters, measuresFound);
                            continue block8;
                        }
                        case SIBLINGS: {
                            this.getSiblingMeasureRecords(connection, parameters, measuresFound);
                            continue block8;
                        }
                        case DESCENDANTS: {
                            this.getDescendantMeasureRecords(connection, parameters, measuresFound);
                            continue block8;
                        }
                        case ANCESTORS: {
                            this.getAncestorMeasureRecords(connection, parameters, measuresFound);
                            continue block8;
                        }
                    }
                    throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_TREE_OP, treeOp.toString());
                }
            }
        } else if (parameters.levelNumber >= 0 || levelName != null) {
            this.getLevelMeasureRecords(connection, levelName, parameters, measuresFound);
        } else {
            this.getAllMeasureRecords(connection, parameters, measuresFound);
        }
    }

    MeasureRecord getSingleMeasureRecord(EssbaseConnection connection, QueryParameters parameters) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        MeasureRecord record = null;
        EssbaseMemberCacheItem member = metadataCache.findMemberCacheItem(null, parameters.memberName);
        if (member != null) {
            record = member.createMeasureRecord(null, parameters.aliasTableNames, this.localizedStringHelper);
        } else {
            StringBuilder buffer = new StringBuilder();
            buffer.append(STR_MEMBER).append(parameters.memberName).append(STR_QUOTATION_BRKT);
            EssbaseWrappers essbaseAPI = connection.getEssAPI();
            IEssMemberSelection mbrSel = connection.openMbrSel();
            essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buffer.toString());
            IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
            int essMembersCount = essbaseAPI.getCount(essMembers);
            if (essMembersCount < 1) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_MEMBER_NAME, parameters.memberName);
            }
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, 0);
            member = metadataCache.addMember(essMember, parameters.memberName, parameters.dimName);
            record = member.createMeasureRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper);
            connection.releaseMbrSel(mbrSel);
        }
        return record;
    }

    MeasureRecord getParentMeasureRecord(EssbaseConnection connection, QueryParameters parameters) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        MeasureRecord record = null;
        EssbaseMemberCacheItem member = metadataCache.findMemberCacheItem(null, parameters.memberName);
        if (member != null) {
            int levelNumber = member.getLevelNumber();
            if (levelNumber > 0) {
                String parentUniqueName = member.getParentUniqueName();
                String parentName = EssbaseUtil.extractName(parentUniqueName);
                EssbaseMemberCacheItem parentMember = metadataCache.findMemberCacheItem(null, parentName);
                record = parentMember.createMeasureRecord(null, parameters.aliasTableNames, this.localizedStringHelper);
            }
        } else {
            EssbaseWrappers essbaseAPI = connection.getEssAPI();
            IEssMemberSelection mbrSel = connection.openMbrSel();
            essbaseAPI.executeQuery(mbrSel, parameters.memberName, 7, parameters.dimName, STR_EMPTY, parameters);
            IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
            int essMembersCount = essbaseAPI.getCount(essMembers);
            if (essMembersCount > 0) {
                IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, 0);
                member = metadataCache.addMember(essMember, essbaseAPI.getMemberName(essMember), parameters.dimName);
                record = member.createMeasureRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper);
            }
            connection.releaseMbrSel(mbrSel);
        }
        return record;
    }

    void getChildrenMeasureRecords(EssbaseConnection connection, QueryParameters parameters, List<MeasureRecord> measuresFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        String parentName = EssbaseUtil.extractParentName(parameters.memberUniqueName);
        EssbaseMemberCacheItem cachedMember = null;
        cachedMember = metadataCache.findMemberCacheItem(parentName, parameters.memberName);
        if (cachedMember != null && cachedMember.getCardinality() == 0) {
            return;
        }
        cachedMember = metadataCache.findMemberCacheItem(null, parameters.memberName);
        if (cachedMember != null && cachedMember.getCardinality() == 0) {
            return;
        }
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        StringBuilder buffer = new StringBuilder();
        buffer.append(STR_CHILDREN).append(parameters.memberName).append(STR_QUOTATION_BRKT);
        IEssMemberSelection mbrSel = connection.openMbrSel();
        essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buffer.toString(), parameters.from + parameters.size);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        for (int i = parameters.from; i < essMembersCount; ++i) {
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
            String memberName = essbaseAPI.getMemberName(essMember);
            EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, parameters.dimName);
            measuresFound.add(member.createMeasureRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
        }
        connection.releaseMbrSel(mbrSel);
    }

    void getSiblingMeasureRecords(EssbaseConnection connection, QueryParameters parameters, List<MeasureRecord> measuresFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        StringBuilder buffer = new StringBuilder();
        buffer.append(STR_SIBLINGS).append(parameters.memberName).append(STR_QUOTATION_BRKT);
        IEssMemberSelection mbrSel = connection.openMbrSel();
        essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buffer.toString(), parameters.from + parameters.size);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        for (int i = parameters.from; i < essMembersCount; ++i) {
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
            String memberName = essbaseAPI.getMemberName(essMember);
            if (memberName.equals(parameters.memberName)) continue;
            EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, parameters.dimName);
            measuresFound.add(member.createMeasureRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
        }
        connection.releaseMbrSel(mbrSel);
    }

    void getDescendantMeasureRecords(EssbaseConnection connection, QueryParameters parameters, List<MeasureRecord> measuresFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        StringBuilder buffer = new StringBuilder();
        buffer.append(STR_DESCENDANTS).append(parameters.memberName).append(STR_QUOTATION_BRKT);
        IEssMemberSelection mbrSel = connection.openMbrSel();
        essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buffer.toString(), parameters.from + parameters.size);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        for (int i = parameters.from; i < essMembersCount; ++i) {
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
            String memberName = essbaseAPI.getMemberName(essMember);
            EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, parameters.dimName);
            measuresFound.add(member.createMeasureRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
        }
        connection.releaseMbrSel(mbrSel);
    }

    void getAncestorMeasureRecords(EssbaseConnection connection, QueryParameters parameters, List<MeasureRecord> measuresFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseMemberCacheItem member = metadataCache.addMember(null, parameters.memberName, parameters.dimName);
        String parentUniqueName = member.getParentUniqueName();
        while (parentUniqueName != null) {
            String parentName = EssbaseUtil.extractName(parentUniqueName);
            member = metadataCache.findMemberCacheItem(null, parentName);
            if (member.getLevelNumber() > 0) {
                measuresFound.add(member.createMeasureRecord(null, parameters.aliasTableNames, this.localizedStringHelper));
            }
            parentUniqueName = member.getParentUniqueName();
        }
    }

    void getLevelMeasureRecords(EssbaseConnection connection, String levelName, QueryParameters parameters, List<MeasureRecord> measuresFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        IEssMemberSelection mbrSel = connection.openMbrSel();
        this.getMembersFromDimension(connection, mbrSel, levelName, parameters);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        if (parameters.treeOpSet.isEmpty()) {
            for (int i = parameters.from; i < essMembersCount; ++i) {
                IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
                String memberName = essbaseAPI.getMemberName(essMember);
                EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, parameters.dimName);
                measuresFound.add(member.createMeasureRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
            }
        } else {
            int localFrom = parameters.from;
            int localSize = parameters.size;
            QueryParameters params = new QueryParameters();
            params.dimName = parameters.dimName;
            params.treeOpSet = parameters.treeOpSet;
            params.from = 0;
            params.size = Integer.MAX_VALUE;
            params.aliasTableNames = parameters.aliasTableNames;
            params.currentAliasTableName = parameters.currentAliasTableName;
            for (int i = 0; i < essMembersCount; ++i) {
                IEssMember essMbr = (IEssMember)essbaseAPI.getAt(essMembers, i);
                ArrayList<MeasureRecord> msresFound = new ArrayList<MeasureRecord>();
                params.memberName = essbaseAPI.getMemberName(essMbr);
                params.levelNumber = essbaseAPI.getGenerationNumber(essMbr) - 1;
                this.getMeasureRecords(connection, null, params, msresFound);
                int count = msresFound.size();
                if (localFrom >= count) {
                    localFrom -= count;
                    continue;
                }
                count = Math.min(localSize, count - localFrom);
                for (int j = localFrom; j < localFrom + count; ++j) {
                    measuresFound.add((MeasureRecord)msresFound.get(j));
                }
                localFrom = 0;
                if ((localSize -= count) > 0) {
                    continue;
                }
                break;
            }
        }
        connection.releaseMbrSel(mbrSel);
    }

    void getAllMeasureRecords(EssbaseConnection connection, QueryParameters parameters, List<MeasureRecord> measuresFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        IEssMemberSelection mbrSel = connection.openMbrSel();
        essbaseAPI.executeQuery(mbrSel, parameters.dimName, 2, parameters.dimName, STR_EMPTY, parameters);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        for (int i = 0; i < essMembersCount; ++i) {
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
            String memberName = essbaseAPI.getMemberName(essMember);
            EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, parameters.dimName);
            measuresFound.add(member.createMeasureRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
        }
        connection.releaseMbrSel(mbrSel);
    }

    private void getMemberRecordsWithMUN(EssbaseConnection connection, String levelName, QueryParameters parameters, List<MemberRecord> membersFound) {
        if (parameters.treeOpSet.isEmpty()) {
            membersFound.add(this.getSingleMemberRecord(connection, parameters, null));
        } else {
            if (parameters.treeOpSet.contains(TreeOperatorEnum.SELF)) {
                membersFound.add(this.getSingleMemberRecord(connection, parameters, null));
            }
            block8: for (TreeOperatorEnum treeOp : parameters.treeOpSet) {
                switch (treeOp) {
                    case SELF: {
                        continue block8;
                    }
                    case PARENT: {
                        MemberRecord record = this.getParentMemberRecord(connection, parameters);
                        if (record == null) continue block8;
                        membersFound.add(record);
                        continue block8;
                    }
                    case CHILDREN: {
                        this.getChildrenMemberRecords(connection, parameters, membersFound);
                        continue block8;
                    }
                    case SIBLINGS: {
                        this.getSiblingMemberRecords(connection, parameters, membersFound);
                        continue block8;
                    }
                    case DESCENDANTS: {
                        this.getDescendantMemberRecords(connection, parameters, membersFound);
                        continue block8;
                    }
                    case ANCESTORS: {
                        this.getAncestorMemberRecords(connection, parameters, membersFound);
                        continue block8;
                    }
                }
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_TREE_OP, treeOp.toString());
            }
        }
    }

    private void getMemberRecordsWithMUNforSharedMember(EssbaseConnection connection, String levelName, QueryParameters params, List<MemberRecord> membersFound) {
        String parentName = EssbaseUtil.extractParentName(params.memberUniqueName);
        QueryParameters parameters = new QueryParameters();
        parameters.dimName = params.dimName;
        parameters.memberName = parentName;
        parameters.memberUniqueName = STR_EMPTY;
        parameters.levelNumber = params.levelNumber - 1;
        parameters.from = params.from;
        parameters.size = params.size;
        parameters.aliasTableNames = params.aliasTableNames;
        ArrayList<MemberRecord> tempList = new ArrayList<MemberRecord>();
        if (params.treeOpSet.isEmpty()) {
            this.getChildrenMemberRecords(connection, parameters, tempList);
            for (MemberRecord m : tempList) {
                if (!m.getName().equals(params.memberName)) continue;
                membersFound.add(m);
            }
        } else {
            if (params.treeOpSet.contains(TreeOperatorEnum.SELF)) {
                parameters.size = Integer.MAX_VALUE;
                this.getChildrenMemberRecords(connection, parameters, tempList);
                for (MemberRecord m : tempList) {
                    if (!m.getName().equals(params.memberName)) continue;
                    membersFound.add(m);
                }
            }
            parameters.size = params.size;
            block10: for (TreeOperatorEnum treeOp : params.treeOpSet) {
                switch (treeOp) {
                    case SELF: {
                        break;
                    }
                    case PARENT: {
                        MemberRecord record = this.getSingleMemberRecord(connection, parameters, null);
                        if (record == null) continue block10;
                        membersFound.add(record);
                        break;
                    }
                    case CHILDREN: {
                        break;
                    }
                    case SIBLINGS: {
                        this.getChildrenMemberRecords(connection, parameters, tempList);
                        for (MemberRecord m : tempList) {
                            if (m.getName().equals(params.memberName)) continue;
                            membersFound.add(m);
                        }
                        continue block10;
                    }
                    case DESCENDANTS: {
                        break;
                    }
                    case ANCESTORS: {
                        MemberRecord parentRecord = this.getSingleMemberRecord(connection, parameters, null);
                        if (parentRecord != null) {
                            membersFound.add(parentRecord);
                        }
                        this.getAncestorMemberRecords(connection, parameters, membersFound);
                        break;
                    }
                    default: {
                        throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_TREE_OP, treeOp.toString());
                    }
                }
            }
        }
    }

    private void getMemberRecords(EssbaseConnection connection, String levelName, QueryParameters parameters, List<MemberRecord> membersFound) {
        MemberRecord member;
        String parentName = EssbaseUtil.extractParentName(parameters.memberUniqueName);
        boolean isSharedMember = false;
        String recordParent = STR_EMPTY;
        if (parentName != null && (member = this.getSingleMemberRecord(connection, parameters, null)) != null) {
            recordParent = EssbaseUtil.extractName(member.getParentUniqueName());
            boolean bl = isSharedMember = !parentName.equals(recordParent);
        }
        if (parameters.memberName != null) {
            if (isSharedMember) {
                this.getMemberRecordsWithMUNforSharedMember(connection, levelName, parameters, membersFound);
            } else {
                this.getMemberRecordsWithMUN(connection, levelName, parameters, membersFound);
            }
        } else if (parameters.dimName != null) {
            this.getDimensionMemberRecords(connection, levelName, parameters, membersFound);
        } else {
            this.getAllMemberRecords(connection, parameters, membersFound);
        }
    }

    MemberRecord getSingleMemberRecord(EssbaseConnection connection, QueryParameters parameters, IEssMember essMbr) {
        EssbaseMemberCacheItem member;
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        MemberRecord record = null;
        String parentName = null;
        if (essMbr != null && essbaseAPI.isSharedMember(essMbr)) {
            parentName = essbaseAPI.getParentMemberName(essMbr);
        }
        if ((member = metadataCache.findMemberCacheItem(parentName, parameters.memberName)) != null) {
            record = member.createMemberRecord(null, parameters.aliasTableNames, this.localizedStringHelper);
        } else {
            IEssMember essMember = essMbr;
            IEssMemberSelection mbrSel = null;
            if (essMember == null) {
                StringBuilder buffer = new StringBuilder();
                buffer.append(STR_MEMBER).append(parameters.memberName).append(STR_QUOTATION_BRKT);
                mbrSel = connection.openMbrSel();
                essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buffer.toString());
                IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
                int essMembersCount = essbaseAPI.getCount(essMembers);
                if (essMembersCount < 1) {
                    throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_MEMBER_NAME, parameters.memberName);
                }
                essMember = (IEssMember)essbaseAPI.getAt(essMembers, 0);
            }
            member = metadataCache.addMember(essMember, parameters.memberName, parameters.dimName);
            record = member.createMemberRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper);
            if (mbrSel != null) {
                connection.releaseMbrSel(mbrSel);
            }
        }
        return record;
    }

    MemberRecord getParentMemberRecord(EssbaseConnection connection, QueryParameters parameters) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        MemberRecord record = null;
        EssbaseMemberCacheItem member = metadataCache.findMemberCacheItem(null, parameters.memberName);
        if (member != null) {
            int levelNumber = member.getLevelNumber();
            if (levelNumber > 0) {
                String parentUniqueName = member.getParentUniqueName();
                String parentName = EssbaseUtil.extractName(parentUniqueName);
                EssbaseMemberCacheItem parentMember = metadataCache.findMemberCacheItem(null, parentName);
                record = parentMember.createMemberRecord(null, parameters.aliasTableNames, this.localizedStringHelper);
            }
        } else {
            EssbaseWrappers essbaseAPI = connection.getEssAPI();
            IEssMemberSelection mbrSel = connection.openMbrSel();
            essbaseAPI.executeQuery(mbrSel, parameters.memberName, 7, parameters.dimName, STR_EMPTY, parameters);
            IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
            int essMembersCount = essbaseAPI.getCount(essMembers);
            if (essMembersCount > 0) {
                IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, 0);
                member = metadataCache.addMember(essMember, essbaseAPI.getMemberName(essMember), parameters.dimName);
                record = member.createMemberRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper);
            }
            connection.releaseMbrSel(mbrSel);
        }
        return record;
    }

    void getChildrenMemberRecords(EssbaseConnection connection, QueryParameters parameters, List<MemberRecord> membersFound) {
        String parentName;
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseMemberCacheItem cachedMember = metadataCache.findMemberCacheItem(parentName = EssbaseUtil.extractParentName(parameters.memberUniqueName), parameters.memberName);
        if (cachedMember != null && cachedMember.getCardinality() == 0) {
            return;
        }
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        StringBuilder buffer = new StringBuilder();
        buffer.append(STR_CHILDREN).append(parameters.memberName).append(STR_QUOTATION_BRKT);
        IEssMemberSelection mbrSel = connection.openMbrSel();
        essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buffer.toString(), parameters.from + parameters.size);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        for (int i = parameters.from; i < essMembersCount; ++i) {
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
            String memberName = essbaseAPI.getMemberName(essMember);
            EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, parameters.dimName);
            membersFound.add(member.createMemberRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
        }
        connection.releaseMbrSel(mbrSel);
    }

    void getSiblingMemberRecords(EssbaseConnection connection, QueryParameters parameters, List<MemberRecord> membersFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        StringBuilder buffer = new StringBuilder();
        buffer.append(STR_SIBLINGS).append(parameters.memberName).append(STR_QUOTATION_BRKT);
        IEssMemberSelection mbrSel = connection.openMbrSel();
        essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buffer.toString(), parameters.from + parameters.size);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        for (int i = parameters.from; i < essMembersCount; ++i) {
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
            String memberName = essbaseAPI.getMemberName(essMember);
            if (memberName.equals(parameters.memberName)) continue;
            EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, parameters.dimName);
            membersFound.add(member.createMemberRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
        }
        connection.releaseMbrSel(mbrSel);
    }

    void getDescendantMemberRecords(EssbaseConnection connection, QueryParameters parameters, List<MemberRecord> membersFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        StringBuilder buffer = new StringBuilder();
        buffer.append(STR_DESCENDANTS).append(parameters.memberName).append(STR_QUOTATION_BRKT);
        IEssMemberSelection mbrSel = connection.openMbrSel();
        essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buffer.toString(), parameters.from + parameters.size);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        for (int i = parameters.from; i < essMembersCount; ++i) {
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
            String memberName = essbaseAPI.getMemberName(essMember);
            EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, parameters.dimName);
            membersFound.add(member.createMemberRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
        }
        connection.releaseMbrSel(mbrSel);
    }

    void getAncestorMemberRecords(EssbaseConnection connection, QueryParameters parameters, List<MemberRecord> membersFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseMemberCacheItem member = metadataCache.addMember(null, parameters.memberName, parameters.dimName);
        String parentUniqueName = member.getParentUniqueName();
        while (parentUniqueName != null) {
            String parentName = EssbaseUtil.extractName(parentUniqueName);
            member = metadataCache.findMemberCacheItem(null, parentName);
            membersFound.add(member.createMemberRecord(null, parameters.aliasTableNames, this.localizedStringHelper));
            parentUniqueName = member.getParentUniqueName();
        }
    }

    private void getMemberRecordsFromPPDSCodes(EssbaseConnection connection, Collection<String> ppdsCodes, String levelName, QueryParameters parameters, List<MemberRecord> membersFound) {
        for (String ppdsCode : ppdsCodes) {
            if (ppdsCode != null) {
                List<DimensionRecord> records = this.getDimensionRecords(connection, null, null);
                if (records != null) {
                    for (DimensionRecord dr : records) {
                        if (!ppdsCode.equals(dr.getName())) continue;
                        parameters.dimName = ppdsCode;
                        break;
                    }
                }
                parameters.memberName = ppdsCode;
                this.getMemberRecords(connection, levelName, parameters, membersFound);
                continue;
            }
            if (!this.logger.isOn(LogLevel.WARN)) continue;
            this.logger.log(LogLevel.WARN, "Empty PPDSCode restriction");
        }
    }

    void getDimensionMemberRecords(EssbaseConnection connection, String levelName, QueryParameters parameters, List<MemberRecord> membersFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        IEssMemberSelection mbrSel = connection.openMbrSel();
        this.getMembersFromDimension(connection, mbrSel, levelName, parameters);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        if (parameters.treeOpSet.isEmpty()) {
            for (int i = parameters.from; i < essMembersCount; ++i) {
                IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
                String memberName = essbaseAPI.getMemberName(essMember);
                EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, parameters.dimName);
                membersFound.add(member.createMemberRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
            }
        } else {
            int localFrom = parameters.from;
            int localSize = parameters.size;
            QueryParameters params = new QueryParameters();
            params.treeOpSet = parameters.treeOpSet;
            params.from = 0;
            params.size = Integer.MAX_VALUE;
            params.currentAliasTableName = parameters.currentAliasTableName;
            for (int i = 0; i < essMembersCount; ++i) {
                IEssMember essMbr = (IEssMember)essbaseAPI.getAt(essMembers, i);
                ArrayList<MemberRecord> mbrsFound = new ArrayList<MemberRecord>();
                params.dimName = essbaseAPI.getDimensionName(essMbr);
                params.memberName = essbaseAPI.getMemberName(essMbr);
                params.levelNumber = essbaseAPI.getGenerationNumber(essMbr) - 1;
                this.getMemberRecords(connection, null, params, mbrsFound);
                int count = mbrsFound.size();
                if (localFrom >= count) {
                    localFrom -= count;
                    continue;
                }
                count = Math.min(localSize, count - localFrom);
                for (int j = localFrom; j < localFrom + count; ++j) {
                    membersFound.add((MemberRecord)mbrsFound.get(j));
                }
                localFrom = 0;
                if ((localSize -= count) > 0) {
                    continue;
                }
                break;
            }
        }
        connection.releaseMbrSel(mbrSel);
    }

    void getMembersFromDimension(EssbaseConnection connection, IEssMemberSelection mbrSel, String levelName, QueryParameters parameters) {
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        if (parameters.levelNumber >= 0) {
            EssbaseMetadataCache metadataCache = connection.getMetadataCache();
            int levelNumber = parameters.levelNumber;
            if (parameters.dimName.equals(metadataCache.getMeasureDimensionName())) {
                ++levelNumber;
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append(STR_GENMBRS).append(parameters.dimName).append(STR_QUOTATION_COMMA);
            buffer.append(Integer.toString(levelNumber + 1)).append(STR_CLOSE_BRKT);
            essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buffer.toString(), parameters.from + parameters.size);
        } else if (levelName != null) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(STR_GENMBRS).append(parameters.dimName).append(STR_QUOTATION_COMMA);
            buffer.append(STR_QUOTATION).append(levelName).append(STR_QUOTATION_BRKT);
            essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", buffer.toString(), parameters.from + parameters.size);
        } else {
            QueryParameters essQueryParams = new QueryParameters();
            essQueryParams.currentAliasTableName = parameters.currentAliasTableName;
            essQueryParams.from = 0;
            essQueryParams.size = parameters.from + parameters.size;
            essbaseAPI.executeQuery(mbrSel, null, 12, parameters.dimName, ASTER, essQueryParams);
        }
    }

    void getAllMemberRecords(EssbaseConnection connection, QueryParameters parameters, List<MemberRecord> membersFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        List<EssbaseDimensionCacheItem> cashedDimensions = this.getCachedDimensions(connection, null, parameters.aliasTableNames, DimensionType.REGULAR);
        Iterator<EssbaseDimensionCacheItem> iter = cashedDimensions.iterator();
        int totalCount = 0;
        boolean isContinue = true;
        IEssMemberSelection mbrSel = connection.openMbrSel();
        block0: while (isContinue && iter.hasNext()) {
            EssbaseDimensionCacheItem dimension = iter.next();
            String dimensionName = dimension.getName();
            essbaseAPI.executeQuery(mbrSel, null, 12, dimensionName, ASTER, parameters);
            IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
            int essMembersCount = essbaseAPI.getCount(essMembers);
            for (int i = 0; i < essMembersCount; ++i) {
                IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
                String memberName = essbaseAPI.getMemberName(essMember);
                EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, dimensionName);
                membersFound.add(member.createMemberRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
                if (++totalCount < parameters.size) continue;
                isContinue = false;
                continue block0;
            }
        }
        connection.releaseMbrSel(mbrSel);
    }

    private void getMemberProperty(EssbaseConnection essConnection, String memberProperty, QueryParameters inputParameters, List<MemberRecord> membersFound) {
        if (!"MEMBER_TYPE".equals(memberProperty)) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_UNSUPPORTED_RESTRICTION_COMBINATION);
        }
        String cmd = this.generateCMD(essConnection, inputParameters);
        IEssMemberSelection mbrSel = essConnection.openMbrSel();
        try {
            EssbaseWrappers essbaseAPI = essConnection.getEssAPI();
            essbaseAPI.executeQuery(mbrSel, "<OutputType Binary <SelectMbrInfo(MemberName,MemberFormula)", cmd);
            IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
            if (essbaseAPI.getCount(essMembers) < 1) {
                throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_MEMBER_NAME, inputParameters.memberUniqueName);
            }
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, 0);
            MemberRecord memberRec = new MemberRecord();
            memberRec.setName(inputParameters.memberName);
            memberRec.setUniqueName(inputParameters.memberUniqueName);
            boolean isMemberFormula = essbaseAPI.isFormula(essMember);
            if (isMemberFormula) {
                memberRec.setType(MemberTypeEnum.CALCULATED);
            } else {
                memberRec.setType(MemberTypeEnum.REGULAR);
            }
            membersFound.add(memberRec);
        }
        catch (EssbaseRuntimeException e) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_MEMBER_QUERY_ERROR, (Throwable)((Object)e), cmd);
        }
        finally {
            essConnection.releaseMbrSel(mbrSel);
        }
    }

    private String generateCMD(EssbaseConnection essConnection, QueryParameters inputParameters) {
        if (inputParameters.memberName == null) {
            if (this.logger.isOn(LogLevel.ERROR)) {
                this.logger.log(LogLevel.ERROR, "Member name is not set.");
            }
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_UNSUPPORTED_RESTRICTION_COMBINATION);
        }
        EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
        String memberName = null;
        memberName = metadataCache.isDuplicateMembersAllowed() ? inputParameters.memberUniqueName : inputParameters.memberName;
        StringBuilder cmd = new StringBuilder(STR_MEMBER);
        cmd.append(memberName).append(STR_QUOTATION_BRKT);
        if (this.logger.isOn()) {
            StringBuilder buf = new StringBuilder();
            buf.append("Generated command line for member types retrieval: ").append((CharSequence)cmd);
            this.logger.log(buf.toString());
        }
        return cmd.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void getMemberRecordsSearch(EssbaseConnection connection, String levelName, QueryParameters inputParameters, MASearchCriteria searchCriteria, List<MemberRecord> membersFound) {
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        String runLocaleLanguage = this.localizedStringHelper.getRunLocaleLanguage();
        String runLocaleAiasTable = null;
        if (inputParameters.aliasTableNames != null) {
            runLocaleAiasTable = inputParameters.aliasTableNames.get(runLocaleLanguage);
        }
        EssbaseMemberSearch memberSearchHelper = new EssbaseMemberSearch(essbaseAPI, runLocaleAiasTable, searchCriteria);
        if (inputParameters.memberName != null) {
            if (inputParameters.treeOpSet.isEmpty()) {
                membersFound.add(this.getSingleMemberRecord(connection, inputParameters, null));
                return;
            } else {
                if (inputParameters.treeOpSet.contains(TreeOperatorEnum.SELF)) {
                    membersFound.add(this.getSingleMemberRecord(connection, inputParameters, null));
                }
                if (!inputParameters.treeOpSet.contains(TreeOperatorEnum.CHILDREN) && !inputParameters.treeOpSet.contains(TreeOperatorEnum.DESCENDANTS)) throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_TREE_OP, inputParameters.treeOpSet.toString());
                this.searchChildMembers(connection, inputParameters, memberSearchHelper, membersFound);
            }
            return;
        } else if (inputParameters.dimName != null) {
            IEssMemberSelection mbrSel = connection.openMbrSel();
            this.searchMembersInDimension(connection, levelName, inputParameters, mbrSel, memberSearchHelper, membersFound);
            connection.releaseMbrSel(mbrSel);
            return;
        } else {
            List<EssbaseDimensionCacheItem> cashedDimensions = this.getCachedDimensions(connection, null, inputParameters.aliasTableNames, DimensionType.REGULAR);
            Iterator<EssbaseDimensionCacheItem> iter = cashedDimensions.iterator();
            IEssMemberSelection mbrSel = connection.openMbrSel();
            while (iter.hasNext()) {
                EssbaseDimensionCacheItem dimension = iter.next();
                inputParameters.dimName = dimension.getName();
                this.searchMembersInDimension(connection, levelName, inputParameters, mbrSel, memberSearchHelper, membersFound);
                if (inputParameters.size > 0) continue;
                break;
            }
            connection.releaseMbrSel(mbrSel);
        }
    }

    private void searchChildMembers(EssbaseConnection connection, QueryParameters parameters, EssbaseMemberSearch memberSearchHelper, List<MemberRecord> membersFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        int maxCount = parameters.size;
        int memberCount = 0;
        IEssMemberSelection mbrSel = connection.openMbrSel();
        int queryType = 1;
        if (parameters.treeOpSet.contains(TreeOperatorEnum.DESCENDANTS)) {
            queryType = 2;
        }
        parameters.size = Integer.MAX_VALUE;
        essbaseAPI.executeQuery(mbrSel, parameters.memberName, queryType, parameters.dimName, STR_EMPTY, parameters);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        for (int i = parameters.from; i < essMembersCount; ++i) {
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
            if (!memberSearchHelper.isMemberFound(essMember)) continue;
            EssbaseMemberCacheItem member = metadataCache.addMember(essMember, essbaseAPI.getMemberName(essMember), parameters.dimName);
            membersFound.add(member.createMemberRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
            if (++memberCount >= maxCount) break;
        }
        connection.releaseMbrSel(mbrSel);
    }

    private int searchMembersInDimension(EssbaseConnection connection, String levelName, QueryParameters parameters, IEssMemberSelection mbrSel, EssbaseMemberSearch memberSearchHelper, List<MemberRecord> membersFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        int maxCount = parameters.size;
        int memberCount = 0;
        parameters.size = Integer.MAX_VALUE;
        this.getMembersFromDimension(connection, mbrSel, levelName, parameters);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        for (int i = parameters.from; i < essMembersCount; ++i) {
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
            if (!memberSearchHelper.isMemberFound(essMember)) continue;
            EssbaseMemberCacheItem member = metadataCache.addMember(essMember, essbaseAPI.getMemberName(essMember), parameters.dimName);
            membersFound.add(member.createMemberRecord(essMember, parameters.aliasTableNames, this.localizedStringHelper));
            if (++memberCount >= maxCount) break;
        }
        parameters.size = maxCount - memberCount;
        return memberCount;
    }

    private String getLevelName(IRestrictions restrictions) {
        String levelUniqueName = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null);
        return EssbaseUtil.extractName(levelUniqueName);
    }

    private String getMemberName(IRestrictions restrictions) {
        String memberUniqueName = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME, null);
        return EssbaseUtil.extractName(memberUniqueName);
    }

    private String getMeasureName(IRestrictions restrictions) {
        String measureUniqueName = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME, null);
        return EssbaseUtil.extractName(measureUniqueName);
    }

    private String getPropertyName(IRestrictions restrictions) {
        String propertyUniqueName = (String)restrictions.getValueOf(RestrictionType.NAME, null);
        return EssbaseUtil.extractName(propertyUniqueName);
    }

    private String getNamedSetName(IRestrictions restrictions) {
        String namedSetUniqueName = (String)restrictions.getValueOf(RestrictionType.SET, null);
        return EssbaseUtil.extractName(namedSetUniqueName);
    }

    private void getNamedSetsAndMacros(EssbaseConnection connection) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        IEssCube essCube = metadataCache.getEssConnectionCube();
        Map<String, EssbaseNamedSet> namedSetCache = metadataCache.createNamedSetCache();
        Map<String, EssbaseMacro> macroCache = metadataCache.createMacroCache();
        Map<String, IEssDimension> cachedEssDimensions = metadataCache.getEssDimensionMap();
        String[][] svList = essbaseAPI.getSubstitutionVariables(essCube);
        IEssIterator essMembers = null;
        IEssMemberSelection mbrSel = connection.openMbrSel();
        for (int svNo = 0; svNo < svList.length; ++svNo) {
            int essMembersCount = 0;
            String svName = svList[svNo][0];
            String svValue = svList[svNo][1];
            if (!connection.getMetadataUpdateMarkerName().equals(svName)) {
                try {
                    mbrSel.executeQuery(STR_SEL_MBR_INFO_DIM, svValue);
                    essMembers = essbaseAPI.getMembers(mbrSel);
                    essMembersCount = essbaseAPI.getCount(essMembers);
                }
                catch (EssException e) {
                    essMembersCount = 0;
                }
            }
            if (essMembersCount > 0) {
                String dimensionName = this.getCommonDimension(cachedEssDimensions, essMembers, essMembersCount, essbaseAPI);
                if (dimensionName == null) continue;
                EssbaseNamedSet namedSet = namedSetCache.get(svName);
                if (namedSet == null) {
                    namedSet = new EssbaseNamedSet(connection, svList[svNo], dimensionName);
                    namedSetCache.put(svName, namedSet);
                    continue;
                }
                namedSet.updateNamedSetIfRequired(svList[svNo]);
                continue;
            }
            EssbaseMacro macro = macroCache.get(svName);
            if (macro == null) {
                macro = new EssbaseMacro(connection, svList[svNo]);
                macroCache.put(svName, macro);
                continue;
            }
            macro.updateMacroIfRequired(svList[svNo]);
        }
        connection.releaseMbrSel(mbrSel);
    }

    public String getCommonDimension(Map<String, IEssDimension> cachedEssDimensions, IEssIterator essMembers, int essMembersCount, EssbaseWrappers essbaseAPI) {
        String dimensionName = null;
        for (int memberNo = 0; memberNo < essMembersCount; ++memberNo) {
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, memberNo);
            String name = essbaseAPI.getDimensionName(essMember);
            if (memberNo == 0) {
                IEssDimension essDimension;
                int dimCategory;
                dimensionName = name;
                if (!this.isAttributeProperty || (dimCategory = essbaseAPI.intValue(essbaseAPI.getTag(essDimension = cachedEssDimensions.get(dimensionName)))) != 6 && dimCategory != 7) continue;
                return null;
            }
            if (name.compareTo(dimensionName) == 0) continue;
            return null;
        }
        return dimensionName;
    }

    private void getNamedSetMembers(EssbaseConnection connection, String namedSetName, int restrFrom, int restrSize, Map<String, String> aliasTableNames, List<MemberRecord> namedSetMembers) {
        EssbaseNamedSet namedSet;
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        Map<String, EssbaseNamedSet> cache = metadataCache.getNamedSetCache();
        if (cache == null) {
            this.getNamedSetsAndMacros(connection);
            cache = metadataCache.getNamedSetCache();
        }
        if ((namedSet = cache.get(namedSetName)) == null) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_NAMEDSET_NAME, namedSetName);
        }
        namedSet.refreshCachedValue(connection);
        String namedSetExpression = namedSet.getExpression();
        if (EssbaseUtil.isEmpty(namedSetExpression)) {
            return;
        }
        IEssMemberSelection mbrSel = connection.openMbrSel();
        essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", namedSetExpression, restrFrom + restrSize);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        String[] parts = namedSetExpression.split(",");
        if (restrSize > 1 && parts.length == essMembersCount) {
            block0: for (String part : parts) {
                String name = part.replaceAll(STR_QUOTATION, STR_EMPTY).trim();
                for (int i = restrFrom; i < essMembersCount; ++i) {
                    IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
                    String memberName = essbaseAPI.getMemberName(essMember);
                    if (name.compareToIgnoreCase(memberName) != 0) continue;
                    EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, null);
                    namedSetMembers.add(member.createMemberRecord(essMember, aliasTableNames, this.localizedStringHelper));
                    continue block0;
                }
            }
        } else {
            for (int i = restrFrom; i < essMembersCount; ++i) {
                IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
                String memberName = essbaseAPI.getMemberName(essMember);
                EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName, null);
                namedSetMembers.add(member.createMemberRecord(essMember, aliasTableNames, this.localizedStringHelper));
            }
        }
        connection.releaseMbrSel(mbrSel);
    }

    private void getNamedSetLevelUniqueNames(EssbaseConnection connection, String namedSetName, int restrFrom, int restrSize, Map<String, String> aliasTableNames, List<String> levelUniqueNameList) {
        EssbaseNamedSet namedSet;
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        Map<String, EssbaseNamedSet> cache = metadataCache.getNamedSetCache();
        if (cache == null) {
            this.getNamedSetsAndMacros(connection);
            cache = metadataCache.getNamedSetCache();
        }
        if ((namedSet = cache.get(namedSetName)) == null) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_NAMEDSET_NAME, namedSetName);
        }
        namedSet.refreshCachedValue(connection);
        IEssMemberSelection mbrSel = connection.openMbrSel();
        essbaseAPI.executeQuery(mbrSel, " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)", namedSet.getExpression(), restrFrom + restrSize);
        IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        HashSet<String> levelList = new HashSet<String>();
        ArrayList<String> returnedList = new ArrayList<String>();
        for (int i = restrFrom; i < essMembersCount; ++i) {
            String memberName;
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, i);
            EssbaseMemberCacheItem member = metadataCache.addMember(essMember, memberName = essbaseAPI.getMemberName(essMember), null);
            MemberRecord memRec = member.createMemberRecord(essMember, aliasTableNames, this.localizedStringHelper);
            if (levelList.contains(memRec.getLevelUniqueName())) continue;
            levelList.add(memRec.getLevelUniqueName());
            returnedList.add(memRec.getLevelUniqueName());
        }
        levelUniqueNameList.addAll(returnedList);
        connection.releaseMbrSel(mbrSel);
    }

    private CatalogRecord createCatalogRecord(EssbaseConnection connection, IEssOlapApplication essCatalog) {
        CatalogRecord catalogRec = new CatalogRecord();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        String catalogName = essbaseAPI.getApplicationName(essCatalog);
        catalogRec.setName(catalogName);
        catalogRec.setUniqueName(catalogName);
        catalogRec.setCaption(catalogName);
        catalogRec.setUniqueId(catalogName);
        String catalogDescription = essbaseAPI.getApplicationDescription(essCatalog);
        if (catalogDescription != null) {
            catalogRec.setDescription(catalogDescription);
        }
        return catalogRec;
    }

    private CubeRecord createCubeRecord(EssbaseConnection connection, IEssCube essCube) {
        CubeRecord cubeRec = new CubeRecord();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        String cubeName = essbaseAPI.getCubeName(essCube);
        cubeRec.setName(cubeName);
        cubeRec.setUniqueName(cubeName);
        cubeRec.setCaption(cubeName);
        cubeRec.setCatalogName(essbaseAPI.getCatalogName(essCube));
        cubeRec.setUniqueId(cubeName);
        String description = essbaseAPI.getCubeDescription(essCube);
        if (description != null) {
            cubeRec.setDescription(description);
        }
        cubeRec.setDataUpdateDate(this.schemaUpdateTimeStamp);
        cubeRec.setSchemaUpdateDate(this.schemaUpdateTimeStamp);
        return cubeRec;
    }

    private String getDefaultMeasureMUN(EssbaseConnection connection, EssbaseWrappers essbaseAPI, EssbaseMetadataCache metadataCache) {
        String defaultMeasureMUN = null;
        String measureDimName = metadataCache.getMeasureDimensionName();
        if (measureDimName != null) {
            IEssMemberSelection mbrSel = connection.openMbrSel();
            StringBuilder buf = new StringBuilder();
            buf.append(STR_GENMBRS).append(measureDimName);
            buf.append(STR_QUOTATION_COMMA).append(" 2)");
            String selMbrInfo = "<OutputType Binary <SelectMbrInfo(MemberName)";
            essbaseAPI.executeQuery(mbrSel, "<OutputType Binary <SelectMbrInfo(MemberName)", buf.toString(), 1);
            IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
            IEssMember essMember = (IEssMember)essbaseAPI.getAt(essMembers, 0);
            String memberName = essbaseAPI.getMemberName(essMember);
            defaultMeasureMUN = UniqueNameGenerator.createUniqueName((String)measureDimName, (String)memberName);
            connection.releaseMbrSel(mbrSel);
        }
        return defaultMeasureMUN;
    }

    private void cacheProperties(EssbaseConnection essConnection, EssbaseDimensionCacheItem dimension, Map<String, String> aliasTableNames) {
        String dimensionName;
        IEssCube essCube;
        EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
        EssbaseWrappers essbaseAPI = essConnection.getEssAPI();
        String[][] attributes = essbaseAPI.getAssociatedAttributes(essCube = metadataCache.getEssConnectionCube(), dimensionName = dimension.getName());
        if (attributes.length == 0) {
            metadataCache.addCacheProperties(dimensionName, null);
            return;
        }
        ArrayList<EssbasePropertyCacheItem> propertyList = new ArrayList<EssbasePropertyCacheItem>(attributes.length);
        for (String[] attribute : attributes) {
            String propertyName = attribute[1];
            List<EssbaseDimensionCacheItem> dimsFound = this.getCachedDimensions(essConnection, propertyName, aliasTableNames, DimensionType.ATTRIBUTE);
            EssbaseDimensionCacheItem attrDimension = dimsFound.get(0);
            EssbasePropertyCacheItem cacheProp = new EssbasePropertyCacheItem();
            cacheProp.setCacheProperty(attribute, dimension, attrDimension, null);
            propertyList.add(cacheProp);
        }
        metadataCache.addCacheProperties(dimensionName, propertyList);
    }

    private void getPropertyRecords(EssbaseConnection essConnection, String dimensionName, String levelName, Map<String, String> aliasTableNames, List<PropertyRecord> resultRecords) {
        EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
        List<EssbasePropertyCacheItem> cachedProperies = metadataCache.getCacheProperties(dimensionName);
        if (cachedProperies == null) {
            return;
        }
        String lun = null;
        if (levelName != null) {
            lun = EssbaseMetadataNames.createLevelUniqueName(dimensionName, levelName);
        }
        for (EssbasePropertyCacheItem cacheProp : cachedProperies) {
            List<EssbaseDimensionCacheItem> dimsFound = this.getCachedDimensions(essConnection, cacheProp.getName(), aliasTableNames, DimensionType.ATTRIBUTE);
            EssbaseDimensionCacheItem attrDimension = dimsFound.get(0);
            resultRecords.add(cacheProp.createPropertyRecord(attrDimension, lun, aliasTableNames, this.localizedStringHelper));
        }
    }

    private void getPropertyRecord(EssbaseConnection essConnection, String dimensionName, String propertyName, List<PropertyRecord> resultRecords) {
        EssbaseMetadataCache metadataCache = essConnection.getMetadataCache();
        List<EssbasePropertyCacheItem> cachedProperies = metadataCache.getCacheProperties(dimensionName);
        if (cachedProperies == null) {
            return;
        }
        for (EssbasePropertyCacheItem cacheProp : cachedProperies) {
            if (!propertyName.equals(cacheProp.getName())) continue;
            resultRecords.add(cacheProp.createPropertyRecord());
            return;
        }
    }

    private void getMemberRecordsWithProperies(EssbaseConnection connection, String levelName, QueryParameters parameters, List<MemberRecord> membersFound) {
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        List<EssbaseDimensionCacheItem> cashedDimensions = this.getCachedDimensions(connection, parameters.dimName, parameters.aliasTableNames, DimensionType.REGULAR);
        EssbaseDimensionCacheItem dimension = cashedDimensions.get(0);
        if (!metadataCache.isDimensionPropertiesCached(parameters.dimName)) {
            this.cacheProperties(connection, dimension, parameters.aliasTableNames);
        }
        EssbaseMembersAndProperties mbrsWithProps = new EssbaseMembersAndProperties(connection, this.localizedStringHelper);
        mbrsWithProps.getMemberRecordsWithProperies(levelName, parameters, membersFound);
    }

    public void releaseImpl() {
        if (this.released.compareAndSet(false, true) && null != this.logger && this.logger.isOn()) {
            this.logger.log("Releasing EssbaseMetadataProvider.");
        }
    }

    public List<MemberRecord> getHierarchyCalculatedMembers(IRestrictions restrictions) {
        return Collections.emptyList();
    }

    protected class QueryParameters {
        String dimName = null;
        String memberName = null;
        String memberUniqueName = null;
        int levelNumber = -1;
        EnumSet<TreeOperatorEnum> treeOpSet = EnumSet.noneOf(TreeOperatorEnum.class);
        int from = 0;
        int size = Integer.MAX_VALUE;
        String currentAliasTableName = null;
        Map<String, String> aliasTableNames = null;
        Integer descendantsopt = null;
        Integer descendantsleveldistance = null;

        protected QueryParameters() {
        }
    }

    public static enum DimensionType {
        REGULAR,
        ATTRIBUTE,
        MEASURE,
        ALL;

    }
}

