/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.essbase;

import com.cognos.xqe.data.providers.olap.essbase.EssbaseApiDeltaFactory;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseConnection;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMessageKeys;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataCache;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseMetadataNames;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseRuntimeException;
import com.cognos.xqe.data.providers.olap.essbase.EssbaseWrappers;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.FloatValue;
import com.cognos.xqe.data.values.IntegerValue;
import com.cognos.xqe.data.values.LongValue;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.TimestampValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.essbase.api.base.EssException;
import com.essbase.api.base.IEssIterator;
import com.essbase.api.base.IEssValueAny;
import com.essbase.api.dataquery.IEssMdMember;
import com.essbase.api.metadata.IEssMember;
import com.essbase.api.metadata.IEssMemberSelection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class EssbaseUtil {
    static int debugTriggerIndex = 0;
    public static final String STR_SEL_MBR_INFO = " <OutputType Binary <SelectMbrInfo(MemberName,DimensionName,MemberGeneration,MemberLevel,Consolidation,MemberFormula,MemberAliasName,UDAList,Comment,ParentMemberName,ShareOption,ChildrenCount)";
    public static final String STR_SEL_MBR_FORMULA = "<OutputType Binary <SelectMbrInfo(MemberName,MemberFormula)";
    public static final int MAX_LEVEL_NO = 10;
    private static final int SOCKETEXCEPTERRRSTARTSET1 = 1040999;
    private static final int SOCKETEXCEPTERRRENDSET1 = 1041015;
    private static final int SOCKETEXCEPTERRRSTARTSET2 = 1042001;
    private static final int SOCKETEXCEPTERRRENDSET2 = 1042023;
    private static final int LOGGED_OUT_ERROR = 1051021;
    private static final int WRAPPED_ERROR_1 = 1023040;
    private static final int WRAPPED_ERROR_2 = 1051544;

    private EssbaseUtil() {
    }

    public static String getUDAvalue(String[] listUDAs, String udaName) {
        if (listUDAs != null) {
            for (String uda : listUDAs) {
                int index;
                if (!uda.startsWith(udaName) || (index = uda.indexOf(61)) <= 0) continue;
                return uda.substring(++index);
            }
        }
        return null;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String extractName(String uniqueName) {
        String[] parts = EssbaseMetadataNames.parseUniqueName(uniqueName);
        if (parts != null) {
            return parts[parts.length - 1];
        }
        return null;
    }

    public static String extractParentName(String uniqueName) {
        String[] parts = EssbaseMetadataNames.parseUniqueName(uniqueName);
        if (parts != null && parts.length > 1) {
            return parts[parts.length - 2];
        }
        return null;
    }

    public static String extractDimensionName(String uniqueName) {
        String[] parts = EssbaseMetadataNames.parseUniqueName(uniqueName);
        if (parts != null) {
            return parts[0];
        }
        return null;
    }

    public static Value getPropertyValue(EssbaseConnection connection, String propertyName, IEssValueAny.EEssDataType type, IEssValueAny propertyValue, String aliasTableName) {
        try {
            switch (type.intValue()) {
                case 1: {
                    boolean boolValue = propertyValue.getBoolean();
                    IntegerValue vBool = DataValueFactory.createIntegerValue();
                    vBool.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                    if (boolValue) {
                        vBool.set(1);
                    } else {
                        vBool.set(0);
                    }
                    return vBool;
                }
                case 2: 
                case 3: {
                    int ivalue = propertyValue.getInt();
                    IntegerValue vInt = DataValueFactory.createIntegerValue();
                    vInt.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                    vInt.set(ivalue);
                    return vInt;
                }
                case 4: {
                    long lvalue = propertyValue.getLong();
                    LongValue vLong = DataValueFactory.createLongValue();
                    vLong.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                    vLong.set(lvalue);
                    return vLong;
                }
                case 6: {
                    double dblvalue = propertyValue.getDouble();
                    DoubleValue vDbl = DataValueFactory.createDoubleValue();
                    vDbl.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                    vDbl.set(dblvalue);
                    return vDbl;
                }
                case 5: {
                    float fltvalue = propertyValue.getFloat();
                    FloatValue vFlt = DataValueFactory.createFloatValue();
                    vFlt.setFormatId(FormatId.DEFAULT_NUMBER_FORMAT_FID);
                    vFlt.set(fltvalue);
                    return vFlt;
                }
                case 9: {
                    Date dateValue = EssbaseApiDeltaFactory.getDateValue(propertyName, propertyValue);
                    TimestampValue tsvalue = DataValueFactory.createTimestampValue();
                    tsvalue.set(dateValue);
                    return tsvalue;
                }
            }
            String value = propertyValue.toString();
            String caption = EssbaseUtil.getPropertyCaption(connection, propertyName, value, aliasTableName);
            StringValue vStr = DataValueFactory.createStringValue();
            vStr.set(caption);
            return vStr;
        }
        catch (Throwable e) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_PROPERTY_VALUE_ERROR, e, propertyName);
        }
    }

    public static String getPropertyCaption(EssbaseConnection connection, String propertyName, String propertyValue, String aliasTableName) {
        String propertyCaption;
        if (EssbaseUtil.isEmpty(aliasTableName)) {
            return propertyValue;
        }
        EssbaseMetadataCache metadataCache = connection.getMetadataCache();
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        Map<String, String> propertyCaptions = metadataCache.getPropertyCaptions(propertyName, aliasTableName);
        if (propertyCaptions == null) {
            propertyCaptions = new HashMap<String, String>();
            IEssMemberSelection mbrSel = connection.openMbrSel();
            essbaseAPI.executeQuery(mbrSel, propertyName, 2, propertyName, "", "");
            IEssIterator essMembers = essbaseAPI.getMembers(mbrSel);
            int essMembersCount = essbaseAPI.getCount(essMembers);
            for (int i = 0; i < essMembersCount; ++i) {
                IEssMember essChild = (IEssMember)essbaseAPI.getAt(essMembers, i);
                String caption = essbaseAPI.getAlias(essChild, aliasTableName);
                if (caption == null) continue;
                String memberName = essbaseAPI.getMemberName(essChild);
                propertyCaptions.put(memberName, caption);
            }
            connection.releaseMbrSel(mbrSel);
            metadataCache.addPropertyCaptions(propertyName, aliasTableName, propertyCaptions);
        }
        if ((propertyCaption = propertyCaptions.get(propertyValue)) == null) {
            return propertyValue;
        }
        return propertyCaption;
    }

    public static boolean isLoggedOutError(EssbaseRuntimeException e) {
        EssException essException;
        int essCode;
        Throwable exception = e.getCause();
        return exception != null && exception instanceof EssException && EssbaseUtil.isLoggedOutError(essCode = (essException = (EssException)exception).getNativeCode());
    }

    public static boolean isLoggedOutError(int errorCode) {
        return errorCode == 1051021;
    }

    public static boolean isNetworkError(int errorCode) {
        return errorCode > 1040999 && errorCode < 1041015 || errorCode > 1042001 && errorCode < 1042023 || errorCode == 1023040 || errorCode == 1051544;
    }

    public static MemberTypeEnum getMemberType(EssbaseConnection connection, IEssMdMember essMember, boolean isMeasure) {
        String memberName;
        boolean isFormulaAssigned;
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        MemberTypeEnum result = MemberTypeEnum.UNKNOWN;
        result = essbaseAPI.isCalced(essMember) ? MemberTypeEnum.QUERY_CALCULATION : (isMeasure ? ((isFormulaAssigned = EssbaseUtil.isFormula(connection, memberName = essbaseAPI.getMdMemberName(essMember))) ? MemberTypeEnum.CALCULATED : MemberTypeEnum.REGULAR) : MemberTypeEnum.REGULAR);
        return result;
    }

    public static boolean isFormula(EssbaseConnection connection, String memberName) {
        EssbaseWrappers essbaseAPI = connection.getEssAPI();
        boolean isFormulaAssigned = false;
        StringBuilder buf = new StringBuilder();
        buf.append("@MEMBER(\"").append(memberName).append("\")");
        IEssMemberSelection essMbrSelection = connection.openMbrSel();
        essbaseAPI.executeQuery(essMbrSelection, STR_SEL_MBR_FORMULA, buf.toString());
        IEssIterator essMembers = essbaseAPI.getMembers(essMbrSelection);
        int essMembersCount = essbaseAPI.getCount(essMembers);
        if (essMembersCount < 1) {
            throw new EssbaseRuntimeException(EssbaseMessageKeys.ERR_INVALID_MEMBER_NAME, memberName);
        }
        IEssMember essMbr = (IEssMember)essbaseAPI.getAt(essMembers, 0);
        isFormulaAssigned = essbaseAPI.isFormula(essMbr);
        connection.releaseMbrSel(essMbrSelection);
        return isFormulaAssigned;
    }

    public static void exceptionTrigger() throws EssException {
        boolean stateToThrow = false;
        if (debugTriggerIndex++ == 0) {
            int error = 1051021;
            EssbaseUtil.emulateEssException(1051021);
        }
    }

    public static EssException emulateEssException(int theCode) throws EssException {
        EssException e = new EssException();
        int code = theCode;
        if (code == 0) {
            int someNetworkError = 1042017;
            code = 1042017;
        }
        e.setNativeCode(code);
        e.setNativeMessage("Emulated Essbase exception");
        throw e;
    }
}

