/*
 * Decompiled with CFR 0.152.
 */
package com.simba.googlebigquery.jdbc41.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractAdaptor;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import com.ibm.cognos.jdbc.adaptor.AdaptorMethodOverride;
import com.ibm.cognos.jdbc.adaptor.BaseResultSetAdaptor;
import com.ibm.cognos.jdbc.adaptor.IWrapper;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;

public class BigqueryResultSetAdaptor
extends BaseResultSetAdaptor {
    private static final int MILLISECONDS_PER_HOUR = 3600000;
    private static final int MILLISECONDS_PER_MINUTE = 60000;

    public BigqueryResultSetAdaptor(ResultSet rs, AdaptorFactory factory) {
        super(rs, factory);
    }

    @AdaptorMethodOverride
    public String getExtendedData(int type, int column) throws SQLException {
        switch (type) {
            case -1001: {
                GregorianCalendar cal = new GregorianCalendar();
                Timestamp ts = this.getResultSet().getTimestamp(column, (Calendar)cal);
                if (ts == null) {
                    return null;
                }
                return ts.toString() + this.convertTimeZoneToString(cal);
            }
        }
        return super.getExtendedData(type, column);
    }

    public String convertTimeZoneToString(Calendar value) {
        StringBuilder b = new StringBuilder();
        int hour = value.get(15) / 3600000;
        int minute = Math.abs(value.get(15) % 3600000 / 60000);
        if (hour < 0) {
            hour = -hour;
            b.append("-");
        } else {
            b.append("+");
        }
        DecimalFormat f = new DecimalFormat("00");
        b.append(f.format(hour) + ":" + f.format(minute));
        return b.toString();
    }

    private ResultSet getResultSet() {
        return this.rs;
    }

    public static class Wrapper
    implements IWrapper {
        public AbstractAdaptor wrap(Object toWrap, AdaptorFactory factory) {
            return new BigqueryResultSetAdaptor((ResultSet)toWrap, factory);
        }
    }
}

