/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.config.ConfigException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.data.providers.olap.odbo.MissingMemberModeEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.configuration.ConversionException;

public final class ODBOConfig
implements XQEConfigurationListener {
    private static final String LOAD_ERR_MSG = "Error loading XQEODP configuration: ";
    public static final String COMMA = ",";
    public static final String SPACE = " ";
    private boolean isRegistered = false;
    public static final long POOL_SHUTDOWN_TIMEOUT = 3600L;
    private static final Boolean DEFAULT_DISABLE_PREFETCH_FACTS = null;
    private static final boolean DEFAULT_USE_CACHING = Boolean.TRUE;
    private static final boolean DEFAULT_PREFETCH_MODEL_METADATA = true;
    private static final String DEFAULT_MDX_MISSING_MEMBER_MODE = "";
    private static final String CONFIG_ERROR_PREFIX = "Error converting value of configuration parameter: ";
    private static final String DEFAULT_APPLICATION_NAME = "";
    private static final String DEFAULT_PROVIDER_NAME = null;
    private static final int MIN_CONNECTION_TIMEOUT = 30;
    private static final int MAX_CONNECTION_TIMEOUT = 180;
    private static final int MIN_GENERIC_TIMEOUT = 0;
    private static final int MIN_COMMAND_TIMEOUT = -1;
    private static final int DEFAULT_CONNECTION_TIMEOUT = -1;
    private static final int DEFAULT_GENERIC_TIMEOUT = -1;
    private static final int DEFAULT_COMMAND_TIMEOUT = -1;
    private static final int DEFAULT_MAX_STRING_LENGTH = 1024;
    private static final boolean DEFAULT_RETURN_NULL_CELLS = false;
    private static final String DEFAULT_UNKNOWN_CURRENCY_SYMBOL = "*";
    private static final String STR_TIMESTAMP_WILDCARD = "*\\*";
    private Boolean disablePrefetchFacts = DEFAULT_DISABLE_PREFETCH_FACTS;
    private String mdxMissingMemberMode = "";
    private String configuredProviderName = DEFAULT_PROVIDER_NAME;
    private String applicationName = "";
    private int connectionTimeout = -1;
    private int genericTimeout = -1;
    private int commandTimeout = -1;
    private int defaultMaxStringLength = 1024;
    private boolean returnNULLCells = false;
    private String unknownCurrencySymbol = "*";
    private String providerName;
    private boolean useCaching = DEFAULT_USE_CACHING;
    private boolean prefetchModelMetadata = true;
    private List<String> configListDataTimestamp = null;

    public ODBOConfig(String theProviderName) {
        this.providerName = this.getConfigProviderName(theProviderName);
        if (ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.TRACE)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.TRACE, "Constructing ODBOConfig for " + this.providerName);
        }
    }

    public void configurationChanged(XQEConfigurationEvent e) {
        if (e != null && e.isBeforeUpdate()) {
            return;
        }
        this.reload();
    }

    private String getConfigProviderName(String theProviderName) {
        if (theProviderName.equals("YK")) {
            return "MSAnalysis2005ODP";
        }
        if (theProviderName.equals("M8")) {
            return "MSAnalysis2008ODP";
        }
        if (theProviderName.equals("M12")) {
            return "MSAnalysis2012ODP";
        }
        if (theProviderName.equals("M14")) {
            return "MSAnalysis2014ODP";
        }
        if (theProviderName.equals("M16")) {
            return "MSAnalysis2016ODP";
        }
        if (theProviderName.equals("M17")) {
            return "MSAnalysis2017ODP";
        }
        if (theProviderName.equals("M19")) {
            return "MSAnalysis2019ODP";
        }
        if (theProviderName.equals("MAZ")) {
            return "MSAzureASODP";
        }
        throw new IllegalArgumentException("providerName");
    }

    public void reload() {
        block57: {
            XQEConfiguration config;
            if (ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.TRACE)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.TRACE, "Loading ODBOConfig");
            }
            if ((config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP)) == null) {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.TRACE)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.TRACE, "Constructing new XQEConfiguration instance for XQEODP");
                }
                try {
                    config = XQECCLConfigurationAdapter.createDefaultConfigurationForService((ServiceEnumeration)ServiceEnumeration.XQEODP);
                    XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQEODP, config);
                    config.registerConfigurationListener((XQEConfigurationListener)this);
                    this.isRegistered = true;
                }
                catch (ConfigException ce) {
                    if (XQEMessageKeys.CFG_FileExistError == ce.getMessageKey()) {
                        if (ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.WARN)) {
                            ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.WARN, LOAD_ERR_MSG, (Throwable)ce);
                        }
                    } else if (ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, LOAD_ERR_MSG, (Throwable)ce);
                    }
                    return;
                }
            } else if (!this.isRegistered) {
                config.registerConfigurationListener((XQEConfigurationListener)this);
                this.isRegistered = true;
            }
            XQESubConfiguration configOLEDB = config.getConfigForXQEODPComponent(this.providerName);
            if (configOLEDB != null) {
                block56: {
                    block55: {
                        block54: {
                            block53: {
                                block52: {
                                    block51: {
                                        block50: {
                                            block49: {
                                                block48: {
                                                    block47: {
                                                        block46: {
                                                            block45: {
                                                                configOLEDB.next();
                                                                try {
                                                                    this.useCaching = configOLEDB.getBoolean("useCaching[@value]", Boolean.valueOf(DEFAULT_USE_CACHING));
                                                                }
                                                                catch (ConversionException ce) {
                                                                    if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block45;
                                                                    ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": useCaching : ", (Throwable)ce);
                                                                }
                                                            }
                                                            try {
                                                                this.prefetchModelMetadata = configOLEDB.getBoolean("prefetchModelMetadata[@value]", Boolean.valueOf(true));
                                                            }
                                                            catch (ConversionException ce) {
                                                                if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block46;
                                                                ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": prefetchModelMetadata : ", (Throwable)ce);
                                                            }
                                                        }
                                                        try {
                                                            this.disablePrefetchFacts = configOLEDB.getBoolean("disablePrefetchFacts[@value]", DEFAULT_DISABLE_PREFETCH_FACTS);
                                                        }
                                                        catch (ConversionException ce) {
                                                            if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block47;
                                                            ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": disablePrefetchFacts : ", (Throwable)ce);
                                                        }
                                                    }
                                                    try {
                                                        String tmpMode = configOLEDB.getString("MDXMissingMemberMode[@value]", "");
                                                        this.validateMissingMemberMode(tmpMode);
                                                        this.mdxMissingMemberMode = tmpMode;
                                                    }
                                                    catch (ConversionException ce) {
                                                        if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block48;
                                                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": mdxMissingMemberMode : ", (Throwable)ce);
                                                    }
                                                }
                                                try {
                                                    int tmpTimeout = configOLEDB.getInteger("connectionTimeout[@value]", Integer.valueOf(-1));
                                                    this.validateConnectionTimeout(tmpTimeout);
                                                    this.connectionTimeout = tmpTimeout;
                                                }
                                                catch (ConversionException ce) {
                                                    if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block49;
                                                    ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": connectionTimeout : ", (Throwable)ce);
                                                }
                                            }
                                            try {
                                                int tmpTimeout = configOLEDB.getInteger("genericTimeout[@value]", Integer.valueOf(-1));
                                                this.validateGenericTimeout(tmpTimeout);
                                                this.genericTimeout = tmpTimeout;
                                            }
                                            catch (ConversionException ce) {
                                                if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block50;
                                                ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": genericTimeout : ", (Throwable)ce);
                                            }
                                        }
                                        try {
                                            int tmpTimeout = configOLEDB.getInteger("commandTimeout[@value]", Integer.valueOf(-1));
                                            this.validateCommandTimeout(tmpTimeout);
                                            this.commandTimeout = tmpTimeout;
                                        }
                                        catch (ConversionException ce) {
                                            if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block51;
                                            ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": commandTimeout : ", (Throwable)ce);
                                        }
                                    }
                                    try {
                                        Integer tempStrLength = configOLEDB.getInteger("defaultMaxStringLength[@value]", Integer.valueOf(1024));
                                        if (tempStrLength != -1) {
                                            this.validateDefaultMaxStringLength(tempStrLength);
                                            this.defaultMaxStringLength = tempStrLength;
                                        }
                                    }
                                    catch (ConversionException ce) {
                                        if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block52;
                                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": defaultMaxStringLength : ", (Throwable)ce);
                                    }
                                }
                                try {
                                    this.configuredProviderName = configOLEDB.getString("providerName[@value]", DEFAULT_PROVIDER_NAME);
                                }
                                catch (ConversionException ce) {
                                    if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block53;
                                    ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": providerName : ", (Throwable)ce);
                                }
                            }
                            try {
                                this.applicationName = configOLEDB.getString("applicationName[@value]", "");
                            }
                            catch (ConversionException ce) {
                                if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block54;
                                ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": applicationName : ", (Throwable)ce);
                            }
                        }
                        try {
                            this.returnNULLCells = configOLEDB.getBoolean("returnNULLCells[@value]", Boolean.valueOf(false));
                        }
                        catch (ConversionException ce) {
                            if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block55;
                            ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": returnNULLCells : ", (Throwable)ce);
                        }
                    }
                    try {
                        this.unknownCurrencySymbol = configOLEDB.getString("unknownCurrencySymbol[@value]", DEFAULT_UNKNOWN_CURRENCY_SYMBOL);
                    }
                    catch (ConversionException ce) {
                        if (!ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) break block56;
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": unknownCurrencySymbol : ", (Throwable)ce);
                    }
                }
                try {
                    String[] tmpArray = configOLEDB.getStringArray("dataUpdateForSchema");
                    if (tmpArray != null && tmpArray.length > 0) {
                        this.configListDataTimestamp = new ArrayList<String>(tmpArray.length);
                        for (String tmp : tmpArray) {
                            String trimStr = tmp.trim();
                            if (trimStr.length() <= 0) continue;
                            this.configListDataTimestamp.add(trimStr);
                        }
                        if (this.configListDataTimestamp.size() > 1 && this.configListDataTimestamp.contains(STR_TIMESTAMP_WILDCARD)) {
                            this.configListDataTimestamp.clear();
                            this.configListDataTimestamp.add(STR_TIMESTAMP_WILDCARD);
                        }
                        if (this.configListDataTimestamp.isEmpty()) {
                            this.configListDataTimestamp = null;
                        }
                        break block57;
                    }
                    this.configListDataTimestamp = null;
                }
                catch (ConversionException ce) {
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.ERROR)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.ERROR, CONFIG_ERROR_PREFIX + this.providerName + ": dataUpdateForSchema : ", (Throwable)ce);
                    }
                    break block57;
                }
            }
            if (ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.TRACE)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION).log(LogLevel.TRACE, "Configuration for " + this.providerName + " provider not found");
            }
        }
        this.writeToLog();
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    private void validateDefaultMaxStringLength(int tempStrLength) {
        if (tempStrLength < 1024) {
            throw new ConversionException();
        }
    }

    private void validateGenericTimeout(int tmpTimeout) {
        if (tmpTimeout != -1 && tmpTimeout < 0) {
            throw new ConversionException();
        }
    }

    private void validateConnectionTimeout(int tmpTimeout) {
        if (tmpTimeout != -1 && tmpTimeout < 30 && tmpTimeout > 180) {
            throw new ConversionException();
        }
    }

    private void validateCommandTimeout(int tmpTimeout) {
        if (tmpTimeout < -1) {
            throw new ConversionException();
        }
    }

    private void validateMissingMemberMode(String theMDXMissingMemberMode) {
        try {
            MissingMemberModeEnum.stringToMissingMemberMode(theMDXMissingMemberMode);
        }
        catch (ODBORuntimeException ex) {
            throw new ConversionException();
        }
    }

    public Boolean getDisablePrefetchFacts() {
        return this.disablePrefetchFacts;
    }

    public boolean getUseCaching() {
        return this.useCaching;
    }

    public boolean getPrefetchModelMetadata() {
        return this.prefetchModelMetadata;
    }

    public String getMDXMissingMemberMode() {
        return this.mdxMissingMemberMode;
    }

    public String getConfiguredProviderName() {
        return this.configuredProviderName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getGenericTimeout() {
        return this.genericTimeout;
    }

    public int getCommandTimeout() {
        return this.commandTimeout;
    }

    public int getDefaultMaxStringLength() {
        return this.defaultMaxStringLength;
    }

    public boolean getReturnNULLCells() {
        return this.returnNULLCells;
    }

    public String getUnknownCurrencySymbol() {
        return this.unknownCurrencySymbol;
    }

    public void writeToLog() {
        if (ODBOLog.isOn(ODBOLogEnum.LOG_CONFIGURATION, LogLevel.WARN)) {
            XQELogger logger = ODBOLog.getLogger(ODBOLogEnum.LOG_CONFIGURATION);
            logger.log(LogLevel.WARN, this.providerName + ": useCaching: " + this.useCaching);
            logger.log(LogLevel.WARN, this.providerName + ": prefetchModelMetadata: " + this.prefetchModelMetadata);
            logger.log(LogLevel.WARN, this.providerName + ": disablePrefetchFacts: " + this.disablePrefetchFacts);
            logger.log(LogLevel.WARN, this.providerName + ": mdxMissingMemberMode: " + this.mdxMissingMemberMode);
            logger.log(LogLevel.WARN, this.providerName + ": connectionTimeout: " + this.connectionTimeout);
            logger.log(LogLevel.WARN, this.providerName + ": genericTimeout: " + this.genericTimeout);
            logger.log(LogLevel.WARN, this.providerName + ": commandTimeout: " + this.commandTimeout);
            logger.log(LogLevel.WARN, this.providerName + ": defaultMaxStringLength: " + this.defaultMaxStringLength);
            logger.log(LogLevel.WARN, this.providerName + ": providerName: " + this.configuredProviderName);
            logger.log(LogLevel.WARN, this.providerName + ": applicationName: " + this.applicationName);
            logger.log(LogLevel.WARN, this.providerName + ": returnNULLCells: " + this.returnNULLCells);
            logger.log(LogLevel.WARN, this.providerName + ": unknownCurrencySymbol: " + this.unknownCurrencySymbol);
            String bp = " ODBOConfig: configListDataTimestamp: ";
            if (this.configListDataTimestamp == null) {
                logger.log(LogLevel.WARN, this.providerName + bp);
            } else {
                StringBuilder tmp = new StringBuilder(this.configListDataTimestamp.get(0));
                for (int i = 1; i < this.configListDataTimestamp.size(); ++i) {
                    tmp.append(COMMA);
                    tmp.append(SPACE);
                    tmp.append(this.configListDataTimestamp.get(i));
                }
                logger.log(LogLevel.WARN, this.providerName + bp + tmp);
            }
        }
    }

    public List<String> getCubeDataUpdateList() {
        return this.configListDataTimestamp;
    }
}

