/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.olap.common.MSASCommonActions;
import com.cognos.xqe.data.olap.common.MSASCommonAggregators;
import com.cognos.xqe.data.olap.common.MSASCommonDatatypes;
import com.cognos.xqe.data.olap.common.MSASCommonDimTypes;
import com.cognos.xqe.data.olap.common.MSASCommonHierStructure;
import com.cognos.xqe.data.olap.common.MSASCommonMemberTypes;
import com.cognos.xqe.data.olap.common.MSASCommonTreeOp;
import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.UpperCaseCatalogParameter;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataOperation;
import com.cognos.xqe.data.providers.olap.MetadataRestriction;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.cache.IOLAPMetadataCache;
import com.cognos.xqe.data.providers.olap.cache.OlapMetadataCacheService;
import com.cognos.xqe.data.providers.olap.odbo.ODBOCapabilities;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConfig;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConfigManager;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConnection;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLogEnum;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBOResultSet;
import com.cognos.xqe.data.providers.olap.odbo.ODBORowset;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.types.StringType;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DateTimeValue;
import com.cognos.xqe.data.values.TimestampWithTZValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ActionCoordinateTypeEnum;
import com.cognos.xqe.metadata.ActionTypeEnum;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.MetadataUtil;
import com.cognos.xqe.metadata.PPDSCodeTypeEnum;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.RollupTypeEnum;
import com.cognos.xqe.metadata.TreeOperatorEnum;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.MetadataRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.RankComparator;
import com.cognos.xqe.metadata.record.RecordType;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocalizedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;

public class ODBOMetadataHandler {
    private static final int MDDIMENSIONS_MEMBER_NAME_UNIQUE = 2;
    private static final String MEASURES_STRING = "[Measures]";
    private static final String PROP_DIMENSION_UNIQUE_NAME = "[DIMENSION_UNIQUE_NAME]";
    private static final String PROP_HIERARCHY_UNIQUE_NAME = "[HIERARCHY_UNIQUE_NAME]";
    private static final String PROP_LEVEL_UNIQUE_NAME = "[LEVEL_UNIQUE_NAME]";
    private static final String PROP_LEVEL_NUMBER = "[LEVEL_NUMBER]";
    private static final String PROP_MEMBER_CAPTION = "[MEMBER_CAPTION]";
    private static final String PROP_MEMBER_UNIQUE_NAME = "[MEMBER_UNIQUE_NAME]";
    private static final String PROP_PARENT_LEVEL = "[PARENT_LEVEL]";
    private static final String PROP_PARENT_UNIQUE_NAME = "[PARENT_UNIQUE_NAME]";
    private static final String STARTING_BRACKET = "[";
    private static final String ENDING_BRACKET = "]";
    private static final String STARTING_TUPLE = "(";
    private static final String ENDING_TUPLE = ")";
    private static final String COMMA_SEPARATOR = ",";
    private static final String KEY_SUFFIX = " - Key";
    private static final String MEASURES_LUN_STRING = "[Measures].[MeasuresLevel]";
    private static final String LOGMSG_MDCACHE_HIT = "Metadata cache satisfied query for ";
    private static final String LOGMSG_MDCACHE_MISS = "Metadata cache did not satisfy query for ";
    private static final String LOGMSG_WITH_RESTRICTIONS = " with restrictions ";
    private static final String CATALOG_STR = "catalog";
    private static final String CUBE_STR = "cube";
    private static final String HIERARCHY_STR = "hierarchy";
    private static final String MEASURE_STR = "measure";
    private static final String SELECT_STR = "SELECT";
    private static final String AXIS_STR = " ON AXIS(0)";
    private static final String FROM_STR = " FROM ";
    private static final String DIMENSION_PROPERTIES = " DIMENSION PROPERTIES";
    private static final String DIMENSION_PROPERTIES_NAME = " DIMENSION_UNIQUE_NAME, HIERARCHY_UNIQUE_NAME, PARENT_UNIQUE_NAME, PARENT_LEVEL ";
    private static final String CELL_PROPERTIES = " CELL PROPERTIES VALUE";
    private static final String DATA_UPDATE_WILDKEY_STR = "*\\*";
    private static final String DATA_UPDATE_SLASH_STAR = "\\*";
    private static final String DATA_UPDATE_SLASH = "\\";
    private final AtomicBoolean released = new AtomicBoolean(false);
    protected String providerType;
    protected ConnectionParameters connectionParameters;
    private final Locale runLocale;
    private boolean forceRollupToComputed = false;

    public ODBOMetadataHandler(Locale theRunLocale, String theProviderType, ConnectionParameters theConnectionParams) {
        this.connectionParameters = theConnectionParams;
        this.runLocale = theRunLocale;
        this.providerType = theProviderType;
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Constructing metadata handler for " + this.providerType);
        }
    }

    public void releaseImpl() {
        block3: {
            try {
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Releasing metadata connection.");
                }
                this.released.set(true);
            }
            catch (Exception e) {
                if (!ODBOLog.isOn(LogLevel.ERROR)) break block3;
                ODBOLog.getLogger().log(LogLevel.ERROR, (Throwable)e);
            }
        }
    }

    private boolean canPrefetchModelMetadata() {
        ODBOConfig currConfig = ODBOConfigManager.getConfig(this.providerType);
        return currConfig.getPrefetchModelMetadata();
    }

    private boolean useDataRefreshForSchema(String catalogName, String cubeName) {
        ODBOConfig currConfig = ODBOConfigManager.getConfig(this.providerType);
        boolean bUseDataForSchema = false;
        List<String> dataUpdateList = currConfig.getCubeDataUpdateList();
        if (null != dataUpdateList) {
            String sTempKey = DATA_UPDATE_WILDKEY_STR;
            String sWildCubeKey = "*\\" + cubeName;
            String sCatWildKey = catalogName + DATA_UPDATE_SLASH_STAR;
            String sCatCubeKey = catalogName + DATA_UPDATE_SLASH + cubeName;
            for (String tmpStr : dataUpdateList) {
                if (!tmpStr.equalsIgnoreCase(sTempKey) && !tmpStr.equalsIgnoreCase(sWildCubeKey) && !tmpStr.equalsIgnoreCase(sCatWildKey) && !tmpStr.equalsIgnoreCase(sCatCubeKey)) continue;
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("DataRefreshForSchema matches: " + tmpStr);
                }
                bUseDataForSchema = true;
                break;
            }
        }
        return bUseDataForSchema;
    }

    public CacheParameters getCacheParameters(String catalogName, String cubeName) {
        ConnectionParameters connParams = this.connectionParameters.duplicate();
        connParams.remove(UpperCaseCatalogParameter.class);
        connParams.remove(CatalogParameter.class);
        connParams.remove(CubeParameter.class);
        CacheParameters cacheParams = new CacheParameters();
        cacheParams.put(connParams);
        cacheParams.put("FACTORY_NAME", (Object)"MSASCacheFactory");
        if (null != catalogName) {
            cacheParams.put(CATALOG_STR, (Object)catalogName);
        }
        if (null != cubeName) {
            cacheParams.put(CUBE_STR, (Object)cubeName);
        }
        return cacheParams;
    }

    private <T extends MetadataRecord> List<T> getCachedMetadata(MetadataOperation mdOperation, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        newRestrictions.remove(RestrictionType.CATALOG);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        IOLAPMetadataCache cache = OlapMetadataCacheService.getInstance().getCache(this.getCacheParameters(catalogName, cubeName));
        List answer = cache.getMetadata(mdOperation, newRestrictions);
        if (null != answer) {
            ODBOMetadataHandler.logMetadataCacheHit(mdOperation, newRestrictions);
        } else {
            ODBOMetadataHandler.logMetadataCacheMiss(mdOperation, newRestrictions);
        }
        return answer;
    }

    private <T extends MetadataRecord> void putCachedMetadata(MetadataOperation mdOperation, IRestrictions restrictions, List<T> records) {
        IRestrictions newRestrictions = restrictions.duplicate();
        newRestrictions.remove(RestrictionType.CATALOG);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        IOLAPMetadataCache cache = OlapMetadataCacheService.getInstance().getCache(this.getCacheParameters(catalogName, cubeName));
        cache.putMetadata(mdOperation, newRestrictions, records);
    }

    private boolean canUseCache() {
        ODBOConfig currConfig = ODBOConfigManager.getConfig(this.providerType);
        return Boolean.TRUE.equals(currConfig.getUseCaching());
    }

    protected List<ActionRecord> getActions(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateActionRestrictions(odboConn, restrictions);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        int currentSkipped = 0;
        EnumSet resCoordinateType = (EnumSet)restrictions.getValueOf(RestrictionType.COORDINATE_TYPE);
        ArrayList<ActionRecord> actionRecords = new ArrayList<ActionRecord>();
        if (resCoordinateType.contains(ActionCoordinateTypeEnum.CUBE)) {
            currentSkipped = this.getActionsForCube(odboConn, restrictions, actionRecords, currentSkipped);
        }
        Collection resCoordinates = (Collection)restrictions.getValueOf(RestrictionType.COORDINATE);
        if (resCoordinateType.contains(ActionCoordinateTypeEnum.DIMENSION)) {
            currentSkipped = this.getActionsForDimensions(executionEnvironment, odboConn, restrictions, size, currentSkipped, actionRecords, resCoordinates);
        }
        if (resCoordinateType.contains(ActionCoordinateTypeEnum.LEVEL)) {
            currentSkipped = this.getActionsForLevels(executionEnvironment, odboConn, restrictions, size, currentSkipped, actionRecords, resCoordinates);
        }
        if (resCoordinateType.contains(ActionCoordinateTypeEnum.MEMBER)) {
            currentSkipped = this.getActionsForMembers(odboConn, restrictions, size, currentSkipped, actionRecords, resCoordinates);
        }
        if (resCoordinateType.contains(ActionCoordinateTypeEnum.CELL)) {
            this.getActionsForCells(odboConn, restrictions, size, currentSkipped, actionRecords, resCoordinates);
        }
        return actionRecords;
    }

    private void validateActionRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        Collection coords = (Collection)restrictions.getValueOf(RestrictionType.COORDINATE);
        EnumSet coordTypes = (EnumSet)restrictions.getValueOf(RestrictionType.COORDINATE_TYPE);
        Collection resDimensionLine = (Collection)restrictions.getValueOf(RestrictionType.DIMENSION_LINE);
        if (!restrictions.contains(RestrictionType.CUBE)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        this.validateCatalogNames(odboConn, restrictions);
        if (null == coordTypes || coordTypes.isEmpty()) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.COORDINATE_TYPE);
        } else {
            if ((coordTypes.contains(ActionCoordinateTypeEnum.DIMENSION) || coordTypes.contains(ActionCoordinateTypeEnum.LEVEL) || coordTypes.contains(ActionCoordinateTypeEnum.MEMBER)) && (null == coords || coords.isEmpty())) {
                ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.COORDINATE);
            }
            if (coordTypes.contains(ActionCoordinateTypeEnum.CELL) && (null == coords || coords.isEmpty()) && (null == resDimensionLine || resDimensionLine.isEmpty())) {
                ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.COORDINATE);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getActionsForCells(ODBOConnection odboConn, IRestrictions restrictions, int size, int currentSkipped, List<ActionRecord> actionRecords, Collection<String> resCoordinates) {
        if (0 == size || size != 0 && actionRecords.size() < size) {
            Collection resDimensionLine = (Collection)restrictions.getValueOf(RestrictionType.DIMENSION_LINE);
            ODBOConnection.CRestrictionArray cRestrictions = this.getActionRestrictions(odboConn, restrictions);
            StringBuilder sTuple = new StringBuilder();
            sTuple.append(STARTING_TUPLE);
            boolean bAdded = false;
            if (null != resCoordinates) {
                for (String sTemp : resCoordinates) {
                    if (null == sTemp) continue;
                    if (bAdded) {
                        sTuple.append(COMMA_SEPARATOR);
                    } else {
                        bAdded = true;
                    }
                    sTuple.append(sTemp);
                }
            }
            if (null != resDimensionLine) {
                for (String sTemp : resDimensionLine) {
                    if (null == sTemp) continue;
                    if (bAdded) {
                        sTuple.append(COMMA_SEPARATOR);
                    } else {
                        bAdded = true;
                    }
                    sTuple.append(sTemp);
                }
            }
            sTuple.append(ENDING_TUPLE);
            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Getting Actions for CELL:" + sTuple.toString());
            }
            cRestrictions.set(ActionRestrictions.COORDINATE.ordinal(), sTuple.toString());
            int code = MSASCommonActions.convertActionCoordinateTypeEnumSetToInt(EnumSet.of(ActionCoordinateTypeEnum.CELL));
            cRestrictions.set(ActionRestrictions.COORDINATE_TYPE.ordinal(), code);
            try {
                currentSkipped = this.getActionsInternal(odboConn, actionRecords, restrictions, cRestrictions, currentSkipped, "");
            }
            finally {
                cRestrictions.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActionsForMembers(ODBOConnection odboConn, IRestrictions restrictions, int size, int currentSkipped, List<ActionRecord> actionRecords, Collection<String> resCoordinates) {
        if (0 == size || size != 0 && actionRecords.size() < size) {
            ODBOConnection.CRestrictionArray cRestrictions = this.getActionRestrictions(odboConn, restrictions);
            try {
                for (String sTemp : resCoordinates) {
                    if (null != sTemp) {
                        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Getting Actions for MEMBER:" + sTemp);
                        }
                        cRestrictions.set(ActionRestrictions.COORDINATE.ordinal(), sTemp);
                    }
                    int code = MSASCommonActions.convertActionCoordinateTypeEnumSetToInt(EnumSet.of(ActionCoordinateTypeEnum.MEMBER));
                    cRestrictions.set(ActionRestrictions.COORDINATE_TYPE.ordinal(), code);
                    currentSkipped = this.getActionsInternal(odboConn, actionRecords, restrictions, cRestrictions, currentSkipped, sTemp);
                }
            }
            finally {
                cRestrictions.release();
            }
        }
        return currentSkipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActionsForLevels(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions, int size, int currentSkipped, List<ActionRecord> actionRecords, Collection<String> resCoordinates) {
        if (0 == size || size != 0 && actionRecords.size() < size) {
            ODBOConnection.CRestrictionArray cRestrictions = this.getActionRestrictions(odboConn, restrictions);
            ODBOCapabilities capabilities = odboConn.getCapabilities();
            try {
                for (String sTemp : resCoordinates) {
                    if (null != sTemp) {
                        if (capabilities.canUseMUNsForActionRestrictions()) {
                            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Getting Level Actions for MUN:" + sTemp);
                            }
                            cRestrictions.set(ActionRestrictions.COORDINATE.ordinal(), sTemp);
                        } else {
                            MetadataRestriction newRestrictions = new MetadataRestriction();
                            newRestrictions.add(RestrictionType.CATALOG, restrictions.getValueOf(RestrictionType.CATALOG));
                            newRestrictions.add(RestrictionType.CUBE, restrictions.getValueOf(RestrictionType.CUBE));
                            newRestrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, (Object)sTemp);
                            MemberRecord memberRec = this.getMemberRecord(executionEnvironment, odboConn, (IRestrictions)newRestrictions, sTemp);
                            if (null != memberRec) {
                                String levelUniqueName = memberRec.getLevelUniqueName();
                                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Getting Level Actions for LUN:" + levelUniqueName);
                                }
                                cRestrictions.set(ActionRestrictions.COORDINATE.ordinal(), levelUniqueName);
                            } else {
                                throw new ODBORuntimeException(ODBOMessageKeys.MET_CANNOT_FIND_MEMBER, sTemp);
                            }
                        }
                    }
                    int code = MSASCommonActions.convertActionCoordinateTypeEnumSetToInt(EnumSet.of(ActionCoordinateTypeEnum.LEVEL));
                    cRestrictions.set(ActionRestrictions.COORDINATE_TYPE.ordinal(), code);
                    currentSkipped = this.getActionsInternal(odboConn, actionRecords, restrictions, cRestrictions, currentSkipped, sTemp);
                }
            }
            finally {
                cRestrictions.release();
            }
        }
        return currentSkipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActionsForDimensions(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions, int size, int currentSkipped, List<ActionRecord> actionRecords, Collection<String> resCoordinates) {
        if (0 == size || size != 0 && actionRecords.size() < size) {
            ODBOConnection.CRestrictionArray cRestrictions = this.getActionRestrictions(odboConn, restrictions);
            ODBOCapabilities capabilities = odboConn.getCapabilities();
            try {
                for (String sTemp : resCoordinates) {
                    if (null != sTemp) {
                        if (capabilities.canUseMUNsForActionRestrictions()) {
                            if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Getting Dimension Actions for MUN:" + sTemp);
                            }
                            cRestrictions.set(ActionRestrictions.COORDINATE.ordinal(), sTemp);
                        } else {
                            MetadataRestriction newRestrictions = new MetadataRestriction();
                            newRestrictions.add(RestrictionType.CATALOG, restrictions.getValueOf(RestrictionType.CATALOG));
                            newRestrictions.add(RestrictionType.CUBE, restrictions.getValueOf(RestrictionType.CUBE));
                            newRestrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, (Object)sTemp);
                            MemberRecord memberRec = this.getMemberRecord(executionEnvironment, odboConn, (IRestrictions)newRestrictions, sTemp);
                            if (null != memberRec) {
                                String hierarchyUniqueName = memberRec.getHierarchyUniqueName();
                                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Getting Dimension Actions for HUN:" + hierarchyUniqueName);
                                }
                                cRestrictions.set(ActionRestrictions.COORDINATE.ordinal(), hierarchyUniqueName);
                            } else {
                                throw new ODBORuntimeException(ODBOMessageKeys.MET_CANNOT_FIND_MEMBER, sTemp);
                            }
                        }
                    }
                    int code = MSASCommonActions.convertActionCoordinateTypeEnumSetToInt(EnumSet.of(ActionCoordinateTypeEnum.DIMENSION));
                    cRestrictions.set(ActionRestrictions.COORDINATE_TYPE.ordinal(), code);
                    currentSkipped = this.getActionsInternal(odboConn, actionRecords, restrictions, cRestrictions, currentSkipped, sTemp);
                }
            }
            finally {
                cRestrictions.release();
            }
        }
        return currentSkipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getActionsForCube(ODBOConnection odboConn, IRestrictions restrictions, List<ActionRecord> actionRecords, int numberSkipped) {
        ODBOConnection.CRestrictionArray cRestrictions = this.getActionRestrictions(odboConn, restrictions);
        cRestrictions.set(ActionRestrictions.COORDINATE.ordinal(), (String)restrictions.getValueOf(RestrictionType.CUBE));
        int code = MSASCommonActions.convertActionCoordinateTypeEnumSetToInt(EnumSet.of(ActionCoordinateTypeEnum.CUBE));
        cRestrictions.set(ActionRestrictions.COORDINATE_TYPE.ordinal(), code);
        int currentSkipped = numberSkipped;
        try {
            currentSkipped = this.getActionsInternal(odboConn, actionRecords, restrictions, cRestrictions, numberSkipped, (String)restrictions.getValueOf(RestrictionType.CUBE));
        }
        finally {
            cRestrictions.release();
        }
        return currentSkipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getActionsInternal(ODBOConnection odboConn, List<ActionRecord> actionRecords, IRestrictions restrictions, ODBOConnection.CRestrictionArray cRestrictions, int numberSkipped, String originalCoordinate) {
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("MDSCHEMA_ACTIONS", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, "action", ex);
        }
        int posSchema = -1;
        int posCube = -1;
        int posActionName = -1;
        int posActionType = -1;
        int posCoordinateType = -1;
        int posCaption = -1;
        int posDescription = -1;
        int posContent = -1;
        try (ODBORowset rows = new ODBORowset(odboConn, rowsetHandle);){
            int columnCount = rows.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = rows.getColumnName(i);
                if (columnNames[i].equals("SCHEMA_NAME")) {
                    posSchema = i;
                    continue;
                }
                if (columnNames[i].equals("CUBE_NAME")) {
                    posCube = i;
                    continue;
                }
                if (columnNames[i].equals("ACTION_NAME")) {
                    posActionName = i;
                    continue;
                }
                if (columnNames[i].equals("ACTION_TYPE")) {
                    posActionType = i;
                    continue;
                }
                if (columnNames[i].equals("COORDINATE_TYPE")) {
                    posCoordinateType = i;
                    continue;
                }
                if (columnNames[i].equals("ACTION_CAPTION")) {
                    posCaption = i;
                    continue;
                }
                if (columnNames[i].equals("DESCRIPTION")) {
                    posDescription = i;
                    continue;
                }
                if (!columnNames[i].equals("CONTENT")) continue;
                posContent = i;
            }
            while (rows.getNextRow()) {
                String value;
                boolean addAction = false;
                if (posActionType == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "ACTION_TYPE");
                Long longValue = rows.getLongColumn(posActionType);
                if (longValue == null) throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "ACTION_TYPE");
                ActionTypeEnum actionType = MSASCommonActions.convertIntToActionTypeEnum((int)longValue.intValue());
                if (actionType == ActionTypeEnum.HTML || actionType == ActionTypeEnum.URL) {
                    addAction = true;
                }
                if (!addAction) continue;
                ActionRecord action = new ActionRecord();
                action.setCommandType(actionType);
                if (from != 0 && numberSkipped != from) {
                    ++numberSkipped;
                    continue;
                }
                if (size != 0 && actionRecords.size() >= size) {
                    return numberSkipped;
                }
                action.setCatalogName(this.getCatalogNameFromConnection(odboConn));
                if (posSchema != -1 && (value = rows.getStringColumn(posSchema, false)) != null) {
                    action.setSchemaName(value);
                }
                if (posCube == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "CUBE_NAME");
                value = rows.getStringColumn(posCube, true);
                if (value == null) {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CUBE_NAME");
                }
                action.setCubeName(value);
                if (posActionName == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "ACTION_NAME");
                value = rows.getStringColumn(posActionName, true);
                if (value == null) {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "ACTION_NAME");
                }
                action.setName(value);
                action.setUniqueName(value);
                if (posCaption == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "ACTION_CAPTION");
                value = rows.getStringColumn(posCaption, true);
                if (value == null) {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "ACTION_CAPTION");
                }
                LocalizedString localizedCaption = this.getLocalizedString(value);
                action.setCaption((ILocalizedString)localizedCaption);
                if (posContent == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "CONTENT");
                value = rows.getStringColumn(posContent, true);
                if (value == null) {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CONTENT");
                }
                action.setCommand(value);
                if (posCoordinateType == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "COORDINATE_TYPE");
                longValue = rows.getLongColumn(posCoordinateType);
                if (longValue == null) {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "COORDINATE_TYPE");
                }
                action.setCoordinateType(MSASCommonActions.convertIntToActionCoordinateTypeEnumSet((int)longValue.intValue()));
                action.setCoordinateValue(originalCoordinate);
                if (posDescription != -1) {
                    value = rows.getStringColumn(posDescription, false);
                    action.setDescription(value);
                }
                actionRecords.add(action);
            }
            return numberSkipped;
        }
    }

    protected ODBOConnection.CRestrictionArray getActionRestrictions(ODBOConnection connection, IRestrictions restrictions) {
        ODBOConnection oDBOConnection = connection;
        ((Object)((Object)oDBOConnection)).getClass();
        ODBOConnection.CRestrictionArray cRestrictions = oDBOConnection.new ODBOConnection.CRestrictionArray(ActionRestrictions.values().length);
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String resCubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        cRestrictions.set(ActionRestrictions.CATALOG.ordinal(), resCatalogName);
        cRestrictions.setEmpty(ActionRestrictions.SCHEMA.ordinal());
        cRestrictions.set(ActionRestrictions.CUBE.ordinal(), resCubeName);
        cRestrictions.setEmpty(ActionRestrictions.ACTION_NAME.ordinal());
        cRestrictions.setEmpty(ActionRestrictions.ACTION_TYPE.ordinal());
        return cRestrictions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CatalogRecord> getCatalogs(ODBOConnection odboConn, IRestrictions restrictions) {
        ArrayList<CatalogRecord> catalogRecords = new ArrayList<CatalogRecord>();
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        ODBOConnection.CRestrictionArray cRestrictions = this.getCatalogRestrictions(odboConn, restrictions);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("DBSCHEMA_CATALOGS", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, CATALOG_STR, ex);
        }
        finally {
            cRestrictions.release();
        }
        int posName = -1;
        int posDescription = -1;
        try (ODBORowset rows = new ODBORowset(odboConn, rowsetHandle);){
            int columnCount = rows.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = rows.getColumnName(i);
                if (columnNames[i].equals("CATALOG_NAME")) {
                    posName = i;
                    continue;
                }
                if (!columnNames[i].equals("DESCRIPTION")) continue;
                posDescription = i;
            }
            int numberSkipped = 0;
            while (rows.getNextRow()) {
                String value;
                if (from != 0 && numberSkipped != from) {
                    ++numberSkipped;
                    continue;
                }
                if (size != 0 && catalogRecords.size() >= size) {
                    break;
                }
                CatalogRecord catalog = new CatalogRecord();
                if (posName != -1) {
                    value = rows.getStringColumn(posName, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CATALOG_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "CATALOG_NAME");
                }
                catalog.setName(value);
                catalog.setUniqueName(value);
                catalog.setUniqueId(RecordType.CATALOG, value);
                LocalizedString localizedCaption = this.getLocalizedString(value);
                catalog.setCaption((ILocalizedString)localizedCaption);
                if (posDescription != -1) {
                    value = rows.getStringColumn(posDescription, false);
                    catalog.setDescription(value);
                }
                catalogRecords.add(catalog);
            }
        }
        return catalogRecords;
    }

    protected ODBOConnection.CRestrictionArray getCatalogRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOConnection oDBOConnection = odboConn;
        ((Object)((Object)oDBOConnection)).getClass();
        ODBOConnection.CRestrictionArray cRestrictions = oDBOConnection.new ODBOConnection.CRestrictionArray(CatalogRestrictions.values().length);
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        if (null != resCatalogName) {
            cRestrictions.set(CatalogRestrictions.CATALOG.ordinal(), resCatalogName);
        } else {
            cRestrictions.setEmpty(CatalogRestrictions.CATALOG.ordinal());
        }
        return cRestrictions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<CubeRecord> getCubes(ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateCubeRestrictions(odboConn, restrictions);
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Getting Cubes with ODBOConnection params:" + odboConn.getConnectionParameters().toString());
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Getting Cubes with connection params:" + this.connectionParameters.toString());
        }
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        ArrayList<CubeRecord> cubeRecords = new ArrayList<CubeRecord>();
        ODBOConnection.CRestrictionArray cRestrictions = this.getCubeRestrictions(odboConn, restrictions);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("MDSCHEMA_CUBES", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, CUBE_STR, ex);
        }
        finally {
            cRestrictions.release();
        }
        int posName = -1;
        int posCaption = -1;
        int posDescription = -1;
        int posCreatedDate = -1;
        int posLastSchemaUpdate = -1;
        int posLastDataUpdate = -1;
        try (ODBORowset rows = new ODBORowset(odboConn, rowsetHandle);){
            int columnCount = rows.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = rows.getColumnName(i);
                if (columnNames[i].equals("CUBE_NAME")) {
                    posName = i;
                    continue;
                }
                if (columnNames[i].equals("CUBE_CAPTION")) {
                    posCaption = i;
                    continue;
                }
                if (columnNames[i].equals("DESCRIPTION")) {
                    posDescription = i;
                    continue;
                }
                if (columnNames[i].equals("CREATED_ON")) {
                    posCreatedDate = i;
                    continue;
                }
                if (columnNames[i].equals("LAST_SCHEMA_UPDATE")) {
                    posLastSchemaUpdate = i;
                    continue;
                }
                if (!columnNames[i].equals("LAST_DATA_UPDATE")) continue;
                posLastDataUpdate = i;
            }
            int numberSkipped = 0;
            while (rows.getNextRow()) {
                TimestampWithTZValue tsvalue;
                int status;
                LocalizedString localizedCaption;
                if (from != 0 && numberSkipped != from) {
                    ++numberSkipped;
                    continue;
                }
                if (size != 0 && cubeRecords.size() >= size) {
                    return cubeRecords;
                }
                CubeRecord cube = new CubeRecord();
                cube.setCatalogName(this.getCatalogNameFromConnection(odboConn));
                if (posName == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "CUBE_NAME");
                String value = rows.getStringColumn(posName, true);
                if (value == null) throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CUBE_NAME");
                cube.setName(value);
                cube.setUniqueName(value);
                if (cube.getCaption() == null || cube.getCaption().length() == 0) {
                    localizedCaption = this.getLocalizedString(value);
                    cube.setCaption((ILocalizedString)localizedCaption);
                }
                cube.setUniqueId(RecordType.CUBE, cube.getUniqueName());
                if (posCaption != -1 && (value = rows.getStringColumn(posName, true)) != null) {
                    localizedCaption = this.getLocalizedString(value);
                    cube.setCaption((ILocalizedString)localizedCaption);
                }
                if (posDescription != -1) {
                    value = rows.getStringColumn(posDescription, false);
                    cube.setDescription(value);
                }
                boolean bUseDataRefreshForSchema = this.useDataRefreshForSchema(cube.getCatalogName(), cube.getName());
                if (posLastSchemaUpdate == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "LAST_SCHEMA_UPDATE");
                if (!bUseDataRefreshForSchema) {
                    status = rows.getColumnStatus(posLastSchemaUpdate);
                    if (3 == status) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "LAST_SCHEMA_UPDATE");
                    tsvalue = DataValueFactory.createTimestampWithTZValue();
                    value = rows.getStringColumnWithStatus(posLastSchemaUpdate, true, status);
                    tsvalue.set(rows.convertStringToTimestampWithTZ(value, false).toString());
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("LastSchemaUpdate:" + tsvalue.toString());
                    }
                    cube.setSchemaUpdateDate((DateTimeValue)tsvalue);
                }
                if (posLastDataUpdate == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "LAST_DATA_UPDATE");
                status = rows.getColumnStatus(posLastDataUpdate);
                if (3 != status) {
                    tsvalue = DataValueFactory.createTimestampWithTZValue();
                    value = rows.getStringColumnWithStatus(posLastDataUpdate, true, status);
                    tsvalue.set(rows.convertStringToTimestampWithTZ(value, false).toString());
                    if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("LastDataUpdate:" + tsvalue.toString());
                    }
                    cube.setDataUpdateDate((DateTimeValue)tsvalue);
                    if (bUseDataRefreshForSchema) {
                        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("LastSchemaUpdate from Data timestamp:" + tsvalue.toString());
                        }
                        cube.setSchemaUpdateDate((DateTimeValue)tsvalue);
                    }
                }
                if (posCreatedDate != -1 && ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Created Date is not supported by MS Analysis Services.");
                }
                cube.setSuppressionType(ICube.CubeSuppressionTypeEnum.NULL);
                cubeRecords.add(cube);
            }
            return cubeRecords;
        }
    }

    private String getCubeDefaultMeasureInternal(ODBOConnection odboConn, String catalogName, String cubeName) {
        MeasureRecord measureRec;
        String defMUN;
        MetadataRestriction newRestrictions = new MetadataRestriction();
        newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        newRestrictions.add(RestrictionType.CUBE, (Object)cubeName);
        DimensionRecord measureDim = this.getMeasureDimension(odboConn, (IRestrictions)newRestrictions);
        HierarchyRecord measureHier = this.getHierarchyRecord(odboConn, (IRestrictions)newRestrictions, measureDim.getDefaultHierarchyUniqueName());
        if (measureHier != null && (defMUN = measureHier.getDefaultMemberUniqueName()) != null && defMUN.length() > 0 && (measureRec = this.getMeasureRecord(odboConn, (IRestrictions)newRestrictions, measureHier.getDefaultMemberUniqueName())) != null) {
            return measureRec.getUniqueName();
        }
        return "";
    }

    private void validateCubeRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    private void validateCatalogNames(ODBOConnection odboConn, IRestrictions restrictions) {
        String catalogRes;
        String connCatalog = this.getCatalogNameFromConnection(odboConn);
        if (!connCatalog.equals(catalogRes = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class)) && !connCatalog.equals(catalogRes = catalogRes.toUpperCase(this.runLocale))) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_CATALOG_NAME_MISMATCH, catalogRes, connCatalog);
        }
    }

    private String getCatalogNameFromConnection(ODBOConnection odboConn) {
        String connCatalog = odboConn.getCapabilities().canSupportCaseInsensitiveCatalog() ? (String)((UpperCaseCatalogParameter)odboConn.getConnectionParameters().get(UpperCaseCatalogParameter.class)).value() : (String)((CatalogParameter)odboConn.getConnectionParameters().get(CatalogParameter.class)).value();
        return connCatalog;
    }

    private LocalizedString getLocalizedString(String value) {
        return new LocalizedString(this.runLocale, value);
    }

    private DimensionRecord getMeasureDimension(ODBOConnection odboConn, IRestrictions restrictions) {
        DimensionRecord measureDimRec = null;
        List<DimensionRecord> dimRecords = this.getDimensions(odboConn, restrictions);
        for (DimensionRecord dimRec : dimRecords) {
            if (DimensionTypeEnum.MEASURE != dimRec.getType()) continue;
            measureDimRec = dimRec;
            break;
        }
        return measureDimRec;
    }

    protected ODBOConnection.CRestrictionArray getCubeRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOConnection oDBOConnection = odboConn;
        ((Object)((Object)oDBOConnection)).getClass();
        ODBOConnection.CRestrictionArray cRestrictions = oDBOConnection.new ODBOConnection.CRestrictionArray(CubeRestrictions.values().length);
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String resCubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        cRestrictions.set(CubeRestrictions.CATALOG.ordinal(), resCatalogName);
        cRestrictions.setEmpty(CubeRestrictions.SCHEMA.ordinal());
        if (null != resCubeName) {
            cRestrictions.set(CubeRestrictions.CUBE.ordinal(), resCubeName);
        } else {
            cRestrictions.setEmpty(CubeRestrictions.CUBE.ordinal());
        }
        return cRestrictions;
    }

    protected List<DimensionRecord> getDimensions(ODBOConnection odboConn, IRestrictions restrictions) {
        List<DimensionRecord> answer;
        boolean useCache = this.canUseCache();
        IRestrictions newRestrictions = restrictions.duplicate();
        newRestrictions.remove(RestrictionType.HIERARCHY_UNIQUE_NAME);
        this.validateDimensionRestrictions(odboConn, restrictions);
        if (useCache && null != (answer = this.getCachedMetadata(MetadataOperation.DIMENSIONS, newRestrictions))) {
            ODBOMetadataHandler.logMetadataCacheHit(MetadataOperation.DIMENSIONS, newRestrictions);
            return answer;
        }
        answer = this.getDimensionsFromProvider(odboConn, newRestrictions);
        Collections.sort(answer, new RankComparator());
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        if (from != 0) {
            int toIndex = answer.size();
            if (size != 0) {
                toIndex = Math.min(from + size, answer.size());
            }
            answer = answer.subList(from, toIndex);
        }
        if (useCache) {
            this.putCachedMetadata(MetadataOperation.DIMENSIONS, newRestrictions, answer);
        }
        return answer;
    }

    private void validateDimensionRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    protected ODBOConnection.CRestrictionArray getHierarchyRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOConnection oDBOConnection = odboConn;
        ((Object)((Object)oDBOConnection)).getClass();
        ODBOConnection.CRestrictionArray cRestrictions = oDBOConnection.new ODBOConnection.CRestrictionArray(HierarchyRestrictions.values().length);
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String resCubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String resDUN = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String resHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        cRestrictions.set(HierarchyRestrictions.CATALOG.ordinal(), resCatalogName);
        cRestrictions.setEmpty(HierarchyRestrictions.SCHEMA.ordinal());
        cRestrictions.set(HierarchyRestrictions.CUBE.ordinal(), resCubeName);
        if (resDUN != null) {
            cRestrictions.set(HierarchyRestrictions.DIMENSION_UNIQUE_NAME.ordinal(), resDUN);
        } else {
            cRestrictions.setEmpty(HierarchyRestrictions.DIMENSION_UNIQUE_NAME.ordinal());
        }
        if (resHUN != null) {
            cRestrictions.set(HierarchyRestrictions.HIERARCHY_UNIQUE_NAME.ordinal(), resHUN);
        }
        return cRestrictions;
    }

    private DimensionRecord getDimensionRecord(ODBOConnection odboConn, IRestrictions restrictions, String dimensionUniqueName) {
        List<Object> records;
        boolean useCache = this.canUseCache();
        IRestrictions newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.CUBE});
        newRestrictions.add(RestrictionType.DIMENSION_UNIQUE_NAME, (Object)dimensionUniqueName);
        DimensionRecord dimRec = null;
        if (useCache && null != (records = this.getCachedMetadata(MetadataOperation.DIMENSIONS, newRestrictions)) && !records.isEmpty()) {
            dimRec = (DimensionRecord)records.get(0);
        }
        if (null == dimRec) {
            records = this.getDimensionsFromProvider(odboConn, newRestrictions);
            if (!records.isEmpty()) {
                dimRec = (DimensionRecord)records.get(0);
            }
            if (useCache) {
                this.putCachedMetadata(MetadataOperation.DIMENSIONS, newRestrictions, records);
            }
        }
        return dimRec;
    }

    private HierarchyRecord getHierarchyRecord(ODBOConnection odboConn, IRestrictions restrictions, String hierarchyUniqueName) {
        IRestrictions newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.CUBE});
        newRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierarchyUniqueName);
        List<HierarchyRecord> hiers = this.getHierarchies(odboConn, newRestrictions);
        if (!hiers.isEmpty()) {
            return hiers.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DimensionRecord> getDimensionsFromProvider(ODBOConnection odboConn, IRestrictions restrictions) {
        ArrayList<DimensionRecord> dimensionRecords = new ArrayList<DimensionRecord>();
        ODBOConnection.CRestrictionArray cRestrictions = this.getDimensionRestrictions(odboConn, restrictions);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("MDSCHEMA_DIMENSIONS", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, "dimension", ex);
        }
        finally {
            cRestrictions.release();
        }
        int posName = -1;
        int posCubeName = -1;
        int posCaption = -1;
        int posUniqueName = -1;
        int posDescription = -1;
        int posDefaultHierarchy = -1;
        int posCardinality = -1;
        int posOrdinal = -1;
        int posType = -1;
        try (ODBORowset rows = new ODBORowset(odboConn, rowsetHandle);){
            int columnCount = rows.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = rows.getColumnName(i);
                if (columnNames[i].equals("DIMENSION_NAME")) {
                    posName = i;
                    continue;
                }
                if (columnNames[i].equals("CUBE_NAME")) {
                    posCubeName = i;
                    continue;
                }
                if (columnNames[i].equals("DIMENSION_CAPTION")) {
                    posCaption = i;
                    continue;
                }
                if (columnNames[i].equals("DIMENSION_UNIQUE_NAME")) {
                    posUniqueName = i;
                    continue;
                }
                if (columnNames[i].equals("DEFAULT_HIERARCHY")) {
                    posDefaultHierarchy = i;
                    continue;
                }
                if (columnNames[i].equals("DESCRIPTION")) {
                    posDescription = i;
                    continue;
                }
                if (columnNames[i].equals("DIMENSION_CARDINALITY")) {
                    posCardinality = i;
                    continue;
                }
                if (columnNames[i].equals("DIMENSION_ORDINAL")) {
                    posOrdinal = i;
                    continue;
                }
                if (!columnNames[i].equals("DIMENSION_TYPE")) continue;
                posType = i;
            }
            while (rows.getNextRow()) {
                int dimType;
                String value;
                DimensionRecord dimension = new DimensionRecord();
                dimension.setCatalogName(this.getCatalogNameFromConnection(odboConn));
                if (posCubeName != -1) {
                    value = rows.getStringColumn(posCubeName, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CUBE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "CUBE_NAME");
                }
                dimension.setCubeName(value);
                if (posName != -1) {
                    value = rows.getStringColumn(posName, false);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DIMENSION_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DIMENSION_NAME");
                }
                dimension.setName(value);
                if (posCaption != -1) {
                    value = rows.getStringColumn(posCaption, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DIMENSION_CAPTION");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DIMENSION_CAPTION");
                }
                LocalizedString localizedCaption = this.getLocalizedString(value);
                dimension.setCaption((ILocalizedString)localizedCaption);
                if (posUniqueName != -1) {
                    value = rows.getStringColumn(posUniqueName, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DIMENSION_UNIQUE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DIMENSION_UNIQUE_NAME");
                }
                dimension.setUniqueName(value);
                if (posDescription != -1) {
                    value = rows.getStringColumn(posDescription, false);
                    dimension.setDescription(value);
                }
                if (posDefaultHierarchy != -1) {
                    value = rows.getStringColumn(posDefaultHierarchy, true);
                    dimension.setDefaultHierarchyUniqueName(value);
                }
                if (posCardinality != -1) {
                    value = rows.getStringColumn(posCardinality, true);
                    dimension.setCardinality(Integer.parseInt(value));
                }
                if (posOrdinal != -1) {
                    value = rows.getStringColumn(posOrdinal, true);
                    dimension.setRank(Integer.parseInt(value));
                }
                if (posType != -1) {
                    dimType = rows.getLongColumn(posType).intValue();
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DIMENSION_TYPE");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DIMENSION_TYPE");
                }
                dimension.setType(MSASCommonDimTypes.convertOLEDBDimensionTypeToEnum((int)dimType));
                if (dimension.getType() == DimensionTypeEnum.ACCOUNT || dimension.getType() == DimensionTypeEnum.SCENARIO) {
                    dimension.setMembersRollup(false);
                }
                dimension.setDimensionGroupName("");
                dimension.setDimensionGroupDescription("");
                dimension.setUniqueId(RecordType.DIMENSION, dimension.getUniqueName());
                if (dimension.getType() == DimensionTypeEnum.MEASURE) {
                    dimension.setRank(Integer.MAX_VALUE);
                }
                dimensionRecords.add(dimension);
            }
        }
        return dimensionRecords;
    }

    protected ODBOConnection.CRestrictionArray getDimensionRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOConnection oDBOConnection = odboConn;
        ((Object)((Object)oDBOConnection)).getClass();
        ODBOConnection.CRestrictionArray cRestrictions = oDBOConnection.new ODBOConnection.CRestrictionArray(DimensionRestrictions.values().length);
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String resCubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String resDUN = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        cRestrictions.set(DimensionRestrictions.CATALOG.ordinal(), resCatalogName);
        cRestrictions.setEmpty(DimensionRestrictions.SCHEMA.ordinal());
        cRestrictions.set(DimensionRestrictions.CUBE.ordinal(), resCubeName);
        cRestrictions.setEmpty(DimensionRestrictions.DIMENSION_NAME.ordinal());
        if (null != resDUN) {
            cRestrictions.set(DimensionRestrictions.DIMENSION_UNIQUE_NAME.ordinal(), resDUN);
        } else {
            cRestrictions.setEmpty(DimensionRestrictions.DIMENSION_UNIQUE_NAME.ordinal());
        }
        return cRestrictions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<HierarchyRecord> getHierarchies(ODBOConnection odboConn, IRestrictions restrictions) {
        boolean useCache = this.canUseCache();
        ODBOCapabilities capabilities = odboConn.getCapabilities();
        List<HierarchyRecord> answer = null;
        IRestrictions newRestrictions = restrictions;
        this.validateHierarchyRestrictions(odboConn, restrictions);
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        if (useCache) {
            answer = this.getCachedMetadata(MetadataOperation.HIERARCHIES, restrictions);
            if (null != answer) {
                return answer;
            }
            if (this.canPrefetchModelMetadata()) {
                newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
            }
        }
        ODBOConnection.CRestrictionArray cRestrictions = this.getHierarchyRestrictions(odboConn, newRestrictions);
        answer = new ArrayList();
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("MDSCHEMA_HIERARCHIES", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, HIERARCHY_STR, ex);
        }
        finally {
            cRestrictions.release();
        }
        int posName = -1;
        int posCubeName = -1;
        int posDimensionUniqueName = -1;
        int posUniqueName = -1;
        int posDescription = -1;
        int posCaption = -1;
        int posDisplayPath = -1;
        int posCardinality = -1;
        int posDefaultMember = -1;
        int posAllMember = -1;
        int posStructure = -1;
        int posHierOrigin = -1;
        int posHierOrdinal = -1;
        int posDimensionType = -1;
        ODBORowset rows = null;
        rows = new ODBORowset(odboConn, rowsetHandle);
        try {
            int columnCount = rows.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = rows.getColumnName(i);
                if (columnNames[i].equals("HIERARCHY_NAME")) {
                    posName = i;
                    continue;
                }
                if (columnNames[i].equals("HIERARCHY_UNIQUE_NAME")) {
                    posUniqueName = i;
                    continue;
                }
                if (columnNames[i].equals("CUBE_NAME")) {
                    posCubeName = i;
                    continue;
                }
                if (columnNames[i].equals("DIMENSION_UNIQUE_NAME")) {
                    posDimensionUniqueName = i;
                    continue;
                }
                if (columnNames[i].equals("HIERARCHY_DISPLAY_FOLDER")) {
                    posDisplayPath = i;
                    continue;
                }
                if (columnNames[i].equals("HIERARCHY_CAPTION")) {
                    posCaption = i;
                    continue;
                }
                if (columnNames[i].equals("HIERARCHY_CARDINALITY")) {
                    posCardinality = i;
                    continue;
                }
                if (columnNames[i].equals("DEFAULT_MEMBER")) {
                    posDefaultMember = i;
                    continue;
                }
                if (columnNames[i].equals("ALL_MEMBER")) {
                    posAllMember = i;
                    continue;
                }
                if (columnNames[i].equals("STRUCTURE")) {
                    posStructure = i;
                    continue;
                }
                if (columnNames[i].equals("DESCRIPTION")) {
                    posDescription = i;
                    continue;
                }
                if (columnNames[i].equals("HIERARCHY_ORIGIN")) {
                    posHierOrigin = i;
                    continue;
                }
                if (columnNames[i].equals("HIERARCHY_ORDINAL")) {
                    posHierOrdinal = i;
                    continue;
                }
                if (!columnNames[i].equals("DIMENSION_TYPE")) continue;
                posDimensionType = i;
            }
            int rowNumber = 0;
            while (rows.getNextRow()) {
                Long longValue;
                HierarchyRecord hierarchy = new HierarchyRecord();
                hierarchy.setRank(++rowNumber);
                hierarchy.setCatalogName(this.getCatalogNameFromConnection(odboConn));
                if (posUniqueName == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "HIERARCHY_UNIQUE_NAME");
                String value = rows.getStringColumn(posUniqueName, true);
                if (value == null) throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "HIERARCHY_UNIQUE_NAME");
                hierarchy.setUniqueName(value);
                if (posCaption == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "HIERARCHY_CAPTION");
                String caption = rows.getStringColumn(posCaption, true);
                if (caption == null) throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "HIERARCHY_CAPTION");
                LocalizedString localizedCaption = this.getLocalizedString(caption);
                hierarchy.setCaption((ILocalizedString)localizedCaption);
                if (posName == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "HIERARCHY_NAME");
                value = rows.getStringColumn(posName, false);
                if (value != null && value.length() > 0) {
                    hierarchy.setName(value);
                }
                if (posCubeName == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "CUBE_NAME");
                value = rows.getStringColumn(posCubeName, true);
                if (value == null) throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CUBE_NAME");
                hierarchy.setCubeName(value);
                if (posDimensionUniqueName == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DIMENSION_UNIQUE_NAME");
                value = rows.getStringColumn(posDimensionUniqueName, true);
                if (value == null) throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DIMENSION_UNIQUE_NAME");
                hierarchy.setDimensionUniqueName(value);
                if (posDescription != -1) {
                    value = rows.getStringColumn(posDescription, false);
                    hierarchy.setDescription(value);
                }
                if (posDisplayPath != -1) {
                    value = rows.getStringColumn(posDisplayPath, true);
                    hierarchy.setDisplayPath(value);
                }
                if (posCardinality != -1 && (longValue = rows.getLongColumn(posCardinality)) != null) {
                    hierarchy.setCardinality(longValue.intValue());
                }
                if (posDefaultMember == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DEFAULT_MEMBER");
                value = rows.getStringColumn(posDefaultMember, true);
                if (value == null) throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DEFAULT_MEMBER");
                if (hierarchy.getUniqueName().equals(MEASURES_STRING)) {
                    MetadataRestriction newMeasureRestrictions = new MetadataRestriction();
                    newMeasureRestrictions.add(RestrictionType.CATALOG, newRestrictions.getValueOf(RestrictionType.CATALOG));
                    newMeasureRestrictions.add(RestrictionType.CUBE, newRestrictions.getValueOf(RestrictionType.CUBE));
                    newMeasureRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierarchy.getUniqueName());
                    newMeasureRestrictions.add(RestrictionType.MEASURE_UNIQUE_NAME, (Object)value);
                    if (this.validateDefaultMeasure(odboConn, (IRestrictions)newMeasureRestrictions)) {
                        hierarchy.setDefaultMemberUniqueName(value);
                    }
                } else {
                    hierarchy.setDefaultMemberUniqueName(value);
                }
                if (posAllMember != -1) {
                    value = rows.getStringColumn(posAllMember, true);
                    hierarchy.setHighestRollupMemberUniqueName(value);
                }
                if (posStructure == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "STRUCTURE");
                longValue = rows.getLongColumn(posStructure);
                if (longValue == null) throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "STRUCTURE");
                MSASCommonHierStructure.convertHierarchyStructure((HierarchyRecord)hierarchy, (int)longValue.intValue());
                hierarchy.setUniqueId(RecordType.HIERARCHY, hierarchy.getUniqueName());
                if (hierarchy.getName() == null || hierarchy.getName().length() == 0) {
                    DimensionRecord dimRecord = this.getDimensionRecord(odboConn, newRestrictions, hierarchy.getDimensionUniqueName());
                    if (dimRecord == null) throw new ODBORuntimeException(ODBOMessageKeys.MET_CANNOT_FIND_DIMENSION, (Object)hierarchy.getDimensionUniqueName(), (Object)hierarchy.getCatalogName(), hierarchy.getCubeName());
                    hierarchy.setName(dimRecord.getName());
                }
                if (hierarchy.getUniqueName().equals(MEASURES_STRING)) {
                    hierarchy.setParentChild(true);
                } else if (capabilities.canDetermineParentChildByLevelNames()) {
                    MetadataRestriction newPCRestrictions = new MetadataRestriction();
                    newPCRestrictions.add(RestrictionType.CATALOG, newRestrictions.getValueOf(RestrictionType.CATALOG, (Object)""));
                    newPCRestrictions.add(RestrictionType.CUBE, newRestrictions.getValueOf(RestrictionType.CUBE, (Object)""));
                    newPCRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierarchy.getUniqueName());
                    hierarchy.setParentChild(this.isParentChildHierarchyBasedOnLevelNames(odboConn, (IRestrictions)newPCRestrictions));
                } else {
                    hierarchy.setParentChild(false);
                }
                if (posHierOrigin != -1 && (longValue = rows.getLongColumn(posHierOrigin)) != null) {
                    if ((2 & longValue.intValue()) != 0) {
                        hierarchy.setAttributeHierarchy(true);
                        if ((1 & longValue.intValue()) != 0) {
                            hierarchy.setParentChild(true);
                        }
                    } else {
                        hierarchy.setAttributeHierarchy(false);
                    }
                }
                if (capabilities.canForceRaggedToUnbalanced() && hierarchy.isRagged()) {
                    hierarchy.setBalanced(false);
                    if (ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).isOn()) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Ragged hierarchy changed to unbalanced:" + hierarchy.getUniqueName());
                    }
                } else if (capabilities.canForceParentChildToUnbalanced() && hierarchy.isParentChild()) {
                    hierarchy.setBalanced(false);
                    if (ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).isOn()) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Parent-Child hierarchy changed to unbalanced:" + hierarchy.getUniqueName());
                    }
                }
                this.useMDDSHierarchyRanking(posHierOrdinal, posDimensionType, rows, hierarchy, capabilities.canApplyNewRankToHierarchies());
                answer.add(hierarchy);
            }
        }
        finally {
            rows.close();
        }
        Collections.sort(answer, new RankComparator());
        if (useCache) {
            this.putCachedMetadata(MetadataOperation.HIERARCHIES, newRestrictions, answer);
            List<HierarchyRecord> cachedAnswer = this.getCachedMetadata(MetadataOperation.HIERARCHIES, restrictions);
            if (null != cachedAnswer) {
                return cachedAnswer;
            }
            answer = this.filterHierarchyRecords(answer, dunRes, hunRes);
        }
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        if (from == 0) return answer;
        int toIndex = answer.size();
        if (size == 0) return answer.subList(from, toIndex);
        toIndex = Math.min(from + size, answer.size());
        return answer.subList(from, toIndex);
    }

    private void validateHierarchyRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    private void useMDDSHierarchyRanking(int posHierOrdinal, int posDimensionType, ODBORowset rowset, HierarchyRecord hierarchy, boolean canApplyNewRankToHierarchies) {
        DimensionTypeEnum dimensionType = DimensionTypeEnum.REGULAR;
        if (posDimensionType != -1) {
            int dimType = rowset.getLongColumn(posDimensionType).intValue();
            dimensionType = MSASCommonDimTypes.convertOLEDBDimensionTypeToEnum((int)dimType);
        }
        if (posHierOrdinal == -1) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "HIERARCHY_ORDINAL");
        }
        if (dimensionType == DimensionTypeEnum.MEASURE) {
            hierarchy.setRank(Integer.MAX_VALUE);
        } else if (canApplyNewRankToHierarchies) {
            Long ordinal = rowset.getLongColumn(posHierOrdinal);
            hierarchy.setRank(ordinal.intValue());
        }
    }

    protected List<MemberRecord> getHierarchyRootMembers(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        List<Object> rootMembers;
        this.validateRootMemberRestrictions(odboConn, restrictions);
        boolean useCache = this.canUseCache();
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        IRestrictions newRestrictions = restrictions.duplicate();
        newRestrictions.add(RestrictionType.LEVEL_NUMBER, (Object)0);
        if (useCache) {
            rootMembers = this.getCachedMetadata(MetadataOperation.HIERARCHYROOTMEMBERS, restrictions);
            if (null != rootMembers) {
                return rootMembers;
            }
            if (this.canPrefetchModelMetadata()) {
                newRestrictions = newRestrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE, RestrictionType.LEVEL_NUMBER});
            }
        }
        rootMembers = this.getMembers(executionEnvironment, odboConn, newRestrictions);
        if (useCache) {
            if (this.canPrefetchModelMetadata()) {
                IRestrictions hierRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
                List<HierarchyRecord> hiers = this.getHierarchies(odboConn, hierRestrictions);
                for (HierarchyRecord currHier : hiers) {
                    IRestrictions rootMemRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
                    rootMemRestrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)currHier.getUniqueName());
                    List<MemberRecord> currRootMembers = this.getRootMembersForHier(rootMembers, currHier.getUniqueName());
                    this.putCachedMetadata(MetadataOperation.HIERARCHYROOTMEMBERS, rootMemRestrictions, currRootMembers);
                }
            } else {
                this.putCachedMetadata(MetadataOperation.HIERARCHYROOTMEMBERS, newRestrictions, rootMembers);
            }
            List<MemberRecord> cachedAnswer = this.getCachedMetadata(MetadataOperation.HIERARCHYROOTMEMBERS, restrictions);
            if (null != cachedAnswer) {
                return cachedAnswer;
            }
            rootMembers = this.filterRootMemberRecords(rootMembers, dunRes, hunRes);
        }
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        if (from != 0) {
            int toIndex = rootMembers.size();
            if (size != 0) {
                toIndex = Math.min(from + size, rootMembers.size());
            }
            return rootMembers.subList(from, toIndex);
        }
        return rootMembers;
    }

    private List<MemberRecord> getRootMembersForHier(List<MemberRecord> rootMembers, String uniqueName) {
        ArrayList<MemberRecord> currList = new ArrayList<MemberRecord>();
        for (MemberRecord memRec : rootMembers) {
            if (!memRec.getHierarchyUniqueName().equals(uniqueName)) continue;
            currList.add(memRec);
        }
        return currList;
    }

    private List<MemberRecord> filterRootMemberRecords(List<MemberRecord> rootMembers, String dunRes, String hunRes) {
        if (dunRes == null && hunRes == null) {
            if (rootMembers == null) {
                return new ArrayList<MemberRecord>();
            }
            return rootMembers;
        }
        ArrayList<MemberRecord> answer = new ArrayList<MemberRecord>();
        for (MemberRecord rootMemberRec : rootMembers) {
            if (dunRes != null && !dunRes.equals(rootMemberRec.getDimensionUniqueName()) || hunRes != null && !hunRes.equals(rootMemberRec.getUniqueName())) continue;
            answer.add(rootMemberRec);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<LevelRecord> getLevels(ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateLevelRestrictions(odboConn, restrictions);
        boolean useCache = this.canUseCache();
        List<Object> levelRecords = null;
        IRestrictions newRestrictions = restrictions;
        int resLevelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER, (Object)-1);
        String dunRes = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String hunRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String lunRes = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        if (useCache) {
            levelRecords = this.getCachedMetadata(MetadataOperation.LEVELS, restrictions);
            if (null != levelRecords) {
                return levelRecords;
            }
            if (this.canPrefetchModelMetadata()) {
                newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.SCHEMA, RestrictionType.CUBE});
            }
        }
        levelRecords = new ArrayList();
        ODBOConnection.CRestrictionArray cRestrictions = this.getLevelRestrictions(odboConn, newRestrictions);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("MDSCHEMA_LEVELS", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, "level", ex);
        }
        finally {
            cRestrictions.release();
        }
        int posName = -1;
        int posCubeName = -1;
        int posUniqueName = -1;
        int posCaption = -1;
        int posDescription = -1;
        int posCardinality = -1;
        int posDUN = -1;
        int posHUN = -1;
        int posLevelNumber = -1;
        int posLevelUniqueSettings = -1;
        int posAttribHierName = -1;
        try (ODBORowset rows = new ODBORowset(odboConn, rowsetHandle);){
            int columnCount = rows.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = rows.getColumnName(i);
                if (columnNames[i].equals("LEVEL_NAME")) {
                    posName = i;
                    continue;
                }
                if (columnNames[i].equals("CUBE_NAME")) {
                    posCubeName = i;
                    continue;
                }
                if (columnNames[i].equals("LEVEL_UNIQUE_NAME")) {
                    posUniqueName = i;
                    continue;
                }
                if (columnNames[i].equals("LEVEL_CAPTION")) {
                    posCaption = i;
                    continue;
                }
                if (columnNames[i].equals("LEVEL_CARDINALITY")) {
                    posCardinality = i;
                    continue;
                }
                if (columnNames[i].equals("DIMENSION_UNIQUE_NAME")) {
                    posDUN = i;
                    continue;
                }
                if (columnNames[i].equals("HIERARCHY_UNIQUE_NAME")) {
                    posHUN = i;
                    continue;
                }
                if (columnNames[i].equals("DESCRIPTION")) {
                    posDescription = i;
                    continue;
                }
                if (columnNames[i].equals("LEVEL_NUMBER")) {
                    posLevelNumber = i;
                    continue;
                }
                if (columnNames[i].equals("LEVEL_UNIQUE_SETTINGS")) {
                    posLevelUniqueSettings = i;
                    continue;
                }
                if (!columnNames[i].equals("LEVEL_ATTRIBUTE_HIERARCHY_NAME")) continue;
                posAttribHierName = i;
            }
            while (rows.getNextRow()) {
                Long longValue;
                int levelNumber = 0;
                if (posLevelNumber != -1) {
                    longValue = rows.getLongColumn(posLevelNumber);
                    if (longValue == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "LEVEL_NUMBER");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "LEVEL_NUMBER");
                }
                levelNumber = longValue.intValue();
                LevelRecord level = new LevelRecord();
                level.setLevelNumber(levelNumber);
                level.setCatalogName(this.getCatalogNameFromConnection(odboConn));
                if (posName == -1) {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "LEVEL_NAME");
                }
                String value = rows.getStringColumn(posName, true);
                level.setName(value);
                if (posCubeName != -1) {
                    value = rows.getStringColumn(posCubeName, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CUBE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "CUBE_NAME");
                }
                level.setCubeName(value);
                if (posUniqueName != -1) {
                    value = rows.getStringColumn(posUniqueName, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "LEVEL_UNIQUE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "LEVEL_UNIQUE_NAME");
                }
                level.setUniqueName(value);
                if (posDescription != -1) {
                    value = rows.getStringColumn(posDescription, false);
                    level.setDescription(value);
                }
                if (posCaption != -1) {
                    value = rows.getStringColumn(posCaption, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "LEVEL_CAPTION");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "LEVEL_CAPTION");
                }
                LocalizedString localizedCaption = this.getLocalizedString(value);
                level.setCaption((ILocalizedString)localizedCaption);
                if (posCardinality != -1 && (longValue = rows.getLongColumn(posCardinality)) != null) {
                    level.setCardinality(longValue.intValue());
                }
                if (posHUN != -1) {
                    value = rows.getStringColumn(posHUN, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "HIERARCHY_UNIQUE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "HIERARCHY_UNIQUE_NAME");
                }
                level.setHierarchyUniqueName(value);
                if (posDUN != -1) {
                    value = rows.getStringColumn(posDUN, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DIMENSION_UNIQUE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DIMENSION_UNIQUE_NAME");
                }
                level.setDimensionUniqueName(value);
                if (posLevelUniqueSettings != -1 && (longValue = rows.getLongColumn(posLevelUniqueSettings)) != null) {
                    if ((2 & longValue.intValue()) != 0) {
                        level.setUniqueMemberNames(true);
                    } else {
                        level.setUniqueMemberNames(false);
                    }
                }
                if (posAttribHierName != -1) {
                    value = rows.getStringColumn(posAttribHierName, true);
                    level.setAttributeHierarchyName(value);
                }
                level.setUniqueId(RecordType.LEVEL, level.getUniqueName());
                levelRecords.add(level);
            }
        }
        if (useCache) {
            this.putCachedMetadata(MetadataOperation.LEVELS, newRestrictions, levelRecords);
            List<LevelRecord> cachedAnswer = this.getCachedMetadata(MetadataOperation.LEVELS, restrictions);
            if (null != cachedAnswer) {
                return cachedAnswer;
            }
            levelRecords = this.filterLevelRecords(levelRecords, dunRes, hunRes, lunRes, resLevelNumber);
        } else if (-1 != resLevelNumber) {
            levelRecords = this.filterLevelRecords(levelRecords, null, null, null, resLevelNumber);
        }
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        if (from != 0) {
            int toIndex = levelRecords.size();
            if (size != 0) {
                toIndex = Math.min(from + size, levelRecords.size());
            }
            return levelRecords.subList(from, toIndex);
        }
        return levelRecords;
    }

    private List<LevelRecord> filterLevelRecords(List<LevelRecord> cachedAnswer, String dunRes, String hunRes, String lunRes, int resLevelNumber) {
        if (dunRes == null && hunRes == null && lunRes == null && resLevelNumber == -1) {
            if (cachedAnswer == null) {
                return new ArrayList<LevelRecord>();
            }
            return cachedAnswer;
        }
        ArrayList<LevelRecord> answer = new ArrayList<LevelRecord>();
        for (LevelRecord levelRec : cachedAnswer) {
            if (dunRes != null && !dunRes.equals(levelRec.getDimensionUniqueName()) || hunRes != null && !hunRes.equals(levelRec.getHierarchyUniqueName()) || lunRes != null && !lunRes.equals(levelRec.getUniqueName()) || resLevelNumber != -1 && resLevelNumber != levelRec.getLevelNumber()) continue;
            answer.add(levelRec);
        }
        return answer;
    }

    private void validateLevelRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    protected ODBOConnection.CRestrictionArray getLevelRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOConnection oDBOConnection = odboConn;
        ((Object)((Object)oDBOConnection)).getClass();
        ODBOConnection.CRestrictionArray cRestrictions = oDBOConnection.new ODBOConnection.CRestrictionArray(LevelRestrictions.values().length);
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String resCubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String resDUN = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String resHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String resLUN = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        cRestrictions.set(LevelRestrictions.CATALOG.ordinal(), resCatalogName);
        cRestrictions.setEmpty(LevelRestrictions.SCHEMA.ordinal());
        cRestrictions.set(LevelRestrictions.CUBE.ordinal(), resCubeName);
        if (null != resDUN) {
            cRestrictions.set(LevelRestrictions.DIMENSION_UNIQUE_NAME.ordinal(), resDUN);
        } else {
            cRestrictions.setEmpty(LevelRestrictions.DIMENSION_UNIQUE_NAME.ordinal());
        }
        if (null != resHUN) {
            cRestrictions.set(LevelRestrictions.HIERARCHY_UNIQUE_NAME.ordinal(), resHUN);
        } else {
            cRestrictions.setEmpty(LevelRestrictions.HIERARCHY_UNIQUE_NAME.ordinal());
        }
        cRestrictions.setEmpty(LevelRestrictions.LEVEL_NAME.ordinal());
        if (null != resLUN) {
            cRestrictions.set(LevelRestrictions.LEVEL_UNIQUE_NAME.ordinal(), resLUN);
        } else {
            cRestrictions.setEmpty(LevelRestrictions.LEVEL_UNIQUE_NAME.ordinal());
        }
        return cRestrictions;
    }

    private boolean isParentChildHierarchyBasedOnLevelNames(ODBOConnection odboConn, IRestrictions restrictions) {
        List<LevelRecord> allLevels = this.getLevels(odboConn, restrictions);
        boolean isParentChild = true;
        for (LevelRecord level : allLevels) {
            if (level.getName().startsWith("Level ") || "(All)".equals(level.getName())) continue;
            isParentChild = false;
            break;
        }
        return isParentChild;
    }

    private MeasureRecord getMeasureRecord(ODBOConnection odboConn, IRestrictions restrictions, String sMUN) {
        IRestrictions newRestrictions = restrictions.duplicate(new RestrictionType[]{RestrictionType.CATALOG, RestrictionType.CUBE});
        newRestrictions.add(RestrictionType.MEASURE_UNIQUE_NAME, (Object)sMUN);
        List<MeasureRecord> measures = this.getMeasures(odboConn, newRestrictions);
        if (!measures.isEmpty()) {
            return measures.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MeasureRecord> getMeasures(ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateMeasureRestrictions(odboConn, restrictions);
        boolean useCache = this.canUseCache();
        List<MeasureRecord> measureRecords = null;
        if (useCache && null != (measureRecords = this.getCachedMetadata(MetadataOperation.MEASURES, restrictions))) {
            return measureRecords;
        }
        EnumSet treeOps = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP, null);
        boolean skipSelf = false;
        String resMUN = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        if (treeOps != null) {
            if (!treeOps.contains(TreeOperatorEnum.SELF) && !treeOps.contains(TreeOperatorEnum.SIBLINGS)) {
                return Collections.emptyList();
            }
            if (treeOps.contains(TreeOperatorEnum.SIBLINGS)) {
                restrictions.remove(RestrictionType.MEASURE_UNIQUE_NAME);
                if (treeOps.size() == 1) {
                    skipSelf = true;
                }
            }
        }
        ODBOConnection.CRestrictionArray cRestrictions = this.getMeasureRestrictions(odboConn, restrictions);
        measureRecords = new ArrayList<MeasureRecord>();
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("MDSCHEMA_MEASURES", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, MEASURE_STR, ex);
        }
        finally {
            cRestrictions.release();
        }
        int posName = -1;
        int posCubeName = -1;
        int posUniqueName = -1;
        int posDescription = -1;
        int posCaption = -1;
        int posUnits = -1;
        int posDataType = -1;
        int posAggregator = -1;
        int posDisplayFolder = -1;
        int posScale = -1;
        int posPrecision = -1;
        ODBORowset rows = null;
        rows = new ODBORowset(odboConn, rowsetHandle);
        try {
            int columnCount = rows.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = rows.getColumnName(i);
                if (columnNames[i].equals("MEASURE_NAME")) {
                    posName = i;
                    continue;
                }
                if (columnNames[i].equals("CUBE_NAME")) {
                    posCubeName = i;
                    continue;
                }
                if (columnNames[i].equals("MEASURE_UNIQUE_NAME")) {
                    posUniqueName = i;
                    continue;
                }
                if (columnNames[i].equals("DESCRIPTION")) {
                    posDescription = i;
                    continue;
                }
                if (columnNames[i].equals("MEASURE_UNITS")) {
                    posUnits = i;
                    continue;
                }
                if (columnNames[i].equals("DATA_TYPE")) {
                    posDataType = i;
                    continue;
                }
                if (columnNames[i].equals("MEASURE_AGGREGATOR")) {
                    posAggregator = i;
                    continue;
                }
                if (columnNames[i].equals("MEASURE_CAPTION")) {
                    posCaption = i;
                    continue;
                }
                if (columnNames[i].equals("NUMERIC_SCALE")) {
                    posScale = i;
                    continue;
                }
                if (columnNames[i].equals("NUMERIC_PRECISION")) {
                    posPrecision = i;
                    continue;
                }
                if (!columnNames[i].equals("MEASURE_DISPLAY_FOLDER")) continue;
                posDisplayFolder = i;
            }
            int numberSkipped = 0;
            long datatype = 5L;
            while (rows.getNextRow()) {
                Long longValue;
                String value;
                String measureUniqueName;
                if (posUniqueName != -1) {
                    measureUniqueName = rows.getStringColumn(posUniqueName, true);
                    if (measureUniqueName == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "MEASURE_UNIQUE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "MEASURE_UNIQUE_NAME");
                }
                if (skipSelf && measureUniqueName.equals(resMUN)) continue;
                if (from != 0 && numberSkipped != from) {
                    ++numberSkipped;
                    continue;
                }
                if (size != 0 && measureRecords.size() >= size) {
                    break;
                }
                MeasureRecord measure = new MeasureRecord();
                measure.setUniqueName(measureUniqueName);
                measure.setCatalogName(this.getCatalogNameFromConnection(odboConn));
                if (posName != -1) {
                    value = rows.getStringColumn(posName, false);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "MEASURE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "MEASURE_NAME");
                }
                measure.setName(value);
                if (posCubeName != -1) {
                    value = rows.getStringColumn(posCubeName, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CUBE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "CUBE_NAME");
                }
                measure.setCubeName(value);
                if (posDescription != -1) {
                    value = rows.getStringColumn(posDescription, false);
                    measure.setDescription(value);
                }
                if (posCaption != -1) {
                    value = rows.getStringColumn(posCaption, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "MEASURE_CAPTION");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "MEASURE_CAPTION");
                }
                LocalizedString localizedCaption = this.getLocalizedString(value);
                measure.setCaption((ILocalizedString)localizedCaption);
                int scale = 0;
                if (posScale != -1 && (longValue = rows.getLongColumn(posScale)) != null) {
                    scale = longValue.intValue();
                }
                int precision = 0;
                if (posPrecision != -1 && (longValue = rows.getLongColumn(posPrecision)) != null) {
                    precision = longValue.intValue();
                }
                if (posDataType != -1) {
                    longValue = rows.getLongColumn(posDataType);
                    if (longValue == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DATA_TYPE");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DATA_TYPE");
                }
                datatype = longValue;
                this.setMeasureDatatypeInfo(measure, datatype, precision, scale);
                if (posAggregator != -1) {
                    longValue = rows.getLongColumn(posAggregator);
                    if (longValue == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "MEASURE_AGGREGATOR");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "MEASURE_AGGREGATOR");
                }
                AggregateTypeEnum aggregate = MSASCommonAggregators.convertOLEDBAggregateTypeToEnum((int)longValue.intValue());
                measure.setRegularAggregate(aggregate);
                measure.setSemiAggregate(aggregate);
                if (posUnits != -1) {
                    value = rows.getStringColumn(posUnits, true);
                    if (datatype == 6L) {
                        measure.setUnits("Currency");
                    } else {
                        measure.setUnits(value);
                    }
                }
                if (posDisplayFolder != -1) {
                    value = rows.getStringColumn(posDisplayFolder, true);
                    measure.setDisplayPath(value);
                }
                measure.setUniqueId(RecordType.MEASURE, measure.getUniqueName());
                measure.setDimensionUniqueName(MEASURES_STRING);
                measure.setHierarchyUniqueName(MEASURES_STRING);
                measure.setLevelUniqueName(MEASURES_LUN_STRING);
                measureRecords.add(measure);
            }
        }
        finally {
            rows.close();
        }
        if (useCache) {
            this.putCachedMetadata(MetadataOperation.MEASURES, restrictions, measureRecords);
        }
        return measureRecords;
    }

    private void validateMeasureRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    private void setMeasureDatatypeInfo(MeasureRecord measure, long datatype, int precision, int scale) {
        if (this.shouldCheckPrecisionScale(datatype)) {
            if (scale == 255 || scale == -1) {
                scale = 0;
            }
            if (scale == 0 && datatype == 6L) {
                scale = 4;
            }
            if (precision == 65535 || precision == -1) {
                precision = 0;
            }
        }
        IDataType dataType = MSASCommonDatatypes.convertMSASDatatype((long)datatype, (int)precision, (int)scale);
        measure.setDataType(dataType);
    }

    private void setPropertyDatatypeInfo(PropertyRecord property, long datatype, int precision, int scale) {
        if (this.shouldCheckPrecisionScale(datatype)) {
            if (scale == 255 || scale == -1) {
                scale = 0;
            }
            if (scale == 0 && datatype == 6L) {
                scale = 4;
            }
            if (precision == 65535 || precision == -1) {
                precision = 0;
            }
        }
        IDataType dataType = MSASCommonDatatypes.convertMSASDatatype((long)datatype, (int)precision, (int)scale);
        property.setDataType(dataType);
    }

    private boolean shouldCheckPrecisionScale(long datatype) {
        switch ((int)datatype) {
            case 12: 
            case 131: 
            case 135: 
            case 139: {
                return false;
            }
        }
        return true;
    }

    protected List<MemberRecord> getMembers(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateMemberRestrictions(odboConn, restrictions);
        Collection resPPDSCodes = (Collection)restrictions.getValueOf(RestrictionType.PPDS_CODES);
        if (resPPDSCodes != null && !resPPDSCodes.isEmpty()) {
            return this.getMembersFromPPDSCodes(executionEnvironment, odboConn, restrictions, resPPDSCodes);
        }
        return this.getMembersInternal(odboConn, restrictions);
    }

    private List<MemberRecord> getMembersFromPPDSCodes(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions, Collection<String> resPPDSCodes) {
        String resMUN = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        int numberSkipped = 0;
        ArrayList<MemberRecord> memberRecords = new ArrayList<MemberRecord>();
        for (String ppdsCode : resPPDSCodes) {
            if (null != ppdsCode) {
                if (ppdsCode.length() < 2) {
                    throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionIllegalValue, RestrictionType.PPDS_CODES.name(), ppdsCode);
                }
                String ppdsCodeType = ppdsCode.substring(0, 1);
                String mun = ppdsCode.substring(1);
                if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Getting Members for PPDS_CODE:" + ppdsCode);
                }
                if (ppdsCodeType.equals(PPDSCodeTypeEnum.DIMENSION.getPPDSCodePrefix())) {
                    DimensionRecord dimRecord = this.getDimensionRecord(odboConn, restrictions, mun);
                    if (dimRecord != null) {
                        HierarchyRecord hierRecord = this.getHierarchyRecord(odboConn, restrictions, dimRecord.getDefaultHierarchyUniqueName());
                        if (hierRecord != null) {
                            MemberRecord memRec = this.getMemberRecord(executionEnvironment, odboConn, restrictions, hierRecord.getDefaultMemberUniqueName());
                            if (null == memRec) continue;
                            if (from != 0 && numberSkipped != from) {
                                ++numberSkipped;
                                continue;
                            }
                            if (size <= memberRecords.size()) break;
                            memRec.setUniqueId(ppdsCode);
                            memberRecords.add(memRec);
                            continue;
                        }
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_CANNOT_FIND_HIERARCHY, (Object)dimRecord.getDefaultHierarchyUniqueName(), restrictions.getValueOf(RestrictionType.CUBE), restrictions.getValueOf(RestrictionType.CATALOG));
                    }
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_CANNOT_FIND_DIMENSION, (Object)mun, restrictions.getValueOf(RestrictionType.CUBE), restrictions.getValueOf(RestrictionType.CATALOG));
                }
                if (ppdsCodeType.equals(PPDSCodeTypeEnum.MEMBER.getPPDSCodePrefix())) {
                    if (null != resMUN && !resMUN.equals(mun)) {
                        if (!ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) continue;
                        StringBuilder sBuf = new StringBuilder();
                        sBuf.append("PPDSCode restriction (");
                        sBuf.append(mun);
                        sBuf.append(")doesn't match MUN restriction (");
                        sBuf.append(resMUN);
                        sBuf.append(").");
                        ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log(sBuf.toString());
                        continue;
                    }
                    MemberRecord memRec = this.getMemberRecord(executionEnvironment, odboConn, restrictions, mun);
                    if (null == memRec) continue;
                    if (from != 0 && numberSkipped != from) {
                        ++numberSkipped;
                        continue;
                    }
                    if (size <= memberRecords.size()) break;
                    memberRecords.add(memRec);
                    continue;
                }
                if (!ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) continue;
                ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("PPDSCode restriction was not a DUN or MUN:" + ppdsCode);
                continue;
            }
            if (!ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) continue;
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Empty PPDSCode restriction");
        }
        return memberRecords;
    }

    private void validateMemberRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        if (restrictions.contains(RestrictionType.TREEOP) && !restrictions.contains(RestrictionType.MEMBER_UNIQUE_NAME)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.MEMBER_UNIQUE_NAME);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    private void validateRootMemberRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateMemberRestrictions(odboConn, restrictions);
        if (!restrictions.contains(RestrictionType.HIERARCHY_UNIQUE_NAME)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.HIERARCHY_UNIQUE_NAME);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MemberRecord> getMembersInternal(ODBOConnection odboConn, IRestrictions restrictions) {
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        ODBOConnection.CRestrictionArray cRestrictions = this.getMemberRestrictions(odboConn, restrictions);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("MDSCHEMA_MEMBERS", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, "member", ex);
        }
        finally {
            cRestrictions.release();
        }
        int posName = -1;
        int posCubeName = -1;
        int posUniqueName = -1;
        int posDescription = -1;
        int posCaption = -1;
        int posHUN = -1;
        int posDUN = -1;
        int posLUN = -1;
        int posCardinality = -1;
        int posLevelNumber = -1;
        int posParentLevelNumber = -1;
        int posParentUniqueName = -1;
        int posParentCount = -1;
        int posMemberType = -1;
        ODBORowset rows = new ODBORowset(odboConn, rowsetHandle);
        ArrayList<MemberRecord> memberRecords = new ArrayList<MemberRecord>();
        DimensionRecord currDim = null;
        try {
            int columnCount = rows.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = rows.getColumnName(i);
                if (columnNames[i].equals("MEMBER_NAME")) {
                    posName = i;
                    continue;
                }
                if (columnNames[i].equals("CUBE_NAME")) {
                    posCubeName = i;
                    continue;
                }
                if (columnNames[i].equals("MEMBER_UNIQUE_NAME")) {
                    posUniqueName = i;
                    continue;
                }
                if (columnNames[i].equals("DESCRIPTION")) {
                    posDescription = i;
                    continue;
                }
                if (columnNames[i].equals("MEMBER_CAPTION")) {
                    posCaption = i;
                    continue;
                }
                if (columnNames[i].equals("DIMENSION_UNIQUE_NAME")) {
                    posDUN = i;
                    continue;
                }
                if (columnNames[i].equals("HIERARCHY_UNIQUE_NAME")) {
                    posHUN = i;
                    continue;
                }
                if (columnNames[i].equals("LEVEL_UNIQUE_NAME")) {
                    posLUN = i;
                    continue;
                }
                if (columnNames[i].equals("CHILDREN_CARDINALITY")) {
                    posCardinality = i;
                    continue;
                }
                if (columnNames[i].equals("LEVEL_NUMBER")) {
                    posLevelNumber = i;
                    continue;
                }
                if (columnNames[i].equals("PARENT_LEVEL")) {
                    posParentLevelNumber = i;
                    continue;
                }
                if (columnNames[i].equals("PARENT_UNIQUE_NAME")) {
                    posParentUniqueName = i;
                    continue;
                }
                if (columnNames[i].equals("PARENT_COUNT")) {
                    posParentCount = i;
                    continue;
                }
                if (!columnNames[i].equals("MEMBER_TYPE")) continue;
                posMemberType = i;
            }
            int numberSkipped = 0;
            while (rows.getNextRow()) {
                String hun;
                String dun;
                Long longValue;
                String mun;
                String value;
                if (from != 0 && numberSkipped != from) {
                    ++numberSkipped;
                    continue;
                }
                if (size != 0 && memberRecords.size() >= size) {
                    break;
                }
                MemberRecord member = new MemberRecord();
                member.setCatalogName(this.getCatalogNameFromConnection(odboConn));
                if (posName != -1) {
                    value = rows.getStringColumn(posName, false);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "MEMBER_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "MEMBER_NAME");
                }
                member.setName(value);
                if (posUniqueName != -1) {
                    mun = rows.getStringColumn(posUniqueName, true);
                    if (mun == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "MEMBER_UNIQUE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "MEMBER_UNIQUE_NAME");
                }
                member.setUniqueName(mun);
                if (posCubeName != -1) {
                    value = rows.getStringColumn(posCubeName, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CUBE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "MEMBER_UNIQUE_NAME");
                }
                member.setCubeName(value);
                if (posDescription != -1) {
                    value = rows.getStringColumn(posDescription, false);
                    member.setDescription(value);
                }
                if (posCaption != -1) {
                    value = rows.getStringColumn(posCaption, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "MEMBER_CAPTION");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "MEMBER_CAPTION");
                }
                LocalizedString localizedCaption = this.getLocalizedString(value);
                member.setCaption((ILocalizedString)localizedCaption);
                if (posCardinality != -1 && (longValue = rows.getLongColumn(posCardinality)) != null) {
                    member.setChildCardinality(longValue.intValue());
                }
                if (posDUN != -1) {
                    dun = rows.getStringColumn(posDUN, true);
                    if (dun == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DIMENSION_UNIQUE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DIMENSION_UNIQUE_NAME");
                }
                member.setDimensionUniqueName(dun);
                member.setDimensionUniqueName(dun);
                if (posHUN != -1) {
                    hun = rows.getStringColumn(posHUN, true);
                    if (hun == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "HIERARCHY_UNIQUE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "HIERARCHY_UNIQUE_NAME");
                }
                member.setHierarchyUniqueName(hun);
                if (posLUN != -1) {
                    value = rows.getStringColumn(posLUN, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "LEVEL_UNIQUE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "LEVEL_UNIQUE_NAME");
                }
                member.setLevelUniqueName(value);
                if (posLevelNumber != -1) {
                    longValue = rows.getLongColumn(posLevelNumber);
                    if (longValue != null) {
                        member.setLevelNumber(longValue.intValue());
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "LEVEL_NUMBER");
                }
                if (posParentLevelNumber != -1) {
                    longValue = rows.getLongColumn(posParentLevelNumber);
                    if (longValue == null) {
                        member.setParentLevelNumber(-1);
                    } else {
                        member.setParentLevelNumber(longValue.intValue());
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "PARENT_LEVEL");
                }
                if (posParentUniqueName != -1) {
                    value = rows.getStringColumn(posParentUniqueName, true);
                    member.setParentUniqueName(value);
                }
                if (posParentCount != -1) {
                    longValue = rows.getLongColumn(posParentCount);
                    if (longValue == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "PARENT_COUNT");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "PARENT_COUNT");
                }
                member.setParentCount(longValue.intValue());
                if (posMemberType != -1) {
                    longValue = rows.getLongColumn(posMemberType);
                    if (longValue == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "MEMBER_TYPE");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "MEMBER_TYPE");
                }
                int memberType = longValue.intValue();
                member.setType(MSASCommonMemberTypes.convertIntToMemberType((int)memberType));
                member.setDataMemberUniqueName(null);
                if (this.forceRollupToComputed) {
                    member.setRollupType(RollupTypeEnum.COMPUTED);
                } else {
                    if (null == currDim || !currDim.getUniqueName().equals(dun)) {
                        currDim = this.getDimensionRecord(odboConn, restrictions, dun);
                    }
                    this.calculateMemberRollup(currDim, member);
                }
                member.setUniqueId(RecordType.MEMBER, member.getUniqueName());
                memberRecords.add(member);
            }
        }
        finally {
            rows.close();
        }
        return memberRecords;
    }

    private void calculateMemberRollup(DimensionRecord currDim, MemberRecord member) {
        DimensionTypeEnum dimType = currDim.getType();
        if (dimType == DimensionTypeEnum.ACCOUNT || dimType == DimensionTypeEnum.SCENARIO) {
            member.setRollupType(RollupTypeEnum.COMPUTED);
        } else {
            member.setRollupType(RollupTypeEnum.ROLLUP);
        }
    }

    private MemberRecord getMemberRecord(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions, String memberUniqueName) {
        MetadataRestriction newRestrictions = new MetadataRestriction();
        newRestrictions.add(RestrictionType.CATALOG, restrictions.getValueOf(RestrictionType.CATALOG));
        newRestrictions.add(RestrictionType.CUBE, restrictions.getValueOf(RestrictionType.CUBE));
        newRestrictions.add(RestrictionType.MEMBER_UNIQUE_NAME, (Object)memberUniqueName);
        List<MemberRecord> members = this.getMembers(executionEnvironment, odboConn, (IRestrictions)newRestrictions);
        if (!members.isEmpty()) {
            return members.get(0);
        }
        return null;
    }

    protected ODBOConnection.CRestrictionArray getMemberRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOConnection oDBOConnection = odboConn;
        ((Object)((Object)oDBOConnection)).getClass();
        ODBOConnection.CRestrictionArray cRestrictions = oDBOConnection.new ODBOConnection.CRestrictionArray(MemberRestrictions.values().length);
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String resCubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String resDUN = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String resHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String resLUN = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        Integer resLevelNumber = (Integer)restrictions.getValueOf(RestrictionType.LEVEL_NUMBER);
        String resMUN = (String)restrictions.getValueOf(RestrictionType.MEMBER_UNIQUE_NAME);
        EnumSet resTreeOp = (EnumSet)restrictions.getValueOf(RestrictionType.TREEOP);
        cRestrictions.set(MemberRestrictions.CATALOG.ordinal(), resCatalogName);
        cRestrictions.setEmpty(MemberRestrictions.SCHEMA.ordinal());
        cRestrictions.set(MemberRestrictions.CUBE.ordinal(), resCubeName);
        ODBOCapabilities capabilities = odboConn.getCapabilities();
        if (null != resDUN && !capabilities.canDisableDimForProperties()) {
            cRestrictions.set(PropertyRestrictions.DIMENSION_UNIQUE_NAME.ordinal(), resDUN);
        } else {
            cRestrictions.setEmpty(PropertyRestrictions.DIMENSION_UNIQUE_NAME.ordinal());
        }
        if (null != resHUN) {
            cRestrictions.set(MemberRestrictions.HIERARCHY_UNIQUE_NAME.ordinal(), resHUN);
        } else {
            cRestrictions.setEmpty(MemberRestrictions.HIERARCHY_UNIQUE_NAME.ordinal());
        }
        if (null != resLUN) {
            cRestrictions.set(MemberRestrictions.LEVEL_UNIQUE_NAME.ordinal(), resLUN);
        } else {
            cRestrictions.setEmpty(MemberRestrictions.LEVEL_UNIQUE_NAME.ordinal());
        }
        if (null != resLevelNumber) {
            cRestrictions.set(MemberRestrictions.LEVEL_NUMBER.ordinal(), resLevelNumber);
        } else {
            cRestrictions.setEmpty(MemberRestrictions.LEVEL_NUMBER.ordinal());
        }
        cRestrictions.setEmpty(MemberRestrictions.MEMBER_NAME_RESTRICTION.ordinal());
        if (null != resMUN) {
            cRestrictions.set(MemberRestrictions.MEMBER_UNIQUE_NAME.ordinal(), resMUN);
        } else {
            cRestrictions.setEmpty(MemberRestrictions.MEMBER_UNIQUE_NAME.ordinal());
        }
        cRestrictions.setEmpty(MemberRestrictions.MEMBER_CAPTION.ordinal());
        cRestrictions.setEmpty(MemberRestrictions.MEMBER_TYPE.ordinal());
        if (null != resTreeOp) {
            int n = MSASCommonTreeOp.convertTreeOperatorEnumSetToInt((EnumSet)resTreeOp);
            Integer value = new Integer(n);
            cRestrictions.set(MemberRestrictions.TREEOP.ordinal(), value);
        }
        return cRestrictions;
    }

    private List<HierarchyRecord> filterHierarchyRecords(List<HierarchyRecord> cachedAnswer, String dunRes, String hunRes) {
        if (dunRes == null && hunRes == null) {
            if (cachedAnswer == null) {
                return new ArrayList<HierarchyRecord>();
            }
            return cachedAnswer;
        }
        ArrayList<HierarchyRecord> answer = new ArrayList<HierarchyRecord>();
        for (HierarchyRecord hierRec : cachedAnswer) {
            if (dunRes != null) {
                if (!dunRes.equals(hierRec.getDimensionUniqueName())) continue;
                if (hunRes != null) {
                    if (!hunRes.equals(hierRec.getUniqueName())) continue;
                    answer.add(hierRec);
                    continue;
                }
                answer.add(hierRec);
                continue;
            }
            if (!hunRes.equals(hierRec.getUniqueName())) continue;
            answer.add(hierRec);
        }
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean validateDefaultMeasure(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOConnection.CRestrictionArray cRestrictions = this.getMeasureRestrictions(odboConn, restrictions);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("MDSCHEMA_MEASURES", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, MEASURE_STR, ex);
        }
        finally {
            cRestrictions.release();
        }
        boolean validMember = false;
        try (ODBORowset rows = new ODBORowset(odboConn, rowsetHandle);){
            if (rows.getNextRow()) {
                validMember = true;
            }
        }
        return validMember;
    }

    protected ODBOConnection.CRestrictionArray getMeasureRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOConnection oDBOConnection = odboConn;
        ((Object)((Object)oDBOConnection)).getClass();
        ODBOConnection.CRestrictionArray cRestrictions = oDBOConnection.new ODBOConnection.CRestrictionArray(MeasureRestrictions.values().length);
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String resCubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String resMUN = (String)restrictions.getValueOf(RestrictionType.MEASURE_UNIQUE_NAME);
        cRestrictions.set(MeasureRestrictions.CATALOG.ordinal(), resCatalogName);
        cRestrictions.setEmpty(MeasureRestrictions.SCHEMA.ordinal());
        cRestrictions.set(MeasureRestrictions.CUBE.ordinal(), resCubeName);
        cRestrictions.setEmpty(MeasureRestrictions.MEASURE_NAME.ordinal());
        if (null != resMUN) {
            cRestrictions.set(MeasureRestrictions.MEASURE_UNIQUE_NAME.ordinal(), resMUN);
        } else {
            cRestrictions.setEmpty(MeasureRestrictions.MEASURE_UNIQUE_NAME.ordinal());
        }
        return cRestrictions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<NamedSetRecord> getNamedSets(ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateNamedSetRestrictions(odboConn, restrictions);
        ArrayList<NamedSetRecord> namedSetRecords = new ArrayList<NamedSetRecord>();
        ODBOConnection.CRestrictionArray cRestrictions = this.getNamedSetRestrictions(odboConn, restrictions);
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("MDSCHEMA_SETS", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, "named set", ex);
        }
        finally {
            cRestrictions.release();
        }
        int posName = -1;
        int posDescription = -1;
        int posExpression = -1;
        int posDimensions = -1;
        int posDisplayFolder = -1;
        int posCubeName = -1;
        int posCaption = -1;
        try (ODBORowset rows = new ODBORowset(odboConn, rowsetHandle);){
            int columnCount = rows.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = rows.getColumnName(i);
                if (columnNames[i].equals("SET_NAME")) {
                    posName = i;
                    continue;
                }
                if (columnNames[i].equals("SET_CAPTION")) {
                    posCaption = i;
                    continue;
                }
                if (columnNames[i].equals("DESCRIPTION")) {
                    posDescription = i;
                    continue;
                }
                if (columnNames[i].equals("CUBE_NAME")) {
                    posCubeName = i;
                    continue;
                }
                if (columnNames[i].equals("EXPRESSION")) {
                    posExpression = i;
                    continue;
                }
                if (columnNames[i].equals("DIMENSIONS")) {
                    posDimensions = i;
                    continue;
                }
                if (!columnNames[i].equals("SET_DISPLAY_FOLDER")) continue;
                posDisplayFolder = i;
            }
            String value = null;
            String originalName = null;
            String hierarchyList = null;
            int numberSkipped = 0;
            while (rows.getNextRow()) {
                LocalizedString localizedCaption;
                if (posDimensions == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DIMENSIONS");
                hierarchyList = rows.getStringColumn(posDimensions, true);
                if (hierarchyList == null) throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DIMENSIONS");
                if (hierarchyList.contains(COMMA_SEPARATOR)) {
                    if (!ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) continue;
                    ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Dropped Named List: " + value);
                    continue;
                }
                if (from != 0 && numberSkipped != from) {
                    ++numberSkipped;
                    continue;
                }
                if (size != 0 && namedSetRecords.size() >= size) {
                    return namedSetRecords;
                }
                NamedSetRecord namedSet = new NamedSetRecord();
                namedSet.setCatalogName(this.getCatalogNameFromConnection(odboConn));
                if (posName == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "SET_NAME");
                originalName = rows.getStringColumn(posName, true);
                if (originalName == null) {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "SET_NAME");
                }
                String newName = this.massageNamedSetName(originalName);
                namedSet.setName(newName);
                namedSet.setUniqueName(newName);
                if (posCaption != -1) {
                    value = rows.getStringColumn(posCaption, true);
                    if (value != null) {
                        localizedCaption = this.getLocalizedString(value);
                        namedSet.setCaption((ILocalizedString)localizedCaption);
                    }
                } else {
                    localizedCaption = this.getLocalizedString(originalName);
                    namedSet.setCaption((ILocalizedString)localizedCaption);
                }
                if (posDescription != -1) {
                    value = rows.getStringColumn(posDescription, false);
                    namedSet.setDescription(value);
                }
                if (posCubeName == -1) throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "CUBE_NAME");
                value = rows.getStringColumn(posCubeName, true);
                if (value == null) {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CUBE_NAME");
                }
                namedSet.setCubeName(value);
                if (posExpression != -1) {
                    int colStatus = rows.getColumnStatus(posExpression);
                    value = rows.getStringColumnWithStatus(posExpression, false, colStatus);
                    if (4 != colStatus) {
                        namedSet.setExpression(value);
                    } else if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA, LogLevel.WARN)) {
                        ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log(LogLevel.WARN, "Expression was truncated for Named Set " + namedSet.getUniqueName());
                    }
                }
                if (posDisplayFolder != -1) {
                    value = rows.getStringColumn(posDisplayFolder, true);
                    namedSet.setDisplayPath(value);
                }
                namedSet.setUniqueId(RecordType.NAMEDSET, namedSet.getUniqueName());
                namedSetRecords.add(namedSet);
            }
            return namedSetRecords;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<MemberRecord> getNamedSetMembers(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateNamedSetMembersRestrictions(odboConn, restrictions);
        int from = (Integer)restrictions.getValueOf(RestrictionType.FROM, (Object)0);
        int size = (Integer)restrictions.getValueOf(RestrictionType.SIZE, (Object)Integer.MAX_VALUE);
        StringBuilder mdxString = new StringBuilder();
        mdxString.append(SELECT_STR);
        mdxString.append((String)restrictions.getValueOf(RestrictionType.SET, (Object)null));
        mdxString.append(DIMENSION_PROPERTIES);
        mdxString.append(DIMENSION_PROPERTIES_NAME);
        mdxString.append(AXIS_STR);
        mdxString.append(FROM_STR);
        mdxString.append(STARTING_BRACKET);
        mdxString.append((String)restrictions.getValueOf(RestrictionType.CUBE, (Object)null));
        mdxString.append(ENDING_BRACKET);
        mdxString.append(CELL_PROPERTIES);
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Creating data named set content query: " + mdxString.toString());
        }
        ArrayList<MemberRecord> memberRecords = new ArrayList<MemberRecord>();
        ODBOResultSet results = null;
        XDataContext dataContext = executionEnvironment.pushDataContext();
        try {
            results = odboConn.query(dataContext, ODBOMetadataHandler.makeMDXQueryArguments(((RequestEnvironment)executionEnvironment.getRequestEnvironment()).getRunLocale()), null, mdxString.toString(), 1);
        }
        catch (ODBORuntimeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_NAMEDSET_MEMBERS, (Throwable)((Object)ex));
        }
        finally {
            executionEnvironment.popDataContext(dataContext);
        }
        try {
            ODBORowset rowset = results.getAxisRowset(0, 30);
            int dunIdx = -1;
            int hunIdx = -1;
            int lunIdx = -1;
            int lnumIdx = -1;
            int capIdx = -1;
            int munIdx = -1;
            int plnumIdx = -1;
            int punIdx = -1;
            try {
                for (int i = 0; i < rowset.getColumnCount(); ++i) {
                    String columnName = rowset.getColumnName(i);
                    if (columnName.endsWith(PROP_DIMENSION_UNIQUE_NAME)) {
                        dunIdx = i;
                    }
                    if (columnName.endsWith(PROP_HIERARCHY_UNIQUE_NAME)) {
                        hunIdx = i;
                    }
                    if (columnName.endsWith(PROP_LEVEL_UNIQUE_NAME)) {
                        lunIdx = i;
                    }
                    if (columnName.endsWith(PROP_LEVEL_NUMBER)) {
                        lnumIdx = i;
                    }
                    if (columnName.endsWith(PROP_MEMBER_CAPTION)) {
                        capIdx = i;
                    }
                    if (columnName.endsWith(PROP_MEMBER_UNIQUE_NAME)) {
                        munIdx = i;
                    }
                    if (columnName.endsWith(PROP_PARENT_LEVEL)) {
                        plnumIdx = i;
                    }
                    if (!columnName.endsWith(PROP_PARENT_UNIQUE_NAME)) continue;
                    punIdx = i;
                }
                String value = null;
                Long longValue = null;
                int i = 0;
                while (rowset.getNextRow()) {
                    if (i >= from) {
                        if (i - from >= size) {
                            break;
                        }
                        MemberRecord member = new MemberRecord();
                        member.setCatalogName(this.getCatalogNameFromConnection(odboConn));
                        member.setCubeName((String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class));
                        if (dunIdx != -1) {
                            value = rowset.getStringColumn(dunIdx, true);
                            member.setDimensionUniqueName(value);
                        }
                        if (hunIdx != -1) {
                            value = rowset.getStringColumn(hunIdx, true);
                            member.setHierarchyUniqueName(value);
                        }
                        if (lunIdx != -1) {
                            value = rowset.getStringColumn(lunIdx, true);
                            member.setLevelUniqueName(value);
                        }
                        if (lnumIdx != -1) {
                            longValue = rowset.getLongColumn(lnumIdx);
                            member.setLevelNumber(longValue.intValue());
                        }
                        if (capIdx != -1) {
                            value = rowset.getStringColumn(capIdx, true);
                            member.setName(value);
                            member.setCaption(value);
                        }
                        if (munIdx != -1) {
                            value = rowset.getStringColumn(munIdx, true);
                            member.setUniqueName(value);
                            member.setUniqueId(RecordType.MEMBER, value);
                        }
                        if (plnumIdx != -1) {
                            longValue = rowset.getLongColumn(plnumIdx);
                            member.setParentLevelNumber(longValue.intValue());
                        }
                        if (punIdx != -1) {
                            value = rowset.getStringColumn(punIdx, true);
                            member.setParentUniqueName(value);
                        }
                        memberRecords.add(member);
                    }
                    ++i;
                }
            }
            finally {
                rowset.close();
            }
        }
        finally {
            results.release();
        }
        return memberRecords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> getNamedSetLevelUniqueNames(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateNamedSetLevelUniqueNamesRestrictions(odboConn, restrictions);
        StringBuilder mdxString = new StringBuilder();
        mdxString.append(SELECT_STR);
        mdxString.append((String)restrictions.getValueOf(RestrictionType.SET, (Object)null));
        mdxString.append(AXIS_STR);
        mdxString.append(FROM_STR);
        mdxString.append(STARTING_BRACKET);
        mdxString.append((String)restrictions.getValueOf(RestrictionType.CUBE, (Object)null));
        mdxString.append(ENDING_BRACKET);
        mdxString.append(CELL_PROPERTIES);
        if (ODBOLog.isOn(ODBOLogEnum.LOG_PROVIDER_METADATA)) {
            ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA).log("Creating data named set LUN query: " + mdxString.toString());
        }
        HashSet<String> levelList = new HashSet<String>();
        ArrayList<String> returnedList = new ArrayList<String>();
        ODBOResultSet results = null;
        XDataContext dataContext = executionEnvironment.pushDataContext();
        try {
            results = odboConn.query(dataContext, ODBOMetadataHandler.makeMDXQueryArguments(((RequestEnvironment)executionEnvironment.getRequestEnvironment()).getRunLocale()), null, mdxString.toString(), 1);
        }
        catch (ODBORuntimeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_NAMEDSET_LUNS, (Throwable)((Object)ex));
        }
        finally {
            executionEnvironment.popDataContext(dataContext);
        }
        try {
            int lunIdx = -1;
            try (ODBORowset rowset = results.getAxisRowset(0, 8);){
                for (int i = 0; i < rowset.getColumnCount(); ++i) {
                    String columnName = rowset.getColumnName(i);
                    if (!columnName.endsWith(PROP_LEVEL_UNIQUE_NAME)) continue;
                    lunIdx = i;
                    break;
                }
                String value = null;
                if (lunIdx != -1) {
                    while (rowset.getNextRow()) {
                        value = rowset.getStringColumn(lunIdx, true);
                        if (levelList.contains(value)) continue;
                        levelList.add(value);
                        returnedList.add(value);
                    }
                }
            }
        }
        finally {
            results.release();
        }
        return returnedList;
    }

    private void validateNamedSetRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    private void validateNamedSetMembersRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateNamedSetRestrictions(odboConn, restrictions);
        if (!restrictions.contains(RestrictionType.SET)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.SET);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    private void validateNamedSetLevelUniqueNamesRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateNamedSetRestrictions(odboConn, restrictions);
        if (!restrictions.contains(RestrictionType.SET)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.SET);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    protected ODBOConnection.CRestrictionArray getNamedSetRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOConnection oDBOConnection = odboConn;
        ((Object)((Object)oDBOConnection)).getClass();
        ODBOConnection.CRestrictionArray cRestrictions = oDBOConnection.new ODBOConnection.CRestrictionArray(NamedSetRestrictions.values().length);
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String resCubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String resSet = (String)restrictions.getValueOf(RestrictionType.SET);
        cRestrictions.set(NamedSetRestrictions.CATALOG.ordinal(), resCatalogName);
        cRestrictions.setEmpty(NamedSetRestrictions.SCHEMA.ordinal());
        cRestrictions.set(NamedSetRestrictions.CUBE.ordinal(), resCubeName);
        cRestrictions.setEmpty(NamedSetRestrictions.SCOPE.ordinal());
        if (resSet != null) {
            cRestrictions.set(NamedSetRestrictions.SET.ordinal(), resSet);
        } else {
            cRestrictions.setEmpty(NamedSetRestrictions.SET.ordinal());
        }
        return cRestrictions;
    }

    private String massageNamedSetName(String originalName) {
        int firstBracket = originalName.indexOf(STARTING_BRACKET);
        if (firstBracket < 0) {
            StringBuilder newName = new StringBuilder();
            newName.append(STARTING_BRACKET);
            newName.append(originalName);
            newName.append(ENDING_BRACKET);
            return newName.toString();
        }
        return originalName;
    }

    protected List<PropertyRecord> getProperties(ODBOConnection odboConn, IRestrictions restrictions) {
        this.validatePropertiesRestrictions(odboConn, restrictions);
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        String sLUNRes = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        String sHUNRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        ArrayList<PropertyRecord> propertyRecords = new ArrayList<PropertyRecord>();
        if (null != sHUNRes && sHUNRes.equals(MEASURES_STRING)) {
            return propertyRecords;
        }
        IRestrictions originalRestrictions = restrictions.duplicate();
        HierarchyRecord hierRec = this.getHierarchyRecordFromPropRestrictions(odboConn, restrictions);
        LevelRecord levelRec = null;
        if (null != hierRec) {
            sHUNRes = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        }
        if (null == hierRec || !hierRec.isParentChild()) {
            levelRec = this.getLevelRecordFromPropRestrictions(odboConn, restrictions, hierRec, propertyRestriction);
            if (null != levelRec) {
                if (levelRec.getHierarchyUniqueName().equals(MEASURES_STRING)) {
                    return propertyRecords;
                }
                String levelHUN = levelRec.getHierarchyUniqueName();
                sLUNRes = levelRec.getUniqueName();
                if (null == sHUNRes || sHUNRes.length() == 0) {
                    restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)levelHUN);
                    sHUNRes = levelHUN;
                }
            } else if (null == hierRec && null != sLUNRes && null != propertyRestriction) {
                throw new ODBORuntimeException(ODBOMessageKeys.MET_LUN_AND_PUN_MISMATCH, sLUNRes, propertyRestriction);
            }
        }
        if (null == hierRec && null != sHUNRes && null == (hierRec = this.getHierarchyRecord(odboConn, restrictions, sHUNRes))) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_CANNOT_FIND_HIERARCHY, (Object)sHUNRes, restrictions.getValueOf(RestrictionType.CATALOG), restrictions.getValueOf(RestrictionType.CUBE));
        }
        if (null != propertyRestriction) {
            if (hierRec.isParentChild()) {
                this.getPropertiesInternal(odboConn, restrictions, propertyRecords, hierRec, null);
            } else {
                this.getPropertiesInternal(odboConn, restrictions, propertyRecords, hierRec, levelRec);
            }
        } else if (null != sLUNRes) {
            if (!hierRec.isParentChild()) {
                this.getPropertiesInternal(odboConn, restrictions, propertyRecords, hierRec, levelRec);
            }
        } else if (null != sHUNRes) {
            this.getPropertiesForHierarchy(odboConn, restrictions, propertyRecords, hierRec);
        } else {
            List<HierarchyRecord> hierRecords = this.getHierarchies(odboConn, restrictions);
            for (HierarchyRecord currHier : hierRecords) {
                this.getPropertiesForHierarchy(odboConn, restrictions, propertyRecords, currHier);
            }
        }
        this.addFakeProperties(odboConn, originalRestrictions, propertyRecords, hierRec, levelRec);
        return MetadataUtil.applyFromSizeRestrictions(propertyRecords, (IRestrictions)restrictions);
    }

    private void validatePropertiesRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    private HierarchyRecord getHierarchyRecordFromPropRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        int lastLeftBracket;
        HierarchyRecord hierRec = null;
        String originalHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String sHUNRes = originalHUN;
        if (null != sHUNRes && null == (hierRec = this.getHierarchyRecord(odboConn, restrictions, sHUNRes))) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_CANNOT_FIND_HIERARCHY, (Object)sHUNRes, restrictions.getValueOf(RestrictionType.CATALOG), restrictions.getValueOf(RestrictionType.CUBE));
        }
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        if (null != propertyRestriction && (lastLeftBracket = propertyRestriction.lastIndexOf(STARTING_BRACKET)) >= 0) {
            String tempRes = propertyRestriction;
            propertyRestriction = tempRes.substring(lastLeftBracket + 1, tempRes.length() - 1);
            sHUNRes = tempRes.substring(0, lastLeftBracket - 1);
            hierRec = this.getHierarchyRecord(odboConn, restrictions, sHUNRes);
            if (null != hierRec) {
                restrictions.replace(RestrictionType.PROPERTY, (Object)propertyRestriction);
                if (null != originalHUN) {
                    if (!originalHUN.equals(hierRec.getUniqueName())) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_HUN_AND_PUN_MISMATCH, originalHUN, hierRec.getUniqueName());
                    }
                } else {
                    restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierRec.getUniqueName());
                }
            }
        }
        return hierRec;
    }

    private LevelRecord getLevelRecordFromPropRestrictions(ODBOConnection odboConn, IRestrictions restrictions, HierarchyRecord hierRec, String originalPUN) {
        int lastLeftBracket;
        LevelRecord levelRec = null;
        String originalLUN = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        String sLUNRes = originalLUN;
        if (null != sLUNRes && null == (levelRec = this.getLevelRecord(odboConn, restrictions, sLUNRes))) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_CANNOT_FIND_LEVEL, (Object)sLUNRes, restrictions.getValueOf(RestrictionType.CATALOG), restrictions.getValueOf(RestrictionType.CUBE));
        }
        if (null != originalPUN && (lastLeftBracket = originalPUN.lastIndexOf(STARTING_BRACKET)) >= 0) {
            String tempRes = originalPUN;
            originalPUN = tempRes.substring(lastLeftBracket + 1, tempRes.length() - 1);
            sLUNRes = tempRes.substring(0, lastLeftBracket - 1);
            levelRec = this.getLevelRecord(odboConn, restrictions, sLUNRes);
            if (null != levelRec) {
                restrictions.replace(RestrictionType.PROPERTY, (Object)originalPUN);
                if (null != originalLUN) {
                    if (!originalLUN.equals(levelRec.getUniqueName())) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_LUN_AND_PUN_MISMATCH, levelRec.getUniqueName(), originalLUN);
                    }
                } else {
                    restrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)levelRec.getUniqueName());
                }
            } else {
                if (null != originalLUN && null != hierRec && !hierRec.isParentChild()) {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_LUN_AND_PUN_MISMATCH, originalLUN, sLUNRes);
                }
                if (null == hierRec) {
                    String originalHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
                    String val = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
                    if (null != originalHUN) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_HUN_AND_PUN_MISMATCH, originalHUN, val);
                    }
                }
            }
        }
        return levelRec;
    }

    private void getPropertiesForHierarchy(ODBOConnection odboConn, IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec) {
        if (!hierRec.getUniqueName().equals(MEASURES_STRING)) {
            this.getPropertiesInternal(odboConn, restrictions, propertyRecords, hierRec, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPropertiesInternal(ODBOConnection odboConn, IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, LevelRecord levelRec) {
        ODBOCapabilities capabilities = odboConn.getCapabilities();
        restrictions.add(RestrictionType.HIERARCHY_UNIQUE_NAME, (Object)hierRec.getUniqueName());
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        ODBOConnection.CRestrictionArray cRestrictions = this.getPropertyRestrictions(odboConn, restrictions);
        long rowsetHandle = 0L;
        try {
            rowsetHandle = odboConn.getRowset("MDSCHEMA_PROPERTIES", cRestrictions.getSize(), cRestrictions.getArgs());
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.MET_PROVIDER_ERROR_GETTING_METADATA, "property", ex);
        }
        finally {
            cRestrictions.release();
        }
        int posCubeName = -1;
        int posName = -1;
        int posDescription = -1;
        int posCaption = -1;
        int posDUN = -1;
        int posLUN = -1;
        int posDataType = -1;
        int posScale = -1;
        int posPrecision = -1;
        LevelRecord currLevelRec = levelRec;
        try (ODBORowset rows = new ODBORowset(odboConn, rowsetHandle);){
            int columnCount = rows.getColumnCount();
            String[] columnNames = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                columnNames[i] = rows.getColumnName(i);
                if (columnNames[i].equals("CUBE_NAME")) {
                    posCubeName = i;
                    continue;
                }
                if (columnNames[i].equals("PROPERTY_NAME")) {
                    posName = i;
                    continue;
                }
                if (columnNames[i].equals("DESCRIPTION")) {
                    posDescription = i;
                    continue;
                }
                if (columnNames[i].equals("DIMENSION_UNIQUE_NAME")) {
                    posDUN = i;
                    continue;
                }
                if (columnNames[i].equals("LEVEL_UNIQUE_NAME")) {
                    posLUN = i;
                    continue;
                }
                if (columnNames[i].equals("PROPERTY_CAPTION")) {
                    posCaption = i;
                    continue;
                }
                if (columnNames[i].equals("NUMERIC_SCALE")) {
                    posScale = i;
                    continue;
                }
                if (columnNames[i].equals("NUMERIC_PRECISION")) {
                    posPrecision = i;
                    continue;
                }
                if (!columnNames[i].equals("DATA_TYPE")) continue;
                posDataType = i;
            }
            String sDUN = "";
            String sLUN = "";
            int scale = 0;
            int precision = 0;
            while (rows.getNextRow()) {
                Long longValue;
                String value;
                String uniqueName;
                String propertyName;
                if (posName != -1) {
                    propertyName = rows.getStringColumn(posName, true);
                    if (propertyName == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "PROPERTY_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "PROPERTY_NAME");
                }
                currLevelRec = levelRec;
                if (posLUN != -1) {
                    sLUN = rows.getStringColumn(posLUN, true);
                }
                if (posDUN != -1) {
                    sDUN = rows.getStringColumn(posDUN, true);
                    if (sDUN == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DIMENSION_UNIQUE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DIMENSION_UNIQUE_NAME");
                }
                if (!capabilities.canFakeMemberKey()) {
                    if (propertyName.equals("KEY0")) {
                        this.createKey0Property(odboConn, restrictions, propertyRecords, new DimensionalRecords(hierRec, currLevelRec), sDUN, sLUN);
                    } else if (propertyName.equals("KEY1")) {
                        this.updateMultiPartKeyProperty(propertyRecords, hierRec, sLUN);
                    }
                }
                if (this.skipProperty(propertyName, propertyRestriction) || this.doesPropertyRecordExist(propertyRecords, hierRec, uniqueName = this.createPropertyUniqueName(hierRec, propertyName, sLUN))) continue;
                PropertyRecord property = new PropertyRecord();
                property.setName(propertyName);
                property.setHierarchyUniqueName(hierRec.getUniqueName());
                if (!hierRec.isParentChild()) {
                    property.setLevelUniqueName(sLUN);
                }
                property.setUniqueName(uniqueName);
                property.setDimensionUniqueName(sDUN);
                if (posDescription != -1) {
                    value = rows.getStringColumn(posDescription, false);
                    property.setDescription(value);
                }
                if (posCaption != -1) {
                    value = rows.getStringColumn(posCaption, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "PROPERTY_CAPTION");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "PROPERTY_CAPTION");
                }
                LocalizedString localizedCaption = this.getLocalizedString(value);
                property.setCaption((ILocalizedString)localizedCaption);
                scale = 0;
                if (posScale != -1 && (longValue = rows.getLongColumn(posScale)) != null) {
                    scale = longValue.intValue();
                }
                precision = 0;
                if (posPrecision != -1 && (longValue = rows.getLongColumn(posPrecision)) != null) {
                    precision = longValue.intValue();
                }
                if (posDataType != -1) {
                    longValue = rows.getLongColumn(posDataType);
                    if (longValue == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "DATA_TYPE");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "DATA_TYPE");
                }
                this.setPropertyDatatypeInfo(property, longValue.intValue(), precision, scale);
                property.setUniqueId(RecordType.PROPERTY, property.getUniqueName());
                property.setCatalogName(this.getCatalogNameFromConnection(odboConn));
                if (posCubeName != -1) {
                    value = rows.getStringColumn(posCubeName, true);
                    if (value == null) {
                        throw new ODBORuntimeException(ODBOMessageKeys.MET_NULL_METADATA_COLUMN, "CUBE_NAME");
                    }
                } else {
                    throw new ODBORuntimeException(ODBOMessageKeys.MET_MISSING_METADATA_COLUMN, "CUBE_NAME");
                }
                property.setCubeName(value);
                propertyRecords.add(property);
            }
        }
    }

    private boolean doesPropertyRecordExist(List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, String uniqueName) {
        boolean foundProp = false;
        if (hierRec.isParentChild()) {
            for (PropertyRecord prop : propertyRecords) {
                if (!prop.getUniqueName().equals(uniqueName) || !prop.getHierarchyUniqueName().equals(hierRec.getUniqueName())) continue;
                foundProp = true;
                break;
            }
        }
        return foundProp;
    }

    private String createPropertyUniqueName(HierarchyRecord hierRec, String propertyName, String sLUN) {
        StringBuilder uniqueName = new StringBuilder();
        if (!hierRec.isParentChild()) {
            uniqueName.append(sLUN);
        } else {
            uniqueName.append(hierRec.getUniqueName());
        }
        uniqueName.append(".[");
        uniqueName.append(propertyName);
        uniqueName.append(ENDING_BRACKET);
        return uniqueName.toString();
    }

    private void updateMultiPartKeyProperty(List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, String sLUN) {
        if (!hierRec.isParentChild()) {
            for (PropertyRecord prop : propertyRecords) {
                if (!prop.getName().equals("MEMBER_KEY") || null == prop.getLevelUniqueName() || !prop.getLevelUniqueName().equals(sLUN)) continue;
                prop.setRoleType(RoleTypeEnum.MULTI_PART_BUSINESS_KEY);
            }
        }
    }

    private void createKey0Property(ODBOConnection odboConn, IRestrictions restrictions, List<PropertyRecord> propertyRecords, DimensionalRecords dimensionalRecords, String sDUN, String levelUniqueName) {
        LevelRecord currLevelRec = dimensionalRecords.levelRec;
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        if (null != propertyRestriction && !propertyRestriction.equals("MEMBER_KEY")) {
            return;
        }
        StringBuilder newCaption = new StringBuilder();
        if (!dimensionalRecords.hierRec.isParentChild()) {
            LocalizedString levelCaption;
            if (null == currLevelRec) {
                currLevelRec = this.getLevelRecord(odboConn, restrictions, levelUniqueName);
            }
            if ((levelCaption = currLevelRec.getCaption()) != null) {
                newCaption.append(levelCaption.toString());
            }
            newCaption.append(KEY_SUFFIX);
        } else {
            newCaption.append(dimensionalRecords.hierRec.getCaption().toString());
            newCaption.append(KEY_SUFFIX);
            String sCaption = newCaption.toString();
            for (PropertyRecord prop : propertyRecords) {
                if (!prop.getCaption().equals((Object)sCaption) || !prop.getHierarchyUniqueName().equals(dimensionalRecords.hierRec.getUniqueName())) continue;
                return;
            }
        }
        LocalizedString localizedCaption = this.getLocalizedString(newCaption.toString());
        String sLUN = null;
        if (null != dimensionalRecords.hierRec && !dimensionalRecords.hierRec.isParentChild()) {
            sLUN = levelUniqueName;
        }
        PropertyRecord property = this.createFakeProperty("MEMBER_KEY", sDUN, dimensionalRecords.hierRec.getUniqueName(), sLUN, RoleTypeEnum.BUSINESS_KEY, (IDataType)StringType.DEFAULTSTRINGTYPE, localizedCaption);
        property.setCatalogName(this.getCatalogNameFromConnection(odboConn));
        property.setCubeName((String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class));
        propertyRecords.add(property);
    }

    protected ODBOConnection.CRestrictionArray getPropertyRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOConnection oDBOConnection = odboConn;
        ((Object)((Object)oDBOConnection)).getClass();
        ODBOConnection.CRestrictionArray cRestrictions = oDBOConnection.new ODBOConnection.CRestrictionArray(PropertyRestrictions.values().length);
        String resCatalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String resCubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        String resDUN = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME);
        String resHUN = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME);
        String resLUN = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME);
        String resProperty = (String)restrictions.getValueOf(RestrictionType.PROPERTY);
        cRestrictions.set(PropertyRestrictions.CATALOG.ordinal(), resCatalogName);
        cRestrictions.setEmpty(PropertyRestrictions.SCHEMA.ordinal());
        cRestrictions.set(PropertyRestrictions.CUBE.ordinal(), resCubeName);
        ODBOCapabilities capabilities = odboConn.getCapabilities();
        if (null != resDUN && !capabilities.canDisableDimForProperties()) {
            cRestrictions.set(PropertyRestrictions.DIMENSION_UNIQUE_NAME.ordinal(), resDUN);
        } else {
            cRestrictions.setEmpty(PropertyRestrictions.DIMENSION_UNIQUE_NAME.ordinal());
        }
        if (null != resProperty && resProperty.equals("MEMBER_KEY")) {
            resProperty = null;
        }
        cRestrictions.set(PropertyRestrictions.HIERARCHY_UNIQUE_NAME.ordinal(), resHUN);
        if (null != resLUN) {
            cRestrictions.set(PropertyRestrictions.LEVEL_UNIQUE_NAME.ordinal(), resLUN);
        } else {
            cRestrictions.setEmpty(PropertyRestrictions.LEVEL_UNIQUE_NAME.ordinal());
        }
        cRestrictions.setEmpty(PropertyRestrictions.MEMBER_UNIQUE_NAME.ordinal());
        if (null != resProperty) {
            cRestrictions.set(PropertyRestrictions.PROPERTY.ordinal(), resProperty);
        } else {
            cRestrictions.setEmpty(PropertyRestrictions.PROPERTY.ordinal());
        }
        return cRestrictions;
    }

    private void addFakeProperties(ODBOConnection odboConn, IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, LevelRecord levelRec) {
        ODBOCapabilities capabilities;
        String sHUNRes = null;
        if (null != hierRec) {
            sHUNRes = hierRec.getUniqueName();
        }
        if (null != levelRec) {
            sHUNRes = levelRec.getHierarchyUniqueName();
        }
        if ((capabilities = odboConn.getCapabilities()).canFakeMemberKey()) {
            this.addFakeMemberKey(odboConn, restrictions, propertyRecords, hierRec, levelRec, sHUNRes);
        }
        this.addFakeRollupTypeProperty(odboConn, restrictions, propertyRecords);
        this.addFakePPDSCodeProperty(odboConn, restrictions, propertyRecords);
    }

    private void addFakePPDSCodeProperty(ODBOConnection odboConn, IRestrictions restrictions, List<PropertyRecord> propertyRecords) {
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY, null);
        if (propertyRestriction == null || propertyRestriction.length() == 0 || propertyRestriction.equals("PPDS_CODE")) {
            String dunRestriction = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
            String hunRestriction = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
            LocalizedString propCaption = this.getLocalizedString("PPDS_CODE");
            PropertyRecord property = this.createFakeProperty("PPDS_CODE", dunRestriction, hunRestriction, null, RoleTypeEnum.PPDS_CODE, (IDataType)StringType.DEFAULTSTRINGTYPE, propCaption);
            property.setCatalogName(this.getCatalogNameFromConnection(odboConn));
            property.setCubeName((String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class));
            propertyRecords.add(property);
        }
    }

    private void addFakeRollupTypeProperty(ODBOConnection odboConn, IRestrictions restrictions, List<PropertyRecord> propertyRecords) {
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY, null);
        if (propertyRestriction == null || propertyRestriction.length() == 0 || propertyRestriction.equals("_rollupType")) {
            String dunRestriction = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
            String hunRestriction = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
            LocalizedString propCaption = this.getLocalizedString("_rollupType");
            PropertyRecord property = this.createFakeProperty("_rollupType", dunRestriction, hunRestriction, null, RoleTypeEnum.MEMBER_ROLLUP, (IDataType)StringType.DEFAULTSTRINGTYPE, propCaption);
            property.setCatalogName(this.getCatalogNameFromConnection(odboConn));
            property.setCubeName((String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class));
            propertyRecords.add(property);
        }
    }

    private void addFakeMemberKey(ODBOConnection odboConn, IRestrictions restrictions, List<PropertyRecord> propertyRecords, HierarchyRecord hierRec, LevelRecord levelRec, String sHUNRes) {
        String propertyRestriction = (String)restrictions.getValueOf(RestrictionType.PROPERTY, null);
        String lunRestriction = (String)restrictions.getValueOf(RestrictionType.LEVEL_UNIQUE_NAME, null);
        String dunRestriction = (String)restrictions.getValueOf(RestrictionType.DIMENSION_UNIQUE_NAME, null);
        String hunRestriction = (String)restrictions.getValueOf(RestrictionType.HIERARCHY_UNIQUE_NAME, null);
        if (propertyRestriction == null || propertyRestriction.length() == 0 || propertyRestriction.equals("MEMBER_KEY")) {
            StringBuilder newCaption = new StringBuilder();
            if (null != lunRestriction && lunRestriction.length() > 0) {
                if (null != levelRec) {
                    newCaption.append(levelRec.getCaption().toString());
                    newCaption.append(KEY_SUFFIX);
                }
            } else if (null != sHUNRes && sHUNRes.length() > 0) {
                if (null != hierRec) {
                    newCaption.append(hierRec.getCaption().toString());
                    newCaption.append(KEY_SUFFIX);
                }
            } else {
                newCaption.append("MEMBER_KEY");
            }
            LocalizedString propCaption = this.getLocalizedString(newCaption.toString());
            String sLUN = null;
            if (null != hierRec && !hierRec.isParentChild()) {
                sLUN = lunRestriction;
            }
            PropertyRecord property = this.createFakeProperty("MEMBER_KEY", dunRestriction, hunRestriction, sLUN, RoleTypeEnum.BUSINESS_KEY, (IDataType)StringType.DEFAULTSTRINGTYPE, propCaption);
            property.setCatalogName(this.getCatalogNameFromConnection(odboConn));
            property.setCubeName((String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class));
            propertyRecords.add(property);
        }
    }

    private LevelRecord getLevelRecord(ODBOConnection odboConn, IRestrictions restrictions, String sLUN) {
        MetadataRestriction newRestrictions = new MetadataRestriction();
        newRestrictions.add(RestrictionType.CATALOG, restrictions.getValueOf(RestrictionType.CATALOG));
        newRestrictions.add(RestrictionType.CUBE, restrictions.getValueOf(RestrictionType.CUBE));
        newRestrictions.add(RestrictionType.LEVEL_UNIQUE_NAME, (Object)sLUN);
        List<LevelRecord> levels = this.getLevels(odboConn, (IRestrictions)newRestrictions);
        if (!levels.isEmpty()) {
            return levels.get(0);
        }
        return null;
    }

    private PropertyRecord createFakeProperty(String propertyName, String sDUN, String sHUN, String sLUN, RoleTypeEnum roleType, IDataType dataType, LocalizedString caption) {
        PropertyRecord property = new PropertyRecord();
        property.setUniqueName(propertyName);
        if (null != sDUN) {
            property.setDimensionUniqueName(sDUN);
        }
        if (null != sHUN) {
            property.setHierarchyUniqueName(sHUN);
        }
        if (null != sLUN) {
            property.setLevelUniqueName(sLUN);
        }
        property.setName(propertyName);
        property.setRoleType(roleType);
        property.setUniqueId(RecordType.PROPERTY, propertyName);
        property.setDataType(dataType);
        property.setCaption((ILocalizedString)caption);
        return property;
    }

    private boolean skipProperty(String propertyName, String propertyRestriction) {
        boolean skipThisProperty = false;
        if (propertyRestriction != null && propertyRestriction.equals("MEMBER_KEY")) {
            skipThisProperty = true;
        } else if (propertyName.equals("MEMBER_VALUE")) {
            skipThisProperty = true;
        } else if (propertyName.equals("SKIPPED_LEVELS")) {
            skipThisProperty = true;
        } else if (propertyName.equals("CUSTOM_ROLLUP")) {
            skipThisProperty = true;
        } else if (propertyName.equals("NAME")) {
            skipThisProperty = true;
        } else if (propertyName.equals("UNARY_OPERATOR")) {
            skipThisProperty = true;
        } else if (propertyName.startsWith("KEY")) {
            String afterKey = propertyName.substring("KEY".length());
            skipThisProperty = true;
            try {
                Integer.parseInt(afterKey);
            }
            catch (NumberFormatException e) {
                skipThisProperty = false;
            }
        } else if (propertyName.startsWith("TRAN")) {
            String afterKey = propertyName.substring("TRAN".length());
            skipThisProperty = true;
            try {
                Integer.parseInt(afterKey);
            }
            catch (NumberFormatException e) {
                skipThisProperty = false;
            }
        }
        return skipThisProperty;
    }

    protected static void throwRestrictionMissing(RestrictionType restrictionType) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, restrictionType.toString());
    }

    private static MDXQueryArguments makeMDXQueryArguments(Locale runLocale) {
        MDXQuery mdxQuery = new MDXQuery();
        return new MDXQueryArguments(null, mdxQuery, runLocale, null);
    }

    private static void logMetadataCacheHit(MetadataOperation mdOperation, IRestrictions restrictions) {
        XQELogger logger = ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA_CACHE);
        if (logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LOGMSG_MDCACHE_HIT).append(mdOperation);
            buffer.append(LOGMSG_WITH_RESTRICTIONS).append(restrictions);
            logger.log(LogLevel.INFO, buffer.toString());
        }
    }

    private static void logMetadataCacheMiss(MetadataOperation mdOperation, IRestrictions restrictions) {
        XQELogger logger = ODBOLog.getLogger(ODBOLogEnum.LOG_PROVIDER_METADATA_CACHE);
        if (logger.isOn(LogLevel.INFO)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(LOGMSG_MDCACHE_MISS).append(mdOperation);
            buffer.append(LOGMSG_WITH_RESTRICTIONS).append(restrictions);
            logger.log(LogLevel.INFO, buffer.toString());
        }
    }

    protected String getCubeDefaultMeasure(ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateCubeDefaultMeasureRestrictions(odboConn, restrictions);
        String catalogName = (String)restrictions.getValueOf(RestrictionType.CATALOG);
        String cubeName = (String)restrictions.getValueOf(RestrictionType.CUBE);
        return this.getCubeDefaultMeasureInternal(odboConn, catalogName, cubeName);
    }

    private void validateCubeDefaultMeasureRestrictions(ODBOConnection odboConn, IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CATALOG);
        }
        if (!restrictions.contains(RestrictionType.CUBE)) {
            ODBOMetadataHandler.throwRestrictionMissing(RestrictionType.CUBE);
        }
        this.validateCatalogNames(odboConn, restrictions);
    }

    public void release() {
    }

    private static class DimensionalRecords {
        final HierarchyRecord hierRec;
        final LevelRecord levelRec;

        DimensionalRecords(HierarchyRecord hierRecord, LevelRecord levelRecord) {
            this.hierRec = hierRecord;
            this.levelRec = levelRecord;
        }
    }

    public static enum PropertyRestrictions {
        CATALOG,
        SCHEMA,
        CUBE,
        DIMENSION_UNIQUE_NAME,
        HIERARCHY_UNIQUE_NAME,
        LEVEL_UNIQUE_NAME,
        MEMBER_UNIQUE_NAME,
        PROPERTY;

    }

    public static enum NamedSetRestrictions {
        CATALOG,
        SCHEMA,
        CUBE,
        SET,
        SCOPE;

    }

    public static enum MemberRestrictions {
        CATALOG,
        SCHEMA,
        CUBE,
        DIMENSION_UNIQUE_NAME,
        HIERARCHY_UNIQUE_NAME,
        LEVEL_UNIQUE_NAME,
        LEVEL_NUMBER,
        MEMBER_NAME_RESTRICTION,
        MEMBER_UNIQUE_NAME,
        MEMBER_CAPTION,
        MEMBER_TYPE,
        TREEOP;

    }

    public static enum MeasureRestrictions {
        CATALOG,
        SCHEMA,
        CUBE,
        MEASURE_NAME,
        MEASURE_UNIQUE_NAME;

    }

    public static enum LevelRestrictions {
        CATALOG,
        SCHEMA,
        CUBE,
        DIMENSION_UNIQUE_NAME,
        HIERARCHY_UNIQUE_NAME,
        LEVEL_NAME,
        LEVEL_UNIQUE_NAME;

    }

    public static enum HierarchyRestrictions {
        CATALOG,
        SCHEMA,
        CUBE,
        DIMENSION_UNIQUE_NAME,
        HIERARCHY_NAME,
        HIERARCHY_UNIQUE_NAME;

    }

    public static enum DimensionRestrictions {
        CATALOG,
        SCHEMA,
        CUBE,
        DIMENSION_NAME,
        DIMENSION_UNIQUE_NAME;

    }

    public static enum CubeRestrictions {
        CATALOG,
        SCHEMA,
        CUBE;

    }

    public static enum CatalogRestrictions {
        CATALOG;

    }

    public static enum ActionRestrictions {
        CATALOG,
        SCHEMA,
        CUBE,
        ACTION_NAME,
        ACTION_TYPE,
        COORDINATE,
        COORDINATE_TYPE;

    }
}

