/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo;

import com.cognos.xqe.data.providers.connection.parameters.CatalogParameter;
import com.cognos.xqe.data.providers.connection.parameters.CubeParameter;
import com.cognos.xqe.data.providers.connection.parameters.UpperCaseCatalogParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.IRestrictions;
import com.cognos.xqe.data.providers.olap.MetadataProviderEnvironmentHelper;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.RestrictionType;
import com.cognos.xqe.data.providers.olap.cache.CacheParameters;
import com.cognos.xqe.data.providers.olap.odbo.DataSourceLocaleParameter;
import com.cognos.xqe.data.providers.olap.odbo.ODBOConnection;
import com.cognos.xqe.data.providers.olap.odbo.ODBODataProvider;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMetadataHandler;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.olap.odbo.concurrent.ODBOThreadContext;
import com.cognos.xqe.data.providers.secbridge.ErrorStatus;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.record.ActionRecord;
import com.cognos.xqe.metadata.record.AliasRecord;
import com.cognos.xqe.metadata.record.CatalogRecord;
import com.cognos.xqe.metadata.record.CubeRecord;
import com.cognos.xqe.metadata.record.DimensionRecord;
import com.cognos.xqe.metadata.record.HierarchyRecord;
import com.cognos.xqe.metadata.record.LevelRecord;
import com.cognos.xqe.metadata.record.MacroRecord;
import com.cognos.xqe.metadata.record.MeasureRecord;
import com.cognos.xqe.metadata.record.MemberRecord;
import com.cognos.xqe.metadata.record.NamedSetRecord;
import com.cognos.xqe.metadata.record.PropertyRecord;
import com.cognos.xqe.metadata.record.VariableRecord;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.util.context.ContextTransfer;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;

public class ODBOMetadataProvider
extends MetadataProviderEnvironmentHelper<ODBOConnection>
implements IOLAPMetadataProvider {
    private final AtomicBoolean released = new AtomicBoolean(false);
    protected String providerType;
    protected boolean upperCaseCatalog;
    private final Locale runLocale;

    public ODBOMetadataProvider(ODBODataProvider theDataProvider, MetadataQueryArguments theQueryArgs, ConnectionParameters theConnectionParams) {
        super((OLAPDataProviderBase)theDataProvider, theConnectionParams);
        this.runLocale = (Locale)theConnectionParams.valueOf(DataSourceLocaleParameter.class, Locale.class);
        this.providerType = theQueryArgs.getDataSource().getType();
        this.upperCaseCatalog = theQueryArgs.getDataSource().getCapabilities().isSupported("olap.metadata.caseInsensitiveCatalog");
        if (ODBOLog.isOn("Metadata")) {
            ODBOLog.getLogger("Metadata").log("Constructing metadata provider for " + this.providerType);
        }
    }

    public void releaseImpl() {
        block3: {
            try {
                if (ODBOLog.isOn("Metadata")) {
                    ODBOLog.getLogger("Metadata").log("Releasing metadata connection.");
                }
                this.released.set(true);
            }
            catch (Exception e) {
                if (!ODBOLog.isOn(LogLevel.ERROR)) break block3;
                ODBOLog.getLogger().log(LogLevel.ERROR, (Throwable)e);
            }
        }
    }

    private void fixCatalogNameCase(IRestrictions restrictions) {
        String catalogName;
        String upperCaseCatalogName = (String)this.connectionParameters.valueOf(UpperCaseCatalogParameter.class, String.class);
        if (null != upperCaseCatalogName && (catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class)) != null) {
            restrictions.add(RestrictionType.CATALOG, (Object)upperCaseCatalogName);
        }
    }

    public CacheParameters getCacheParameters(IRestrictions restrictions) {
        this.fixCatalogNameCase(restrictions);
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        String cubeName = (String)restrictions.getTypedValueOf(RestrictionType.CUBE, String.class);
        ConnectionParameters connParams = this.connectionParameters.duplicate();
        connParams.remove(UpperCaseCatalogParameter.class);
        connParams.remove(CatalogParameter.class);
        connParams.remove(CubeParameter.class);
        CacheParameters cacheParams = new CacheParameters();
        cacheParams.put(this.connectionParameters);
        cacheParams.put("FACTORY_NAME", (Object)"MSASCacheFactory");
        if (null != catalogName) {
            cacheParams.put("catalog", (Object)catalogName);
        }
        if (null != cubeName) {
            cacheParams.put("cube", (Object)cubeName);
        }
        return cacheParams;
    }

    protected List<ActionRecord> getActions(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetActions(executionEnvironment, odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving actions: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<ActionRecord> nativeGetActions(final ExecutionEnvironment executionEnvironment, final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<ActionRecord>> task = new Callable<List<ActionRecord>>(){

                @Override
                public List<ActionRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetActions(executionEnvironment, odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetActions(executionEnvironment, odboConn, restrictions);
    }

    private List<ActionRecord> internalGetActions(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetActions restrictions: " + newRestrictions.toString());
            }
            List<ActionRecord> list = metadataHandler.getActions(executionEnvironment, odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetActions failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<AliasRecord> getAliases(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        if (ODBOLog.isOn("Metadata")) {
            ODBOLog.getLogger("Metadata").log("Aliases are not supported in MSAS.");
        }
        return Collections.emptyList();
    }

    protected List<String> getDatasourceLocales(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateDatasourceLocalesRestrictions(restrictions);
        return Collections.emptyList();
    }

    private void validateDatasourceLocalesRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    protected List<CatalogRecord> getCatalogs(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetCatalogs(odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving catalogs: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<CatalogRecord> nativeGetCatalogs(final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<CatalogRecord>> task = new Callable<List<CatalogRecord>>(){

                @Override
                public List<CatalogRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetCatalogs(odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetCatalogs(odboConn, restrictions);
    }

    private List<CatalogRecord> internalGetCatalogs(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetCatalogs restrictions: " + restrictions.toString());
            }
            List<CatalogRecord> list = metadataHandler.getCatalogs(odboConn, restrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetCatalogs failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<CubeRecord> getCubes(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetCubes(odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving cubes: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<CubeRecord> nativeGetCubes(final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<CubeRecord>> task = new Callable<List<CubeRecord>>(){

                @Override
                public List<CubeRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetCubes(odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetCubes(odboConn, restrictions);
    }

    private List<CubeRecord> internalGetCubes(ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetCubes restrictions: " + newRestrictions.toString());
            }
            List<CubeRecord> list = metadataHandler.getCubes(odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetCubes failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<DimensionRecord> getDimensions(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetDimensions(odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving dimensions: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<DimensionRecord> nativeGetDimensions(final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<DimensionRecord>> task = new Callable<List<DimensionRecord>>(){

                @Override
                public List<DimensionRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetDimensions(odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetDimensions(odboConn, restrictions);
    }

    private List<DimensionRecord> internalGetDimensions(ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetDimensions restrictions: " + newRestrictions.toString());
            }
            List<DimensionRecord> list = metadataHandler.getDimensions(odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetDimensions failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<HierarchyRecord> getHierarchies(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetHierarchies(odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving hierarchies: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<HierarchyRecord> nativeGetHierarchies(final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<HierarchyRecord>> task = new Callable<List<HierarchyRecord>>(){

                @Override
                public List<HierarchyRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetHierarchies(odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetHierarchies(odboConn, restrictions);
    }

    private List<HierarchyRecord> internalGetHierarchies(ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetHierarchies restrictions: " + newRestrictions.toString());
            }
            List<HierarchyRecord> list = metadataHandler.getHierarchies(odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetHierarchies failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<MemberRecord> getHierarchyRootMembers(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetHierarchyRootMembers(executionEnvironment, odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving hierarchy root members: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<MemberRecord> nativeGetHierarchyRootMembers(final ExecutionEnvironment executionEnvironment, final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<MemberRecord>> task = new Callable<List<MemberRecord>>(){

                @Override
                public List<MemberRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetHierarchyRootMembers(executionEnvironment, odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetHierarchyRootMembers(executionEnvironment, odboConn, restrictions);
    }

    private List<MemberRecord> internalGetHierarchyRootMembers(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetHierarchyRootMembers restrictions: " + newRestrictions.toString());
            }
            List<MemberRecord> list = metadataHandler.getHierarchyRootMembers(executionEnvironment, odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetHierarchyRootMembers failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<LevelRecord> getLevels(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetLevels(odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving levels: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<LevelRecord> nativeGetLevels(final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<LevelRecord>> task = new Callable<List<LevelRecord>>(){

                @Override
                public List<LevelRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetLevels(odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetLevels(odboConn, restrictions);
    }

    private List<LevelRecord> internalGetLevels(ODBOConnection odboConn, IRestrictions restrictions) {
        ODBOMetadataHandler metadataHandler = null;
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetLevels restrictions: " + newRestrictions.toString());
            }
            List<LevelRecord> list = metadataHandler.getLevels(odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetLevels failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<MacroRecord> getMacros(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        if (ODBOLog.isOn("Metadata")) {
            ODBOLog.getLogger("Metadata").log("Macros metadata not supported in MSAS.");
        }
        return Collections.emptyList();
    }

    protected List<MeasureRecord> getMeasures(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetMeasures(odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving measures: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<MeasureRecord> nativeGetMeasures(final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<MeasureRecord>> task = new Callable<List<MeasureRecord>>(){

                @Override
                public List<MeasureRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetMeasures(odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetMeasures(odboConn, restrictions);
    }

    private List<MeasureRecord> internalGetMeasures(ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetMeasures restrictions: " + newRestrictions.toString());
            }
            List<MeasureRecord> list = metadataHandler.getMeasures(odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetMeasures failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<MemberRecord> getMembers(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetMembers(executionEnvironment, odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving members: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<MemberRecord> nativeGetMembers(final ExecutionEnvironment executionEnvironment, final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<MemberRecord>> task = new Callable<List<MemberRecord>>(){

                @Override
                public List<MemberRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetMembers(executionEnvironment, odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetMembers(executionEnvironment, odboConn, restrictions);
    }

    private List<MemberRecord> internalGetMembers(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetMembers restrictions: " + newRestrictions.toString());
            }
            List<MemberRecord> list = metadataHandler.getMembers(executionEnvironment, odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetMembers failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<PropertyRecord> getProperties(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetProperties(odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving properties: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<PropertyRecord> nativeGetProperties(final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<PropertyRecord>> task = new Callable<List<PropertyRecord>>(){

                @Override
                public List<PropertyRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetProperties(odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetProperties(odboConn, restrictions);
    }

    private List<PropertyRecord> internalGetProperties(ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetProperties restrictions: " + newRestrictions.toString());
            }
            List<PropertyRecord> list = metadataHandler.getProperties(odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetProperties failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<NamedSetRecord> getNamedSets(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetNamedSets(odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving named sets: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<NamedSetRecord> nativeGetNamedSets(final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<NamedSetRecord>> task = new Callable<List<NamedSetRecord>>(){

                @Override
                public List<NamedSetRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetNamedSets(odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetNamedSets(odboConn, restrictions);
    }

    private List<NamedSetRecord> internalGetNamedSets(ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetNamedSets restrictions: " + newRestrictions.toString());
            }
            List<NamedSetRecord> list = metadataHandler.getNamedSets(odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetNamedSets failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<String> getNamedSetLevelUniqueNames(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetNamedSetLevelUniqueNames(executionEnvironment, odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving named set level unique names: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<String> nativeGetNamedSetLevelUniqueNames(final ExecutionEnvironment executionEnvironment, final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<String>> task = new Callable<List<String>>(){

                @Override
                public List<String> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetNamedSetLevelUniqueNames(executionEnvironment, odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetNamedSetLevelUniqueNames(executionEnvironment, odboConn, restrictions);
    }

    private List<String> internalGetNamedSetLevelUniqueNames(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetNamedSetLevelUniqueNames restrictions: " + newRestrictions.toString());
            }
            List<String> list = metadataHandler.getNamedSetLevelUniqueNames(executionEnvironment, odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetNamedSetLevelUniqueNames failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<MemberRecord> getNamedSetMembers(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetNamedSetMembers(executionEnvironment, odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving named set members: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected List<MemberRecord> nativeGetNamedSetMembers(final ExecutionEnvironment executionEnvironment, final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<List<MemberRecord>> task = new Callable<List<MemberRecord>>(){

                @Override
                public List<MemberRecord> call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        List list = ODBOMetadataProvider.this.internalGetNamedSetMembers(executionEnvironment, odboConn, restrictions);
                        return list;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalGetNamedSetMembers(executionEnvironment, odboConn, restrictions);
    }

    private List<MemberRecord> internalGetNamedSetMembers(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalGetNamedSetMembers restrictions: " + newRestrictions.toString());
            }
            List<MemberRecord> list = metadataHandler.getNamedSetMembers(executionEnvironment, odboConn, newRestrictions);
            return list;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalGetNamedSetMembers failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    protected List<VariableRecord> getVariables(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        this.validateVariableRestrictions(restrictions);
        if (ODBOLog.isOn("Metadata")) {
            ODBOLog.getLogger("Metadata").log("Variables metadata not supported in MSAS.");
        }
        return Collections.emptyList();
    }

    private void validateVariableRestrictions(IRestrictions restrictions) {
        if (!restrictions.contains(RestrictionType.CUBE)) {
            ODBOMetadataProvider.throwRestrictionMissing(RestrictionType.CUBE);
        }
        if (!restrictions.contains(RestrictionType.CATALOG)) {
            ODBOMetadataProvider.throwRestrictionMissing(RestrictionType.CATALOG);
        }
    }

    protected static void throwRestrictionMissing(RestrictionType restrictionType) throws XQERuntimeException {
        throw new XQERuntimeException(XQEMessageKeys.MD_RestrictionMissing, restrictionType.toString());
    }

    protected String getCubeDefaultMeasure(ExecutionEnvironment executionEnvironment, ODBOConnection odboConn, IRestrictions restrictions) {
        try {
            return this.nativeGetCubeDefaultMeasure(odboConn, restrictions);
        }
        catch (NativeException ex) {
            ErrorStatus status = ex.getErrorStatus();
            if (ODBOLog.isOn("Metadata", LogLevel.ERROR)) {
                StringBuilder msgBuffer = new StringBuilder();
                msgBuffer.append("Error retrieving cube default measure: ").append(status);
                ODBOLog.getLogger("DataQuery").log(LogLevel.ERROR, msgBuffer.toString());
            }
            odboConn.checkForLostConnection(status);
            throw new ODBORuntimeException(ODBOMessageKeys.GEN_GENERAL_PROVIDER_ERROR, ex);
        }
    }

    protected String nativeGetCubeDefaultMeasure(final ODBOConnection odboConn, final IRestrictions restrictions) throws NativeException {
        if (!ODBOThreadContext.isODBOThread()) {
            final ContextTransfer traceCtxTransfer = TraceContext.createTransfer();
            final ContextTransfer execEnvTransfer = ExecutionEnvironmentContext.createTransfer();
            Callable<String> task = new Callable<String>(){

                @Override
                public String call() throws NativeException {
                    traceCtxTransfer.push();
                    execEnvTransfer.push();
                    try {
                        String string = ODBOMetadataProvider.this.internalCubeDefaultMeasure(odboConn, restrictions);
                        return string;
                    }
                    finally {
                        execEnvTransfer.pop();
                        traceCtxTransfer.pop();
                    }
                }
            };
            return odboConn.invokeNativeCall(task);
        }
        return this.internalCubeDefaultMeasure(odboConn, restrictions);
    }

    private String internalCubeDefaultMeasure(ODBOConnection odboConn, IRestrictions restrictions) {
        IRestrictions newRestrictions = restrictions.duplicate();
        String catalogName = (String)restrictions.getTypedValueOf(RestrictionType.CATALOG, String.class);
        if (catalogName != null) {
            if (this.upperCaseCatalog) {
                catalogName = catalogName.toUpperCase(this.runLocale);
            }
            newRestrictions.remove(RestrictionType.CATALOG);
            newRestrictions.add(RestrictionType.CATALOG, (Object)catalogName);
        }
        ODBOMetadataHandler metadataHandler = null;
        try {
            metadataHandler = new ODBOMetadataHandler(this.runLocale, this.providerType, this.connectionParameters);
            if (ODBOLog.isOn("Metadata", LogLevel.INFO)) {
                ODBOLog.getLogger("Metadata").log(LogLevel.INFO, "ODBOMetadataProvider.internalCubeDefaultMeasure restrictions: " + newRestrictions.toString());
            }
            String string = metadataHandler.getCubeDefaultMeasure(odboConn, newRestrictions);
            return string;
        }
        catch (ODBORuntimeException ex) {
            ODBOLog.getLogger("Metadata").log(LogLevel.ERROR, "ODBOMetadataProvider.internalCubeDefaultMeasure failed: ", (Throwable)((Object)ex));
            throw ex;
        }
        finally {
            if (metadataHandler != null) {
                metadataHandler.release();
            }
        }
    }

    public List<MemberRecord> getHierarchyCalculatedMembers(IRestrictions restrictions) {
        return Collections.emptyList();
    }
}

