/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.odbo.concurrent;

import com.cognos.xqe.data.providers.olap.odbo.ODBOConnection;
import com.cognos.xqe.data.providers.olap.odbo.ODBOLog;
import com.cognos.xqe.data.providers.olap.odbo.ODBOMessageKeys;
import com.cognos.xqe.data.providers.olap.odbo.ODBORuntimeException;
import com.cognos.xqe.data.providers.olap.odbo.concurrent.ODBOThreadContext;
import com.cognos.xqe.data.providers.secbridge.NativeException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELogger;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

public final class ODBOCOMThreadFactoryDecorator
implements ThreadFactory {
    private static final AtomicLong THREAD_COUNTER = new AtomicLong(0L);
    private final ThreadFactory sourceFactory;

    public ODBOCOMThreadFactoryDecorator(ThreadFactory theSourceFactory) {
        if (null == theSourceFactory) {
            throw new NullPointerException("theSourceFactory was null");
        }
        this.sourceFactory = theSourceFactory;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread comThread = this.sourceFactory.newThread(new ODBOThreadRunner(r));
        comThread.setName("ODBOCOMThread" + THREAD_COUNTER.getAndIncrement());
        comThread.setUncaughtExceptionHandler(new ThreadExceptionHandler());
        return comThread;
    }

    private static void initializeCOMThread() {
        try {
            ODBOConnection.cInitializeCOMThread();
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.COM_COM_THREAD_INIT_FAILED, ex);
        }
    }

    private static void terminateCOMThread() {
        try {
            ODBOConnection.cTerminateCOMThread();
        }
        catch (NativeException ex) {
            throw new ODBORuntimeException(ODBOMessageKeys.COM_COM_THREAD_TERM_FAILED, ex);
        }
    }

    private static class ThreadExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private ThreadExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            XQELogger logger = ODBOLog.getLogger("Exception");
            StringBuilder buffer = new StringBuilder();
            buffer.append("Detected an unhandled exception in thread ").append(thread.toString()).append(": ");
            logger.log(LogLevel.ERROR, buffer.toString(), throwable);
        }
    }

    private static final class ODBOThreadRunner
    implements Runnable {
        private final Runnable subTask;

        ODBOThreadRunner(Runnable theSubTask) {
            this.subTask = theSubTask;
        }

        @Override
        public void run() {
            ODBOCOMThreadFactoryDecorator.initializeCOMThread();
            ODBOThreadContext.enter();
            try {
                this.subTask.run();
            }
            finally {
                ODBOThreadContext.exit();
                ODBOCOMThreadFactoryDecorator.terminateCOMThread();
            }
        }
    }
}

