/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting;

import com.ibm.bi.predict.algorithms.forecasting.es.ESMethod;
import com.ibm.bi.predict.algorithms.forecasting.eval.EvaluationStatistic;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.hierarchy.Hierarchy;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.data.DataContext;
import com.ibm.bi.predict.source.ColumnGroup;
import com.ibm.bi.predict.source.ColumnIdentifier;
import com.ibm.bi.predict.source.jsonstat.ColumnGroupType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ForecastingAlgorithmContext
extends DataContext {
    public static final String CONFIG_PREFIX = "forecast.config.";
    public static final String FORECAST_PERIODS = "forecast.config.forecastPeriods";
    public static final String MISSING_VALUE_THRESHOLD = "forecast.config.missingValueThreshold";
    public static final String FORECAST_PERCENTAGE = "forecast.config.forecastPercentage";
    public static final String CONFIDENCE_LEVEL = "forecast.config.confidenceLevel";
    public static final String SEASONALITY_TYPE = "forecast.config.seasonalityType";
    public static final String TREND_TYPE = "forecast.config.trendType";
    public static final String SEASONALITY_PERIOD = "forecast.config.seasonalityPeriod";
    public static final String LAST_N_PERIODS = "forecast.config.ignoreLastNPeriods";
    public static final String EVALUATION_METRIC = "forecast.config.evaluationMetric";
    public static final String MINIMUM_SERIES_LENGTH = "forecast.config.minimumSeriesLength";
    public static final String MAXIMUM_FORECAST_PERIODS = "forecast.config.maximumForecastPeriods";
    public static final String INCLUDE_STAT_DETAILS = "forecast.config.includeStatisticalDetails";
    public static final String MODEL_NAME = "forecast.config.modelName";
    public static final String OUTPUT_FORMAT = "forecast.config.outputFormat";
    public static final String INCLUDE_CONFIDENCE_INTERVALS = "forecast.config.includeConfidenceIntervals";
    public static final String INCLUDE_OUTLIERS = "forecast.config.includeOutliers";
    public static final String HISTORY_CONFIDENCE_LEVEL = "forecast.config.historyConfidenceLevel";
    private Hierarchy[] seriesHierarchies;
    private Hierarchy timeHierarchy;
    private TimeDimension timeDimension;
    private ESMethod modelType = null;
    private int cycleLength;

    public ESMethod modelType() {
        return this.modelType;
    }

    public boolean hasModelType() {
        return this.modelType != null;
    }

    public ForecastingAlgorithmContext setModelType(String modelType) {
        for (ESMethod.Trend trend : ESMethod.Trend.values()) {
            for (ESMethod.Seasonality seasonality : ESMethod.Seasonality.values()) {
                String combined = trend.shortName() + seasonality.shortName();
                if (!combined.equals(modelType)) continue;
                this.modelType = ESMethod.make(trend, seasonality);
                return this;
            }
        }
        throw new ForecastingParametersException("Unknown model type of " + modelType, ForecastingParametersExceptionKey.MODEL_NAME);
    }

    public EvaluationStatistic getEvaluationMetric() {
        Optional evalMetric = this.getStringOpt(EVALUATION_METRIC);
        return evalMetric.isPresent() ? EvaluationStatistic.fromString((String)evalMetric.get()) : EvaluationStatistic.AIC;
    }

    public void setSeriesHierarchies(Hierarchy[] seriesHierarchies) {
        this.seriesHierarchies = seriesHierarchies;
    }

    public void setTimeHierarchy(Hierarchy timeHierarchy) {
        this.timeHierarchy = timeHierarchy;
    }

    public List<ColumnGroup> getColumnGroups() {
        List<ColumnIdentifier> columns;
        ArrayList<ColumnGroup> groups = new ArrayList<ColumnGroup>();
        if (this.seriesHierarchies != null) {
            columns = this.colummnIdentifiersForSeriesHierarchy();
            groups.add(new ColumnGroup((Object)"other", "other", Collections.singleton(ColumnGroupType.OTHER), columns));
        }
        columns = ForecastingAlgorithmContext.columnsIdentifiersFromHierarchy(this.timeHierarchy);
        groups.add(new ColumnGroup((Object)"time", "time", Collections.singleton(ColumnGroupType.TIME), columns));
        int valueColumn = (Integer)this.getIntList("target", new ArrayList()).get(0);
        columns = Arrays.asList(new ColumnIdentifier((Object)"value", "value", valueColumn));
        groups.add(new ColumnGroup((Object)"value", "value", Collections.singleton(ColumnGroupType.VALUE), columns));
        return groups;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)((Object)this), (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)((Object)this), (String[])new String[0]);
    }

    public void setTimeDimension(TimeDimension timeDimension) {
        this.timeDimension = timeDimension;
    }

    public TimeDimension getTimeDimension() {
        return this.timeDimension;
    }

    public void setCycleLength(int cycleLength) {
        this.cycleLength = cycleLength;
    }

    public int getCycleLength() {
        return this.cycleLength;
    }

    public TimeDelta getTimeDelta() {
        return this.timeDimension == null ? null : this.timeDimension.getTimeDelta();
    }

    private List<ColumnIdentifier> colummnIdentifiersForSeriesHierarchy() {
        ArrayList<ColumnIdentifier> columns = new ArrayList<ColumnIdentifier>();
        for (Hierarchy h : this.seriesHierarchies) {
            columns.addAll(ForecastingAlgorithmContext.columnsIdentifiersFromHierarchy(h));
        }
        return columns;
    }

    private static List<ColumnIdentifier> columnsIdentifiersFromHierarchy(Hierarchy h) {
        ArrayList<ColumnIdentifier> columns = new ArrayList<ColumnIdentifier>();
        for (int col : h.getColumns()) {
            columns.add(new ColumnIdentifier((Object)h.getName(), h.getName(), col));
        }
        return columns;
    }
}

