/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.concepts;

import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;

public class ConceptUtils {
    public static boolean isIndexing(int indexInTimeDimension) {
        return indexInTimeDimension == 0;
    }

    public static boolean isCyclical(int indexInTimeDimension) {
        return indexInTimeDimension > 0;
    }

    public static boolean isDayOfWeek(TimeConcept concept) {
        return concept == TimeConcept.DAY_OF_WEEK;
    }

    public static boolean isMonth(TimeConcept concept) {
        return concept == TimeConcept.MONTH;
    }

    public static boolean isYear(TimeConcept concept) {
        return concept == TimeConcept.YEAR;
    }

    public static boolean isQuarter(TimeConcept concept) {
        return concept == TimeConcept.QUARTER;
    }

    public static boolean hasVariableLimits(TimeConcept concept, int indexInTimeDimension) {
        return ConceptUtils.isCyclical(indexInTimeDimension) && (concept == TimeConcept.DAY_OF_MONTH || concept == TimeConcept.DAY_OF_YEAR);
    }

    public static boolean isTextIndexingConcept(TimeConcept concept, int indexInTimeDimension) {
        return ConceptUtils.isIndexing(indexInTimeDimension) && concept.hasStringRepr();
    }

    public static boolean isTime(TimeConcept concept) {
        return concept == TimeConcept.TIME;
    }

    public static boolean isWeekConcept(TimeConcept concept) {
        return concept == TimeConcept.WEEK;
    }

    public static boolean isPeriodConcept(TimeConcept concept) {
        return concept == TimeConcept.PERIOD;
    }

    public static boolean includesTime(TimeConcept concept) {
        return concept == TimeConcept.TIME || concept == TimeConcept.DATETIME || concept == TimeConcept.HOUR || concept == TimeConcept.MINUTE || concept == TimeConcept.SECOND || concept == TimeConcept.SECOND_MINUTE;
    }

    private ConceptUtils() {
    }

    public static boolean isQuarterMonthConcepts(TimeDimension timeDimension, int conceptIndex) {
        return conceptIndex == 1 && ConceptUtils.isMonth(timeDimension.concept(conceptIndex)) && ConceptUtils.isQuarter(timeDimension.concept(conceptIndex - 1));
    }

    public static boolean isWeekConceptPresent(TimeDimension timeDimension) {
        TimeConcept[] concepts;
        for (TimeConcept concept : concepts = timeDimension.allConcepts()) {
            if (!ConceptUtils.isWeekConcept(concept)) continue;
            return true;
        }
        return false;
    }
}

