/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.concepts.validation;

import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimestampConceptMatch;
import com.ibm.bi.predict.algorithms.forecasting.concepts.validation.ConceptValidationResult;
import com.ibm.bi.predict.algorithms.forecasting.concepts.validation.NonTimestampConceptValidator;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.util.TimeUtils;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;

public final class ConceptValidator {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ConceptValidator.class);

    private ConceptValidator() {
    }

    public static ConceptValidationResult validateValues(TimeConcept concept, int indexInTimeDimension, DataColumn column, Optional<TimestampConceptMatch> match, Locale locale) {
        ConceptValidationResult validationResult = TimeUtils.getFieldValuesInformation(column, concept, indexInTimeDimension);
        Set<String> fieldValues = validationResult.getValueFrequencyMap().keySet();
        if (concept == TimeConcept.PERIOD) {
            return ConceptValidator.cleanupFrequencyMap(validationResult);
        }
        if (concept.isTimestamp()) {
            if (match.isPresent()) {
                if (!match.get().unmatchedValues.isEmpty()) {
                    validationResult.setIsValid(false);
                    validationResult.setInvalidValues(match.get().unmatchedValues);
                }
                return ConceptValidator.cleanupFrequencyMap(validationResult);
            }
            throw new IllegalArgumentException("Timestamp concept should have had match information");
        }
        if (ConceptValidator.canNonTimeStampConceptBeValidated(concept, indexInTimeDimension)) {
            if (ConceptValidator.treatAsCategorical(validationResult = NonTimestampConceptValidator.validateNonTimestamp(validationResult, concept, indexInTimeDimension, fieldValues, locale), concept, indexInTimeDimension) && (validationResult = ConceptValidator.validateIndexing(validationResult, fieldValues)).isValid()) {
                validationResult.setTreatAsCategorical(true);
            }
        } else if (ConceptUtils.isIndexing(indexInTimeDimension)) {
            validationResult = ConceptValidator.validateIndexing(validationResult, fieldValues);
        } else {
            throw new ForecastingParametersException("Unexpected concept type", ForecastingParametersExceptionKey.TIME_CONCEPT);
        }
        return ConceptValidator.cleanupFrequencyMap(validationResult);
    }

    private static ConceptValidationResult cleanupFrequencyMap(ConceptValidationResult result) {
        result.setValueFrequencyMap(Collections.emptyMap());
        return result;
    }

    private static boolean treatAsCategorical(ConceptValidationResult result, TimeConcept concept, int indexInTimeDimension) {
        return !result.isValid() && ConceptUtils.isTextIndexingConcept(concept, indexInTimeDimension) && !result.isNumeric();
    }

    private static ConceptValidationResult validateIndexing(ConceptValidationResult result, Set<String> fieldValues) {
        result.setIsValid(true);
        HashSet<String> invalidSet = new HashSet<String>();
        ConceptValidator.checkForEmptyValues(fieldValues, invalidSet);
        if (!invalidSet.isEmpty()) {
            result.setIsValid(false);
        }
        result.setInvalidValues(invalidSet);
        return result;
    }

    private static void checkForEmptyValues(Set<String> fieldValues, Set<String> invalidSet) {
        if (fieldValues.contains("")) {
            invalidSet.add("");
        }
        if (fieldValues.contains("PREDICTNOVALUECAT_4847aaa3-2eac-4489-b1d8-1ebc8146f1aa_PREDICTNOVALUECAT")) {
            invalidSet.add("PREDICTNOVALUECAT_4847aaa3-2eac-4489-b1d8-1ebc8146f1aa_PREDICTNOVALUECAT");
        }
    }

    private static boolean canNonTimeStampConceptBeValidated(TimeConcept concept, int indexInTimeDimension) {
        return ConceptUtils.isCyclical(indexInTimeDimension) || ConceptUtils.isTextIndexingConcept(concept, indexInTimeDimension);
    }
}

