/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.concepts.validation;

import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;

public final class NestedConceptValidator {
    private NestedConceptValidator() {
    }

    public static void validateConcepts(TimeConcept[] concepts) {
        if (concepts.length == 0) {
            throw new ForecastingParametersException("Zero-length concepts array passed to validation", ForecastingParametersExceptionKey.TIME_CONCEPT);
        }
        for (TimeConcept concept : concepts) {
            if (concept == TimeConcept.UNKNOWN) {
                throw new ForecastingParametersException("UNKNOWN concept was passed to validation", ForecastingParametersExceptionKey.TIME_CONCEPT);
            }
            if (concept != null) continue;
            throw new ForecastingParametersException("Expected a TimeConcept but got null.", ForecastingParametersExceptionKey.TIME_CONCEPT);
        }
        if (concepts.length != 1) {
            NestedConceptValidator.validateNestedConcepts(concepts);
        }
    }

    public static void validateNestedConcepts(TimeConcept[] concepts) {
        NestedConceptValidator.checkOuterConcept(concepts[0]);
        for (int i = 1; i < concepts.length; ++i) {
            TimeConcept concept = concepts[i];
            TimeConcept parentConcept = concepts[i - 1];
            if (concept.isTimestamp() || parentConcept.isTimestamp()) {
                NestedConceptValidator.handleTimestampConcept(concept, parentConcept);
                continue;
            }
            if (NestedConceptValidator.isValidChildOfParent(concept, parentConcept)) continue;
            throw new ForecastingParametersException("The provided nested concepts are not supported according to the current hierarchical definition.", ForecastingParametersExceptionKey.TIME_CONCEPT);
        }
    }

    public static boolean isValidChildOfParent(TimeConcept childConcept, TimeConcept parentConcept) {
        if (childConcept.getParentTimeUnit() == TimeUnit.UNKNOWN) {
            return false;
        }
        return parentConcept.getUnit() == childConcept.getParentTimeUnit() || childConcept.getUnit() == TimeUnit.MONTH && parentConcept.getUnit() == TimeUnit.QUARTER;
    }

    private static void checkOuterConcept(TimeConcept concept) {
        if (concept == TimeConcept.TIME) {
            throw new ForecastingParametersException("Time concept cannot be in first position when time columns are nested", ForecastingParametersExceptionKey.TIME_CONCEPT);
        }
    }

    private static void handleTimestampConcept(TimeConcept concept, TimeConcept parentConcept) {
        if (parentConcept == TimeConcept.TIME) {
            throw new ForecastingParametersException("Time concept cannot have nested children", ForecastingParametersExceptionKey.TIME_CONCEPT);
        }
        if (concept.isTimestamp() && concept != TimeConcept.TIME) {
            throw new ForecastingParametersException("Timestamp concepts other than TIME cannot be nested", ForecastingParametersExceptionKey.TIME_CONCEPT);
        }
        if (concept == TimeConcept.TIME) {
            if (parentConcept.isTimestamp() && parentConcept != TimeConcept.DATE) {
                throw new ForecastingParametersException("Date has to be parent of time", ForecastingParametersExceptionKey.TIME_CONCEPT);
            }
            if (parentConcept.isNonTimestamp() && parentConcept.getUnit() != TimeUnit.DAY) {
                throw new ForecastingParametersException("Date has to be parent of time", ForecastingParametersExceptionKey.TIME_CONCEPT);
            }
        }
    }
}

