/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.concepts.validation;

import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.concepts.validation.ConceptValidationResult;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.util.TextDateNames;
import com.ibm.bi.predict.algorithms.forecasting.util.TimeUtils;
import com.ibm.bi.predict.data.Range;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public final class NonTimestampConceptValidator {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(NonTimestampConceptValidator.class);
    private static final double DELTA = 1.0E-10;
    private static final Locale DEFAULT_LOCALE = TextDateNames.getDefaultLocale();
    private static final Set<String> MONTHS = NonTimestampConceptValidator.getNamesSet(TextDateNames.getConceptLabels(TimeConcept.MONTH, DEFAULT_LOCALE, TextDateNames.TextForm.LONG));
    private static final Set<String> SHORT_MONTHS = NonTimestampConceptValidator.getNamesSet(TextDateNames.getConceptLabels(TimeConcept.MONTH, DEFAULT_LOCALE, TextDateNames.TextForm.SHORT));
    private static final Set<String> WEEKDAYS = NonTimestampConceptValidator.getNamesSet(TextDateNames.getConceptLabels(TimeConcept.DAY_OF_WEEK, DEFAULT_LOCALE, TextDateNames.TextForm.LONG));
    private static final Set<String> SHORT_WEEKDAYS = NonTimestampConceptValidator.getNamesSet(TextDateNames.getConceptLabels(TimeConcept.DAY_OF_WEEK, DEFAULT_LOCALE, TextDateNames.TextForm.SHORT));

    private NonTimestampConceptValidator() {
    }

    private static Set<String> getNamesSet(List<String> names) {
        return new HashSet<String>(names);
    }

    private static boolean isInteger(String value) {
        double doubleVal;
        return NumericUtils.tryParseDouble((String)value) && Math.abs((doubleVal = Double.parseDouble(value)) - (double)((int)doubleVal)) <= 1.0E-10;
    }

    private static ConceptValidationResult validateIntFields(ConceptValidationResult result, Set<String> fieldValues, Range range) {
        return NonTimestampConceptValidator.validateIntFields(result, fieldValues, range, range);
    }

    private static ConceptValidationResult validateIntFields(ConceptValidationResult result, Set<String> fieldValues, Range range1, Range range2) {
        Range fullRange = Range.union((Range)range1, (Range)range2);
        int lowerBound = (int)fullRange.minInclusive();
        int upperBound = (int)fullRange.maxExclusive() - 1;
        NonTimestampConceptValidator.checkForInconsistentValues(fieldValues, lowerBound, upperBound);
        Set<String> invalidValues = result.getInvalidValues();
        for (String fieldValue : fieldValues) {
            if (NonTimestampConceptValidator.isInteger(fieldValue)) {
                int value = (int)Double.parseDouble(fieldValue);
                if (value >= lowerBound && value <= upperBound) continue;
                result.setIsValid(false);
                invalidValues.add(fieldValue);
                continue;
            }
            result.setIsValid(false);
            invalidValues.add(fieldValue);
        }
        result.setInvalidValues(invalidValues);
        return result;
    }

    private static void checkForInconsistentValues(Set<String> fieldValues, int lowerBound, int upperBound) {
        if (fieldValues.contains(Integer.toString(lowerBound)) && fieldValues.contains(Integer.toString(upperBound)) || fieldValues.contains(Double.toString(lowerBound)) && fieldValues.contains(Double.toString(upperBound))) {
            throw new ForecastingParametersException("The combined field values encompass a logically inconsistent range for the concept.", ForecastingParametersExceptionKey.TOO_MANY_CYCLICAL_PERIODS);
        }
    }

    private static ConceptValidationResult validateStringFields(ConceptValidationResult result, Set<String> fieldValues, Set<String> longValues, Set<String> shortValues, Set<String> longValuesLocale, Set<String> shortValuesLocale) {
        HashSet<String> longInvalidValues = new HashSet<String>();
        HashSet<String> shortInvalidValues = new HashSet<String>();
        HashSet longSet = new HashSet();
        HashSet shortSet = new HashSet();
        fieldValues.stream().forEach(val -> {
            String lowerCaseVal = val.toLowerCase();
            if (longValues.contains(lowerCaseVal) || longValuesLocale.contains(lowerCaseVal)) {
                longSet.add(val);
            } else {
                longInvalidValues.add((String)val);
            }
            if (shortValues.contains(lowerCaseVal) || shortValuesLocale.contains(lowerCaseVal)) {
                shortSet.add(val);
            } else {
                shortInvalidValues.add((String)val);
            }
        });
        if (longSet.size() == fieldValues.size()) {
            result.setIsValid(true);
            result.setLong(true);
        } else if (shortSet.size() == fieldValues.size()) {
            result.setIsValid(true);
            result.setLong(false);
        } else if (shortSet.size() >= longSet.size()) {
            result.setIsValid(false);
            result.setLong(false);
            result.setInvalidValues(shortInvalidValues);
        } else {
            result.setIsValid(false);
            result.setLong(true);
            result.setInvalidValues(longInvalidValues);
        }
        return result;
    }

    static ConceptValidationResult validateNonTimestamp(ConceptValidationResult result, TimeConcept concept, int indexInTimeDimension, Set<String> fieldValues, Locale locale) {
        if (concept.isTimestamp()) {
            throw new IllegalArgumentException("validateNonTimestamp called with a timestamp concept");
        }
        if (concept == TimeConcept.SEASON || concept == TimeConcept.PERIOD) {
            return result;
        }
        boolean isCyclical = ConceptUtils.isCyclical(indexInTimeDimension);
        if (isCyclical) {
            if (concept == TimeConcept.QUARTER) {
                HashSet<String> invalidSet = new HashSet<String>();
                HashSet<String> validSet = new HashSet<String>();
                fieldValues.stream().forEach(val -> {
                    try {
                        String value = String.valueOf(TimeUtils.parseQuarter((String)val)._2);
                        validSet.add(value);
                    }
                    catch (ForecastingParametersException e) {
                        LOGGER.debug("error while parsing quarter", (Throwable)((Object)e));
                        invalidSet.add((String)val);
                    }
                });
                fieldValues = validSet;
                if (!invalidSet.isEmpty()) {
                    result.setIsValid(false);
                    result.setInvalidValues(invalidSet);
                }
            }
            NonTimestampConceptValidator.validateIntFields(result, fieldValues, concept.getCycleRange0(), concept.getCycleRange1());
        } else {
            NonTimestampConceptValidator.validateIntFields(result, fieldValues, concept.getIndexRange());
        }
        if (result.isValid() || !concept.hasStringRepr()) {
            return result;
        }
        ConceptValidationResult stringValidationResult = new ConceptValidationResult(concept);
        if (concept == TimeConcept.MONTH) {
            Set<String> monthLocale = NonTimestampConceptValidator.getNamesSet(TextDateNames.getConceptLabels(TimeConcept.MONTH, locale, TextDateNames.TextForm.LONG));
            Set<String> shortMonthLocale = NonTimestampConceptValidator.getNamesSet(TextDateNames.getConceptLabels(TimeConcept.MONTH, locale, TextDateNames.TextForm.SHORT));
            NonTimestampConceptValidator.validateStringFields(stringValidationResult, fieldValues, MONTHS, SHORT_MONTHS, monthLocale, shortMonthLocale);
        } else if (concept == TimeConcept.DAY_OF_WEEK) {
            Set<String> weekdayLocale = NonTimestampConceptValidator.getNamesSet(TextDateNames.getConceptLabels(TimeConcept.DAY_OF_WEEK, locale, TextDateNames.TextForm.LONG));
            Set<String> shortWeekdayLocale = NonTimestampConceptValidator.getNamesSet(TextDateNames.getConceptLabels(TimeConcept.DAY_OF_WEEK, locale, TextDateNames.TextForm.SHORT));
            NonTimestampConceptValidator.validateStringFields(stringValidationResult, fieldValues, WEEKDAYS, SHORT_WEEKDAYS, weekdayLocale, shortWeekdayLocale);
        }
        if (stringValidationResult.isValid() || NonTimestampConceptValidator.isString(result, stringValidationResult)) {
            return stringValidationResult;
        }
        return result;
    }

    private static boolean isString(ConceptValidationResult intResult, ConceptValidationResult stringResult) {
        Map<String, Integer> frequencyMap = intResult.getValueFrequencyMap();
        int invalidValuesForInteger = NonTimestampConceptValidator.findFrequency(intResult, frequencyMap);
        int invalidValuesForString = NonTimestampConceptValidator.findFrequency(stringResult, frequencyMap);
        return invalidValuesForString < invalidValuesForInteger;
    }

    private static int findFrequency(ConceptValidationResult validationResult, Map<String, Integer> frequencyMap) {
        return validationResult.getInvalidValues().stream().mapToInt(val -> frequencyMap.getOrDefault(val, 0)).sum();
    }
}

