/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.data;

import com.ibm.bi.predict.utils.Tuple;
import java.util.Arrays;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;

public class NearestNeighborsLinearInterpolation {
    private double[] data;
    private int firstNonMissingIndex;
    private int lastNonMissingIndex;

    public static double[] interpolateMissingValues(double[] y) {
        NearestNeighborsLinearInterpolation model = new NearestNeighborsLinearInterpolation(y);
        for (int i = 0; i < y.length; ++i) {
            if (!Double.isNaN(y[i])) continue;
            y[i] = model.interpolate(i);
        }
        return y;
    }

    public static Tuple<Integer, double[]> handleMissingValues(double[] y, boolean interpolateMissingValues) {
        NearestNeighborsLinearInterpolation model = new NearestNeighborsLinearInterpolation(y);
        int firstNonMissing = model.getFirstNonMissingIndex();
        int lastNonMissing = model.getLastNonMissingIndex();
        int removedFromEnd = y.length - lastNonMissing - 1;
        double[] copy = firstNonMissing == 0 && lastNonMissing == y.length - 1 ? y : (firstNonMissing > -1 ? Arrays.copyOfRange(y, firstNonMissing, lastNonMissing + 1) : new double[]{});
        if (interpolateMissingValues && firstNonMissing > -1) {
            for (int i = 0; i < copy.length; ++i) {
                if (!Double.isNaN(copy[i])) continue;
                copy[i] = model.interpolate(i + firstNonMissing);
            }
        }
        return Tuple.of((Object)removedFromEnd, (Object)copy);
    }

    public NearestNeighborsLinearInterpolation(double[] data) {
        this.data = data;
        this.makeBounds();
    }

    public double interpolate(int j) {
        if (this.isInvalid()) {
            return Double.NaN;
        }
        Tuple<Integer, Integer> kAndL = this.nearestNonMissing(j);
        int k = (Integer)kAndL._1;
        int l = (Integer)kAndL._2;
        double xk = this.data[k];
        double xl = this.data[l];
        return xl + (xk - xl) / (double)(k - l) * (double)(j - l);
    }

    private Tuple<Integer, Integer> nearestNonMissing(int j) {
        if (j <= this.firstNonMissingIndex) {
            int k = this.firstNonMissing(j, v -> v > this.data.length - 1, v -> v + 1);
            int l = this.firstNonMissing(k + 1, v -> v > this.data.length - 1, v -> v + 1);
            return new Tuple((Object)k, (Object)l);
        }
        if (j >= this.lastNonMissingIndex) {
            int k = this.firstNonMissing(j, v -> v < 0, v -> v - 1);
            int l = this.firstNonMissing(k - 1, v -> v < 0, v -> v - 1);
            return new Tuple((Object)k, (Object)l);
        }
        int k = this.firstNonMissing(j - 1, v -> v < 0, v -> v - 1);
        int l = this.firstNonMissing(j + 1, v -> v > this.data.length - 1, v -> v + 1);
        return new Tuple((Object)k, (Object)l);
    }

    private void makeBounds() {
        if (this.data.length == 0) {
            this.firstNonMissingIndex = -1;
            this.lastNonMissingIndex = -1;
        } else {
            this.firstNonMissingIndex = this.firstNonMissing(0, v -> v > this.data.length - 1, v -> v + 1);
            this.lastNonMissingIndex = this.firstNonMissing(this.data.length - 1, v -> v < 0, v -> v - 1);
        }
    }

    private boolean isInvalid() {
        return this.firstNonMissingIndex == -1 || this.lastNonMissingIndex == -1 || this.firstNonMissingIndex == this.lastNonMissingIndex;
    }

    private int firstNonMissing(int startIndex, IntFunction<Boolean> stopFunction, IntUnaryOperator update) {
        int m = startIndex;
        while (Double.isNaN(this.data[m])) {
            if (!stopFunction.apply(m = update.applyAsInt(m)).booleanValue()) continue;
            return -1;
        }
        return m;
    }

    public int getFirstNonMissingIndex() {
        return this.firstNonMissingIndex;
    }

    public int getLastNonMissingIndex() {
        return this.lastNonMissingIndex;
    }
}

