/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.es;

import com.ibm.bi.predict.algorithms.forecasting.es.ESFunctions;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class ESMethod
implements Comparable<ESMethod> {
    private static final Map<String, ESMethod> all = new LinkedHashMap<String, ESMethod>();
    protected final Trend trend;
    protected final Seasonality seasonality;
    private final boolean logTransform;
    public final ESFunctions.ForecastFn forecastFunction;
    public final ESFunctions.VarianceFactorFn varianceFactorFunction;
    public final ESFunctions.UpdateFn updateFunction;
    protected final double[] loBounds;
    protected final double[] hiBounds;
    private static final String ILLEGAL_METHOD_MSG = "Illegal method: ";

    public static ESMethod of(String nn) {
        ESMethod esm = all.get(nn);
        if (esm != null) {
            return esm;
        }
        throw new IllegalArgumentException(String.format("Given key \"%s\" missing from map of all known methods", nn));
    }

    public static Collection<ESMethod> values() {
        return all.values();
    }

    public static ESMethod make(Trend trend, Seasonality seasonality) {
        return all.get(trend.shortName + seasonality.shortName);
    }

    public static ESMethod make(Trend trend, Seasonality seasonality, boolean logTransform) {
        String transform = "";
        if (logTransform) {
            transform = "t";
        }
        if (seasonality == Seasonality.MULTIPLICATIVE && logTransform) {
            throw new IllegalArgumentException("Log transform is not supported with multiplicative seasonality");
        }
        return all.get(transform + trend.shortName + seasonality.shortName);
    }

    @Override
    public int compareTo(ESMethod o) {
        int d = this.trend.compareTo(o.trend);
        return d != 0 ? d : this.seasonality.compareTo(o.seasonality);
    }

    public Trend trend() {
        return this.trend;
    }

    public Seasonality seasonality() {
        return this.seasonality;
    }

    public boolean usesLogTransform() {
        return this.logTransform;
    }

    private ESMethod(Trend trend, Seasonality seasonality, boolean isLogTransform) {
        block17: {
            block18: {
                block16: {
                    if (trend == null || seasonality == null) {
                        throw new IllegalArgumentException("Must have defined components");
                    }
                    this.trend = trend;
                    this.seasonality = seasonality;
                    this.logTransform = isLogTransform;
                    if (trend != Trend.NONE) break block16;
                    switch (seasonality) {
                        case NONE: {
                            this.forecastFunction = ESFunctions::NN_forecast;
                            this.updateFunction = ESFunctions::NN_update;
                            this.varianceFactorFunction = ESFunctions::NN_varianceFactor;
                            break block17;
                        }
                        case ADDITIVE: {
                            this.forecastFunction = ESFunctions::NA_forecast;
                            this.updateFunction = ESFunctions::NA_update;
                            this.varianceFactorFunction = ESFunctions::NA_varianceFactor;
                            break block17;
                        }
                        case MULTIPLICATIVE: {
                            this.forecastFunction = ESFunctions::NM_forecast;
                            this.updateFunction = ESFunctions::NM_update;
                            this.varianceFactorFunction = ESFunctions::NM_varianceFactor;
                            break block17;
                        }
                        default: {
                            throw new UnsupportedOperationException(ILLEGAL_METHOD_MSG + this);
                        }
                    }
                }
                if (trend != Trend.ADDITIVE) break block18;
                switch (seasonality) {
                    case NONE: {
                        this.forecastFunction = ESFunctions::AN_forecast;
                        this.updateFunction = ESFunctions::AN_update;
                        this.varianceFactorFunction = ESFunctions::AN_varianceFactor;
                        break block17;
                    }
                    case ADDITIVE: {
                        this.forecastFunction = ESFunctions::AA_forecast;
                        this.updateFunction = ESFunctions::AA_update;
                        this.varianceFactorFunction = ESFunctions::AA_varianceFactor;
                        break block17;
                    }
                    case MULTIPLICATIVE: {
                        this.forecastFunction = ESFunctions::AM_forecast;
                        this.updateFunction = ESFunctions::AM_update;
                        this.varianceFactorFunction = ESFunctions::AM_varianceFactor;
                        break block17;
                    }
                    default: {
                        throw new UnsupportedOperationException(ILLEGAL_METHOD_MSG + this);
                    }
                }
            }
            switch (seasonality) {
                case NONE: {
                    this.forecastFunction = ESFunctions::AdN_forecast;
                    this.updateFunction = ESFunctions::AdN_update;
                    this.varianceFactorFunction = ESFunctions::AdN_varianceFactor;
                    break;
                }
                case ADDITIVE: {
                    this.forecastFunction = ESFunctions::AdA_forecast;
                    this.updateFunction = ESFunctions::AdA_update;
                    this.varianceFactorFunction = ESFunctions::AdA_varianceFactor;
                    break;
                }
                case MULTIPLICATIVE: {
                    this.forecastFunction = ESFunctions::AdM_forecast;
                    this.updateFunction = ESFunctions::AdM_update;
                    this.varianceFactorFunction = ESFunctions::AdM_varianceFactor;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(ILLEGAL_METHOD_MSG + this);
                }
            }
        }
        this.loBounds = new double[1 + trend.parametersNeeded + seasonality.parametersNeeded];
        this.hiBounds = new double[this.loBounds.length];
        Arrays.fill(this.loBounds, 1.0E-4);
        Arrays.fill(this.hiBounds, 0.9999);
    }

    public boolean hasSeasonality() {
        return this.seasonality != Seasonality.NONE;
    }

    public boolean hasTrend() {
        return this.trend != Trend.NONE;
    }

    public int hashCode() {
        return 31 * this.trend.hashCode() + this.seasonality.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ESMethod)) {
            return false;
        }
        ESMethod esMethod = (ESMethod)o;
        return this.trend == esMethod.trend && this.seasonality == esMethod.seasonality;
    }

    public String toString() {
        if (this.logTransform) {
            return "t" + this.trend.shortName + this.seasonality.shortName;
        }
        return this.trend.shortName + this.seasonality.shortName;
    }

    int numberOfParameters() {
        return 1 + this.trend.parametersNeeded + this.seasonality.parametersNeeded;
    }

    public double[] getLoBounds() {
        return this.loBounds;
    }

    public double[] getHiBounds() {
        return this.hiBounds;
    }

    static {
        for (Trend t : Trend.values()) {
            for (Seasonality s : Seasonality.values()) {
                ESMethod withoutLogTransform = new ESMethod(t, s, false);
                all.put(withoutLogTransform.toString(), withoutLogTransform);
                if (s == Seasonality.MULTIPLICATIVE) continue;
                ESMethod withLogTransform = new ESMethod(t, s, true);
                all.put(withLogTransform.toString(), withLogTransform);
            }
        }
    }

    public static enum Seasonality {
        NONE("N", 0),
        ADDITIVE("A", 1),
        MULTIPLICATIVE("M", 1);

        private final String shortName;
        private final int parametersNeeded;

        public static Seasonality fromString(String seasonality) {
            for (Seasonality s : Seasonality.values()) {
                if (!s.shortName.equals(seasonality)) continue;
                return s;
            }
            throw new IllegalArgumentException("Unknown seasonality type of " + seasonality);
        }

        private Seasonality(String shortName, int parametersNeeded) {
            this.shortName = shortName;
            this.parametersNeeded = parametersNeeded;
        }

        public String shortName() {
            return this.shortName;
        }
    }

    public static enum Trend {
        NONE("N", 0),
        ADDITIVE("A", 1),
        ADDITIVE_DAMPED("Ad", 2);

        private final String shortName;
        private final int parametersNeeded;

        public static Trend fromString(String trend) {
            for (Trend t : Trend.values()) {
                if (!t.shortName.equals(trend)) continue;
                return t;
            }
            throw new IllegalArgumentException("Unknown trend type of " + trend);
        }

        private Trend(String shortName, int parametersNeeded) {
            this.shortName = shortName;
            this.parametersNeeded = parametersNeeded;
        }

        public String shortName() {
            return this.shortName;
        }
    }
}

