/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.es;

import com.ibm.bi.predict.algorithms.forecasting.es.ESMethod;

public class ESParameters {
    public final double alpha;
    public final double beta;
    public final double gamma;
    public final double phi;
    public final int m;

    public ESParameters(double alpha, double beta, double gamma, double phi, int m) {
        this.alpha = alpha;
        this.beta = beta;
        this.gamma = gamma;
        this.phi = phi;
        this.m = Double.isNaN(gamma) ? 1 : m;
    }

    public ESParameters modifyForModel(ESMethod model) {
        double b = model.hasTrend() ? this.beta : Double.NaN;
        double p = model.trend == ESMethod.Trend.ADDITIVE_DAMPED ? this.phi : Double.NaN;
        double g = model.hasSeasonality() ? this.gamma : Double.NaN;
        int s = model.hasSeasonality() ? this.m : 0;
        return new ESParameters(this.alpha, b, g, p, s);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.alpha);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.beta);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.gamma);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.phi);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.m;
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ESParameters)) {
            return false;
        }
        ESParameters that = (ESParameters)o;
        return Double.compare(that.alpha, this.alpha) == 0 && Double.compare(that.beta, this.beta) == 0 && Double.compare(that.gamma, this.gamma) == 0 && Double.compare(that.phi, this.phi) == 0 && this.m == that.m;
    }

    public String toString() {
        return "{" + this.listParameters() + "}";
    }

    public String listParameters() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("\u03b1=%1.3f", this.alpha));
        if (this.beta > 0.0) {
            sb.append(String.format(" \u03b2=%1.3f", this.beta));
        }
        if (this.gamma > 0.0) {
            sb.append(String.format(" \u03b3=%1.3f", this.gamma));
        }
        if (this.phi > 0.0) {
            sb.append(String.format(" \u03c6=%1.3f", this.phi));
        }
        if (this.gamma > 0.0) {
            sb.append(String.format(" m=%d", this.m));
        }
        return sb.toString();
    }
}

