/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.es;

import com.ibm.bi.predict.algorithms.forecasting.AutoCorrelationFunction;
import com.ibm.bi.predict.algorithms.forecasting.es.ESDiagnostics;
import com.ibm.bi.predict.algorithms.forecasting.es.ESFit;
import com.ibm.bi.predict.algorithms.forecasting.es.ESMethod;
import com.ibm.bi.predict.algorithms.forecasting.es.ESModelArrays;
import com.ibm.bi.predict.algorithms.forecasting.es.ESParameters;
import com.ibm.bi.predict.algorithms.forecasting.es.PeriodSelection;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingNoModelException;
import com.ibm.bi.predict.exceptions.UnsuitableModelException;
import com.ibm.bi.predict.math.Optimizer;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ExponentialSmoothing {
    private static final Logger LOG = PredictLoggerFactory.getLogger(ExponentialSmoothing.class);
    private static final int MAX_PERIODS_TO_CONSIDER = 8;
    private static final int MAX_ACF_VALUES_TO_CALCULATE = 10000;
    private static final double BIAS_FRACTION_FOR_LONGEST_LAG = 0.01;
    private static boolean SIMULATE_FAILED_FITTING = false;
    protected final ESMethod method;
    protected final int period;

    protected ExponentialSmoothing(ESMethod method, int period) {
        this.method = method;
        this.period = period;
    }

    public static ESFit fit(double[] y) {
        return ExponentialSmoothing.fit(y, null, PeriodSelection.unknown());
    }

    public static ESFit fit(double[] y, ESMethod method) {
        if (method == null) {
            throw new NullPointerException("Method must be defined if requested");
        }
        return ExponentialSmoothing.fit(y, method, PeriodSelection.unknown());
    }

    public static ESFit fit(double[] y, PeriodSelection period) {
        return ExponentialSmoothing.fit(y, null, period);
    }

    public static ESFit fit(double[] y, int knownPeriod) {
        return ExponentialSmoothing.fit(y, null, PeriodSelection.knownPeriod(knownPeriod));
    }

    public static ESFit fit(double[] y, ESMethod method, int knownPeriod) {
        if (method == null) {
            throw new NullPointerException("Method must be defined if requested");
        }
        return ExponentialSmoothing.fit(y, method, PeriodSelection.knownPeriod(knownPeriod));
    }

    public static ESFit fit(double[] y, ESMethod method, PeriodSelection periodSelection) {
        ESFit fit;
        int period = periodSelection.hasDefinedPeriod() ? periodSelection.definedPeriod() : ExponentialSmoothing.findPeriodicity(y, 10000, 8, periodSelection.timeCycleLength());
        long start = System.currentTimeMillis();
        if (method == null) {
            fit = ExponentialSmoothing.findBestModel(y, period);
            LOG.debug(() -> "Best fit searching across models is: " + fit);
        } else {
            fit = ExponentialSmoothing.optimizeModel(y, period, method);
            LOG.debug(() -> "Fitted Model: " + fit);
        }
        LOG.debug(() -> "Fit ran in " + (System.currentTimeMillis() - start) + "ms");
        if (fit == null) {
            throw new ForecastingNoModelException("Optimizer did not find models suitable for forecasting");
        }
        return fit;
    }

    public static int findPeriodicity(double[] y, int maxACFValuesToCalculate, int maxPeriodsToConsider, Integer timeCycleLength) {
        int max = Math.min(y.length / 2 + 1, maxACFValuesToCalculate);
        AutoCorrelationFunction acf = AutoCorrelationFunction.calculateOnDetrendedSeries(y, max);
        List<Integer> lags = ExponentialSmoothing.findBestLags(acf, maxPeriodsToConsider);
        ESMethod fitPeriodMethod = ESMethod.make(ESMethod.Trend.ADDITIVE, ESMethod.Seasonality.ADDITIVE);
        ExponentialSmoothing.modifyCandidatePeriods(lags, timeCycleLength);
        ESFit best = lags.stream().filter(p -> ESModelArrays.validPeriod(p, y.length)).map(period -> ExponentialSmoothing.optimizeModel(y, period, fitPeriodMethod)).filter(Objects::nonNull).peek(fit -> LOG.debug(() -> String.format("Period = %d, AIC = %5.3f for %s", fit.parameters().m, fit.diagnostics().AIC(), fit.toString()))).min(ExponentialSmoothing::periodicityComparison).orElse(null);
        if (best == null) {
            LOG.debug("No potential periodicity detected");
            return 1;
        }
        int period2 = best.parameters().m;
        String lagsStr = lags.toString();
        LOG.debug(() -> "Best periodicity = " + period2 + " for model = " + best + " (considered " + lagsStr + ")");
        return period2;
    }

    private static List<Integer> findBestLags(AutoCorrelationFunction acf, int maxPeriodsToConsider) {
        int i2;
        double[] values = acf.acf();
        int N = values.length;
        double[] score = new double[N];
        double max = 0.0;
        for (i2 = 2; i2 < N - 1; ++i2) {
            score[i2] = 2.0 * values[i2] - values[i2 - 1] - values[i2 + 1];
            max = Math.max(score[i2], max);
        }
        for (i2 = 2; i2 < N - 1; ++i2) {
            int n = i2;
            score[n] = score[n] - max * 0.01 * (double)i2 / (double)N;
        }
        return IntStream.range(2, N - 1).filter(i -> score[i] > 0.0).boxed().sorted(Comparator.comparingDouble(i -> -score[i])).limit(maxPeriodsToConsider).collect(Collectors.toList());
    }

    private static boolean shouldTryLogTransform(double[] y) {
        return false;
    }

    private static ESFit findBestModel(double[] y, int period) {
        HashMap<ESMethod, ESDiagnostics> fittedDiag = new HashMap<ESMethod, ESDiagnostics>();
        AtomicInteger allModels = new AtomicInteger(0);
        AtomicInteger returnedModels = new AtomicInteger(0);
        boolean allowMultiplicative = !ExponentialSmoothing.skipMultiplicativeModels(y);
        ESFit bestFit = ESMethod.values().stream().filter(m -> period > 1 || !m.hasSeasonality()).filter(m -> m.seasonality() != ESMethod.Seasonality.MULTIPLICATIVE || allowMultiplicative).filter(m -> !m.usesLogTransform() || ExponentialSmoothing.shouldTryLogTransform(y)).map(m -> {
            allModels.getAndIncrement();
            return ExponentialSmoothing.optimizeModel(y, period, m);
        }).filter(Objects::nonNull).map(fit -> {
            fittedDiag.put(fit.method(), fit.diagnostics());
            returnedModels.getAndIncrement();
            return fit;
        }).peek(fit -> LOG.debug(() -> String.format("AIC = %5.3f for %s", fit.diagnostics().AIC(), fit.toString()))).min(ExponentialSmoothing::modelComparison).orElseThrow(() -> new ForecastingNoModelException("No model returned from optimizer"));
        if (!allowMultiplicative) {
            bestFit.setRestrictedModels(true);
        }
        if (returnedModels.get() < allModels.get()) {
            LOG.warn(() -> String.format("One or more models were not returned by the Optimizer", new Object[0]));
            bestFit.setOptimizeError();
        }
        return bestFit.setFittedDiagnostics(fittedDiag);
    }

    private static boolean skipMultiplicativeModels(double[] y) {
        int sign = (int)Math.signum(y[0]);
        if (sign == 0) {
            return true;
        }
        for (int i = 1; i < y.length; ++i) {
            if (sign == (int)Math.signum(y[i])) continue;
            return true;
        }
        return false;
    }

    private static ESFit optimizeModel(double[] y, int period, ESMethod method) {
        return new ExponentialSmoothing(method, period).optimize(y);
    }

    protected ESParameters arrayToParams(double[] array) {
        int index = 0;
        double alpha = array[index];
        ++index;
        double beta = Double.NaN;
        if (this.method.hasTrend()) {
            beta = array[index];
            ++index;
        }
        double gamma = Double.NaN;
        if (this.method.hasSeasonality()) {
            gamma = array[index];
            ++index;
        }
        double phi = Double.NaN;
        if (this.method.trend == ESMethod.Trend.ADDITIVE_DAMPED) {
            phi = array[index];
        }
        return new ESParameters(alpha, beta, gamma, phi, this.period);
    }

    protected ESFit optimizeWithInitialValues(double[] y, double l0, double b0, double[] s0) {
        Function<double[], ESFit> paramArrayToFit = array -> {
            try {
                return new ESFit(this.method, this.arrayToParams((double[])array), y, l0, b0, s0);
            }
            catch (UnsuitableModelException e) {
                LOG.warn(e.getMessage());
                return null;
            }
        };
        return this.optimizeBestFit(paramArrayToFit);
    }

    protected ESFit optimize(double[] y) {
        Function<double[], ESFit> paramArrayToFit = array -> {
            try {
                ESParameters parameters = this.arrayToParams((double[])array);
                return new ESFit(this.method, parameters, y);
            }
            catch (UnsuitableModelException e) {
                LOG.warn(e.getMessage());
                return null;
            }
        };
        return this.optimizeBestFit(paramArrayToFit);
    }

    private ESFit optimizeBestFit(Function<double[], ESFit> paramArrayToFit) {
        if (SIMULATE_FAILED_FITTING) {
            return null;
        }
        Optimizer optimizer = Optimizer.makeMinimizer(paramArrayToFit, ExponentialSmoothing::fitError).bounds(this.method.loBounds, this.method.hiBounds).multivariateMethod(Optimizer.MultivariateMethod.BOBYQA).requiredPrecision(1.0E-5);
        try {
            return (ESFit)optimizer.run();
        }
        catch (Exception e) {
            LOG.warn(() -> String.format("Optimization of model %s to converge", this.method.toString()), (Throwable)e);
            return null;
        }
    }

    public static double fitError(ESFit fit) {
        double sum = 0.0;
        for (int i = 0; i < fit.rowCount(); ++i) {
            sum += Math.abs(fit.transformedHistorical(i, 1) - fit.transformedY(i));
        }
        ESParameters p = fit.parameters();
        double DELTA = 1.0E-10;
        sum += 1.0E-10 * (p.alpha - 1.0);
        if (!Double.isNaN(p.beta)) {
            sum += 1.0E-10 * (p.beta - 1.0);
        }
        if (!Double.isNaN(p.gamma)) {
            sum += 1.0E-10 * (p.gamma - 1.0);
        }
        if (!Double.isNaN(p.phi)) {
            sum += 1.0E-10 * (p.phi - 1.0);
        }
        return sum;
    }

    static double maeNaive(double[] data) {
        return IntStream.range(1, data.length).mapToDouble(i -> Math.abs(data[i] - data[i - 1])).average().orElse(Double.NaN);
    }

    static double[] appendPartialTestDataToTrainingData(int count, double[] train, double[] test) {
        double[] data = Arrays.copyOf(train, train.length + count);
        System.arraycopy(test, 0, data, train.length, count);
        return data;
    }

    public static double maseRepeated(double[] test, ESFit fit) {
        if (fit == null) {
            return Double.NaN;
        }
        double[] train = fit.getY();
        double naiveMAE = ExponentialSmoothing.maeNaive(train);
        return IntStream.range(0, Math.min(50, test.length)).mapToDouble(k -> ExponentialSmoothing.extendTrainingData(test, fit, train, naiveMAE, k)).average().orElseThrow(() -> new IllegalStateException("No test data."));
    }

    private static double extendTrainingData(double[] test, ESFit fit, double[] train, double naiveMAE, int k) {
        double[] extendedData = ExponentialSmoothing.appendPartialTestDataToTrainingData(k, train, test);
        ESFit extendedFit = ExponentialSmoothing.fit(extendedData, fit.method(), fit.period());
        return Math.abs(extendedFit.forecast(1) - test[k]) / naiveMAE;
    }

    public static double fractionOutsideCI(ESFit fit, double[] test, double level) {
        if (test.length == 0) {
            throw new IllegalStateException("No test data.");
        }
        if (fit == null) {
            return Double.NaN;
        }
        return (double)IntStream.range(0, test.length).filter(k -> !fit.forecastConfidence(k + 1, level).contains(test[k])).count() / (double)test.length;
    }

    static void modifyCandidatePeriods(List<Integer> lags, Integer timeCycleLength) {
        if (timeCycleLength != null && timeCycleLength > 0 && !lags.contains(timeCycleLength)) {
            lags.add(timeCycleLength);
        }
    }

    public static int modelComparison(ESFit left, ESFit right) {
        return Double.compare(left.AIC(), right.AIC());
    }

    public static int periodicityComparison(ESFit left, ESFit right) {
        return Double.compare(left.AIC(), right.AIC());
    }
}

