/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.labels;

import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.labels.LabelUtils;
import com.ibm.bi.predict.algorithms.forecasting.labels.TimeLabel;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.utils.Tuple;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public class IndexLabels
implements TimeLabel {
    final Locale locale;
    final Locale defaultLocale;
    final NumberFormat numberFormat;
    final NumberFormat defaultNumberFormat;
    final TimeConcept concept;
    protected TimeDimension timeDimension;
    protected int conceptIndex;
    protected TimeDelta distance;

    public IndexLabels(Locale locale, TimeDimension timeDimension, int conceptIndex) {
        this.locale = locale;
        this.defaultLocale = Locale.getDefault(Locale.Category.FORMAT);
        this.numberFormat = NumberFormat.getInstance(locale);
        this.defaultNumberFormat = NumberFormat.getInstance(this.defaultLocale);
        this.numberFormat.setGroupingUsed(false);
        this.defaultNumberFormat.setGroupingUsed(false);
        this.timeDimension = timeDimension;
        this.conceptIndex = conceptIndex;
        this.concept = timeDimension.concept(conceptIndex);
        this.distance = timeDimension.getTimeDelta();
    }

    @Override
    public List<Tuple<String, TimeDelta>> getNextNLabels(int forecastOffset, int numberOfLabels, List<TimeDelta> carryOverList) {
        carryOverList.stream().forEach(value -> {
            if (value.getSteps() < 0L) {
                throw new IllegalArgumentException("Step size should be greater than or equal to 0");
            }
        });
        int[] rowOrder = this.timeDimension.getRowOrder();
        String[] initialLabels = this.timeDimension.getDateLabels(rowOrder[0]);
        String initialLabel = initialLabels[this.conceptIndex];
        int offset = this.timeDimension.getNumberOfTimePointsConsidered() - forecastOffset;
        boolean isNumeric = this.timeDimension.isComponentNumeric(this.conceptIndex);
        if (isNumeric && this.timeDimension.concept(this.conceptIndex) != TimeConcept.PERIOD) {
            Optional<Tuple<NumberFormat, Double>> initialValueOptional = LabelUtils.getDoubleValue(initialLabel, this.numberFormat, this.defaultNumberFormat);
            if (!initialValueOptional.isPresent()) {
                throw new ForecastingParametersException("Unparseable initial label", ForecastingParametersExceptionKey.DATA_VALUE);
            }
            Tuple<NumberFormat, Double> initialValueInfo = initialValueOptional.get();
            return this.handleNumericalIndexConcepts(initialValueInfo, numberOfLabels, offset, carryOverList);
        }
        return this.handleCategoricalIndexConcepts(forecastOffset, numberOfLabels, carryOverList);
    }

    private List<Tuple<String, TimeDelta>> handleNumericalIndexConcepts(Tuple<NumberFormat, Double> initialValueInfo, int numberOfLabels, int offset, List<TimeDelta> carryOverList) {
        ArrayList<Tuple<String, TimeDelta>> labelList = new ArrayList<Tuple<String, TimeDelta>>();
        NumberFormat initialValueNumberFormatter = (NumberFormat)initialValueInfo._1;
        Double initialValue = (Double)initialValueInfo._2;
        for (int i = 1; i <= numberOfLabels; ++i) {
            long delta = 0L;
            TimeDelta carryOver = carryOverList.get(i - 1);
            if (this.isNonZeroDeltaOfCurrentConcept(this.distance)) {
                delta = this.distance.getSteps();
            }
            long newValue = (long)initialValue.intValue() + delta * (long)offset + carryOver.getSteps();
            String label = initialValueNumberFormatter.format(newValue);
            labelList.add((Tuple<String, TimeDelta>)Tuple.of((Object)label, (Object)new TimeDelta(0L, TimeUnit.UNKNOWN)));
            initialValue = newValue;
            offset = 1;
        }
        return labelList;
    }

    private List<Tuple<String, TimeDelta>> handleCategoricalIndexConcepts(int forecastOffset, int numberOfLabels, List<TimeDelta> carryOverList) {
        ArrayList<Tuple<String, TimeDelta>> labelList = new ArrayList<Tuple<String, TimeDelta>>();
        int offset = this.timeDimension.getNumberOfTimePointsConsidered() - forecastOffset;
        List<String> categoriesForConcept = this.timeDimension.getValidConceptCategories(this.conceptIndex);
        int categoryListSize = categoriesForConcept.size();
        int categoryCurrentIndex = 0;
        if (this.isNonZeroDeltaOfCurrentConcept(this.distance)) {
            categoryCurrentIndex = offset - 1;
        }
        int indexForLabel = 0;
        String label = null;
        for (int i = 0; i < numberOfLabels; ++i) {
            TimeDelta carryOver = carryOverList.get(i);
            if (this.isNonZeroDeltaOfCurrentConcept(carryOver)) {
                categoryCurrentIndex = (int)((long)categoryCurrentIndex + carryOver.getSteps());
            } else if (this.isNonZeroDeltaOfCurrentConcept(this.distance)) {
                ++categoryCurrentIndex;
            }
            TimeDelta netDelta = carryOver.add(this.distance);
            if (categoryCurrentIndex <= categoryListSize - 1) {
                label = categoriesForConcept.get(categoryCurrentIndex);
            } else if (i == 0 || netDelta.getSteps() > 0L) {
                label = "+" + this.numberFormat.format(++indexForLabel);
            }
            labelList.add((Tuple<String, TimeDelta>)Tuple.of((Object)label, (Object)new TimeDelta(0L, TimeUnit.UNKNOWN)));
        }
        return labelList;
    }

    private boolean isNonZeroDeltaOfCurrentConcept(TimeDelta delta) {
        return delta.getSteps() > 0L && delta.getUnit() == this.concept.getUnit();
    }
}

