/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.labels;

import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.text.NumberFormat;
import java.text.ParseException;
import java.time.Month;
import java.util.Optional;
import org.apache.commons.lang3.math.NumberUtils;

public class LabelUtils {
    private static final Logger LOG = PredictLoggerFactory.getLogger(LabelUtils.class);

    private LabelUtils() {
    }

    public static Optional<Tuple<NumberFormat, Double>> getDoubleValue(String label, NumberFormat numberFormat, NumberFormat defaultNumberFormat) {
        if (!LabelUtils.isNumber(label)) {
            return Optional.empty();
        }
        try {
            double val = numberFormat.parse(label).doubleValue();
            return Optional.of(Tuple.of((Object)numberFormat, (Object)val));
        }
        catch (ParseException e) {
            try {
                LOG.info("Label does not match a double value in system locale", (Throwable)e);
                double val = defaultNumberFormat.parse(label).doubleValue();
                return Optional.of(Tuple.of((Object)defaultNumberFormat, (Object)val));
            }
            catch (ParseException e1) {
                LOG.info("Label does not match a double value in default and system locale", (Throwable)e1);
                return Optional.empty();
            }
        }
    }

    public static boolean isNumber(String label) {
        return NumberUtils.isNumber((String)label);
    }

    public static Tuple<String, TimeDelta> getEndOfMonthLabel(TimeDelta distance, boolean isZeroIndexed, int historical, int labelIndex, String[] initialLabels, NumberFormat numberFormat, NumberFormat defaultNumberFormat) {
        String initialMonth = initialLabels[0];
        Optional<Tuple<NumberFormat, Double>> initialValue = LabelUtils.getDoubleValue(initialMonth, numberFormat, defaultNumberFormat);
        if (!initialValue.isPresent()) {
            throw new ForecastingParametersException("Unexpected month label", ForecastingParametersExceptionKey.DATA_VALUE);
        }
        int firstMonth = ((Double)initialValue.get()._2).intValue();
        firstMonth = isZeroIndexed ? firstMonth + 1 : firstMonth;
        int newMonth = (int)(((long)firstMonth + (long)(historical + labelIndex) * distance.getSteps()) % 12L);
        if (newMonth == 0) {
            newMonth = 12;
        }
        Month month = Month.of(newMonth);
        String dayOfMonth = Integer.toString(month.length(false));
        return Tuple.of((Object)dayOfMonth, (Object)new TimeDelta(0L, TimeUnit.MONTH));
    }
}

