/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.labels;

import com.ibm.bi.predict.algorithms.forecasting.ForecastingAlgorithmContext;
import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.labels.CyclicalIndexLabels;
import com.ibm.bi.predict.algorithms.forecasting.labels.CyclicalTextLabels;
import com.ibm.bi.predict.algorithms.forecasting.labels.IndexLabels;
import com.ibm.bi.predict.algorithms.forecasting.labels.LabelUtils;
import com.ibm.bi.predict.algorithms.forecasting.labels.TimeLabel;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.algorithms.forecasting.util.EndOfMonthUtils;
import com.ibm.bi.predict.algorithms.forecasting.util.TimeUtils;
import com.ibm.bi.predict.utils.Tuple;
import java.text.NumberFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.TimeZone;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;

public class TimeSeriesLabelGenerator {
    private static final TimeZone TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final ZoneId ZONE_ID = TIME_ZONE.toZoneId();
    private static final String UNSUPPORTED_CONCEPT = "Unsupported concept";
    ForecastingAlgorithmContext context;
    final Locale locale;
    final Locale defaultLocale;
    final NumberFormat numberFormat;
    final NumberFormat defaultNumberFormat;
    final int forecastOffset;
    Calendar calendar;

    public TimeSeriesLabelGenerator(int forecastOffset, ForecastingAlgorithmContext context) {
        this.context = context;
        this.locale = context.getLocale("locale");
        this.defaultLocale = Locale.getDefault(Locale.Category.FORMAT);
        this.numberFormat = NumberFormat.getInstance(this.locale);
        this.defaultNumberFormat = NumberFormat.getInstance(this.defaultLocale);
        this.numberFormat.setGroupingUsed(false);
        this.defaultNumberFormat.setGroupingUsed(false);
        this.forecastOffset = forecastOffset;
    }

    public List<String[]> generate(int numberOfLabelsToGenerate) {
        TimeDimension timeDimension = this.context.getTimeDimension();
        this.validateInputs(timeDimension);
        if (timeDimension.isFullDate()) {
            return this.handleFullDates(timeDimension, numberOfLabelsToGenerate);
        }
        return this.handleNonFullDates(timeDimension, numberOfLabelsToGenerate);
    }

    private void validateInputs(TimeDimension timeDimension) {
        if (timeDimension == null) {
            throw new IllegalArgumentException("Time dimension needs to be set for label generation");
        }
        int[] rowOrder = timeDimension.getRowOrder();
        if (rowOrder == null) {
            throw new IllegalArgumentException("Row order needs to be set in time dimension");
        }
        if (rowOrder.length < 2) {
            throw new IllegalArgumentException("Row order should have 2 or more values");
        }
    }

    private List<String[]> handleFullDates(TimeDimension timeDimension, int numberOfLabelsToGenerate) {
        int[] rowOrder = timeDimension.getRowOrder();
        int firstLabelPosition = rowOrder[0];
        String[] firstLabels = timeDimension.getDateLabels(firstLabelPosition);
        Date initialDate = timeDimension.getDate(firstLabelPosition);
        ZonedDateTime current = TimeUtils.getZonedDateTime(initialDate, ZONE_ID);
        List<ZonedDateTime> forecastDates = this.getForecastedDates(timeDimension, current, numberOfLabelsToGenerate);
        return this.getLabelsFromDate(forecastDates, timeDimension, firstLabels, current);
    }

    private List<ZonedDateTime> getForecastedDates(TimeDimension timeDimension, ZonedDateTime current, int numberOfLabelsToGenerate) {
        TimeDelta step = timeDimension.getTimeDelta();
        int offset = timeDimension.getNumberOfTimePointsConsidered() - this.forecastOffset;
        boolean allLastDay = false;
        if (timeDimension.isFullDate()) {
            allLastDay = EndOfMonthUtils.allLastDay(timeDimension, ZONE_ID);
        }
        ArrayList<ZonedDateTime> forecastDates = new ArrayList<ZonedDateTime>();
        for (int i = 0; i < numberOfLabelsToGenerate; ++i) {
            Tuple<Long, ChronoUnit> stepSize = step.getStepsAsChronoUnits();
            if (stepSize._2 == null) continue;
            ZonedDateTime newDate = current.plus((Long)stepSize._1 * (long)(offset + i), (TemporalUnit)stepSize._2);
            if (allLastDay && stepSize._2 == ChronoUnit.MONTHS) {
                newDate = newDate.withDayOfMonth(EndOfMonthUtils.getDaysInMonth(newDate));
            }
            forecastDates.add(newDate);
        }
        return forecastDates;
    }

    private List<String[]> getLabelsFromDate(List<ZonedDateTime> forecastDates, TimeDimension timeDimension, String[] lastLabels, ZonedDateTime initialDate) {
        int numberOfTimeComponents = timeDimension.getNumberOfComponents();
        List<String[]> labelsForAllComponents = this.initializeListOfArrays(numberOfTimeComponents, forecastDates.size());
        boolean isWeekConceptPresent = ConceptUtils.isWeekConceptPresent(timeDimension);
        if (isWeekConceptPresent) {
            this.calendar = Calendar.getInstance(TIME_ZONE);
            this.calendar.clear();
        }
        for (int timeComponentIndex = 0; timeComponentIndex < numberOfTimeComponents; ++timeComponentIndex) {
            String lastLabel = lastLabels[timeComponentIndex];
            List<String> labelsForOneComponent = this.getLabelsFromDateForOneComponent(timeDimension, timeComponentIndex, lastLabel, forecastDates, initialDate, isWeekConceptPresent);
            this.addComponentLabelsToList(labelsForAllComponents, labelsForOneComponent, timeComponentIndex);
        }
        return labelsForAllComponents;
    }

    private List<String> getLabelsFromDateForOneComponent(TimeDimension timeDimension, int conceptIndex, String lastLabel, List<ZonedDateTime> forecastDates, ZonedDateTime initialDate, boolean isWeekConceptPresent) {
        Function<ZonedDateTime, String> timeFunction = this.getLabelFunction(timeDimension, conceptIndex, lastLabel, isWeekConceptPresent);
        if (timeDimension.getNumberOfComponents() == 1 && timeDimension.getTimestampConcept(0) == TimeConcept.TIME) {
            return this.getLabelsForSingleTime(forecastDates, timeFunction, initialDate);
        }
        return forecastDates.stream().map(timeFunction).collect(Collectors.toList());
    }

    private List<String> getLabelsForSingleTime(List<ZonedDateTime> forecastDates, Function<ZonedDateTime, String> timeFunction, ZonedDateTime initialDate) {
        ArrayList<String> generatedLabels = new ArrayList<String>();
        if (forecastDates.size() > 0) {
            int firstDayOfYear = initialDate.getDayOfYear();
            boolean detectedRollOver = false;
            int rollOverCounter = 0;
            for (ZonedDateTime date : forecastDates) {
                if (!detectedRollOver && date.getDayOfYear() == firstDayOfYear) {
                    generatedLabels.add(timeFunction.apply(date));
                } else if (!detectedRollOver) {
                    detectedRollOver = true;
                }
                if (!detectedRollOver) continue;
                generatedLabels.add("+" + this.numberFormat.format(++rollOverCounter));
            }
        }
        return generatedLabels;
    }

    private List<String[]> handleNonFullDates(TimeDimension timeDimension, int numberOfLabelsToGenerate) {
        int numberOfTimeComponents = timeDimension.getNumberOfComponents();
        List<String[]> labelsForAllComponents = this.initializeListOfArrays(numberOfTimeComponents, numberOfLabelsToGenerate);
        List<TimeDelta> carryOverList = new ArrayList<TimeDelta>();
        for (int i = numberOfTimeComponents - 1; i >= 0; --i) {
            Tuple<List<String>, List<TimeDelta>> labelsAndCarryOverForOneComponent;
            TimeConcept concept = timeDimension.concept(i);
            if (concept == TimeConcept.TIME && ConceptUtils.isCyclical(i)) {
                labelsAndCarryOverForOneComponent = this.handleNestedTime(timeDimension, i, numberOfLabelsToGenerate);
                carryOverList = (List)labelsAndCarryOverForOneComponent._2;
                this.addComponentLabelsToList(labelsForAllComponents, (List)labelsAndCarryOverForOneComponent._1, i);
                continue;
            }
            if (concept.isNonTimestamp()) {
                labelsAndCarryOverForOneComponent = this.handleTimeConcept(carryOverList, timeDimension, numberOfLabelsToGenerate, i, this.locale);
                List labelsForOneComponent = (List)labelsAndCarryOverForOneComponent._1;
                carryOverList = (List)labelsAndCarryOverForOneComponent._2;
                this.addComponentLabelsToList(labelsForAllComponents, labelsForOneComponent, i);
                continue;
            }
            throw new IllegalArgumentException(UNSUPPORTED_CONCEPT);
        }
        return labelsForAllComponents;
    }

    private Tuple<List<String>, List<TimeDelta>> handleTimeConcept(List<TimeDelta> carryOverList, TimeDimension timeDimension, int numberOfLabelsToGenerate, int componentIndex, Locale locale) {
        TimeConcept concept = timeDimension.concept(componentIndex);
        TimeLabel timeLabel = this.getTimeLabel(timeDimension, componentIndex, concept, locale);
        if (carryOverList.isEmpty()) {
            this.initializeCarryOverList(carryOverList, numberOfLabelsToGenerate, concept);
        }
        List<Tuple<String, TimeDelta>> labelsAndCarryOverForOneComponent = timeLabel.getNextNLabels(this.forecastOffset, numberOfLabelsToGenerate, carryOverList);
        return this.postProcessCyclicalAndIndexingLabels(labelsAndCarryOverForOneComponent, concept);
    }

    private void initializeCarryOverList(List<TimeDelta> carryOverList, int numberOfLabelsToGenerate, TimeConcept concept) {
        for (int j = 0; j < numberOfLabelsToGenerate; ++j) {
            TimeDelta delta = new TimeDelta(0L, concept.getUnit());
            carryOverList.add(delta);
        }
    }

    private Tuple<List<String>, List<TimeDelta>> postProcessCyclicalAndIndexingLabels(List<Tuple<String, TimeDelta>> labelsAndCarryOverForOneComponent, TimeConcept concept) {
        ArrayList labelsForOneComponent = new ArrayList();
        ArrayList carryOvers = new ArrayList();
        labelsAndCarryOverForOneComponent.stream().forEach(value -> {
            labelsForOneComponent.add(value._1);
            carryOvers.add(value._2);
        });
        return Tuple.of(labelsForOneComponent, carryOvers);
    }

    private Tuple<List<String>, List<TimeDelta>> handleNestedTime(TimeDimension timeDimension, int conceptIndex, int numberOfLabelsToGenerate) {
        int initialRowIndex = timeDimension.getRowOrder()[0];
        String initialLabel = timeDimension.getDateLabels(initialRowIndex)[conceptIndex];
        TimeUnit deltaUnit = timeDimension.getTimeDelta().getUnit();
        if (TimeUtils.isUnitOfTime(deltaUnit)) {
            return this.generateNestedTimeLabels(initialLabel, numberOfLabelsToGenerate, timeDimension, conceptIndex);
        }
        return this.reuseNestedTimeLabels(initialLabel, numberOfLabelsToGenerate);
    }

    private Tuple<List<String>, List<TimeDelta>> reuseNestedTimeLabels(String initialLabel, int numberOfLabelsToGenerate) {
        ArrayList carryOverFromThisComponent = new ArrayList();
        ArrayList labels = new ArrayList();
        IntStream.range(0, numberOfLabelsToGenerate).forEach(j -> {
            labels.add(initialLabel);
            carryOverFromThisComponent.add(new TimeDelta(0L, TimeUnit.DAY));
        });
        return Tuple.of(labels, carryOverFromThisComponent);
    }

    private Tuple<List<String>, List<TimeDelta>> generateNestedTimeLabels(String initialLabel, int numberOfLabelsToGenerate, TimeDimension timeDimension, int conceptIndex) {
        Date initialDate = timeDimension.getDate(timeDimension.getRowOrder()[0], conceptIndex);
        ZonedDateTime current = TimeUtils.getZonedDateTime(initialDate, ZONE_ID);
        List<ZonedDateTime> forecastDates = this.getForecastedDates(timeDimension, current, numberOfLabelsToGenerate);
        int initialDay = current.getDayOfYear();
        List<String> labels = this.getLabelsFromDateForOneComponent(timeDimension, conceptIndex, initialLabel, forecastDates, current, false);
        ArrayList<TimeDelta> carryOverFromThisComponent = new ArrayList<TimeDelta>();
        for (int j = 0; j < forecastDates.size(); ++j) {
            ZonedDateTime zonedDateTime = forecastDates.get(j);
            int day = zonedDateTime.getDayOfYear();
            carryOverFromThisComponent.add(new TimeDelta((long)(day - initialDay), TimeUnit.DAY));
            initialDay = day;
        }
        return Tuple.of(labels, carryOverFromThisComponent);
    }

    private Function<ZonedDateTime, String> getLabelFunction(TimeDimension timeDimension, int timeComponentIndex, String lastLabel, boolean isWeekConceptPresent) {
        TimeConcept concept = timeDimension.concept(timeComponentIndex);
        Locale locale = timeDimension.getLocale();
        boolean isZeroIndexed = timeDimension.isComponentZeroIndexed(timeComponentIndex);
        if (concept.isTimestamp()) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern(timeDimension.getFormatString(timeComponentIndex));
            return parameter -> parameter.format(formatter);
        }
        Function<ZonedDateTime, String> timeFunction = null;
        Optional<Tuple<NumberFormat, Double>> labelInfo = LabelUtils.getDoubleValue(lastLabel, this.numberFormat, this.defaultNumberFormat);
        if (concept == TimeConcept.YEAR) {
            timeFunction = parameter -> this.getLabelForYear(labelInfo, (ZonedDateTime)parameter, isWeekConceptPresent, isZeroIndexed, timeDimension.isTwoDigitYear());
        } else if (ConceptUtils.isCyclical(timeComponentIndex)) {
            timeFunction = this.getLabelFunctionForCyclicalConcepts(timeDimension, timeComponentIndex, concept, locale, lastLabel, isZeroIndexed, labelInfo);
        } else {
            throw new IllegalArgumentException(UNSUPPORTED_CONCEPT);
        }
        return timeFunction;
    }

    private String getLabelForYear(Optional<Tuple<NumberFormat, Double>> labelInfo, ZonedDateTime forecastedDate, boolean isWeekConceptPresent, boolean isZeroIndexed, boolean isTwoDigitYear) {
        int year = forecastedDate.getYear();
        if (isWeekConceptPresent) {
            year = this.getWeekYear(forecastedDate);
        }
        if (isZeroIndexed) {
            --year;
        }
        if (isTwoDigitYear) {
            year %= 100;
        }
        return this.formatIntegerOutput(labelInfo, year);
    }

    private int getWeekYear(ZonedDateTime dateTime) {
        this.calendar.setTime(Date.from(dateTime.toInstant()));
        return this.calendar.getWeekYear();
    }

    private Function<ZonedDateTime, String> getLabelFunctionForCyclicalConcepts(TimeDimension timeDimension, int componentIndex, TimeConcept concept, Locale locale, String lastLabel, boolean isZeroIndexed, Optional<Tuple<NumberFormat, Double>> labelInfo) {
        Function<ZonedDateTime, String> timeFunction = null;
        switch (concept) {
            case MONTH: {
                timeFunction = dateTime -> {
                    int month = isZeroIndexed ? dateTime.getMonth().getValue() - 1 : dateTime.getMonth().getValue();
                    CyclicalTextLabels monthOfTheYear = new CyclicalTextLabels(locale, timeDimension, componentIndex);
                    return monthOfTheYear.getLabelsFromIntegerValues(lastLabel, Arrays.asList(month), isZeroIndexed).get(0);
                };
                break;
            }
            case DAY_OF_WEEK: {
                timeFunction = dateTime -> {
                    int dayOfWeek = dateTime.getDayOfWeek().getValue() % concept.getCycleLength();
                    CyclicalTextLabels daysOfWeek = new CyclicalTextLabels(locale, timeDimension, componentIndex);
                    String result = daysOfWeek.getLabelsFromIntegerValues(lastLabel, Arrays.asList(dayOfWeek), true).get(0);
                    if (!isZeroIndexed && StringUtils.isNumeric((String)result)) {
                        return String.valueOf(Integer.parseInt(result) + 1);
                    }
                    return result;
                };
                break;
            }
            case DAY_OF_MONTH: {
                if (isZeroIndexed) {
                    timeFunction = dateTime -> this.formatIntegerOutput(labelInfo, dateTime.getDayOfMonth() - 1);
                    break;
                }
                timeFunction = dateTime -> this.formatIntegerOutput(labelInfo, dateTime.getDayOfMonth());
                break;
            }
            case DAY_OF_YEAR: {
                if (isZeroIndexed) {
                    timeFunction = dateTime -> this.formatIntegerOutput(labelInfo, dateTime.getDayOfYear() - 1);
                    break;
                }
                timeFunction = dateTime -> this.formatIntegerOutput(labelInfo, dateTime.getDayOfYear());
                break;
            }
            case HOUR: {
                timeFunction = dateTime -> this.formatIntegerOutput(labelInfo, dateTime.getHour());
                break;
            }
            case MINUTE: {
                timeFunction = dateTime -> this.formatIntegerOutput(labelInfo, dateTime.getMinute());
                break;
            }
            case SECOND: 
            case SECOND_MINUTE: {
                timeFunction = dateTime -> this.formatIntegerOutput(labelInfo, dateTime.getSecond());
                break;
            }
            case QUARTER: {
                timeFunction = dateTime -> this.getLabelFunctionForQuarterCyclical((ZonedDateTime)dateTime, lastLabel, isZeroIndexed, labelInfo);
                break;
            }
            case WEEK: {
                timeFunction = dateTime -> this.getLabelForWeekCyclical(labelInfo, isZeroIndexed, (ZonedDateTime)dateTime);
                break;
            }
            default: {
                throw new IllegalArgumentException(UNSUPPORTED_CONCEPT);
            }
        }
        return timeFunction;
    }

    private String getLabelForWeekCyclical(Optional<Tuple<NumberFormat, Double>> labelInfo, boolean isZeroIndexed, ZonedDateTime dateTime) {
        this.calendar.setTime(Date.from(dateTime.toInstant()));
        int calendarWeek = this.calendar.get(3);
        int week = isZeroIndexed ? calendarWeek - 1 : calendarWeek;
        return this.formatIntegerOutput(labelInfo, week);
    }

    private String formatIntegerOutput(Optional<Tuple<NumberFormat, Double>> labelInfo, int value) {
        if (labelInfo.isPresent()) {
            NumberFormat format = (NumberFormat)labelInfo.get()._1;
            return format.format(value);
        }
        return Integer.toString(value);
    }

    private String getLabelFunctionForQuarterCyclical(ZonedDateTime dateTime, String lastLabel, boolean isZeroIndexed, Optional<Tuple<NumberFormat, Double>> labelInfo) {
        double monthValue = dateTime.getMonthValue();
        int quarterValue = (int)Math.ceil(monthValue / 3.0);
        if (isZeroIndexed) {
            --quarterValue;
        }
        String quarterNumber = Integer.toString(quarterValue);
        if (labelInfo.isPresent()) {
            NumberFormat format = (NumberFormat)labelInfo.get()._1;
            return format.format(quarterValue);
        }
        Tuple<String, Integer> quarter = TimeUtils.parseQuarter(lastLabel);
        return lastLabel.indexOf(((Integer)quarter._2).toString()) != 0 ? (String)quarter._1 + quarterNumber : quarterNumber + (String)quarter._1;
    }

    private TimeLabel getTimeLabel(TimeDimension timeDimension, int componentIndex, TimeConcept concept, Locale locale) {
        boolean isNumeric = timeDimension.isComponentNumeric(componentIndex);
        boolean isTextIndexingConcept = ConceptUtils.isTextIndexingConcept(concept, componentIndex);
        if ((this.handleAsDayOfTheWeek(concept, componentIndex, isNumeric) || this.handleAsMonthOfTheYear(concept, componentIndex, isNumeric)) && !timeDimension.isTreatAsCategorical(componentIndex)) {
            CyclicalTextLabels textLabels = new CyclicalTextLabels(locale, timeDimension, componentIndex);
            textLabels.setTreatAsIndexing(isTextIndexingConcept);
            return textLabels;
        }
        if (ConceptUtils.isCyclical(componentIndex)) {
            return new CyclicalIndexLabels(locale, timeDimension, componentIndex);
        }
        return new IndexLabels(locale, timeDimension, componentIndex);
    }

    private boolean handleAsDayOfTheWeek(TimeConcept concept, int indexInTimeDimension, boolean isNumeric) {
        return concept == TimeConcept.DAY_OF_WEEK && (ConceptUtils.isCyclical(indexInTimeDimension) || !isNumeric);
    }

    private boolean handleAsMonthOfTheYear(TimeConcept concept, int indexInTimeDimension, boolean isNumeric) {
        return concept == TimeConcept.MONTH && (ConceptUtils.isCyclical(indexInTimeDimension) || !isNumeric);
    }

    private List<String[]> initializeListOfArrays(int numberOfTimeComponents, int lengthOfList) {
        ArrayList<String[]> labelsForAllComponents = new ArrayList<String[]>();
        IntStream.range(0, lengthOfList).forEach(i -> labelsForAllComponents.add(new String[numberOfTimeComponents]));
        return labelsForAllComponents;
    }

    private void addComponentLabelsToList(List<String[]> labelsForAllComponents, List<String> labels, int componentIndex) {
        for (int i = 0; i < labelsForAllComponents.size(); ++i) {
            String[] labelsForOneRow = labelsForAllComponents.get(i);
            labelsForOneRow[componentIndex] = labels.get(i);
            labelsForAllComponents.set(i, labelsForOneRow);
        }
    }
}

