/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.models;

import com.ibm.bi.predict.algorithms.forecasting.ForecastingAlgorithmContext;
import com.ibm.bi.predict.algorithms.forecasting.es.ESFit;
import com.ibm.bi.predict.algorithms.forecasting.es.ESMethod;
import com.ibm.bi.predict.algorithms.forecasting.es.ExponentialSmoothing;
import com.ibm.bi.predict.algorithms.forecasting.es.PeriodSelection;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingNoModelException;
import com.ibm.bi.predict.algorithms.forecasting.labels.TimeSeriesLabelGenerator;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingStatisticalDetails;
import com.ibm.bi.predict.algorithms.forecasting.result.ModelValue;
import com.ibm.bi.predict.algorithms.forecasting.result.Outlier;
import com.ibm.bi.predict.algorithms.forecasting.result.OutlierType;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.algorithms.forecasting.result.TimeValue;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.data.Range;
import com.ibm.bi.predict.graph.Tree;
import com.ibm.bi.predict.graph.TreeNode;
import com.ibm.bi.predict.result.Message;
import com.ibm.bi.predict.result.MessageCode;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class ModelBuilder {
    private static final String LOCALE = "locale";
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(ModelBuilder.class);
    private final ForecastingAlgorithmContext context;
    private static final double DEFAULT_FORECAST_PERCENTAGE = 0.2;
    private boolean includeOutliers;

    public ModelBuilder(ForecastingAlgorithmContext context) {
        this.context = context;
        this.includeOutliers = context.getBoolean("forecast.config.includeOutliers", false);
    }

    public static double[] forecastNSteps(int start, int length, ESFit forecastModel) {
        return IntStream.rangeClosed(1 + start, length + start).parallel().mapToDouble(forecastModel::forecast).toArray();
    }

    public SeriesResult fit(SeriesResult seriesResult, Optional<Integer> forecastPeriods) {
        double[] historicalValues = seriesResult.getHistoricalValues();
        int n = forecastPeriods.orElseGet(() -> this.calculateForecastPeriods(historicalValues.length + seriesResult.getTrimmedValuesCount()));
        ESFit forecastModel = this.fitModel(historicalValues);
        double[] forecastValues = ModelBuilder.forecastNSteps(0, n + seriesResult.getForecastOffset(), forecastModel);
        Range[] confidenceIntervals = ModelBuilder.getConfidenceIntervals(0, n + seriesResult.getForecastOffset(), seriesResult.getConfidenceLevel(), forecastModel);
        ModelValue[] modelValues = this.getModelValues(seriesResult.getForecastOffset(), historicalValues, forecastValues, confidenceIntervals);
        return seriesResult.setForecastValues(modelValues).setStatisticalDetails(this.generateStatisticalDetails(forecastModel, seriesResult)).setESFit(forecastModel).setOutliers(this.findOutliers(historicalValues, this.getHistoryConfidenceLevel(), forecastModel)).setTimeDimension(this.context.getTimeDimension());
    }

    public Tree<SeriesResult> fit(Tree<SeriesResult> hierarchy, Optional<Integer> forecastPeriods) {
        for (TreeNode<SeriesResult> leaf : hierarchy.root().leaves()) {
            SeriesResult modelResult;
            try {
                modelResult = this.fit(leaf.content(), forecastPeriods);
            }
            catch (ForecastingNoModelException e) {
                LOGGER.warn("Failed to fit a model for a series", (Throwable)((Object)e));
                modelResult = leaf.content().setIsForecastSuccessful(false).setStatisticalDetails(new ForecastingStatisticalDetails(leaf.content(), this.context)).setErrorMessage(new Message(MessageCode.FORECASTING_NOTES_NO_MODEL, this.context.getLocale(LOCALE)));
            }
            leaf.content(modelResult);
        }
        this.consolidate(hierarchy);
        return hierarchy;
    }

    public Map<String, SeriesResult> fit(List<Tree<SeriesResult>> hierarchies, Optional<Integer> forecastPeriods) {
        return hierarchies.stream().map(v -> this.fit((Tree<SeriesResult>)v, forecastPeriods)).flatMap(tree -> tree.nodes().stream()).map(TreeNode::content).collect(Collectors.toMap(SeriesResult::id, sr -> sr));
    }

    void consolidate(Tree<SeriesResult> hierarchy) {
        hierarchy.walk(this::updateContent, true);
    }

    void updateContent(TreeNode<SeriesResult> node) {
        if (node.parent() != null) {
            node.parent().content().combine(node.content());
        }
    }

    protected TimeSeriesLabelGenerator getTimeSeriesLabelGenerator(int forecastOffset) {
        return new TimeSeriesLabelGenerator(forecastOffset, this.context);
    }

    private Outlier[] findOutliers(double[] historyValues, double level, ESFit model) {
        TimeDimension time = this.context.getTimeDimension();
        ArrayList<Outlier> outlierList = new ArrayList<Outlier>();
        if (this.includeOutliers) {
            Range[] historyRange = ModelBuilder.getHistoricalConfidenceIntervals(historyValues.length, level, model);
            for (int i = 0; i < historyValues.length; ++i) {
                if (!(historyValues[i] < historyRange[i].minInclusive()) && !(historyValues[i] > historyRange[i].maxExclusive())) continue;
                outlierList.add(new Outlier(this.timeValueAt(i - (int)time.getTimeIndexMapper().missingCountTo(i)), historyValues[i] < historyRange[i].minInclusive() ? OutlierType.low : OutlierType.hi, i, historyValues.length, historyValues[i], model.historical(i, 1), historyValues[i] < historyRange[i].minInclusive() ? historyRange[i].minInclusive() : historyRange[i].maxExclusive()));
            }
        }
        return outlierList.toArray(new Outlier[0]);
    }

    private double getHistoryConfidenceLevel() {
        return this.context.getDouble("forecast.config.historyConfidenceLevel", 0.9974);
    }

    private TimeValue timeValueAt(int index) {
        TimeDimension time = this.context.getTimeDimension();
        String[] labels = time != null ? time.getDateLabels(time.getRowOrder()[index]) : new String[]{"Indexed"};
        return new TimeValue(index, labels);
    }

    private ESFit fitModel(double[] historicalValues) {
        int cycle = this.context.getCycleLength();
        PeriodSelection period = this.context.getIntOpt("forecast.config.seasonalityPeriod").map(PeriodSelection::knownPeriod).orElse(cycle > 0 ? PeriodSelection.knownTimeCycle(cycle) : PeriodSelection.unknown());
        if (this.context.hasModelType()) {
            return ExponentialSmoothing.fit(historicalValues, this.context.modelType(), period);
        }
        return ExponentialSmoothing.fit(historicalValues, period);
    }

    private int calculateForecastPeriods(int historicalValuesLength) {
        return (int)Math.ceil((double)historicalValuesLength * this.context.getDouble("forecast.config.forecastPercentage", 0.2));
    }

    private ModelValue[] getModelValues(int forecastOffset, double[] historicalValues, double[] forecastValues, Range[] confidenceIntervals) {
        List<String[]> labels = this.generateForecastingLabels(forecastOffset, forecastValues.length);
        return IntStream.range(0, forecastValues.length).mapToObj(i -> this.makeModelValue(historicalValues.length, forecastValues[i], confidenceIntervals[i], labels, i)).collect(Collectors.toList()).toArray(new ModelValue[forecastValues.length]);
    }

    private List<String[]> generateForecastingLabels(int forecastOffset, int numberOfValuesToGenerate) {
        TimeSeriesLabelGenerator labelGenerator = this.getTimeSeriesLabelGenerator(forecastOffset);
        List<String[]> labels = null;
        try {
            labels = labelGenerator.generate(numberOfValuesToGenerate);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Label generation code failed to create labels", (Throwable)e);
        }
        return labels;
    }

    private ModelValue makeModelValue(int historicalValueLength, double forecastValue, Range confidenceInterval, List<String[]> labels, int timeIndex) {
        return new ModelValue(this.makeForecastTime(historicalValueLength, timeIndex, labels), forecastValue, confidenceInterval.minInclusive(), confidenceInterval.maxExclusive());
    }

    private TimeValue makeForecastTime(int historicalValueLength, int timeIndex, List<String[]> labels) {
        int forecastIndex = historicalValueLength + timeIndex;
        if (labels != null) {
            return new TimeValue(forecastIndex, labels.get(timeIndex));
        }
        LOGGER.warn("Label generation code failed to create labels");
        return this.makeDefaultForecastTime(forecastIndex);
    }

    private TimeValue makeDefaultForecastTime(int forecastIndex) {
        TimeDimension time = this.context.getTimeDimension();
        if (time == null) {
            return new TimeValue(forecastIndex, new String[]{"t" + forecastIndex});
        }
        int timeComponents = time.getNumberOfComponents();
        String[] names = new String[timeComponents];
        for (int i = 0; i < timeComponents; ++i) {
            names[i] = time.getDataColumn(i).getId() + forecastIndex;
        }
        return new TimeValue(forecastIndex, names);
    }

    static Range[] getConfidenceIntervals(int start, int length, double level, ESFit forecastModel) {
        return (Range[])IntStream.rangeClosed(1 + start, length + start).mapToObj(i -> forecastModel.forecastConfidence(i, level)).toArray(Range[]::new);
    }

    static Range[] getHistoricalConfidenceIntervals(int length, double level, ESFit forecastModel) {
        return (Range[])IntStream.rangeClosed(0, length - 1).mapToObj(i -> forecastModel.historyConfidence(i, level)).toArray(Range[]::new);
    }

    private ForecastingStatisticalDetails generateStatisticalDetails(ESFit forecastModel, SeriesResult seriesResult) {
        ForecastingStatisticalDetails statDetails = new ForecastingStatisticalDetails(forecastModel, seriesResult.setIsForecastSuccessful(true), this.context);
        this.addNotes(statDetails, forecastModel);
        statDetails.concatNotes();
        return statDetails;
    }

    private void addNotes(ForecastingStatisticalDetails statDetails, ESFit forecastModel) {
        if (this.seasonalPeriodSpecified() && this.nonSeasonalModel(statDetails)) {
            statDetails.addNote(MessageCode.FORECASTING_NON_SEASONAL_MODEL_USED, this.context.getLocale(LOCALE), this.context.getIntOpt("forecast.config.seasonalityPeriod").get());
        }
        if (forecastModel.getOptimizeError()) {
            statDetails.addNote(MessageCode.FORECASTING_MISSING_MODEL, this.context.getLocale(LOCALE), new Object[0]);
        }
        if (forecastModel.hasRestrictedModels()) {
            statDetails.addNote(MessageCode.FORECASTING_RESTRICTED_MODEL, this.context.getLocale(LOCALE), new Object[0]);
        }
    }

    private boolean seasonalPeriodSpecified() {
        return this.context.getIntOpt("forecast.config.seasonalityPeriod").filter(period -> period > 1).isPresent();
    }

    private boolean nonSeasonalModel(ForecastingStatisticalDetails statDetails) {
        boolean specifiedNonSeasonal = this.context.hasModelType() && this.context.modelType().seasonality() == ESMethod.Seasonality.NONE;
        return statDetails.getSeasonType() == ESMethod.Seasonality.NONE && !specifiedNonSeasonal;
    }
}

