/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.result;

import com.ibm.bi.predict.algorithms.forecasting.result.ResultSorter;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import java.util.List;
import java.util.Map;

public class ForecastingResultData {
    private final Map<String, SeriesResult> seriesResults;
    private final TimeDimension timeDimension;

    public ForecastingResultData(Map<String, SeriesResult> seriesResults, TimeDimension timeDimension) {
        this.seriesResults = seriesResults;
        this.timeDimension = timeDimension;
    }

    public Map<String, SeriesResult> getSeriesResults() {
        return this.seriesResults;
    }

    public List<SeriesResult> getOrderedSeriesResults() {
        return ResultSorter.getOrderedResults(this.seriesResults.values(), SeriesResult::id);
    }

    public TimeDimension getTimeDimension() {
        return this.timeDimension;
    }

    public TimeDelta getTimeDelta() {
        return this.timeDimension.getTimeDelta();
    }
}

