/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.result;

import com.ibm.bi.predict.algorithms.StatisticalDetails;
import com.ibm.bi.predict.algorithms.forecasting.ForecastingAlgorithmContext;
import com.ibm.bi.predict.algorithms.forecasting.es.ESDiagnostics;
import com.ibm.bi.predict.algorithms.forecasting.es.ESFit;
import com.ibm.bi.predict.algorithms.forecasting.es.ESMethod;
import com.ibm.bi.predict.algorithms.forecasting.es.ESParameters;
import com.ibm.bi.predict.algorithms.forecasting.result.SeriesResult;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.messages.Messages;
import com.ibm.bi.predict.messages.NoValueReplacement;
import com.ibm.bi.predict.result.MessageCode;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ForecastingStatisticalDetails
implements StatisticalDetails {
    private static final Logger LOG = PredictLoggerFactory.getLogger(ForecastingStatisticalDetails.class);
    private static final String REFERENCE_KEY = "reference";
    private static final String ACCURACY_KEY = "accuracy";
    private static final String MODEL_KEY = "model";
    private static final String DATA_KEY = "data";
    private static final String REF_FIELD_KEY = "field";
    private static final String REF_CATEGORY_KEY = "category";
    private static final String REF_TYPE_KEY = "type";
    private static final String CONFIDENCE_LVL_KEY = "confidenceLevel";
    private static final String IGNORED_KEY = "ignoredPeriods";
    private static final String PARAMETERS_KEY = "parameters";
    private static final String NOTES_KEY = "notes";
    private static final String TREND_KEY = "trend";
    private static final String SEASON_KEY = "season";
    private static final String TYPE_KEY = "type";
    private static final String STRENGTH_KEY = "strength";
    private static final String PERIOD_KEY = "period";
    private static final String STATUS_KEY = "status";
    private static final String SERIES_LENGTH_KEY = "seriesLength";
    private static final String MISSING_KEY = "missingCount";
    private static final String TIME_DELTA_UNIT_KEY = "timeDeltaUnit";
    private static final String MODEL_TYPE_MESSAGE_PREFIX = "FORECASTING_MODEL_";
    private static final String LOCALIZED_MESSAGES_BUNDLE = "Predict_Messages";
    private static final String LOCALIZED_SMARTANNOTATIONS_MESSAGES_BUNDLE = "Predict_Smart_Annotations";
    private static final String NO_VALUE = "NO_VALUE";
    private static final String TIME_UNIT_MESSAGE_KEY_PREFIX = "FORECASTING_TIME_UNIT_";
    private String refFieldId = "";
    private String refCategory = "";
    private static final String REF_TYPE = "TIME_SERIES_FORECASTING";
    private static final Double MINIMUM_ACCEPTABLE_AIC = -1000000.0;
    private int seasonalityPeriod;
    private double confidenceLevel;
    private int ignoredPeriods;
    private Map<String, Double> accuracyMetrics = new HashMap<String, Double>();
    private Map<String, Double> parameters = new HashMap<String, Double>();
    private ESMethod.Trend trendType;
    private ESMethod.Seasonality seasonType;
    private double trendContribution;
    private double seasonContribution;
    private int seriesLength;
    private int missingValues;
    private String emptyCategoryLabel = "";
    private String timeDeltaUnit = "";
    private String notes = "";
    private String forecastStatus = "";
    private String localizedStatusFailure = "";
    private String localizedStatusSuccess = "";
    private ArrayList<String> notesList = new ArrayList();
    private Messages messageBundle;
    private Messages saBundle;

    public ForecastingStatisticalDetails() {
        this.messageBundle = Messages.getMessagesFor((String)LOCALIZED_MESSAGES_BUNDLE, (Locale)Locale.ENGLISH);
    }

    public ForecastingStatisticalDetails(SeriesResult sr, ForecastingAlgorithmContext context) {
        this.messageBundle = Messages.getMessagesFor((String)LOCALIZED_MESSAGES_BUNDLE, (Locale)context.getLocale("locale"));
        this.localizedStatusFailure = this.messageBundle.get(MessageCode.FORECASTING_STATUS_FAILURE.toString(), new Object[0]);
        this.localizedStatusSuccess = this.messageBundle.get(MessageCode.FORECASTING_STATUS_SUCCESS.toString(), new Object[0]);
        if (context.getTimeDimension() != null) {
            long timeDeltaStep = context.getTimeDimension().getTimeDelta().getSteps();
            this.timeDeltaUnit = timeDeltaStep == 1L ? this.messageBundle.get(TIME_UNIT_MESSAGE_KEY_PREFIX + context.getTimeDimension().getTimeDelta().getUnit().toString().toUpperCase() + "_SINGULAR", new Object[0]) : this.messageBundle.get(TIME_UNIT_MESSAGE_KEY_PREFIX + context.getTimeDimension().getTimeDelta().getUnit().toString().toUpperCase(), new Object[]{timeDeltaStep});
        }
        this.saBundle = Messages.getMessagesFor((String)LOCALIZED_SMARTANNOTATIONS_MESSAGES_BUNDLE, (Locale)context.getLocale("locale"));
        this.emptyCategoryLabel = this.saBundle.get(NO_VALUE, new Object[0]);
        if (!sr.isNullHierarchyResult()) {
            this.refCategory = ForecastingStatisticalDetails.buildCategory(sr, context);
        }
        this.extractInfoFromSeriesResult(sr);
        this.fillNullForFailure();
    }

    public ForecastingStatisticalDetails(ESFit esfit, SeriesResult sr, ForecastingAlgorithmContext context) {
        this(sr, context);
        this.extractInfoFromESFit(esfit);
    }

    @Override
    public JSONObject get() {
        return this.serialize();
    }

    private final void fillNullForFailure() {
        this.nullAccuracyForFailure();
        this.trendContribution = Double.NaN;
        this.seasonContribution = Double.NaN;
    }

    public final void extractInfoFromSeriesResult(SeriesResult sr) {
        this.refFieldId = sr.getFieldId();
        if (sr.getHistoricalValues() != null) {
            this.seriesLength = sr.getHistoricalValues().length;
        }
        this.confidenceLevel = sr.getConfidenceLevel();
        this.ignoredPeriods = sr.getIgnoreLastNPeriods();
        this.missingValues = sr.getHistoricalValuesMissingCount();
        this.forecastStatus = sr.isForecastSuccessful() ? this.localizedStatusSuccess : this.localizedStatusFailure;
    }

    private static String buildCategory(SeriesResult sr, ForecastingAlgorithmContext context) {
        Messages saBundle = Messages.getMessagesFor((String)LOCALIZED_SMARTANNOTATIONS_MESSAGES_BUNDLE, (Locale)context.getLocale("locale"));
        String category = String.join((CharSequence)"|", sr.getCategories());
        if (!AggregationType.isNone((AggregationType)sr.getAggregationType())) {
            category = category + " (" + saBundle.get(sr.getAggregationType().toString(), new Object[0]) + ")";
        }
        return category;
    }

    public final void extractInfoFromESFit(ESFit esfit) {
        this.seasonalityPeriod = esfit.period();
        this.trendType = esfit.method().trend();
        this.seasonType = esfit.method().seasonality();
        this.extractParametersFromESParameters(esfit.parameters());
        this.extractAccuracyFromDiagnostics(esfit.diagnostics());
        this.extractStrengthFromFittedDiagnostics(esfit, esfit.getFittedDiagnostics());
    }

    public void extractStrengthFromFittedDiagnostics(ESFit esfit, Map<ESMethod, ESDiagnostics> fittedDiag) {
        if (esfit.method().hasTrend()) {
            ESMethod nonTrend = ESMethod.make(ESMethod.Trend.NONE, esfit.method().seasonality());
            this.trendContribution = fittedDiag.get(nonTrend) != null ? fittedDiag.get(nonTrend).MASE() - esfit.diagnostics().MASE() : Double.NaN;
        }
        if (esfit.method().hasSeasonality()) {
            ESMethod nonSeason = ESMethod.make(esfit.method().trend(), ESMethod.Seasonality.NONE);
            this.seasonContribution = fittedDiag.get(nonSeason) != null ? fittedDiag.get(nonSeason).MASE() - esfit.diagnostics().MASE() : Double.NaN;
        }
    }

    public void extractAccuracyFromDiagnostics(ESDiagnostics diag) {
        this.addAccuracyMetric("RMSE", diag.RMSE());
        this.addAccuracyMetric("MASE", diag.MASE());
        this.addAccuracyMetric("MAE", diag.MAE());
        this.addAccuracyMetric("AIC", diag.AIC() < MINIMUM_ACCEPTABLE_AIC ? Double.NaN : diag.AIC());
        this.addAccuracyMetric("MAPE", diag.MAPE());
        this.addAccuracyMetric("predictiveStrength", Math.max(1.0 - diag.MASE(), 0.0));
        this.addAccuracyMetric(ACCURACY_KEY, diag.accuracy());
    }

    private void nullAccuracyForFailure() {
        this.addAccuracyMetric("RMSE", Double.NaN);
        this.addAccuracyMetric("MASE", Double.NaN);
        this.addAccuracyMetric("MAE", Double.NaN);
        this.addAccuracyMetric("AIC", Double.NaN);
        this.addAccuracyMetric("MAPE", Double.NaN);
        this.addAccuracyMetric("predictiveStrength", Double.NaN);
    }

    private void extractParametersFromESParameters(ESParameters params) {
        if (!Double.isNaN(params.alpha)) {
            this.addParameter("alpha", params.alpha);
        }
        if (!Double.isNaN(params.beta)) {
            this.addParameter("beta", params.beta);
        }
        if (!Double.isNaN(params.gamma)) {
            this.addParameter("gamma", params.gamma);
        }
        if (!Double.isNaN(params.phi)) {
            this.addParameter("phi", params.phi);
        }
    }

    private JSONObject serialize() {
        JSONObject result = new JSONObject();
        try {
            result.put(REFERENCE_KEY, (Map)this.serializeReferenceValues());
            result.put(ACCURACY_KEY, (Map)this.serializeAccuracyMeasures());
            result.put(MODEL_KEY, (Map)this.serializeModelDetails());
            result.put(DATA_KEY, (Map)this.serializeDataDetails());
            result.put(STATUS_KEY, (Object)this.forecastStatus);
            result.put(NOTES_KEY, (Object)this.notes);
        }
        catch (JSONException e) {
            LOG.error("JSONException error while serializing Forecasting Statistical Details into json object error={}", (Object)e.getMessage(), (Object)e);
        }
        return result;
    }

    private JSONObject serializeDataDetails() throws JSONException {
        JSONObject data = new JSONObject();
        data.put(SERIES_LENGTH_KEY, this.seriesLength);
        data.put(MISSING_KEY, this.missingValues);
        data.put(TIME_DELTA_UNIT_KEY, (Object)this.timeDeltaUnit);
        return data;
    }

    private JSONObject serializeModelDetails() throws JSONException {
        JSONObject model = new JSONObject();
        model.put(CONFIDENCE_LVL_KEY, this.confidenceLevel);
        model.put(IGNORED_KEY, this.ignoredPeriods);
        model.put(PARAMETERS_KEY, (Map)this.serializeParameters());
        model.put(TREND_KEY, (Map)this.serializeTrendDetails());
        model.put(SEASON_KEY, (Map)this.serializeSeasonalDetails());
        return model;
    }

    private JSONObject serializeSeasonalDetails() throws JSONException {
        JSONObject season = new JSONObject();
        String seasonTypeString = this.seasonType != null ? this.messageBundle.get(MODEL_TYPE_MESSAGE_PREFIX + this.seasonType.toString(), new Object[0]) : this.messageBundle.get(MessageCode.MISSING_INPUT_SHORT_SPLIT_LABEL.toString(), new Object[0]);
        season.put("type", (Object)seasonTypeString);
        if (this.seasonType != ESMethod.Seasonality.NONE && this.seasonType != null) {
            season.put(PERIOD_KEY, this.seasonalityPeriod);
            if (!Double.isNaN(this.seasonContribution)) {
                season.put(STRENGTH_KEY, this.seasonContribution);
            }
        }
        return season;
    }

    private JSONObject serializeTrendDetails() throws JSONException {
        JSONObject trend = new JSONObject();
        String trendTypeString = this.trendType != null ? this.messageBundle.get(MODEL_TYPE_MESSAGE_PREFIX + this.trendType.toString(), new Object[0]) : this.messageBundle.get(MessageCode.MISSING_INPUT_SHORT_SPLIT_LABEL.toString(), new Object[0]);
        trend.put("type", (Object)trendTypeString);
        if (this.trendType != ESMethod.Trend.NONE && this.trendType != null && !Double.isNaN(this.trendContribution)) {
            trend.put(STRENGTH_KEY, this.trendContribution);
        }
        return trend;
    }

    private JSONObject serializeParameters() throws JSONException {
        JSONObject parametersJson = new JSONObject();
        for (Map.Entry<String, Double> param : this.parameters.entrySet()) {
            parametersJson.put(param.getKey(), (Object)param.getValue());
        }
        return parametersJson;
    }

    private JSONObject serializeAccuracyMeasures() throws JSONException {
        JSONObject accuracyJson = new JSONObject();
        for (Map.Entry<String, Double> metric : this.accuracyMetrics.entrySet()) {
            if (Double.isNaN(metric.getValue())) {
                accuracyJson.put(metric.getKey(), (Object)null);
                continue;
            }
            accuracyJson.put(metric.getKey(), (Object)metric.getValue());
        }
        return accuracyJson;
    }

    private JSONObject serializeReferenceValues() throws JSONException {
        JSONObject reference = new JSONObject();
        reference.put(REF_FIELD_KEY, (Object)this.refFieldId);
        if (!this.refCategory.isEmpty()) {
            String category = NoValueReplacement.replace((String)this.refCategory, (String)this.emptyCategoryLabel);
            reference.put(REF_CATEGORY_KEY, (Object)category);
        }
        reference.put("type", (Object)REF_TYPE);
        return reference;
    }

    public void addParameter(String parameter, Double value) {
        this.parameters.put(parameter, value);
    }

    public void addAccuracyMetric(String metric, Double value) {
        this.accuracyMetrics.put(metric, value);
    }

    public void addNote(MessageCode messageCode, Locale locale, Object ... parameters) {
        String translatedMessage = Messages.getMessagesFor((String)LOCALIZED_MESSAGES_BUNDLE, (Locale)locale).get(messageCode.name(), parameters);
        if (!this.notesList.contains(translatedMessage)) {
            this.notesList.add(translatedMessage);
        }
    }

    public void concatNotes() {
        this.notes = String.join((CharSequence)" ", this.notesList);
    }

    public String getNotes() {
        return this.notes;
    }

    public String getRefFieldId() {
        return this.refFieldId;
    }

    public String getRefCategory() {
        return this.refCategory;
    }

    public double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public Map<String, Double> getParameters() {
        return this.parameters;
    }

    public int getSeasonalityPeriod() {
        return this.seasonalityPeriod;
    }

    public ESMethod.Seasonality getSeasonType() {
        return this.seasonType;
    }

    public ESMethod.Trend getTrendType() {
        return this.trendType;
    }

    public Map<String, Double> getAccuracyMetrics() {
        return this.accuracyMetrics;
    }

    public int getMissingValues() {
        return this.missingValues;
    }

    public int getIgnoredPeriods() {
        return this.ignoredPeriods;
    }

    public double getTrendContribution() {
        return this.trendContribution;
    }

    public double getSeasonContribution() {
        return this.seasonContribution;
    }

    public String getTimeDeltaUnit() {
        return this.timeDeltaUnit;
    }

    public String getForecastStatus() {
        return this.forecastStatus;
    }

    public int getSeriesLength() {
        return this.seriesLength;
    }
}

