/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.result;

import com.ibm.bi.predict.algorithms.forecasting.result.OutlierType;
import com.ibm.bi.predict.algorithms.forecasting.result.TimeValue;
import java.util.Objects;

public class Outlier
implements Comparable<Outlier> {
    private TimeValue time;
    private OutlierType type;
    private boolean isLastObservedPoint;
    private double magnitude;
    private int index;

    public Outlier(TimeValue time, OutlierType type, int index, int seriesLength, double historicValue, double expectedValue, double nearestConfidenceThreshold) {
        this.time = time;
        this.type = type;
        this.index = index;
        this.isLastObservedPoint = index == seriesLength - 1;
        this.magnitude = Math.abs((historicValue - nearestConfidenceThreshold) / (expectedValue - nearestConfidenceThreshold));
    }

    public TimeValue getTime() {
        return this.time;
    }

    public OutlierType getType() {
        return this.type;
    }

    public boolean isLastObservedPoint() {
        return this.isLastObservedPoint;
    }

    public double getMagnitude() {
        return this.magnitude;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Outlier)) {
            return false;
        }
        Outlier outlier = (Outlier)o;
        return this.time.equals(outlier.time) && this.type == outlier.type && this.isLastObservedPoint == outlier.isLastObservedPoint;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.time, this.type});
    }

    @Override
    public int compareTo(Outlier comp) {
        return Double.compare(this.getMagnitude(), comp.getMagnitude());
    }
}

