/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.result;

import com.ibm.bi.predict.algorithms.forecasting.data.NearestNeighborsLinearInterpolation;
import com.ibm.bi.predict.algorithms.forecasting.es.ESFit;
import com.ibm.bi.predict.algorithms.forecasting.result.ForecastingStatisticalDetails;
import com.ibm.bi.predict.algorithms.forecasting.result.ModelValue;
import com.ibm.bi.predict.algorithms.forecasting.result.Outlier;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.dataaccess.types.AggregationType;
import com.ibm.bi.predict.result.Message;
import com.ibm.bi.predict.types.Identifiable;
import com.ibm.bi.predict.utils.Tuple;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class SeriesResult
implements Identifiable {
    private final String id;
    private final String label;
    private final int[] columns;
    private boolean isForecastSuccessful;
    private Message errorMessage;
    private final String[] categories;
    private final boolean nullHierarchyResult;
    private ForecastingStatisticalDetails statisticalDetails;
    private ModelValue[] forecastValues;
    private double confidenceLevel;
    private double[] historicalValues;
    private Outlier[] outliers;
    private int historicalValuesMissingCount;
    private String fieldId;
    private int ignoreLastNPeriods;
    private int forecastOffset;
    private int trimmedValuesCount;
    private AggregationType aggregationType;
    private ESFit esFit;
    private TimeDimension timeDimension;
    private Set<Integer> missingValueIndices = new HashSet<Integer>();

    public SeriesResult(String id, String label, int[] columns, String[] categories) {
        this(id, label, columns, categories, false);
    }

    public SeriesResult(String id, String label, int[] columns, String[] categories, boolean nullHierarchyResult) {
        SeriesResult.checkArguments(id, label, categories);
        this.id = id;
        this.label = label;
        this.columns = columns;
        this.categories = categories;
        this.nullHierarchyResult = nullHierarchyResult;
    }

    public String id() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public int[] getColumns() {
        return this.columns;
    }

    public String[] getCategories() {
        return this.categories;
    }

    public ESFit getESFit() {
        return this.esFit;
    }

    public boolean isNullHierarchyResult() {
        return this.nullHierarchyResult;
    }

    public TimeDimension getTimeDimension() {
        return this.timeDimension;
    }

    public SeriesResult setTimeDimension(TimeDimension timeDimension) {
        this.timeDimension = timeDimension;
        return this;
    }

    public SeriesResult setESFit(ESFit esFit) {
        this.esFit = esFit;
        return this;
    }

    public SeriesResult setForecastValues(ModelValue[] forecastValues) {
        this.forecastValues = forecastValues;
        return this;
    }

    public ModelValue[] getForecastValues() {
        return this.forecastValues;
    }

    public SeriesResult setConfidenceLevel(double confidenceLevel) {
        this.confidenceLevel = confidenceLevel;
        return this;
    }

    public double getConfidenceLevel() {
        return this.confidenceLevel;
    }

    public SeriesResult setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
        return this;
    }

    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    public boolean isForecastSuccessful() {
        return this.isForecastSuccessful;
    }

    public SeriesResult setIsForecastSuccessful(boolean isForecastSuccessful) {
        this.isForecastSuccessful = isForecastSuccessful;
        return this;
    }

    public SeriesResult setHistoricalValues(double[] historicalValues) {
        this.historicalValues = historicalValues;
        return this;
    }

    public double[] getHistoricalValues() {
        return this.historicalValues;
    }

    public SeriesResult setIgnoreLastNPeriods(int n) {
        this.ignoreLastNPeriods = n;
        return this;
    }

    public int getIgnoreLastNPeriods() {
        return this.ignoreLastNPeriods;
    }

    public SeriesResult setStatisticalDetails(ForecastingStatisticalDetails statDetails) {
        this.statisticalDetails = statDetails;
        return this;
    }

    public ForecastingStatisticalDetails getStatisticalDetails() {
        return this.statisticalDetails;
    }

    public SeriesResult setOutliers(Outlier[] outliers) {
        this.outliers = outliers;
        return this;
    }

    public Outlier[] getOutliers() {
        return this.outliers;
    }

    public String getFieldId() {
        return this.fieldId;
    }

    public SeriesResult setFieldId(String fieldId) {
        this.fieldId = fieldId;
        return this;
    }

    public SeriesResult setHistoricalValuesMissingCount(int historicalValuesMissingCount) {
        this.historicalValuesMissingCount = historicalValuesMissingCount;
        return this;
    }

    public Message getErrorMessage() {
        return this.errorMessage;
    }

    public SeriesResult setErrorMessage(Message message) {
        this.errorMessage = message;
        return this;
    }

    public void handleMissingValues() {
        NearestNeighborsLinearInterpolation model = new NearestNeighborsLinearInterpolation(this.historicalValues);
        for (int i = 0; i < this.historicalValues.length; ++i) {
            if (!Double.isNaN(this.historicalValues[i])) continue;
            this.historicalValues[i] = model.interpolate(i);
            this.missingValueIndices.add(i);
        }
    }

    public SeriesResult trimMissingValues() {
        int initialCount = this.historicalValues.length;
        Tuple<Integer, double[]> trimResult = NearestNeighborsLinearInterpolation.handleMissingValues(this.historicalValues, false);
        this.forecastOffset = (Integer)trimResult._1;
        this.historicalValues = (double[])trimResult._2;
        this.trimmedValuesCount = initialCount - this.historicalValues.length;
        this.historicalValuesMissingCount -= this.trimmedValuesCount;
        return this;
    }

    public void combine(SeriesResult otherResult) {
        ModelValue[] otherForecastValues = otherResult.getForecastValues();
        if (this.forecastValues == null) {
            this.forecastValues = SeriesResult.deepCopy(otherForecastValues);
            return;
        }
        Arrays.setAll(this.forecastValues, i -> this.forecastValues[i].add(otherForecastValues[i]));
    }

    public int getHistoricalValuesMissingCount() {
        return this.historicalValuesMissingCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SeriesResult)) {
            return false;
        }
        SeriesResult other = (SeriesResult)o;
        return new EqualsBuilder().append((Object[])this.categories, (Object[])this.categories).append((Object[])this.forecastValues, (Object[])other.forecastValues).append(this.confidenceLevel, other.confidenceLevel).append(this.historicalValues, other.historicalValues).append((Object[])this.outliers, (Object[])other.outliers).append(this.historicalValuesMissingCount, other.historicalValuesMissingCount).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object[])this.categories).append((Object[])this.forecastValues).append(this.confidenceLevel).append(this.historicalValues).append((Object[])this.outliers).append(this.historicalValuesMissingCount).toHashCode();
    }

    private static void checkArguments(String id, String label, String[] categories) {
        SeriesResult.checkIdArg(id);
        SeriesResult.checkLabelArg(label);
        SeriesResult.checkCategoriesArg(categories);
    }

    private static void checkCategoriesArg(String[] categories) {
        if (categories == null || categories.length == 0) {
            throw new IllegalArgumentException("categories argument should be a non emty array of strings");
        }
    }

    private static void checkLabelArg(String label) {
        if (label == null || label.isEmpty()) {
            throw new IllegalArgumentException("label argument should be a non empty string");
        }
    }

    private static void checkIdArg(String id) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("id argument should be a non empty string");
        }
    }

    private static ModelValue[] deepCopy(ModelValue[] values) {
        ModelValue[] deepCopy = new ModelValue[values.length];
        Arrays.setAll(deepCopy, i -> new ModelValue(values[i]));
        return deepCopy;
    }

    public int getForecastOffset() {
        return this.forecastOffset;
    }

    public SeriesResult setForecastOffset(int forecastOffset) {
        this.forecastOffset = forecastOffset;
        return this;
    }

    public int getTrimmedValuesCount() {
        return this.trimmedValuesCount;
    }

    public SeriesResult setTrimmedValuesCount(int count) {
        this.trimmedValuesCount = count;
        return this;
    }

    public Set<Integer> getMissingValueIndices() {
        return this.missingValueIndices;
    }

    public SeriesResult setMissingValueIndices(Set<Integer> indices) {
        this.missingValueIndices = indices;
        return this;
    }

    public String toString() {
        String firstForecast = "NaN";
        if (this.forecastValues != null && this.forecastValues.length >= 1) {
            firstForecast = this.forecastValues[0].getValue() + "";
        }
        String model = "Null";
        double accuracy = 0.0;
        int period = 0;
        if (this.esFit != null) {
            model = this.esFit.name();
            accuracy = this.esFit.accuracy();
            period = this.esFit.period();
        }
        return String.format("SeriesResult(label: %s, model: %s, accuracy: %f, seasonality: %d, first forecast: %s)", this.getLabel(), model, accuracy, period, firstForecast);
    }
}

