/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.result;

import com.ibm.bi.predict.algorithms.forecasting.result.ColumnUpdater;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;

public class UpdaterContainers {
    private int numComponents;
    private DataColumn parentColumn;
    private List<List<Integer>> newCategoryIndicesPerColumn;
    private List<Set<Category>> newCategoriesPerColumn;
    private List<Map<String, Integer>> categoryMapsPerColumn;
    private List<List<Integer>> originalCategoryIndicesPerColumn;

    UpdaterContainers(TimeDimension timeDimension) {
        this.parentColumn = timeDimension.consolidate();
        this.numComponents = timeDimension.getNumberOfComponents();
        this.newCategoryIndicesPerColumn = new ArrayList<List<Integer>>();
        this.newCategoriesPerColumn = new ArrayList<Set<Category>>();
        this.categoryMapsPerColumn = new ArrayList<Map<String, Integer>>();
        this.originalCategoryIndicesPerColumn = new ArrayList<List<Integer>>();
        this.initializeContainers(timeDimension);
        this.setOriginalIndicesPerColumn(timeDimension);
    }

    int getNumComponents() {
        return this.numComponents;
    }

    DataColumn getParentColumn() {
        return this.parentColumn;
    }

    List<List<Integer>> getNewCategoryIndicesPerColumn() {
        return this.newCategoryIndicesPerColumn;
    }

    List<Set<Category>> getNewCategoriesPerColumn() {
        return this.newCategoriesPerColumn;
    }

    List<Map<String, Integer>> getCategoryMapsPerColumn() {
        return this.categoryMapsPerColumn;
    }

    List<List<Integer>> getOriginalCategoryIndicesPerColumn() {
        return this.originalCategoryIndicesPerColumn;
    }

    private void initializeContainers(TimeDimension timeDimension) {
        IntStream.range(0, this.numComponents).forEach(i -> {
            DataColumn column = timeDimension.getDataColumn(i);
            Map<String, Integer> categoryMap = ColumnUpdater.mapColumnCategories(column);
            this.categoryMapsPerColumn.add(categoryMap);
            this.newCategoriesPerColumn.add(new LinkedHashSet());
            this.newCategoryIndicesPerColumn.add(new ArrayList());
        });
    }

    private void setOriginalIndicesPerColumn(TimeDimension timeDimension) {
        IntStream.range(0, this.categoryMapsPerColumn.size()).forEach(i -> this.originalCategoryIndicesPerColumn.add(new ArrayList()));
        Set<Category> invalidCategories = timeDimension.getInvalidCategories();
        this.parentColumn.getCategories().forEach(category -> {
            if (!invalidCategories.contains(category)) {
                ColumnUpdater.addDataForValidCategory(this.categoryMapsPerColumn, this.originalCategoryIndicesPerColumn, category);
            }
        });
    }
}

