/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.time;

import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import java.util.Calendar;

public class TimeLimits {
    private static final int DAYS_IN_YEAR = 365;
    private static final int DAYS_IN_LEAP_YEAR = 366;

    private TimeLimits() {
    }

    public static int getLimit(int conceptIndex, TimeDelta carryOver, TimeDimension time, int prevLabelIndex) {
        int firstLabelPosition = time.getRowOrder()[prevLabelIndex];
        TimeConcept concept = time.concept(conceptIndex);
        int limit = -1;
        if (!ConceptUtils.hasVariableLimits(concept, conceptIndex)) {
            return limit;
        }
        double[] labelValues = time.getLabelValues(firstLabelPosition);
        if (ConceptUtils.isCyclical(conceptIndex)) {
            int parentIndex = conceptIndex - 1;
            TimeConcept parentConcept = time.concept(parentIndex);
            if (concept == TimeConcept.DAY_OF_MONTH && ConceptUtils.isMonth(parentConcept)) {
                if (time.isTreatAsCategorical(parentIndex)) {
                    return time.concept(conceptIndex).getCycleLength();
                }
                double monthIndex = time.getDoubleComponentValueForRow(conceptIndex - 1, firstLabelPosition);
                return TimeLimits.getMonthLimit(conceptIndex, carryOver, (int)monthIndex, labelValues, time);
            }
            if (concept == TimeConcept.DAY_OF_YEAR && ConceptUtils.isYear(parentConcept)) {
                return TimeLimits.getYearLimit(parentConcept, conceptIndex, carryOver, labelValues);
            }
        }
        return limit;
    }

    private static int getMonthLimit(int conceptIndex, TimeDelta carryOver, int monthIndex, double[] labelValues, TimeDimension timeDim) {
        TimeConcept grandparentConcept;
        TimeConcept parentConcept = timeDim.concept(conceptIndex - 1);
        if (carryOver.getUnit() == parentConcept.getUnit()) {
            monthIndex = (int)((long)monthIndex + carryOver.getSteps());
        }
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        if (timeDim.isComponentZeroIndexed(conceptIndex - 1)) {
            cal.set(2, monthIndex);
        } else {
            cal.set(2, monthIndex - 1);
        }
        int grandparentIndex = conceptIndex - 2;
        if (grandparentIndex >= 0 && ConceptUtils.isYear(grandparentConcept = timeDim.concept(grandparentIndex))) {
            cal.set(1, (int)labelValues[grandparentIndex]);
        }
        return cal.getActualMaximum(5);
    }

    private static int getYearLimit(TimeConcept parentConcept, int conceptIndex, TimeDelta carryOver, double[] labelValues) {
        int year = (int)labelValues[conceptIndex - 1];
        if (carryOver.getUnit() == parentConcept.getUnit()) {
            year = (int)((long)year + carryOver.getSteps());
        }
        if (TimeLimits.isLeapYear(year)) {
            return 366;
        }
        return 365;
    }

    public static boolean isLeapYear(int year) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        return cal.getActualMaximum(6) >= 366;
    }
}

