/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.time;

import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.stream.IntStream;

public class TimeSorter {
    private TimeSorter() {
    }

    private static int[] sortFullDate(TimeDimension timeDimension) {
        ArrayList<Date> dates = new ArrayList<Date>();
        ArrayList<Integer> rollOverIndices = new ArrayList<Integer>();
        for (int i = 0; i < timeDimension.rowCount(); ++i) {
            Date date = timeDimension.getDate(i);
            if (date != null) {
                dates.add(date);
                continue;
            }
            rollOverIndices.add(i);
        }
        int[] sortedDates = IntStream.range(0, dates.size()).boxed().sorted(Comparator.comparing(dates::get)).mapToInt(ele -> ele).toArray();
        return TimeSorter.combineOrders(sortedDates, rollOverIndices);
    }

    private static int[] combineOrders(int[] sortedDates, List<Integer> rollOverIndices) {
        int[] rowOrder = new int[sortedDates.length + rollOverIndices.size()];
        IntStream.range(0, sortedDates.length).forEach(i -> {
            rowOrder[i] = sortedDates[i];
        });
        IntStream.range(0, rollOverIndices.size()).forEach(i -> {
            rowOrder[sortedDates.length + i] = (Integer)rollOverIndices.get(i);
        });
        return rowOrder;
    }

    private static int[] sortDateKey(TimeDimension timeDimension) {
        ArrayList<IntegerArray> dateKeys = new ArrayList<IntegerArray>();
        for (int i = 0; i < timeDimension.rowCount(); ++i) {
            int[] intArray = timeDimension.getDateKey(i);
            dateKeys.add(new IntegerArray(intArray));
        }
        return IntStream.range(0, dateKeys.size()).boxed().sorted(Comparator.comparing(dateKeys::get)).mapToInt(ele -> ele).toArray();
    }

    public static int[] findRowOrder(TimeDimension timeDimension) {
        if (timeDimension.isFullDate()) {
            return TimeSorter.sortFullDate(timeDimension);
        }
        return TimeSorter.sortDateKey(timeDimension);
    }

    static class IntegerArray
    implements Comparable<IntegerArray> {
        private int[] intArray;

        IntegerArray(int[] intArray) {
            this.intArray = intArray;
        }

        @Override
        public int compareTo(IntegerArray other) {
            int cmp = 0;
            for (int i = 0; i < this.intArray.length && (cmp = this.intArray[i] - other.intArray[i]) == 0; ++i) {
            }
            return cmp;
        }
    }
}

