/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.timedimension;

import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeComponent;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

class CalendarWrapper {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(CalendarWrapper.class);
    private final TimeZone timeZone = TimeZone.getTimeZone("UTC");
    private final ZoneId zoneId = this.timeZone.toZoneId();
    private final Calendar calendar = Calendar.getInstance(this.timeZone);

    CalendarWrapper() {
        this.calendar.clear();
    }

    Date getTimeWithZeroMilliSecond() {
        this.calendar.set(14, 0);
        return this.calendar.getTime();
    }

    Date getTimeByYear(int year) {
        this.calendar.clear();
        this.calendar.set(1, year);
        return this.calendar.getTime();
    }

    Date getTimeByYearAndQuarter(int year, int quarter) {
        this.calendar.clear();
        this.calendar.set(1, year);
        this.calendar.set(2, 0 + (quarter - 1) * 3);
        return this.calendar.getTime();
    }

    void setTime(Date date) {
        this.calendar.setTime(date);
    }

    TimeZone getTimeZone() {
        return this.timeZone;
    }

    void setZonedDateTime(Date date) {
        ZonedDateTime time = ZonedDateTime.ofInstant(date.toInstant(), this.zoneId);
        this.calendar.set(11, time.getHour());
        this.calendar.set(12, time.getMinute());
        this.calendar.set(13, time.getSecond());
    }

    void applyComponentToCalendar(TimeComponent component, int value) {
        boolean isConceptZeroIndexed = false;
        TimeConcept concept = component.getConcept();
        if (component.getConcept().isNonTimestamp()) {
            isConceptZeroIndexed = concept.isZeroIndexed();
        }
        if (component.isZeroIndexed() && !isConceptZeroIndexed) {
            ++value;
        }
        switch (concept) {
            case YEAR: {
                this.calendar.set(1, value);
                break;
            }
            case QUARTER: {
                this.calendar.set(2, 0 + 3 * (value - 1));
                break;
            }
            case MONTH: {
                this.calendar.set(2, 0 + value - 1);
                break;
            }
            case WEEK: {
                this.calendar.set(3, value);
                this.calendar.set(7, 1);
                break;
            }
            case DAY_OF_YEAR: {
                this.calendar.set(6, value);
                break;
            }
            case DAY_OF_MONTH: {
                this.calendar.set(5, value);
                break;
            }
            case DAY_OF_WEEK: {
                this.calendar.set(7, value);
                break;
            }
            case HOUR: {
                this.calendar.set(11, value);
                break;
            }
            case MINUTE: {
                this.calendar.set(12, value);
                break;
            }
            case SECOND: {
                this.calendar.set(13, value);
                break;
            }
            default: {
                LOGGER.warn("Cannot handle nested concept " + (Object)((Object)concept));
            }
        }
    }

    Calendar getCalendar() {
        return this.calendar;
    }
}

