/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.timedimension;

import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimestampConceptMatch;
import com.ibm.bi.predict.algorithms.forecasting.concepts.validation.ConceptValidationResult;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.CalendarWrapper;
import com.ibm.bi.predict.algorithms.forecasting.util.TextDateNames;
import com.ibm.bi.predict.algorithms.forecasting.util.TimeUtils;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import java.time.temporal.IsoFields;
import java.util.ArrayList;
import java.util.Date;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class TimeComponent {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(TimeComponent.class);
    private DataColumn base;
    private final int indexInTimeDimension;
    private final TimeConcept concept;
    private final Optional<TimestampConceptMatch> match;
    private DateFormat dateFormatter;
    private Map<Double, Integer> order;
    private Locale locale;
    private ConceptValidationResult validationResult;
    private final CalendarWrapper calendarWrapper;
    private boolean isTwoDigitYear = false;
    private int century;

    public TimeComponent(DataColumn base, int indexInTimeDimension, TimeConcept concept, Optional<TimestampConceptMatch> match, Locale locale, CalendarWrapper calendarWrapper) {
        this(base, indexInTimeDimension, concept, match, new ConceptValidationResult(concept), locale, calendarWrapper);
    }

    public TimeComponent(DataColumn base, int indexInTimeDimension, TimeConcept concept, Optional<TimestampConceptMatch> match, ConceptValidationResult validationResult, Locale locale, CalendarWrapper calendarWrapper) {
        this.base = base;
        this.indexInTimeDimension = indexInTimeDimension;
        this.concept = concept;
        this.match = match;
        this.locale = locale;
        this.validationResult = validationResult;
        this.calendarWrapper = calendarWrapper;
        this.century = this.calculateCentury();
    }

    boolean isZeroIndexed() {
        return this.validationResult.isZeroIndexed();
    }

    void setIsZeroIndexed(boolean isZeroIndexed) {
        this.validationResult.setIsZeroIndexed(isZeroIndexed);
    }

    DataColumn getBaseData() {
        return this.base;
    }

    public void setBase(DataColumn dataColumn) {
        this.base = dataColumn;
    }

    TimeConcept getConcept() {
        return this.concept;
    }

    Optional<TimestampConceptMatch> getMatch() {
        return this.match;
    }

    public void resetOrder() {
        this.order = null;
    }

    Set<Integer> getInvalidRowIndices() {
        HashSet<Integer> invalidRows = new HashSet<Integer>();
        Set<String> invalidValues = this.getInvalidFieldValues();
        for (int i = 0; i < this.base.rowCount(); ++i) {
            if (!invalidValues.contains(this.getValidationLabel(i))) continue;
            invalidRows.add(i);
        }
        return invalidRows;
    }

    Set<String> getInvalidFieldValues() {
        if (this.match.isPresent()) {
            return this.match.get().unmatchedValues;
        }
        if (this.concept.isTimestamp()) {
            throw new IllegalArgumentException("Timestamp concept should have had match information");
        }
        return this.validationResult.getInvalidValues();
    }

    void setInvalidFieldValues(Set<String> invalidFieldValues) {
        this.validationResult.setInvalidValues(invalidFieldValues);
    }

    public void setTreatAsCategorical(boolean isIndexing) {
        this.validationResult.setTreatAsCategorical(isIndexing);
    }

    public boolean getTreatAsCategorical() {
        return this.validationResult.isTreatAsCategorical();
    }

    public void setIsLong(boolean isLong) {
        this.validationResult.setLong(isLong);
    }

    public void setIsNumeric(boolean isNumeric) {
        this.validationResult.setIsNumeric(isNumeric);
    }

    public boolean isLong() {
        return this.validationResult.isLong();
    }

    public boolean isValid() {
        return this.validationResult.isValid();
    }

    public boolean isNumeric() {
        return this.validationResult.isNumeric();
    }

    public ConceptValidationResult getValidationResult() {
        return this.validationResult;
    }

    public void setValidationResult(ConceptValidationResult validationResult) {
        this.validationResult = validationResult;
    }

    public void removeInvalidRows(Set<Integer> invalidRowIndices) {
        this.base = this.base.copyWithoutRows(invalidRowIndices);
    }

    public boolean isTwoDigitYear() {
        return this.isTwoDigitYear;
    }

    public int toFourDigitYear(int year) {
        if (year >= 0 && year < 100) {
            return this.century + year;
        }
        return year;
    }

    Date toDate(int rowIndex) {
        double rowValue = this.getKeyValue(rowIndex);
        if (Double.isNaN(rowValue)) {
            return null;
        }
        if (this.concept == TimeConcept.YEAR) {
            if (rowValue >= 0.0 && rowValue < 100.0) {
                if (!this.isTwoDigitYear) {
                    this.isTwoDigitYear = true;
                }
                int year = this.toFourDigitYear((int)rowValue);
                return this.calendarWrapper.getTimeByYear(year);
            }
            return this.calendarWrapper.getTimeByYear((int)rowValue);
        }
        Category rowCat = (Category)this.base.getCategories().get((int)this.base.getValue(rowIndex));
        if (this.concept == TimeConcept.YEAR_QUARTER) {
            if (this.match.isPresent()) {
                return this.parseYearQuarter(rowCat.toString(), this.match.get().formatString);
            }
            throw new IllegalStateException("Concept match not set for YEAR_QUARTER");
        }
        try {
            return this.dateFormatter().parse(rowCat.toString());
        }
        catch (ParseException e) {
            LOGGER.warn("Could not parse date item:" + rowCat, (Throwable)e);
            return null;
        }
    }

    String getDateLabel(int rowIndex) {
        return this.getLabel(rowIndex, true);
    }

    String getValidationLabel(int rowIndex) {
        return this.getLabel(rowIndex, false);
    }

    List<String> getCategories() {
        if (this.base.getType() != FieldType.NUMERICAL) {
            return this.base.getCategories().stream().map(value -> value.toString()).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    int indexValueForRow(int rowIndex) {
        return this.order().get(this.getKeyValue(rowIndex));
    }

    Date parseYearQuarter(String yearQuarter, String formatString) {
        int quarter;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatString);
        int year = Year.parse(yearQuarter, formatter).getValue();
        try {
            quarter = formatter.parse(yearQuarter).get(IsoFields.QUARTER_OF_YEAR);
        }
        catch (DateTimeException e) {
            int qIndex = yearQuarter.indexOf(113);
            if (qIndex == -1) {
                qIndex = yearQuarter.indexOf(81);
            }
            quarter = Integer.parseInt(yearQuarter.substring(qIndex + 1, qIndex + 2));
        }
        return this.calendarWrapper.getTimeByYearAndQuarter(year, quarter);
    }

    double getKeyValue(int rowIndex) {
        if (this.base.getType() == FieldType.NUMERICAL) {
            return this.base.getValue(rowIndex);
        }
        return this.getCategoryValue((int)this.base.getValue(rowIndex));
    }

    private String getLabel(int rowIndex, boolean asInt) {
        if (this.base.getType() == FieldType.NUMERICAL) {
            if (asInt) {
                return Integer.toString((int)this.base.getValue(rowIndex));
            }
            return Double.toString(this.base.getValue(rowIndex));
        }
        return ((Category)this.base.getCategories().get((int)this.base.getValue(rowIndex))).toString();
    }

    private double getCategoryValue(int index) {
        if (this.useIndex()) {
            return index;
        }
        Category category = this.base.getCategory(index);
        if (this.validationResult.isNumeric()) {
            return Double.parseDouble(category.toString());
        }
        Tuple<String, Integer> categoryParts = TimeUtils.parsePlusLabels(category.toString().toLowerCase(), this.concept);
        if (NumericUtils.tryParseDouble((String)((String)categoryParts._1))) {
            return Double.parseDouble((String)categoryParts._1);
        }
        if (ConceptUtils.isDayOfWeek(this.concept)) {
            return this.findStringCategoryIndex((String)categoryParts._1) + (double)((Integer)categoryParts._2 * 7);
        }
        if (ConceptUtils.isMonth(this.concept)) {
            return this.findStringCategoryIndex((String)categoryParts._1) + (double)((Integer)categoryParts._2 * 12);
        }
        if (this.concept == TimeConcept.QUARTER) {
            return ((Integer)TimeUtils.parseQuarter((String)((String)categoryParts._1))._2).intValue();
        }
        if (this.concept == TimeConcept.TIME) {
            if (this.match.isPresent()) {
                return TimeUtils.getTimeValueToPrecisionOfSeconds((String)categoryParts._1, this.match.get().formatString);
            }
            throw new IllegalStateException("Concept match not set for TIME concept");
        }
        if (ConceptUtils.isIndexing(this.indexInTimeDimension)) {
            return index;
        }
        return 0.0;
    }

    private boolean useIndex() {
        return this.concept == TimeConcept.PERIOD || this.validationResult.isTreatAsCategorical();
    }

    private double findStringCategoryIndex(String categoryString) {
        TextDateNames.TextDateNamesItem item = TextDateNames.findDateItem(categoryString, this.concept, this.locale, Locale.getDefault());
        if (item == null) {
            throw new ForecastingParametersException("The category string is invalid", ForecastingParametersExceptionKey.DATA_VALUE);
        }
        if (this.isZeroIndexed()) {
            return item.getIndex().intValue();
        }
        return item.getIndex() + 1;
    }

    private Map<Double, Integer> order() {
        if (this.order != null) {
            return this.order;
        }
        List sortedValues = IntStream.range(0, this.base.rowCount()).mapToDouble(this::getKeyValue).distinct().sorted().boxed().collect(Collectors.toList());
        this.order = new HashMap<Double, Integer>();
        for (int i = 0; i < sortedValues.size(); ++i) {
            this.order.put((Double)sortedValues.get(i), i);
        }
        return this.order;
    }

    private DateFormat dateFormatter() {
        if (this.dateFormatter == null) {
            if (this.match.isPresent()) {
                this.dateFormatter = new SimpleDateFormat(this.match.get().formatString);
                this.dateFormatter.setTimeZone(this.calendarWrapper.getTimeZone());
            } else {
                throw new IllegalStateException("Concept match was not set for TimeDimension concept: " + (Object)((Object)this.concept));
            }
        }
        return this.dateFormatter;
    }

    private int calculateCentury() {
        if (this.base != null && this.concept == TimeConcept.YEAR) {
            DoubleSummaryStatistics stats = IntStream.range(0, this.base.rowCount()).mapToDouble(this::getKeyValue).summaryStatistics();
            double min = stats.getMin();
            double max = stats.getMax();
            if (min >= 0.0 && min <= 50.0 && max < 100.0) {
                return 2000;
            }
            if (min > 50.0 && max < 100.0) {
                return 1900;
            }
        }
        return 0;
    }
}

