/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.timedimension;

import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptDisambiguator;
import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimestampConceptMatch;
import com.ibm.bi.predict.algorithms.forecasting.concepts.validation.ConceptValidationResult;
import com.ibm.bi.predict.algorithms.forecasting.concepts.validation.ConceptValidator;
import com.ibm.bi.predict.algorithms.forecasting.concepts.validation.NestedConceptValidator;
import com.ibm.bi.predict.algorithms.forecasting.concepts.validation.TimestampConceptValidator;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeSorter;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.CalendarWrapper;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeComponent;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeIndexMapper;
import com.ibm.bi.predict.algorithms.forecasting.util.TimeUtils;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class TimeDimension {
    private static final Logger LOGGER;
    private final TimeComponent[] components;
    private final CalendarWrapper calendarWrapper;
    private int[] rowOrder;
    private Locale locale;
    private TimeDelta timeDelta;
    private int numberOfTimePointsConsidered;
    private int lastNPointsIgnored;
    private Set<Integer> invalidRowIndices = new HashSet<Integer>();
    private Set<Category> invalidCategories = new HashSet<Category>();
    private boolean isSeriesTooShort;
    private TimeIndexMapper timeMapper;
    private int prevRowYear;
    private static Map<TimeUnit, Integer> timeUnitCycleLengthMap;

    public static TimeDimension makeForColumns(Locale locale, DataColumn ... columns) throws ForecastingParametersException {
        TimeDimension timeDimension = new TimeDimension(locale, columns);
        TimeDimension.setCalculatedFields(timeDimension, true);
        return timeDimension;
    }

    TimeDimension(Locale locale, DataColumn[] base) {
        if (base.length == 0) {
            throw new ForecastingParametersException("At least one time column is required", ForecastingParametersExceptionKey.DATA_VALUE);
        }
        this.locale = locale;
        this.numberOfTimePointsConsidered = base[0].rowCount();
        this.calendarWrapper = new CalendarWrapper();
        this.components = this.createComponents(base);
        this.validateComponents();
    }

    public Set<Integer> getInvalidRowIndices() {
        return this.invalidRowIndices;
    }

    public Set<Category> getInvalidCategories() {
        return this.invalidCategories;
    }

    public void setInvalidRowIndices(Set<Integer> invalidRowIndices) {
        this.invalidRowIndices = invalidRowIndices;
    }

    public DataColumn getDataColumn(int componentIndex) {
        return this.components[componentIndex].getBaseData();
    }

    public void setDataColumn(int componentIndex, DataColumn column) {
        this.components[componentIndex].setBase(column);
    }

    public boolean isComponentZeroIndexed(int componentIndex) {
        if (this.components.length > componentIndex) {
            return this.components[componentIndex].isZeroIndexed();
        }
        return false;
    }

    public boolean isComponentNumeric(int componentIndex) {
        if (this.components.length > componentIndex && componentIndex >= 0) {
            return this.components[componentIndex].isNumeric();
        }
        return false;
    }

    public Optional<Integer> getIndexOfUnit(TimeUnit unit) {
        for (int i = 0; i < this.components.length; ++i) {
            if (unit != this.components[i].getConcept().getUnit()) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    public boolean isComponentLong(int componentIndex) {
        return this.components[componentIndex].isLong();
    }

    public void setIsComponentZeroIndexed(int componentIndex, boolean isZeroIndexed) {
        this.components[componentIndex].setIsZeroIndexed(isZeroIndexed);
    }

    public TimeConcept concept(int columnIndex) {
        return this.components[columnIndex].getConcept();
    }

    public TimeConcept[] allConcepts() {
        TimeConcept[] concepts = new TimeConcept[this.components.length];
        for (int i = 0; i < this.components.length; ++i) {
            concepts[i] = this.components[i].getConcept();
        }
        return concepts;
    }

    public int getNumberOfComponents() {
        return this.components.length;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public DataColumn consolidate() {
        if (this.components.length == 1) {
            return this.components[0].getBaseData();
        }
        return this.components[0].getBaseData().getParent();
    }

    public Date getDate(int rowIndex) {
        Date top = this.getDate(rowIndex, 0);
        if (top == null) {
            return null;
        }
        this.calendarWrapper.setTime(top);
        for (int i = 1; i < this.components.length; ++i) {
            double v = this.getDoubleComponentValueForRow(i, rowIndex);
            if (Double.isNaN(v)) {
                return null;
            }
            if (ConceptUtils.isTime(this.components[i].getConcept())) {
                this.setInnerTimeConcept(rowIndex, i);
                continue;
            }
            this.calendarWrapper.applyComponentToCalendar(this.components[i], (int)v);
        }
        return this.calendarWrapper.getTimeWithZeroMilliSecond();
    }

    public Date getDate(int rowIndex, int columnIndex) {
        return this.components[columnIndex].toDate(rowIndex);
    }

    public double getDoubleComponentValueForRow(int componentIndex, int rowIndex) {
        return this.components[componentIndex].getKeyValue(rowIndex);
    }

    public int[] getDateKey(int rowIndex) {
        int[] result = new int[this.components.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.components[i].indexValueForRow(rowIndex);
        }
        return result;
    }

    public String[] getDateLabels(int rowIndex) {
        String[] result = new String[this.components.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.components[i].getDateLabel(rowIndex);
        }
        return result;
    }

    public String getDateLabel(int rowIndex, TimeUnit unit) {
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].getConcept().getUnit() != unit) continue;
            return this.components[i].getDateLabel(rowIndex);
        }
        return null;
    }

    public String getDayOfWeekFromNestedTime(int rowIndex, Locale locale) {
        int year;
        if (!this.canDetermineDayOfWeek()) {
            return null;
        }
        String[] labels = this.getDateLabels(rowIndex);
        if (this.components.length == 2 && this.components[0].getConcept() == TimeConcept.WEEK) {
            DateFormatSymbols dfs = new DateFormatSymbols(locale);
            int dayNum = Integer.parseInt(labels[labels.length - 1]);
            return dfs.getWeekdays()[dayNum];
        }
        String format = null;
        format = this.isComponentNumeric(1) ? "MM/dd/yyyy" : "MMMM/dd/yyyy";
        if (this.isComponentZeroIndexed(1)) {
            labels[1] = Integer.toString(Integer.parseInt(labels[1]) + 1);
        }
        if (this.isComponentZeroIndexed(2)) {
            labels[0] = Integer.toString(Integer.parseInt(labels[0] + 1));
        }
        if (labels[0].length() <= 2 && (year = Integer.parseInt(labels[0])) >= 0 && year < 100) {
            this.prevRowYear = year = this.components[0].toFourDigitYear(year);
            labels[0] = String.valueOf(year);
        }
        SimpleDateFormat df = new SimpleDateFormat(format, locale);
        String dateStr = labels[1] + "/" + labels[2] + "/" + labels[0];
        try {
            return df.parse(dateStr).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getDayOfWeek().getDisplayName(TextStyle.FULL, locale);
        }
        catch (ParseException e) {
            LOGGER.warn("Failed to parse date and extract day-of-week name. Continuing without date labels.", (Throwable)e);
            return null;
        }
    }

    public String getDayOfWeekFromTimestamp(int rowIndex, Locale locale) {
        String format = this.getFormatString(0);
        String label = this.getDateLabels(rowIndex)[0];
        SimpleDateFormat df = new SimpleDateFormat(format, locale);
        try {
            return df.parse(label).toInstant().atZone(ZoneId.systemDefault()).toLocalDate().getDayOfWeek().getDisplayName(TextStyle.FULL, locale);
        }
        catch (ParseException e) {
            LOGGER.warn("Failed to parse date and extract day-of-week name. Continuing without date labels.", (Throwable)e);
            return null;
        }
    }

    public String getTimeColumnHeader() {
        CharSequence[] result = new String[this.components.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.components[i].getBaseData().getMeta().getLabel();
        }
        return String.join((CharSequence)" | ", result);
    }

    public String getTimeComponentHeader(int componentIndex) {
        return this.components[componentIndex].getBaseData().getMeta().getLabel();
    }

    public double[] getLabelValues(int rowIndex) {
        double[] values = new double[this.components.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = TimeDimension.truncate(this.components[i].getKeyValue(rowIndex));
        }
        return values;
    }

    public String getFormatString(int componentIndex) {
        Optional<TimestampConceptMatch> match = this.components[componentIndex].getMatch();
        if (match.isPresent()) {
            return match.get().formatString;
        }
        return null;
    }

    public TimeConcept getTimestampConcept(int componentIndex) {
        Optional<TimestampConceptMatch> match = this.components[componentIndex].getMatch();
        if (match.isPresent()) {
            return match.get().concept;
        }
        return null;
    }

    public int hashCode() {
        int hash = 13;
        for (TimeComponent component : this.components) {
            hash = 37 * hash + component.getBaseData().hashCode();
        }
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TimeDimension)) {
            return false;
        }
        TimeDimension other = (TimeDimension)o;
        if (this.components.length != other.components.length) {
            return false;
        }
        for (int i = 0; i < this.components.length; ++i) {
            if (this.components[i].getBaseData() == other.components[i].getBaseData()) continue;
            return false;
        }
        return true;
    }

    public boolean includesTime() {
        for (TimeComponent component : this.components) {
            if (!ConceptUtils.includesTime(component.getConcept())) continue;
            return true;
        }
        return false;
    }

    public List<String> getValidConceptCategories(int columnId) {
        TimeComponent component = this.components[columnId];
        List<String> categoryList = component.getCategories();
        Set<String> invalidCategorySet = component.getInvalidFieldValues();
        return new ArrayList<String>(categoryList.stream().filter(catString -> !invalidCategorySet.contains(catString)).collect(Collectors.toCollection(LinkedHashSet::new)));
    }

    public boolean isFullDate() {
        TimeConcept outerConcept = this.components[0].getConcept();
        return outerConcept.isTimestamp() || outerConcept == TimeConcept.YEAR && this.components.length > 1;
    }

    public boolean canDetermineDayOfWeek() {
        return this.components[0].getConcept().isTimestamp() || this.components.length >= 3 && this.components[0].getConcept().getUnit() == TimeUnit.YEAR && this.components[1].getConcept().getUnit() == TimeUnit.MONTH && this.components[2].getConcept().getUnit() == TimeUnit.DAY || this.components.length == 2 && this.components[0].getConcept().getUnit() == TimeUnit.WEEK && this.components[1].getConcept() == TimeConcept.DAY_OF_WEEK;
    }

    public int rowCount() {
        return this.components[0].getBaseData().rowCount();
    }

    public void setRowOrder(int[] rowOrder) {
        this.rowOrder = rowOrder;
    }

    public int[] getRowOrder() {
        return this.rowOrder;
    }

    public TimeDelta getTimeDelta() {
        return this.timeDelta;
    }

    public void setTimeDelta(TimeDelta timeDelta) {
        this.timeDelta = timeDelta;
    }

    public int getNumberOfTimePointsConsidered() {
        return this.numberOfTimePointsConsidered;
    }

    public void setNumberOfTimePointsConsidered(int numberOfTimePointsConsidered) {
        this.numberOfTimePointsConsidered = numberOfTimePointsConsidered;
    }

    public int getLastNPointsIgnored() {
        return this.lastNPointsIgnored;
    }

    public void setLastNPointsIgnored(int lastNPointsIgnored) {
        this.lastNPointsIgnored = lastNPointsIgnored;
    }

    public boolean isTreatAsCategorical(int componentIndex) {
        return this.components[componentIndex].getTreatAsCategorical();
    }

    public TimeIndexMapper getTimeIndexMapper() {
        return this.timeMapper;
    }

    public void setTimeIndexMapper(TimeIndexMapper timeMapper) {
        this.timeMapper = timeMapper;
    }

    public boolean isTwoDigitYear() {
        return Arrays.stream(this.components).anyMatch(TimeComponent::isTwoDigitYear);
    }

    static TimeConcept findBestConcept(DataColumn dataColumn, String parentConceptId) {
        List concepts = dataColumn.getMeta().getConcepts();
        if (concepts.isEmpty()) {
            LOGGER.warn("No concepts passed in");
            return TimeConcept.UNKNOWN;
        }
        if (ConceptDisambiguator.conceptsAreAmbiguous(concepts, parentConceptId)) {
            return ConceptDisambiguator.disambiguateConcepts(concepts, parentConceptId);
        }
        Optional<TimeConcept> bestTimeConcept = concepts.stream().sorted((c1, c2) -> Double.compare((Double)c2._2, (Double)c1._2)).map(c -> (String)c._1).filter(TimeConcept::containsKey).findFirst().map(TimeConcept::idToConcept);
        return bestTimeConcept.orElseGet(() -> {
            LOGGER.warn("No valid concepts found in concept list: {}", (Object)concepts);
            return TimeConcept.UNKNOWN;
        });
    }

    private TimeComponent[] createComponents(DataColumn[] base) {
        TimeComponent[] timeComponents = new TimeComponent[base.length];
        String parentConceptId = null;
        for (int i = 0; i < base.length; ++i) {
            TimeConcept concept = TimeDimension.findBestConcept(base[i], parentConceptId);
            LOGGER.debug("Selected concept: {}", (Object)concept);
            parentConceptId = concept.id();
            Optional<TimestampConceptMatch> match = Optional.empty();
            if (concept.isTimestamp()) {
                Map<String, Integer> frequencyMap = TimeUtils.getFieldValuesInformation(base[i], concept, i).getValueFrequencyMap();
                TimestampConceptMatch result = TimestampConceptValidator.match(concept, frequencyMap.keySet());
                concept = result.concept;
                match = Optional.of(result);
            }
            if (ConceptUtils.isCyclical(i)) {
                concept = this.promoteCyclical(concept, timeComponents[i - 1].getConcept(), i);
            }
            timeComponents[i] = new TimeComponent(base[i], i, concept, match, this.locale, this.calendarWrapper);
        }
        return timeComponents;
    }

    private TimeConcept promoteCyclical(TimeConcept concept, TimeConcept parentConcept, int index) {
        if (index == 1 && concept == TimeConcept.DAY_OF_MONTH && parentConcept == TimeConcept.YEAR) {
            return TimeConcept.DAY_OF_YEAR;
        }
        return concept;
    }

    private void validate() {
        boolean isValid = true;
        for (int i = 0; i < this.components.length; ++i) {
            ConceptValidationResult result = ConceptValidator.validateValues(this.components[i].getConcept(), i, this.components[i].getBaseData(), this.components[i].getMatch(), this.locale);
            this.setComponentValidationResult(i, result);
            if (result.isValid()) continue;
            isValid = false;
        }
        if (!isValid) {
            this.removeInvalidRows();
        }
    }

    public void setComponentValidationResult(int componentIndex, ConceptValidationResult validationResult) {
        this.components[componentIndex].setValidationResult(validationResult);
    }

    private void removeInvalidRows() {
        Arrays.stream(this.components).forEach(component -> this.invalidRowIndices.addAll(component.getInvalidRowIndices()));
        if (this.invalidRowIndices.size() >= this.components[0].getBaseData().rowCount()) {
            throw new ForecastingParametersException("All rows were determined to have invalid time labels.", ForecastingParametersExceptionKey.DATA_VALUE);
        }
        this.setInvalidCategories();
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].removeInvalidRows(this.invalidRowIndices);
        }
        if (this.components.length > 1) {
            DataColumn column = this.components[0].getBaseData();
            column.setParent(column.getParent().copyWithoutRows(this.invalidRowIndices));
        }
    }

    private void setInnerTimeConcept(int rowIndex, int conceptIndex) {
        Date timeDate = this.getDate(rowIndex, conceptIndex);
        this.calendarWrapper.setZonedDateTime(timeDate);
    }

    private void validateComponents() {
        NestedConceptValidator.validateConcepts(this.allConcepts());
        this.validate();
    }

    private static double truncate(double v) {
        return v < 0.0 ? -Math.floor(Math.abs(v)) : Math.floor(v);
    }

    private void setInvalidCategories() {
        DataColumn parent = this.consolidate();
        for (int i : this.invalidRowIndices) {
            double catIndex = parent.getValue(i);
            this.invalidCategories.add(parent.getCategory((int)catIndex));
        }
    }

    public int[] newRowOrder() {
        for (int i = 0; i < this.components.length; ++i) {
            this.components[i].resetOrder();
        }
        int[] newRowOrder = TimeSorter.findRowOrder(this);
        this.setRowOrder(newRowOrder);
        return newRowOrder;
    }

    private static void setCalculatedFields(TimeDimension timeDimension, boolean setDelta) {
        timeDimension.setRowOrder(TimeSorter.findRowOrder(timeDimension));
        if (setDelta) {
            timeDimension.setTimeDelta(TimeDelta.getTimeDelta(timeDimension));
        }
    }

    public void setIsSeriesTooShort(boolean seriesTooShort) {
        this.isSeriesTooShort = seriesTooShort;
    }

    public boolean isSeriesTooShort() {
        return this.isSeriesTooShort;
    }

    public int findCycleLengthByTimeDelta() {
        TimeDelta delta = this.getTimeDelta();
        long steps = delta.getSteps();
        TimeUnit unit = delta.getUnit();
        return (int)((long)this.getCycleLengthFromConcept(unit) / steps);
    }

    private int getCycleLengthFromConcept(TimeUnit unit) {
        TimeConcept[] all = this.allConcepts();
        int[] cyclelenthArray = Arrays.stream(all).filter(tc -> tc.getUnit() == unit).mapToInt(TimeConcept::getCycleLength).toArray();
        if (cyclelenthArray.length > 0 && cyclelenthArray[0] > 0) {
            return cyclelenthArray[0];
        }
        if (timeUnitCycleLengthMap.containsKey((Object)unit)) {
            return timeUnitCycleLengthMap.get((Object)unit);
        }
        return 0;
    }

    static {
        TimeConcept[] all;
        LOGGER = PredictLoggerFactory.getLogger(TimeDimension.class);
        timeUnitCycleLengthMap = new HashMap<TimeUnit, Integer>();
        for (TimeConcept tc : all = TimeConcept.values()) {
            if (tc.getCycleLength() <= 0) continue;
            if (!timeUnitCycleLengthMap.containsKey((Object)tc.getUnit())) {
                timeUnitCycleLengthMap.put(tc.getUnit(), tc.getCycleLength());
                continue;
            }
            if (tc.getCycleLength() >= timeUnitCycleLengthMap.get((Object)tc.getUnit())) continue;
            timeUnitCycleLengthMap.put(tc.getUnit(), tc.getCycleLength());
        }
    }
}

