/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.timedimension;

import com.ibm.bi.predict.algorithms.forecasting.time.TimeDelta;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeDifference;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.data.DataColumn;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;

public class TimeIndexMapper {
    private static final ZoneId ZONE_ID = TimeZone.getTimeZone("UTC").toZoneId();
    private List<Long> cumulativeCount;

    public TimeIndexMapper(TimeDimension time, DataColumn timeColumn) {
        TimeDelta delta = time.getTimeDelta();
        this.cumulativeCount = new ArrayList<Long>();
        this.cumulativeCount.add(0L);
        for (int rowIndex = 1; rowIndex < timeColumn.rowCount(); ++rowIndex) {
            if (timeColumn.getValue(rowIndex - 1) == timeColumn.getValue(rowIndex)) continue;
            long missingCount = TimeIndexMapper.missingTimesBetween(time, rowIndex - 1, rowIndex, delta);
            this.cumulativeCount.add(this.cumulativeCount.get(this.cumulativeCount.size() - 1) + missingCount);
        }
    }

    public long missingCount() {
        return this.cumulativeCount.get(this.cumulativeCount.size() - 1);
    }

    public long missingCountTo(long index) {
        if (index > this.fullIndex(this.cumulativeCount.size() - 1)) {
            return this.missingCount();
        }
        if (index < 0L) {
            return 0L;
        }
        int i = this.cumulativeCount.size() - 1;
        while (index < this.fullIndex(i)) {
            --i;
        }
        return this.cumulativeCount.get(i) + index - this.fullIndex(i);
    }

    private long fullIndex(int i) {
        return (long)i + this.cumulativeCount.get(i);
    }

    public long toTimeIndex(int timeIndex) {
        return (long)timeIndex + this.cumulativeCount.get(timeIndex);
    }

    private static long missingTimesBetween(TimeDimension time, int prevRowIndex, int nextRowIndex, TimeDelta delta) {
        if (time.isFullDate()) {
            return TimeIndexMapper.missingTimesBetweenDate(time, prevRowIndex, nextRowIndex, delta);
        }
        return TimeIndexMapper.missingTimesBetweenNonDate(time, prevRowIndex, nextRowIndex, delta);
    }

    private static long missingTimesBetweenDate(TimeDimension time, int prevRowIndex, int nextRowIndex, TimeDelta delta) {
        int[] rowOrder = time.getRowOrder();
        Date prevDate = time.getDate(rowOrder[prevRowIndex]);
        Date nextDate = time.getDate(rowOrder[nextRowIndex]);
        ZonedDateTime prev = ZonedDateTime.ofInstant(prevDate.toInstant(), ZONE_ID);
        ZonedDateTime next = ZonedDateTime.ofInstant(nextDate.toInstant(), ZONE_ID);
        TimeDifference diffs = new TimeDifference(prev, next);
        return TimeIndexMapper.unitDifference(diffs, delta);
    }

    private static long missingTimesBetweenNonDate(TimeDimension time, int prevRowIndex, int nextRowIndex, TimeDelta delta) {
        int[] rowOrder = time.getRowOrder();
        double[] prev = time.getLabelValues(rowOrder[prevRowIndex]);
        double[] next = time.getLabelValues(rowOrder[nextRowIndex]);
        TimeDifference diffs = new TimeDifference(prevRowIndex, prev, next, time);
        return TimeIndexMapper.unitDifference(diffs, delta);
    }

    private static long unitDifference(TimeDifference diffs, TimeDelta delta) {
        long unitDiff = diffs.getValueOfUnit(delta.getUnit());
        if (unitDiff == 0L) {
            return 0L;
        }
        return unitDiff / delta.getSteps() - 1L;
    }
}

