/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.util;

import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeLimits;
import com.ibm.bi.predict.algorithms.forecasting.timedimension.TimeDimension;
import com.ibm.bi.predict.algorithms.forecasting.util.TimeUtils;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;

public class EndOfMonthUtils {
    private EndOfMonthUtils() {
    }

    public static int getDaysInMonth(ZonedDateTime date) {
        Month month = date.getMonth();
        boolean isLeapYear = TimeLimits.isLeapYear(date.getYear());
        return month.length(isLeapYear);
    }

    public static int getDaysInMonth(int labelIndex, TimeDimension time) {
        int month;
        int labelPosition = time.getRowOrder()[labelIndex];
        double[] values = time.getLabelValues(labelPosition);
        if (time.isComponentZeroIndexed(0)) {
            values[0] = values[0] + 1.0;
        }
        if ((month = (int)values[0] % 12) == 0) {
            month = 12;
        }
        return Month.of(month).length(false);
    }

    public static boolean isLastDayOfMonth(ZonedDateTime date) {
        return EndOfMonthUtils.getDaysInMonth(date) == date.getDayOfMonth();
    }

    public static boolean isLastDayOfMonth(int labelIndex, double[] labelValues, TimeDimension time) {
        if (!EndOfMonthUtils.hasMonthAndDayAsHighestConcepts(time)) {
            return false;
        }
        return (int)labelValues[1] == EndOfMonthUtils.getDaysInMonth(labelIndex, time);
    }

    public static boolean allLastDay(TimeDimension timeDimension, ZoneId zoneId) {
        int[] rowOrder = timeDimension.getRowOrder();
        for (int i = 0; i < rowOrder.length; ++i) {
            Date date = timeDimension.getDate(rowOrder[i]);
            ZonedDateTime current = TimeUtils.getZonedDateTime(date, zoneId);
            if (current.getDayOfMonth() == EndOfMonthUtils.getDaysInMonth(current)) continue;
            return false;
        }
        return true;
    }

    public static boolean hasMonthAndDayAsHighestConcepts(TimeDimension timeDimension) {
        if (timeDimension.getNumberOfComponents() < 2) {
            return false;
        }
        return ConceptUtils.isMonth(timeDimension.concept(0)) && timeDimension.concept(1) == TimeConcept.DAY_OF_MONTH;
    }
}

