/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.util;

import com.ibm.bi.predict.algorithms.forecasting.util.HannanNicholls;
import java.util.stream.IntStream;

public final class LogTransformOracle {
    private LogTransformOracle() {
    }

    public static boolean shouldTransform(double[] data, int season, int m, double ratioThreshold) {
        if (!LogTransformOracle.isStrictlyPositive(data)) {
            throw new IllegalArgumentException("data must be strictly positive");
        }
        double lambdaOne = HannanNicholls.estimatePEV(data, season, m);
        double[] logTransData = IntStream.range(0, data.length).mapToDouble(i -> Math.log(data[i])).toArray();
        double lambdaZero = HannanNicholls.estimatePEV(logTransData, season, m);
        return Math.log(lambdaZero) / Math.log(lambdaOne) < ratioThreshold;
    }

    public static boolean isStrictlyPositive(double[] data) {
        for (double v : data) {
            if (!(v <= 0.0)) continue;
            return false;
        }
        return true;
    }
}

