/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.forecasting.util;

import com.ibm.bi.predict.algorithms.forecasting.concepts.ConceptUtils;
import com.ibm.bi.predict.algorithms.forecasting.concepts.TimeConcept;
import com.ibm.bi.predict.algorithms.forecasting.concepts.validation.ConceptValidationResult;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersException;
import com.ibm.bi.predict.algorithms.forecasting.exception.ForecastingParametersExceptionKey;
import com.ibm.bi.predict.algorithms.forecasting.time.TimeUnit;
import com.ibm.bi.predict.data.Category;
import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.math.NumericUtils;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import com.ibm.bi.predict.utils.Tuple;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeUtils {
    public static final int SECONDS_IN_HOUR = 3600;
    public static final int SECONDS_IN_MINUTE = 60;
    public static final int DAYS_IN_WEEK = 7;
    public static final int MONTHS_IN_YEAR = 12;
    public static final int MONTHS_PER_QUARTER = 3;
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(TimeUtils.class);

    private TimeUtils() {
    }

    public static ConceptValidationResult getFieldValuesInformation(DataColumn column, TimeConcept concept, int indexInTimeDimension) {
        int count = column.rowCount();
        LinkedHashMap<String, Integer> frequencyMap = new LinkedHashMap<String, Integer>();
        boolean isZeroIndexed = concept.isZeroIndexed();
        boolean isNumeric = true;
        boolean isTreatAsCategorical = false;
        int numericCount = 0;
        int invalidCount = 0;
        boolean isCategorical = column.getType() == FieldType.CATEGORICAL || column.getType() == FieldType.DATETIME;
        for (int i = 0; i < count; ++i) {
            String value = TimeUtils.getValue(column, isCategorical, i);
            if (value.equals("") || value.equals("PREDICTNOVALUECAT_4847aaa3-2eac-4489-b1d8-1ebc8146f1aa_PREDICTNOVALUECAT")) {
                ++invalidCount;
            }
            if (isNumeric = NumericUtils.tryParseDouble((String)value)) {
                ++numericCount;
                if ((NumericUtils.equals((double)concept.getCycleLength(), (double)Double.parseDouble(value)) || Double.parseDouble(value) > (double)concept.getCycleLength()) && concept.isZeroIndexed()) {
                    isZeroIndexed = false;
                } else if (NumericUtils.isZero((double)Double.parseDouble(value)) && !concept.isZeroIndexed() && concept != TimeConcept.YEAR) {
                    isZeroIndexed = true;
                }
            }
            if (frequencyMap.containsKey(value)) {
                frequencyMap.put(value, (Integer)((HashMap)frequencyMap).get(value) + 1);
                continue;
            }
            frequencyMap.put(value, 1);
        }
        int nonNumericCount = count - numericCount - invalidCount;
        if (ConceptUtils.isIndexing(indexInTimeDimension) && nonNumericCount > 0) {
            isNumeric = false;
            isZeroIndexed = false;
            isTreatAsCategorical = true;
        } else if (numericCount > nonNumericCount) {
            isNumeric = true;
        } else {
            isNumeric = false;
            isZeroIndexed = false;
        }
        ConceptValidationResult result = new ConceptValidationResult(concept);
        result.setValueFrequencyMap(frequencyMap);
        result.setIsNumeric(isNumeric);
        result.setIsZeroIndexed(isZeroIndexed);
        result.setTreatAsCategorical(isTreatAsCategorical);
        return result;
    }

    private static String getValue(DataColumn column, boolean isCategorical, int rowIndex) {
        if (isCategorical) {
            Category category = column.getCategoryByDataIndex(rowIndex);
            return category.toString();
        }
        Double doubleValue = column.getValue(rowIndex);
        return doubleValue.toString();
    }

    public static Tuple<String, Integer> parsePlusLabels(String label, TimeConcept concept) {
        if (concept.isTimestamp()) {
            return Tuple.of((Object)label, (Object)0);
        }
        String[] labelParts = label.split("\\+");
        if (labelParts.length > 2 || labelParts.length == 0) {
            throw new ForecastingParametersException("Unexpected label format", ForecastingParametersExceptionKey.DATA_VALUE);
        }
        if (labelParts.length == 1) {
            return Tuple.of((Object)labelParts[0], (Object)0);
        }
        if (NumericUtils.tryParseInt((String)labelParts[1])) {
            int plusNum = Integer.parseInt(labelParts[1]);
            return Tuple.of((Object)labelParts[0], (Object)plusNum);
        }
        LOGGER.debug("Second part of label not parsable as int");
        throw new ForecastingParametersException("Unexpected label format", ForecastingParametersExceptionKey.DATA_VALUE);
    }

    public static double getTimeValueToPrecisionOfSeconds(String categoryString, String formatString) {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(formatString);
        LocalTime time = LocalTime.parse(categoryString, formatter);
        return time.getSecond() + time.getMinute() * 60 + time.getHour() * 3600;
    }

    public static boolean isUnitOfTime(TimeUnit deltaUnit) {
        return deltaUnit == TimeUnit.MILLISECOND || deltaUnit == TimeUnit.SECOND || deltaUnit == TimeUnit.MINUTE || deltaUnit == TimeUnit.HOUR;
    }

    private static int parser(String quarterStr, String regex, int expectedGroup) throws NumberFormatException {
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(quarterStr);
        for (int i = 0; i <= expectedGroup; ++i) {
            m.find();
        }
        String intString = m.group();
        return Integer.parseInt(intString);
    }

    public static Tuple<String, Integer> parseQuarter(String quarterStr) {
        int i = 0;
        int maxTries = 2;
        String[] regexs = new String[]{"\\d+|[^0-9]", "[^0-9]+|\\d+$"};
        while (true) {
            try {
                int q = TimeUtils.parser(quarterStr, regexs[i], i);
                int index = quarterStr.indexOf(String.valueOf(q));
                if (i == 0) {
                    return Tuple.of((Object)quarterStr.substring(index + String.valueOf(q).length()), (Object)q);
                }
                return Tuple.of((Object)quarterStr.substring(0, index), (Object)q);
            }
            catch (Exception e) {
                if (++i != maxTries) continue;
                LOGGER.debug("Unable to parse quarter", (Throwable)e);
                throw new ForecastingParametersException("Could not parse quarter", ForecastingParametersExceptionKey.DATA_VALUE);
            }
            break;
        }
    }

    public static int nanosToMillis(int nanos) {
        return (int)java.util.concurrent.TimeUnit.NANOSECONDS.toMillis(nanos);
    }

    public static ZonedDateTime getZonedDateTime(Date date, ZoneId zoneId) {
        return ZonedDateTime.ofInstant(date.toInstant(), zoneId);
    }
}

