/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.multivariateforecasting.var;

import com.ibm.bi.predict.exceptions.InvalidDataException;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.QRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;

public class VAR {
    private int numSeries;
    private int seriesLength;
    private int lag;
    private RealMatrix y;
    private RealMatrix coefficients;
    private RealMatrix z;
    private RealMatrix yLagAdj;

    public VAR(RealMatrix y, int lag) {
        this.y = y;
        this.numSeries = this.y.getRowDimension();
        this.seriesLength = this.y.getColumnDimension();
        this.lag = lag;
        if (this.seriesLength - this.lag <= 1) {
            throw new InvalidDataException("Lag order is too large");
        }
        this.z = this.constructRegressorMatrix();
        this.yLagAdj = this.getLaggedTarget();
        if (this.containsConstant()) {
            throw new InvalidDataException("data contains a constant");
        }
    }

    public RealMatrix constructRegressorMatrix() {
        Array2DRowRealMatrix z = new Array2DRowRealMatrix(this.lag * this.numSeries + 1, this.seriesLength - this.lag);
        for (int j = 0; j < z.getColumnDimension(); ++j) {
            z.setEntry(0, j, 1.0);
        }
        for (int i = 0; i < z.getRowDimension() - 1; ++i) {
            int u = i / this.numSeries;
            int seriesIndex = i % this.numSeries;
            for (int j = 0; j < z.getColumnDimension(); ++j) {
                int lagIndex = this.lag - 1 + j - u;
                z.setEntry(i + 1, j, this.y.getRow(seriesIndex)[lagIndex]);
            }
        }
        return z;
    }

    public RealMatrix getRegressorMatrix() {
        return this.z;
    }

    public RealMatrix getCoefficients() {
        return this.coefficients;
    }

    public RealMatrix getyLagAdj() {
        return this.yLagAdj;
    }

    public boolean timeSeriesContainsConstant(double[] ts) {
        for (int i = 0; i < ts.length - 1; ++i) {
            if (ts[i] == ts[i + 1]) continue;
            return false;
        }
        return true;
    }

    private boolean containsConstant() {
        for (int i = 0; i < this.y.getRowDimension(); ++i) {
            boolean isConst = this.timeSeriesContainsConstant(this.y.getRow(i));
            if (!isConst) continue;
            return true;
        }
        return false;
    }

    private RealMatrix getLaggedTarget() {
        Array2DRowRealMatrix yLagAdj = new Array2DRowRealMatrix(this.y.getRowDimension(), this.y.getColumnDimension() - this.lag);
        for (int i = 0; i < yLagAdj.getRowDimension(); ++i) {
            for (int j = 0; j < yLagAdj.getColumnDimension(); ++j) {
                yLagAdj.setEntry(i, j, this.y.getRow(i)[j + this.lag]);
            }
        }
        return yLagAdj;
    }

    public void solve() {
        double epsilon = 1.0E-10;
        DecompositionSolver solver = new QRDecomposition(this.z.transpose(), epsilon).getSolver();
        if (!solver.isNonSingular()) {
            throw new InvalidDataException("Decomposed Matrix is Singular");
        }
        this.coefficients = solver.solve(this.yLagAdj.transpose()).transpose();
    }

    public RealMatrix fittedvalues() {
        RealMatrix yhat = this.coefficients.multiply(this.z);
        return yhat;
    }

    private RealMatrix constructForecastRegressor() {
        Array2DRowRealMatrix forecastRegressor = new Array2DRowRealMatrix(this.lag * this.y.getRowDimension() + 1, 1);
        forecastRegressor.setEntry(0, 0, 1.0);
        int index = 0;
        for (int j = 0; j < this.lag; ++j) {
            for (int i = 0; i < this.y.getRowDimension(); ++i) {
                forecastRegressor.setEntry(++index, 0, this.y.getRow(i)[this.y.getColumnDimension() - j - 1]);
            }
        }
        return forecastRegressor;
    }

    private void appendForecastRegressor(RealMatrix forecastRegressor, RealMatrix fcast) {
        int i;
        for (i = forecastRegressor.getRowDimension() - 1; i > this.numSeries; --i) {
            int lag = i / this.numSeries;
            int seriesIndex = i % this.numSeries;
            int newIndex = (lag - 1) * this.numSeries + seriesIndex;
            forecastRegressor.setEntry(i, 0, forecastRegressor.getRow(newIndex)[0]);
        }
        for (i = 0; i < this.numSeries; ++i) {
            forecastRegressor.setEntry(i + 1, 0, fcast.getRow(i)[0]);
        }
    }

    public RealMatrix forecast(int h) {
        RealMatrix forecastRegressor = this.constructForecastRegressor();
        Array2DRowRealMatrix forecastValues = new Array2DRowRealMatrix(this.numSeries, h);
        for (int step = 0; step < h; ++step) {
            RealMatrix hStepForecast = this.coefficients.multiply(forecastRegressor);
            for (int i = 0; i < this.numSeries; ++i) {
                forecastValues.setEntry(i, step, hStepForecast.getRow(i)[0]);
            }
            this.appendForecastRegressor(forecastRegressor, hStepForecast);
        }
        return forecastValues;
    }
}

