/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.regression;

import com.ibm.bi.predict.algorithms.regression.Regression;
import com.ibm.bi.predict.algorithms.regression.RegressionFields;
import com.ibm.bi.predict.math.NumericUtils;
import com.spss.math.statistics.DistributionFunctions;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class RegressionSelector {
    private static final double SIGNIFICANCE_LEVEL = 0.05;
    private static final double MODEL_IMPROVEMENT_THRESHOLD = 0.1;
    private static final double ADJUSTED_R_SQUARED_THRESHOLD = 0.1;

    private RegressionSelector() {
    }

    public static Regression findBestFit(RegressionFields fields, int maxDegree) {
        if (!fields.hasGroupField()) {
            return RegressionSelector.fitSimpleRegression(fields, maxDegree);
        }
        return RegressionSelector.findBestFitWithGroups(fields, maxDegree);
    }

    private static Regression fitSimpleRegression(RegressionFields fields, int maxDegree) {
        double[] inputValues = fields.getInputValues();
        int degree = 0;
        Regression best = RegressionSelector.fitRegression(fields, RegressionSelector.buildInputMatrix(inputValues, degree), degree);
        for (degree = 1; degree <= maxDegree; ++degree) {
            Regression trial = RegressionSelector.fitRegression(fields, RegressionSelector.buildInputMatrix(inputValues, degree), degree);
            if (!RegressionSelector.betterThanBest(best, trial)) continue;
            best = trial;
        }
        return best;
    }

    private static Regression findBestFitWithGroups(RegressionFields fields, int maxDegree) {
        double[] inputValues = fields.getInputValues();
        double[] groupValues = fields.getGroupValues();
        Regression best = RegressionSelector.fitRegression(fields, RegressionSelector.buildInputMatrix(inputValues, 0), 0);
        Regression m2 = RegressionSelector.fitRegression(fields, RegressionSelector.buildInputMatrix(inputValues, 1), 1);
        Regression m3 = RegressionSelector.fitRegression(fields, RegressionSelector.buildInputMatrix(inputValues, 2), 2);
        Regression m4 = RegressionSelector.fitRegression(fields, RegressionSelector.buildInputMatrixWithFactor(inputValues, 1, groupValues), 1);
        if (Math.max(m3.adjustedRSquared(), m4.adjustedRSquared()) > Math.max(0.1, m2.adjustedRSquared() + 0.1 * (1.0 - m2.adjustedRSquared()))) {
            Regression m5 = RegressionSelector.fitRegression(fields, RegressionSelector.buildInputMatrixWithFactor(inputValues, 2, groupValues), 2);
            Regression m6 = RegressionSelector.fitRegression(fields, RegressionSelector.buildInputMatrixWithFactorAndInteractions(inputValues, 1, 1, groupValues), 1);
            Regression m7 = RegressionSelector.fitRegression(fields, RegressionSelector.buildInputMatrixWithFactorAndInteractions(inputValues, 2, 1, groupValues), 2);
            Regression m8 = RegressionSelector.fitRegression(fields, RegressionSelector.buildInputMatrixWithFactorAndInteractions(inputValues, 2, 2, groupValues), 2);
            List candidates = Arrays.asList(m3, m4, m5, m6, m7, m8).stream().sorted((a, b) -> Double.compare(b.adjustedRSquared(), a.adjustedRSquared())).collect(Collectors.toList());
            for (Regression candidate : candidates) {
                double pValue = RegressionSelector.getPValue(candidate);
                if (!(pValue <= 0.05) || NumericUtils.isMissingValue((double)pValue)) continue;
                best = candidate;
                break;
            }
        } else {
            double pValue = RegressionSelector.getPValue(m2);
            if (m2.adjustedRSquared() > 0.1 && pValue <= 0.05 && !NumericUtils.isMissingValue((double)pValue)) {
                best = m2;
            }
        }
        return best;
    }

    private static double[][] buildInputMatrix(double[] inputValues, int degree) {
        double[][] xValues = new double[inputValues.length][degree];
        for (int i = 0; i < inputValues.length; ++i) {
            for (int p = 1; p <= degree; ++p) {
                xValues[i][p - 1] = Math.pow(inputValues[i], p);
            }
        }
        return xValues;
    }

    private static double[][] buildInputMatrixWithFactor(double[] inputValues, int degree, double[] factorValues) {
        int uniqCats = (int)Arrays.stream(factorValues).distinct().count();
        double[][] dummies = RegressionSelector.getDummyVariables(uniqCats);
        double[][] xValues = new double[inputValues.length][degree + (uniqCats - 1)];
        for (int i = 0; i < inputValues.length; ++i) {
            int x = 0;
            for (int p = 1; p <= degree; ++p) {
                xValues[i][x++] = Math.pow(inputValues[i], p);
            }
            for (int j = 0; j < uniqCats - 1; ++j) {
                xValues[i][x++] = dummies[(int)factorValues[i]][j];
            }
        }
        return xValues;
    }

    private static double[][] buildInputMatrixWithFactorAndInteractions(double[] inputValues, int degree, int interactionDegree, double[] factorValues) {
        int uniqCats = (int)Arrays.stream(factorValues).distinct().count();
        int numXValues = degree + (uniqCats - 1) + (uniqCats - 1) * interactionDegree;
        double[][] dummies = RegressionSelector.getDummyVariables(uniqCats);
        double[][] xValues = new double[inputValues.length][numXValues];
        for (int i = 0; i < inputValues.length; ++i) {
            int p;
            int x = 0;
            for (p = 1; p <= degree; ++p) {
                xValues[i][x++] = Math.pow(inputValues[i], p);
            }
            for (p = 0; p <= interactionDegree; ++p) {
                for (int j = 0; j < uniqCats - 1; ++j) {
                    xValues[i][x++] = dummies[(int)factorValues[i]][j] * Math.pow(inputValues[i], p);
                }
            }
        }
        return xValues;
    }

    private static Regression fitRegression(RegressionFields fields, double[][] inputMatrix, int degree) {
        Regression regression = new Regression.Builder(fields.getTargetValues(), inputMatrix, degree).withCounts(fields.getCountValues()).withWeights(fields.getWeightValues()).build();
        regression.solve();
        return regression;
    }

    private static boolean betterThanBest(Regression best, Regression trial) {
        double pValue = RegressionSelector.getPValue(trial);
        if (pValue <= 0.05 && !NumericUtils.isMissingValue((double)pValue)) {
            double bestScore = best.adjustedRSquared() + 0.1 * (1.0 - best.adjustedRSquared());
            if (trial.adjustedRSquared() > Math.max(0.1, bestScore)) {
                return true;
            }
        }
        return false;
    }

    private static double[][] getDummyVariables(int numUniqueCategories) {
        double[][] dummies = new double[numUniqueCategories][numUniqueCategories - 1];
        int i = 1;
        int j = 0;
        while (i < numUniqueCategories) {
            dummies[i][j] = 1.0;
            ++i;
            ++j;
        }
        return dummies;
    }

    private static double getPValue(Regression trial) {
        if (trial.getErrorSumSquares() < 1.0E-12 || trial.getNumOfPredictors() <= 0) {
            if (trial.getRegressionSumSquares() >= 1.0E-12) {
                return 0.0;
            }
            return Double.NaN;
        }
        double fStat = trial.getMeanSquaredRegression() / trial.getMeanSquaredError();
        double dfR = trial.getDegreesOfFreedomRegression();
        double dfE = trial.getDegreesOfFreedomError();
        double cdfF = Double.isNaN(fStat) ? 0.0 : DistributionFunctions.cdfF((double)fStat, (double)dfR, (double)dfE);
        return 1.0 - cdfF;
    }
}

