/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.algorithms.regression;

import com.ibm.bi.predict.algorithms.regression.Outlier;
import com.ibm.bi.predict.algorithms.regression.Regression;
import com.ibm.bi.predict.math.NumericUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;

public class StudentizedResiduals {
    private static final double DEFAULT_OUTLIER_THRESHOLD = 3.0;
    private final double outlierThreshold;
    private Regression regression;
    private List<Outlier> outliers = new ArrayList<Outlier>();

    public StudentizedResiduals(Regression regression) {
        this(regression, 3.0);
    }

    public StudentizedResiduals(Regression regression, double outlierThreshold) {
        this.regression = regression;
        this.outlierThreshold = outlierThreshold;
    }

    public StudentizedResiduals fit(double[] targetValues, double[] inputValues, double[] weights) {
        if (!this.regression.isFit()) {
            this.regression.solve();
        }
        ArrayRealVector hatMatrixDiag = this.getProjectionMatrixDiagonal(inputValues, weights);
        for (int i = 0; i < targetValues.length; ++i) {
            double leverage = hatMatrixDiag.getEntry(i);
            if (NumericUtils.isZero((double)(1.0 - leverage)) || leverage > 1.0) continue;
            double predicted = this.predicted(inputValues[i]);
            double error = targetValues[i] - predicted;
            double weight = weights.length == targetValues.length ? weights[i] : 1.0;
            double rse = Math.sqrt(this.regression.getMeanSquaredError());
            double studentizedResidual = error / (rse * Math.sqrt((1.0 - leverage) / weight));
            if (!this.isOutlier(studentizedResidual)) continue;
            this.outliers.add(new Outlier(i, studentizedResidual, inputValues[i], targetValues[i]));
        }
        return this;
    }

    private boolean isOutlier(double residual) {
        return Math.abs(residual) >= this.outlierThreshold;
    }

    private double predicted(double inputValue) {
        double[] newRow = new double[this.regression.numberOfParameters() + 1];
        for (int i = 0; i < newRow.length; i = (int)((byte)(i + 1))) {
            newRow[i] = Math.pow(inputValue, i);
        }
        return this.regression.predicted(newRow);
    }

    public List<Outlier> get() {
        return this.outliers;
    }

    private ArrayRealVector getProjectionMatrixDiagonal(double[] inputValues, double[] weights) {
        double[][] newMatrix = new double[inputValues.length][this.regression.numberOfParameters()];
        for (int i = 0; i < inputValues.length; ++i) {
            double[] newRow = new double[this.regression.numberOfParameters() + 1];
            for (int j = 0; j < newRow.length; j = (int)((byte)(j + 1))) {
                double v;
                double w = weights.length == inputValues.length ? Math.sqrt(weights[i]) : 1.0;
                newRow[j] = v = Math.pow(inputValues[i], j) * w;
            }
            newMatrix[i] = newRow;
        }
        RealMatrix matrix = MatrixUtils.createRealMatrix((double[][])newMatrix);
        RealMatrix mT = matrix.transpose();
        RealMatrix mTm = mT.multiply(matrix);
        RealMatrix inverse = new LUDecomposition(mTm).getSolver().getInverse();
        RealMatrix mAndMInverse = matrix.multiply(inverse);
        ArrayRealVector diag = new ArrayRealVector(mAndMInverse.getRowDimension());
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            diag.setEntry(i, this.dotProduct(mAndMInverse.getRow(i), mT.getColumn(i)));
        }
        return diag;
    }

    private double dotProduct(double[] v1, double[] v2) {
        double total = 0.0;
        for (int i = 0; i < v1.length; ++i) {
            total += v1[i] * v2[i];
        }
        return total;
    }
}

